/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.persist.PersistedMessageReader;
import com.qbrowser.util.QBrowserUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;

public final class TextMessageReader
extends PersistedMessageReader {
    private String retrieved_text_body;
    private long body_size = -1L;

    public final File readPersistedMessageWithLazyLoad(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessageWithLazyLoad(msgArchive);
        File size_file = new File(workdirFile.getAbsolutePath() + File.separator + "textbodysize");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(size_file));
            String line = br.readLine();
            if (line != null) {
                try {
                    this.body_size = Long.parseLong(line.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            br.close();
        }
        catch (IOException ie) {
            TextMessageReader.clearDir(workdirFile);
            this.body_size = 0L;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return workdirFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final File readPersistedMessage(File msgArchive) throws Exception {
        File workdirFile2222 = super.readPersistedMessage(msgArchive);
        File body_file = new File(workdirFile2222.getAbsolutePath() + File.separator + "TextMessageBody.txt");
        if (!body_file.exists()) {
            TextMessageReader.clearDir(workdirFile2222);
            throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg332") + body_file.getName() + QBrowserV2.resources.getString("qkey.msg.msg333"));
        }
        FileInputStream fi = null;
        ByteArrayOutputStream baos = null;
        try {
            fi = new FileInputStream(workdirFile2222.getAbsolutePath() + File.separator + "TextMessageBody.txt");
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = fi.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            this.retrieved_text_body = baos.toString();
        }
        catch (Exception ie) {
            try {
                TextMessageReader.clearDir(workdirFile2222);
                ie.printStackTrace();
                throw ie;
            }
            catch (Throwable workdirFile2222) {
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException iOException) {}
                }
                if (baos == null) throw workdirFile2222;
                try {
                    baos.close();
                    throw workdirFile2222;
                }
                catch (IOException iOException) {}
                throw workdirFile2222;
            }
        }
        try {
            fi.close();
        }
        catch (IOException iOException) {}
        try {
            baos.close();
            return workdirFile2222;
        }
        catch (IOException iOException) {
            return workdirFile2222;
        }
    }

    public final LocalMessageContainer recreateMessagefromReadData(Session session) throws Exception {
        TextMessage msg = session.createTextMessage();
        LocalMessageContainer lmc = new LocalMessageContainer();
        if (this.properties != null) {
            QBrowserUtil.copyUserProperties(this.properties, (Message)msg);
        }
        lmc.setMessage((Message)msg);
        if (this.headers != null) {
            QBrowserUtil.copyMessageHeaders(this.headers, (Message)msg);
            QBrowserUtil.populateHeadersOfLocalMessageContainer(this.headers, lmc);
        }
        msg.setText(this.retrieved_text_body);
        lmc.setReal_file_path(this.source_file_path);
        return lmc;
    }

    public final LocalMessageContainer recreateMessagefromReadDataWithLazyLoad() throws Exception {
        LocalMessageContainer lmc = super.recreateMessagefromReadDataWithLazyLoad();
        lmc.setBody_size(this.body_size);
        lmc.setMessage_type("TextMessage");
        return lmc;
    }
}

