<?php
/**
 * @author     lunt
 * @license    http://www.gnu.org/licenses/gpl.html GPL 2 or later
 * @version    $Id: monobook_getlink.inc.php 1 2009-01-28 14:14:26Z lunt $
 */

function plugin_monobook_getlink($tab, $message, $check_selected = FALSE)
{
	global $vars, $plugin, $_LINK;
	global $do_backup, $function_freeze, $referer, $trackback;
	global $defaultpage, $whatsnew, $help_page, $cantedit;
	static $page, $is_page, $is_pagename, $is_editable, $is_freeze, $has_refer, $request_uri;

	if (is_null($page)) {
		$page        = isset($vars['page']) ? $vars['page'] : '';
		$is_page     = is_page($page);
		$is_pagename = is_pagename($page);
		$is_editable = is_editable($page);
		$is_freeze   = is_freeze($page);
		$has_refer   = isset($vars['refer']) && is_pagename($vars['refer']);
		$request_uri = get_script_uri() . str_replace('&', '&amp;', strrchr($_SERVER['REQUEST_URI'], '?'));
	}

	if ($tab === 'nowplugin') {
		$tab = $plugin;
		if ($plugin === 'attach') {
			if (isset($vars['pcmd']) && $vars['pcmd'] === 'info') {
				$tab = 'attachinfo';
			} elseif (isset($vars['pcmd']) && $vars['pcmd'] === 'list') {
				$tab = $has_refer ? 'attachlist' : 'attachlistall';
			} else {
				$tab = 'upload';
			}
		}
	}

	$link = $title = '';
	$selected = 0;

	switch ($tab) {
	case 'add':
	case 'edit':
		if (PKWK_READONLY || ! $is_editable) break;
		$link  = $_LINK[$tab];
		$title = $message[$tab];
		break;

	case 'attach':
	case 'upload':
		if (PKWK_READONLY || ! ini_get('file_uploads') || ! $is_page || ! $is_editable) break;
		$link  = $_LINK['upload'];
		$title = $message['upload'];
		if ($plugin === 'attach' && isset($vars['pcmd']) && $vars['pcmd'] === 'upload')
			$selected = 1;
		break;

	case 'attachinfo':
		$link  = $request_uri;
		$title = $message['attachinfo'];
		$selected = 1;
		break;

	case 'attachlist':
		if ($is_pagename) $link = get_script_uri() . '?plugin=attach&amp;pcmd=list&amp;refer=' .
			rawurlencode($page);
		elseif ($plugin === 'attach' && isset($vars['pcmd']) &&
			$vars['pcmd'] === 'list' && $has_refer)
		{
			$link = $request_uri;
			$selected = 1;
		}
		$title = $message['attachlist'];
		break;

	case 'attachlistall':
		$link  = get_script_uri() . '?plugin=attach&amp;pcmd=list';
		$title = $message['attachlistall'];
		if ($plugin === 'attach' && isset($vars['pcmd']) &&
			$vars['pcmd'] === 'list' && ! $has_refer)
		{
			$selected = 1;
		}
		break;

	case 'backlink':
	case 'related':
		if (! $is_pagename) break;
		$link  = get_script_uri() . '?plugin=related&amp;page=' . rawurlencode($page);
		$title = $message['related'];
		$tab   = 'related';
		break;

	case 'backup':
		if (! $do_backup || ! $is_pagename) break;
		$link  = $_LINK['backup'];
		$title = $message['backup'];
		break;

	case 'copy':
	case 'template':
		if (PKWK_READONLY) break;
		if ($is_page) $link = $_LINK['copy'];
		elseif ($plugin === 'template')
			$link = $request_uri;
		$title = $message['copy'];
		$tab   = 'template';
		break;

	case 'diff':
		if (! $is_pagename) break;
		$link  = $_LINK['diff'];
		$title = $message['diff'];
		break;

	case 'filelist':
	case 'help':
	case 'list':
	case 'rdf':
	case 'recent':
	case 'rss':
	case 'rss10':
	case 'rss20':
	case 'search':
	case 'top':
		$link  = $_LINK[$tab];
		$title = $message[$tab];
		break;

	case 'freeze':
	case 'unfreeze':
		if (PKWK_READONLY || ! $function_freeze || ! $is_page || in_array($page, $cantedit)) break;
		$tab   = $is_freeze ? 'unfreeze' : 'freeze';
		$link  = $_LINK[$tab];
		$title = $message[$tab];
		break;

	case 'new':
	case 'newpage':
		if (PKWK_READONLY) break;
		$link  = $_LINK['new'];
		$title = $message['new'];
		$tab   = 'newpage';
		break;

	case 'read':
		$link  = $_LINK['reload'];
		$title = $message['article'];
		break;

	case 'refer':
	case 'referer':
		if (! $referer || ! $is_pagename) break;
		$link  = $_LINK['refer'];
		$title = $message['refer'];
		$tab   = 'referer';
		break;

	case 'reload':
		if (! $is_page) break;
		$link  = $_LINK['reload'];
		$title = $message['reload'];
		break;

	case 'rename':
		if (PKWK_READONLY) break;
		if ($is_page && $is_editable) $link = $_LINK['rename'];
		elseif ($plugin === 'rename')
			$link = $request_uri;
		$title = $message['rename'];
		break;

	case 'revert':
		$link  = plugin_revert_getlink();
		$link  = $link ? $link : $request_uri;
		$title = $message['revert'];
		break;

	case 'secedit':
		$link  = $request_uri;
		$title = $message['edit'];
		break;

	case 'source':
		if (! $is_page || PKWK_SAFE_MODE) break;
		$link  = get_script_uri() . '?cmd=source&amp;page=' . rawurlencode($page);
		$title = $message['source'];
		break;

	case 'trackback':
		if (! $trackback || ! $is_pagename) break;
		$link  = $_LINK['trackback'];
		$title = $message['trackback'] . ' (' . tb_count($page) . ')';
		break;

	case 'yetlist':
		if (PKWK_READONLY) break;
		$link  = get_script_uri() . '?plugin=yetlist';
		$title = $message['yetlist'];
		break;
	}

	if ($link) $link = '<a href="' . $link . '">' . $title . '</a>';

	if (! $check_selected) return $link;

	if (($plugin !== 'attach' && $plugin === $tab) ||
		($page === $defaultpage && $tab === 'top') ||
		($page === $whatsnew && $tab === 'recent') ||
		($page === $help_page && $tab === 'help'))
	{
		$selected = 1;
	}

	return array($link, $selected);
}
?>
