;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: SPIM_OLED.inc
;;   Version: 2.6, Updated on 2010/4/6 at 11:27:39
;;  Generated by PSoC Designer 
;;
;;  DESCRIPTION:
;;    Assembler include file of SPIM_OLED instance of SPIM
;;    user module.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

; Mask value for global int reg bit for TX instance
SPIM_OLED_bINT_MASK:             equ 40h
; SPIM interrupt address
SPIM_OLED_INT_REG:               equ 0dfh

; Do not use, this equate will be removed in a future release
bSPIM_OLED_INT_MASK:             equ 40h

;--------------------------------------------------
; Register constants and masks
;--------------------------------------------------
SPIM_OLED_SPIM_MODE_0:             equ   00h      ;MODE 0 - Leading edge latches data - pos clock
SPIM_OLED_SPIM_MODE_1:             equ   02h      ;MODE 1 - Leading edge latches data - neg clock
SPIM_OLED_SPIM_MODE_2:             equ   04h      ;MODE 2 - Trailing edge latches data - pos clock
SPIM_OLED_SPIM_MODE_3:             equ   06h      ;MODE 3 - Trailing edge latches data - neg clock
SPIM_OLED_SPIM_LSB_FIRST:          equ   80h      ;LSB bit transmitted/received first
SPIM_OLED_SPIM_MSB_FIRST:          equ   00h      ;MSB bit transmitted/received first

;---------------------------
; SPI Status register masks
;---------------------------
SPIM_OLED_SPIM_RX_OVERRUN_ERROR:   equ   40h      ;Overrun error in received data
SPIM_OLED_SPIM_TX_BUFFER_EMPTY:    equ   10h      ;TX Buffer register is ready for next data byte
SPIM_OLED_SPIM_RX_BUFFER_FULL:     equ   08h      ;RX Buffer register has received current data
SPIM_OLED_SPIM_SPI_COMPLETE:       equ   20h      ;SPI Tx/Rx cycle has completed

;--------------------------------------------------
; Registers used by SPIM_OLED
;--------------------------------------------------
SPIM_OLED_CONTROL_REG:  equ 5bh                  ;Control register
SPIM_OLED_SHIFT_REG:    equ 58h                  ;TX Shift Register register
SPIM_OLED_TX_BUFFER_REG:    equ 59h              ;TX Buffer Register
SPIM_OLED_RX_BUFFER_REG:    equ 5ah              ;RX Buffer Register
SPIM_OLED_FUNCTION_REG: equ 58h                  ;Function register
SPIM_OLED_INPUT_REG:    equ 59h                  ;Input register
SPIM_OLED_OUTPUT_REG:   equ 5ah                  ;Output register

; end of file SPIM_OLED.inc
