/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.Session;

public final class ThreadPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$ThreadPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$ThreadPolicyRuntime = ThreadPolicyRuntime.class$("com.trend.iwss.jscan.runtime.ThreadPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$ThreadPolicyRuntime);
    public static final String NAME = "Thread";
    public static final String PROP_PREFIX = "thread";
    public static final Factory FACT = new Factory("Thread");
    public static final String CFG_THREAD_THREAD_NUM_LIMITED_BOOL = "thread_num_limited";
    public static final String CFG_THREAD_THREAD_NUM_MAX_INT = "thread_num_max";
    public static final String CFG_THREAD_THREADGROUP_CREATE_BOOL = "threadgroup_create";
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set("java/lang/");
    public static final MethodRefMatcher MATCH_THREAD_START = MATCHERS.make("java/lang/Thread", "start");
    public static final MethodRefMatcher MATCH_THREAD_GROUP_INIT = MATCHERS.make("java/lang/ThreadGroup", "<init>");
    public static final MethodRefMatcher MATCH_THREAD_RESUME = MATCHERS.make("java/lang/Thread", "interrupt");
    private boolean m_threadsLimited = this.getBoolPolicyProp("thread_num_limited", false);
    private boolean m_threadGrpRestricted = !this.getBoolPolicyProp("threadgroup_create", false);
    private int m_maxThreads = this.getIntPolicyProp("thread_num_max", 0);
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$ThreadPolicyRuntime;

    ThreadPolicyRuntime(Session ses) {
        super(NAME, PROP_PREFIX, ses);
    }

    public static void preFilter(CallContext ctx) {
        PolicyRuntime.preFilter(ctx, FACT);
    }

    public static void postFilter(CallContext ctx) {
        PolicyRuntime.postFilter(ctx, FACT);
    }

    void _preFilter(CallContext ctx) {
        if (this.m_threadsLimited && MATCH_THREAD_START.match(ctx)) {
            if (this.m_maxThreads <= this.m_ses.getActiveThreadsCount()) {
                this.stopAction("instr.msg.thread.limit", "" + this.m_maxThreads);
                return;
            }
        } else if (this.m_threadGrpRestricted && MATCH_THREAD_GROUP_INIT.match(ctx)) {
            this.stopAction("instr.msg.thread.group_limit");
            return;
        }
    }

    void _postFilter(CallContext ctx) {
        if (MATCH_THREAD_START.match(ctx)) {
            this.m_ses.addActiveThread((Thread)ctx.getTarget());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Factory
    extends PolicyRuntime.Factory {
        Factory(String ctxKey) {
            super(ctxKey);
        }

        PolicyRuntime make(Session ses) {
            return new ThreadPolicyRuntime(ses);
        }
    }
}

