/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class StubAppletDisplay
implements ActionListener,
WindowListener {
    static final String PLACEHOLDER_DIALOG_TITLE = "APPLET ALERT";
    static final String PLACEHOLDER_OK_BUTTON = "OK";
    static final String PLACEHOLDER_MSG = "The applet is identified to violate corporate security policy and is blocked";
    public static final int DIALOG_PANEL_WIDTH = 400;
    public static final int DIALOG_PANEL_HEIGHT = 150;
    public static final Dimension MINIMUM_APPLET_DISPLAY_AREA = new Dimension(50, 30);
    private Container m_panel;
    private Dialog m_dialog;
    private Button m_ok;
    private TextArea m_textArea;

    private StubAppletDisplay(Container panel, Dialog dialog, Button ok, TextArea textArea) {
        this.m_panel = panel;
        this.m_dialog = dialog;
        this.m_ok = ok;
        this.m_textArea = textArea;
    }

    public static StubAppletDisplay make(Container panel, String msg, String dialogTitle, String okButtonTag) {
        TextArea ta = StubAppletDisplay.getTextArea(msg);
        Button ok = new Button(okButtonTag);
        Dialog dialog = StubAppletDisplay.makeDialog(panel, dialogTitle, ta, ok);
        StubAppletDisplay aal = new StubAppletDisplay(panel, dialog, ok, ta);
        ok.addActionListener(aal);
        dialog.addWindowListener(aal);
        return aal;
    }

    public void show() {
        this.m_panel.removeAll();
        this.m_panel.invalidate();
        this.m_panel.setLayout(new BorderLayout());
        if (StubAppletDisplay.useAppletArea(this.m_panel)) {
            this.m_panel.add("Center", this.m_textArea);
        } else {
            this.m_dialog.show();
        }
    }

    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.m_ok) {
            this.m_dialog.dispose();
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.m_dialog.dispose();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    static TextArea getTextArea(String msg) {
        TextArea ta = new TextArea(msg, 0, 0, 1);
        ta.setForeground(Color.red);
        ta.setEditable(false);
        return ta;
    }

    static boolean useAppletArea(Container panel) {
        Dimension dim = panel.getSize();
        if (StubAppletDisplay.MINIMUM_APPLET_DISPLAY_AREA.height > dim.height) {
            return false;
        }
        return StubAppletDisplay.MINIMUM_APPLET_DISPLAY_AREA.width <= dim.width;
    }

    static void setDialogPosition(Container panel, Dialog dialog, int preferredHeight, int preferredWidth) {
        try {
            Toolkit tk = panel.getToolkit();
            Dimension screenDim = tk.getScreenSize();
            Dimension dim = dialog.getSize();
            int sht = screenDim.height;
            int swi = screenDim.width;
            int ht = 0 < dim.height ? dim.height : preferredHeight;
            int wi = 0 < dim.width ? dim.width : preferredWidth;
            int x = (swi - wi) / 2;
            int y = (sht - ht) / 2;
            x = x > 0 ? x : 0;
            y = y > 0 ? y : 0;
            dialog.setLocation(x, y);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private static Dialog makeDialog(Container panel, String dialogTitle, TextArea ta, Button ok) {
        Dialog dialog = new Dialog(new Frame(), dialogTitle, true);
        dialog.setSize(400, 150);
        dialog.setLayout(new BorderLayout(10, 10));
        dialog.setForeground(Color.red);
        dialog.add("Center", ta);
        Panel p = new Panel();
        p.add(ok);
        dialog.add("South", p);
        dialog.pack();
        StubAppletDisplay.setDialogPosition(panel, dialog, 150, 400);
        return dialog;
    }
}

