/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

import com.trend.iwss.jscan.runtime.CallContext;
import com.trend.iwss.jscan.runtime.FileIOPolicyRuntime;
import com.trend.iwss.jscan.runtime.MethodRefMatcher;
import com.trend.iwss.jscan.runtime.PolicyRuntime;
import com.trend.iwss.jscan.runtime.Session;
import java.io.File;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public final class NetworkPolicyRuntime
extends PolicyRuntime {
    public static final String FULLCLASSPATH = PolicyRuntime.classNameSlashNotation(class$com$trend$iwss$jscan$runtime$NetworkPolicyRuntime == null ? (class$com$trend$iwss$jscan$runtime$NetworkPolicyRuntime = NetworkPolicyRuntime.class$("com.trend.iwss.jscan.runtime.NetworkPolicyRuntime")) : class$com$trend$iwss$jscan$runtime$NetworkPolicyRuntime);
    public static final String NAME = "Network";
    public static final String PROP_PREFIX = "net";
    public static final Factory FACT = new Factory("Network");
    public static final String CFG_NETWORK_CONNECT_SOURCE_BOOL = "connect_src";
    public static final String CFG_NETWORK_CONNECT_OTHER_BOOL = "connect_other";
    public static final String CFG_NETWORK_CONNECT_EXCLUDED_DOMAINS_LIST = "connect_ex_dom_list";
    public static final String CFG_NETWORK_CONNECT_INCLUDED_DOMAINS_LIST = "connect_in_dom_list";
    public static final String CFG_NETWORK_BIND_ENABLE = "bind_enable";
    public static final MethodRefMatcher.Set MATCHERS = new MethodRefMatcher.Set("java/net/");
    public static final MethodRefMatcher MATCH_SERVER_SOCKET_INIT = MATCHERS.make("java/net/ServerSocket", "<init>");
    public static final MethodRefMatcher MATCH_SERVER_SOCKET_INIT_I = MATCHERS.make("java/net/ServerSocket", "<init>", "(I*");
    public static final MethodRefMatcher MATCH_SERVER_SOCKET_BIND = MATCHERS.make("java/net/ServerSocket", "bind", "(Ljava/net/SocketAddress;*");
    public static final MethodRefMatcher MATCH_SOCKET_INIT_INETADDR = MATCHERS.make("java/net/Socket", "<init>", "(Ljava/net/InetAddress;*");
    public static final MethodRefMatcher MATCH_SOCKET_INIT_STRING = MATCHERS.make("java/net/Socket", "<init>", "(Ljava/lang/String;*");
    public static final MethodRefMatcher MATCH_DATAGRAM_SOCKET_INIT_I = MATCHERS.make("java/net/DatagramSocket", "<init>", "(I*");
    public static final MethodRefMatcher MATCH_DATAGRAM_SOCKET_SEND = MATCHERS.make("java/net/DatagramSocket", "send");
    public static final MethodRefMatcher MATCH_DATAGRAM_SOCKET_RECEIVE = MATCHERS.make("java/net/DatagramSocket", "receive");
    public static final MethodRefMatcher MATCH_URL_CONNECTION_INIT = MATCHERS.make("java/net/URLConnection", "<init>");
    public static final MethodRefMatcher MATCH_URL_CONNECTION_CONNECT = MATCHERS.make("java/net/URLConnection", "connect");
    public static final MethodRefMatcher MATCH_URL_INIT = MATCHERS.make("java/net/URL", "<init>");
    public static final MethodRefMatcher MATCH_URL_OPEN = MATCHERS.make("java/net/URL", new String[]{"openConnection", "openStream", "getContent"});
    public static final String CLASS_INETADDRESS = "java.net.InetAddress";
    public static final String CLASS_INETSOCKETADDRESS = "java.net.InetSocketAddress";
    public static final String METH_INETSOCKETADDRESS_GETHOSTNAME = "getHostName";
    public static final String METH_INETSOCKETADDRESS_GETADDRESS = "getAddress";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_FTP = "ftp";
    public static final String LOCALHOST_NAME = "localhost";
    public static final String LOOPBACK_IPADDR = "127.0.0.1";
    private String m_originURI = this.getStrProp("jscan.session.origin_uri", null);
    private String m_originHost = NetworkPolicyRuntime.getHostFromURI(this.m_originURI);
    private InetAddress m_originInetAddress = NetworkPolicyRuntime.getInetAddr(this.m_originHost);
    private boolean m_localBindEnabled = this.getBoolPolicyProp("bind_enable", false);
    private boolean m_connectToOriginEnabled = this.getBoolPolicyProp("connect_src", true);
    private boolean m_connectToOtherEnabled = this.getBoolPolicyProp("connect_other", false);
    private String m_otherDomainsExceptions;
    static /* synthetic */ Class class$com$trend$iwss$jscan$runtime$NetworkPolicyRuntime;

    NetworkPolicyRuntime(Session ses) {
        super(NAME, PROP_PREFIX, ses);
        String listProp = this.m_connectToOtherEnabled ? CFG_NETWORK_CONNECT_EXCLUDED_DOMAINS_LIST : CFG_NETWORK_CONNECT_INCLUDED_DOMAINS_LIST;
        this.m_otherDomainsExceptions = this.getStrPolicyProp(listProp, "");
    }

    public static void preFilter(CallContext ctx) {
        PolicyRuntime.preFilter(ctx, FACT);
    }

    public static void postFilter(CallContext ctx) {
        PolicyRuntime.postFilter(ctx, FACT);
    }

    void _preFilter(CallContext ctx) {
        if (MATCH_SERVER_SOCKET_INIT_I.match(ctx)) {
            int port = ctx.getArg(0).getIntValue();
            if (!this.m_localBindEnabled) {
                this.stopAction("instr.action.bind_local", "" + port);
                return;
            }
        } else if (MATCH_SERVER_SOCKET_INIT.match(ctx)) {
            if (!this.m_localBindEnabled) {
                this.stopAction("instr.action.bind_local_unspec");
                return;
            }
        } else if (MATCH_SOCKET_INIT_INETADDR.match(ctx)) {
            InetAddress addr = (InetAddress)ctx.getArg(0).getObjectValue();
            if (!this.allowInetAddr(addr)) {
                this.stopAction("instr.action.connect", addr.getHostName());
                return;
            }
        } else if (MATCH_SOCKET_INIT_STRING.match(ctx)) {
            String hostname = (String)ctx.getArg(0).getObjectValue();
            if (!this.allowHostName(hostname)) {
                this.stopAction("instr.action.connect", hostname);
                return;
            }
        } else if (MATCH_DATAGRAM_SOCKET_INIT_I.match(ctx)) {
            int port = ctx.getArg(0).getIntValue();
            if (!this.m_localBindEnabled) {
                this.stopAction("instr.action.bind_local", "" + port);
                return;
            }
        } else if (MATCH_DATAGRAM_SOCKET_SEND.match(ctx)) {
            DatagramPacket packet = (DatagramPacket)ctx.getArg(0).getObjectValue();
            InetAddress addr = packet.getAddress();
            if (!this.allowInetAddr(addr)) {
                this.stopAction("instr.action.send_data", addr.toString());
                return;
            }
        } else if (MATCH_SERVER_SOCKET_BIND.match(ctx)) {
            Object addr = ctx.getArg(0).getObjectValue();
            this.checkInetSocketAddr(addr);
        } else if (MATCH_URL_CONNECTION_INIT.match(ctx)) {
            this.checkURL((URL)ctx.getArg(0).getObjectValue(), ctx);
        } else if (MATCH_URL_CONNECTION_CONNECT.match(ctx)) {
            this.checkURL(((URLConnection)ctx.getTarget()).getURL(), ctx);
        } else if (MATCH_URL_OPEN.match(ctx)) {
            this.checkURL((URL)ctx.getTarget(), ctx);
        }
    }

    void _postFilter(CallContext ctx) {
        if (MATCH_DATAGRAM_SOCKET_RECEIVE.match(ctx)) {
            DatagramPacket packet = (DatagramPacket)ctx.getArg(0).getObjectValue();
            InetAddress addr = packet.getAddress();
            if (!this.allowInetAddr(addr)) {
                this.stopAction("instr.action.receive_data", addr.toString());
                return;
            }
        } else if (MATCH_URL_INIT.match(ctx)) {
            this.checkURL((URL)ctx.getTarget(), ctx);
        }
    }

    public static boolean isFileProtocol(URL url) {
        return null != NetworkPolicyRuntime.getFileProtocolFilename(url);
    }

    public static String getFileProtocolFilename(URL url) {
        if (null == url) {
            return null;
        }
        String proto = url.getProtocol();
        if (URL_PROTOCOL_FILE.equalsIgnoreCase(proto)) {
            return NetworkPolicyRuntime.toNormalFilePath(url.getFile());
        }
        if (URL_PROTOCOL_FTP.equalsIgnoreCase(proto)) {
            return NetworkPolicyRuntime.toNormalFilePath(url.getFile());
        }
        if (URL_PROTOCOL_JAR.equalsIgnoreCase(proto)) {
            URL url2 = NetworkPolicyRuntime.fileUrlFromJarUrl(url);
            if (null == url2) {
                return null;
            }
            String proto2 = url2.getProtocol();
            if (!URL_PROTOCOL_FILE.equalsIgnoreCase(proto2)) {
                return null;
            }
            return NetworkPolicyRuntime.toNormalFilePath(url2.getFile());
        }
        return null;
    }

    public static String toNormalFilePath(String netPath) {
        String fpath = netPath;
        if (File.separatorChar != '/') {
            fpath = fpath.replace('/', File.separatorChar);
        }
        if (fpath.length() >= 3) {
            if (fpath.charAt(2) == '|') {
                fpath = fpath.substring(0, 2) + ":" + fpath.substring(3, fpath.length());
            }
            if (fpath.charAt(0) == File.separatorChar && fpath.charAt(2) == ':') {
                fpath = fpath.substring(1);
            }
        }
        return fpath;
    }

    public static boolean isLocalFileProtocol(URL url) {
        if (null == url) {
            return false;
        }
        if (!NetworkPolicyRuntime.isFileProtocol(url)) {
            return false;
        }
        return NetworkPolicyRuntime.isLocal(url);
    }

    public static boolean isLocal(URL urlOrig) {
        if (null == urlOrig) {
            return false;
        }
        URL url = urlOrig;
        if (URL_PROTOCOL_JAR.equalsIgnoreCase(url.getProtocol()) && null == (url = NetworkPolicyRuntime.fileUrlFromJarUrl(url))) {
            return false;
        }
        String host = url.getHost();
        if (null == host) {
            return true;
        }
        if (LOCALHOST_NAME.equalsIgnoreCase(host)) {
            return true;
        }
        if (LOOPBACK_IPADDR.equalsIgnoreCase(host)) {
            return true;
        }
        InetAddress lhAddr = NetworkPolicyRuntime.getLocalhostInetAddr();
        if (null == lhAddr) {
            return false;
        }
        return host.equals(lhAddr.getHostName());
    }

    private static URL fileUrlFromJarUrl(URL jarUrl) {
        String jarpath = jarUrl.getFile();
        int idx = jarpath.indexOf("!/");
        String path = -1 != idx ? jarpath.substring(0, idx) : jarpath;
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void checkURL(URL url, CallContext ctx) {
        if (NetworkPolicyRuntime.isLocalFileProtocol(url)) {
            PolicyRuntime.preFilter(ctx, FileIOPolicyRuntime.FACT);
            return;
        }
        String hostname = url.getHost();
        if (!this.allowHostName(hostname)) {
            this.stopAction("instr.action.connect", url.toString());
        }
    }

    private void checkInetSocketAddr(Object obj) {
        String hostname = PolicyRuntime.invokeStringGetter(obj, CLASS_INETSOCKETADDRESS, METH_INETSOCKETADDRESS_GETHOSTNAME);
        Object inetObj = PolicyRuntime.invokeZeroArgMethod(obj, CLASS_INETSOCKETADDRESS, METH_INETSOCKETADDRESS_GETADDRESS, CLASS_INETADDRESS);
        if (null == hostname && null == inetObj) {
            if (!this.m_localBindEnabled) {
                this.stopAction("instr.action.bind_local_unspec");
            }
            return;
        }
        InetAddress inetAddr = (InetAddress)inetObj;
        if (!this.allow(hostname, inetAddr)) {
            this.stopAction("instr.action.connect", obj.toString());
        }
    }

    private boolean allowInetAddr(InetAddress addr) {
        String hostname = NetworkPolicyRuntime.getHostNameFromInetAddr(addr);
        return this.allow(hostname, addr);
    }

    private boolean allowHostName(String hostname) {
        InetAddress inet = NetworkPolicyRuntime.getInetAddr(hostname);
        return this.allow(hostname, inet);
    }

    private boolean allow(String hostname, InetAddress addr) {
        if (this.matchOrigin(hostname, addr)) {
            return this.m_connectToOriginEnabled;
        }
        if (this.m_connectToOtherEnabled) {
            return !this.matchList(hostname, addr, this.m_otherDomainsExceptions);
        }
        return this.matchList(hostname, addr, this.m_otherDomainsExceptions);
    }

    private boolean matchOrigin(String hostname, InetAddress addr) {
        if (null == this.m_originURI) {
            return false;
        }
        if (null != hostname && hostname.equals(this.m_originHost)) {
            return true;
        }
        return null != addr && addr.equals(this.m_originInetAddress);
    }

    private boolean matchList(String hostname, InetAddress addr, String domList) {
        String iaddrHostAddr = NetworkPolicyRuntime.getHostAddrFromInetAddr(addr);
        StringTokenizer tokens = new StringTokenizer(domList, ";");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals("*")) {
                return true;
            }
            if (!NetworkPolicyRuntime.matchToken(token, hostname) && !NetworkPolicyRuntime.matchToken(token, iaddrHostAddr)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchToken(String token, String name) {
        if (null == name) {
            return false;
        }
        if (token.startsWith("*.")) {
            return name.equals(token.substring(2, token.length())) || name.endsWith(token.substring(1, token.length()));
        }
        return token.equals(name);
    }

    private static String getHostFromURI(String uri) {
        if (null == uri) {
            return null;
        }
        try {
            URL url = new URL(uri);
            return url.getHost();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static InetAddress getLocalhostInetAddr() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static InetAddress getInetAddr(String hostname) {
        if (null == hostname) {
            return null;
        }
        try {
            return InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static String getHostAddrFromInetAddr(InetAddress addr) {
        if (null == addr) {
            return null;
        }
        try {
            return addr.getHostAddress();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static String getHostNameFromInetAddr(InetAddress addr) {
        if (null == addr) {
            return null;
        }
        try {
            return addr.getHostName();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Factory
    extends PolicyRuntime.Factory {
        Factory(String ctxKey) {
            super(ctxKey);
        }

        PolicyRuntime make(Session ses) {
            return new NetworkPolicyRuntime(ses);
        }
    }
}

