/*
 * Decompiled with CFR 0.152.
 */
package com.trend.iwss.jscan.runtime;

public abstract class Base64 {
    private static final char[] enc_table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] dec_table = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    private Base64() {
    }

    private static char[] encodeAtom(byte[] buffer, int begin, int size) {
        char[] out = new char[4];
        switch (size) {
            case 1: {
                byte c1 = buffer[begin];
                out[0] = enc_table[c1 >>> 2 & 0x3F];
                out[1] = enc_table[c1 << 4 & 0x30];
                out[2] = 61;
                out[3] = 61;
                break;
            }
            case 2: {
                byte c1 = buffer[begin];
                byte c2 = buffer[begin + 1];
                out[0] = enc_table[c1 >>> 2 & 0x3F];
                out[1] = enc_table[(c1 << 4 & 0x30) + (c2 >>> 4 & 0xF)];
                out[2] = enc_table[c2 << 2 & 0x3C];
                out[3] = 61;
                break;
            }
            case 3: {
                byte c1 = buffer[begin];
                byte c2 = buffer[begin + 1];
                byte c3 = buffer[begin + 2];
                out[0] = enc_table[c1 >>> 2 & 0x3F];
                out[1] = enc_table[(c1 << 4 & 0x30) + (c2 >>> 4 & 0xF)];
                out[2] = enc_table[(c2 << 2 & 0x3C) + (c3 >>> 6 & 3)];
                out[3] = enc_table[c3 & 0x3F];
            }
        }
        return out;
    }

    private static byte[] decodeAtom(String buffer) {
        byte[] out = null;
        int c1 = 0;
        byte c2 = 0;
        byte c3 = 0;
        byte c4 = 0;
        int size = buffer.length();
        if (size < 2) {
            return new byte[0];
        }
        if (size > 3 && buffer.charAt(3) == '=') {
            size = 3;
        }
        if (size > 2 && buffer.charAt(2) == '=') {
            size = 2;
        }
        switch (size) {
            case 4: {
                c4 = dec_table[buffer.charAt(3)];
            }
            case 3: {
                c3 = dec_table[buffer.charAt(2)];
            }
            case 2: {
                c2 = dec_table[buffer.charAt(1)];
                c1 = dec_table[buffer.charAt(0)];
            }
        }
        switch (size) {
            case 2: {
                out = new byte[]{(byte)(c1 << 2 & 0xFC | c2 >>> 4 & 3)};
                break;
            }
            case 3: {
                out = new byte[]{(byte)(c1 << 2 & 0xFC | c2 >>> 4 & 3), (byte)(c2 << 4 & 0xF0 | c3 >>> 2 & 0xF)};
                break;
            }
            case 4: {
                out = new byte[]{(byte)(c1 << 2 & 0xFC | c2 >>> 4 & 3), (byte)(c2 << 4 & 0xF0 | c3 >>> 2 & 0xF), (byte)(c3 << 6 & 0xC0 | c4 & 0x3F)};
            }
        }
        return out;
    }

    public static String encode(byte[] buffer) {
        int len = buffer.length;
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < len; i += 3) {
            out.append(Base64.encodeAtom(buffer, i, len - i >= 3 ? 3 : len - i));
        }
        return out.toString();
    }

    public static byte[] decode(String buffer) {
        byte[] temp;
        int len = buffer.length();
        byte[] out = new byte[len / 4 * 3 + 3];
        int j = 0;
        for (int i = 0; i < len; i += 4) {
            temp = Base64.decodeAtom(len - i > 4 ? buffer.substring(i, i + 4) : buffer.substring(i));
            int k = 0;
            while (k < temp.length) {
                out[j++] = temp[k++];
            }
        }
        temp = new byte[j];
        System.arraycopy(out, 0, temp, 0, j);
        return temp;
    }
}

