/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class ValueRuleForWhiteSpace
implements IPredicateRule {
    protected IToken fToken;
    protected char[] fSeparateSequences = new char[]{' ', '\t'};
    protected char fEscapeCharacter;
    protected char[] fOtherSeparateSequences;

    public ValueRuleForWhiteSpace(char[] otherSeparateSequences, IToken token, char escapeCharacter) {
        this.fToken = token;
        this.fOtherSeparateSequences = otherSeparateSequences;
        this.fEscapeCharacter = escapeCharacter;
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }

    public void disp(int a) {
        this.disp((char)a);
    }

    public void disp(char a) {
        if (a == '\n') {
            System.out.println("\\n");
        } else if (a == '\r') {
            System.out.println("\\r");
        } else if (a == ' ') {
            System.out.println("\\s");
        } else {
            System.out.println(new char[]{a});
        }
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int readCnt;
        if (scanner.getColumn() == 0) {
            return Token.UNDEFINED;
        }
        scanner.unread();
        int nc = scanner.read();
        boolean escapeFlg = false;
        boolean otherEscapeFlg = false;
        int unreadCnt = 0;
        boolean isSeparateCharFlg = false;
        for (int i = 0; i < this.fSeparateSequences.length; ++i) {
            if ((char)nc != this.fSeparateSequences[i]) continue;
            isSeparateCharFlg = true;
            break;
        }
        if (isSeparateCharFlg) {
            int column;
            int i;
            readCnt = 0;
            block1: while (true) {
                nc = scanner.read();
                ++readCnt;
                if ((char)nc == '\n' || (char)nc == '\r' || nc == -1 || (char)nc == this.fEscapeCharacter) break;
                for (i = 0; i < this.fOtherSeparateSequences.length; ++i) {
                    if ((char)nc != this.fOtherSeparateSequences[i]) continue;
                    if (otherEscapeFlg) break block1;
                    for (int j = 0; j < readCnt; ++j) {
                        scanner.unread();
                    }
                    return Token.UNDEFINED;
                }
                otherEscapeFlg = false;
            }
            for (i = 0; i < readCnt; ++i) {
                scanner.unread();
            }
            for (int i2 = column = scanner.getColumn(); i2 >= 0; --i2) {
                scanner.unread();
                scanner.unread();
                ++unreadCnt;
                nc = scanner.read();
                if ((char)nc == this.fEscapeCharacter) {
                    escapeFlg = !escapeFlg;
                    continue;
                }
                break;
            }
        } else {
            return Token.UNDEFINED;
        }
        for (int j = 0; j < unreadCnt; ++j) {
            scanner.read();
        }
        if (escapeFlg) {
            return Token.UNDEFINED;
        }
        while (true) {
            if ((nc = scanner.read()) == -1) {
                return this.getSuccessToken();
            }
            if ((char)nc == this.fEscapeCharacter) {
                escapeFlg = true;
                readCnt = 0;
                while ((nc = scanner.read()) == this.fEscapeCharacter) {
                    if (escapeFlg) {
                        escapeFlg = false;
                        continue;
                    }
                    escapeFlg = true;
                }
                if (escapeFlg) {
                    if ((char)nc == '\n') continue;
                    if ((char)nc == '\uffffffff') {
                        return this.getSuccessToken();
                    }
                    int nc2 = scanner.read();
                    if ((char)nc == '\r' && (char)nc2 == '\n') continue;
                    if ((char)nc == '\r' && (char)nc2 != '\n') {
                        scanner.unread();
                        continue;
                    }
                    scanner.unread();
                    scanner.unread();
                    continue;
                }
                if ((char)nc != '\r' && (char)nc != '\n') continue;
                return this.getSuccessToken();
            }
            if ((char)nc == '\r' || (char)nc == '\n') break;
        }
        return this.getSuccessToken();
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }
}

