/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;

public class PropertiesReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private PropertiesEditor editor;
    private IDocument fDocument;
    protected final ArrayList fPositions = new ArrayList();

    public PropertiesEditor getEditor() {
        return this.editor;
    }

    public void setEditor(PropertiesEditor editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        this.calculatePositions();
    }

    protected void calculatePositions() {
        this.fPositions.clear();
        try {
            this.recursiveTokens();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        char[] a = this.fDocument.get().toCharArray();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PropertiesReconcilingStrategy.this.editor.updateFoldingStructure(PropertiesReconcilingStrategy.this.fPositions);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recursiveTokens() throws CoreException {
        String line = null;
        int cntLine = 0;
        boolean multipleValueFlg = false;
        int startLine = 0;
        int endLine = 0;
        int startPos = 0;
        int endPos = 0;
        BufferedReader reader = null;
        try {
            IRegion region;
            reader = new BufferedReader(new StringReader(this.fDocument.get()));
            boolean lineEscape = false;
            while ((line = reader.readLine()) != null) {
                ++cntLine;
                if (multipleValueFlg) {
                    if (line.endsWith("\\")) {
                        multipleValueFlg = true;
                        continue;
                    }
                    multipleValueFlg = false;
                    endLine = cntLine - 1;
                    region = this.fDocument.getLineInformation(endLine);
                    String lineDelim = this.fDocument.getLineDelimiter(endLine);
                    int delimiterLength = 0;
                    if (lineDelim != null) {
                        delimiterLength = this.fDocument.getLineDelimiter(endLine).length();
                    }
                    endPos = region.getOffset() + region.getLength() + delimiterLength - 1;
                    startPos = this.fDocument.getLineOffset(startLine);
                    this.emitPosition(startPos, endPos - startPos + 1);
                    continue;
                }
                if (line.trim().equals("") || line.trim().startsWith("#") || line.trim().startsWith("!")) continue;
                line = line.trim();
                boolean escapeFlg = false;
                boolean nonSeparate = true;
                for (int i = 0; i < line.length(); ++i) {
                    String tmp;
                    char achar = line.charAt(i);
                    if (achar == '\\') {
                        if (escapeFlg) {
                            tmp = line;
                            line = "";
                            line = tmp.substring(0, i);
                            line = line + tmp.substring(i + 1, tmp.length());
                            escapeFlg = false;
                            --i;
                            continue;
                        }
                        escapeFlg = true;
                        continue;
                    }
                    if (achar == '=' || achar == '\t' || achar == ':' || achar == ' ') {
                        if (escapeFlg) {
                            tmp = line;
                            line = "";
                            line = tmp.substring(0, i - 1);
                            line = line + tmp.substring(i, tmp.length());
                            escapeFlg = false;
                            --i;
                            continue;
                        }
                        nonSeparate = false;
                        escapeFlg = false;
                        break;
                    }
                    if (escapeFlg) {
                        tmp = line;
                        line = "";
                        line = tmp.substring(0, i - 1);
                        line = line + tmp.substring(i, tmp.length());
                        --i;
                    }
                    escapeFlg = false;
                }
                if (nonSeparate) {
                    if (line.endsWith("\\")) {
                        lineEscape = true;
                        continue;
                    }
                    lineEscape = false;
                } else {
                    lineEscape = false;
                }
                if (line.endsWith("\\")) {
                    multipleValueFlg = true;
                    startLine = cntLine - 1;
                    continue;
                }
                multipleValueFlg = false;
            }
            if (multipleValueFlg) {
                region = this.fDocument.getLineInformation(cntLine - 1);
                endPos = region.getOffset() + region.getLength();
                startPos = this.fDocument.getLineOffset(startLine);
                this.emitPosition(startPos, endPos - startPos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    protected void emitPosition(int startOffset, int length) {
        this.fPositions.add(new Position(startOffset, length));
    }
}

