/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.checker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ussiy.app.propedit.PropertiesEditor;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.checker.CheckAndMarkResourceVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IFileEditorInput;

public class CheckAndMarkDuplicateKey {
    private Map map;

    public CheckAndMarkDuplicateKey(Map map) {
        this.map = map;
    }

    public CheckAndMarkDuplicateKey() {
        this.map = new HashMap();
    }

    public void checkAndMarkDuplicateKeyInResource(IResource resource) throws CoreException {
        try {
            CheckAndMarkResourceVisitor visitor = new CheckAndMarkResourceVisitor(this);
            resource.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            Status s = new Status(4, "org.eclipse.ui", 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)s);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkAndMarkDuplicateKeyInString(String text, IResource resource) throws CoreException {
        IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        int i = 0;
        while (i < markers.length) {
            markers[i].delete();
            ++i;
        }
        if (!PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("checkKeyPreference")) {
            return;
        }
        String line = null;
        int cntLine = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String warn = PropertiesEditor.res.getString("eclipse_editor_key_duplicate");
        boolean multipleValueFlg = false;
        ArrayList<String> duplicateKeyList = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(text));
            String key = null;
            boolean lineEscape = false;
            while (true) {
                if ((line = reader.readLine()) == null) {
                    return;
                }
                if (!lineEscape) {
                    key = "";
                }
                ++cntLine;
                if (line.trim().equals("") || line.trim().startsWith("#") || line.trim().startsWith("!")) {
                    multipleValueFlg = false;
                    continue;
                }
                if (multipleValueFlg) {
                    if (line.endsWith("\\")) {
                        multipleValueFlg = true;
                        continue;
                    }
                    multipleValueFlg = false;
                    continue;
                }
                line = line.trim();
                boolean escapeFlg = false;
                boolean nonSeparate = true;
                int i2 = 0;
                while (i2 < line.length()) {
                    block33: {
                        String tmp;
                        char achar = line.charAt(i2);
                        if (achar == '\\') {
                            if (escapeFlg) {
                                tmp = line;
                                line = "";
                                line = tmp.substring(0, i2);
                                line = line + tmp.substring(i2 + 1, tmp.length());
                                escapeFlg = false;
                                --i2;
                            } else {
                                escapeFlg = true;
                            }
                        } else {
                            if (achar == '=' || achar == '\t' || achar == ':' || achar == ' ') {
                                if (escapeFlg) {
                                    tmp = line;
                                    line = "";
                                    line = tmp.substring(0, i2 - 1);
                                    line = line + tmp.substring(i2, tmp.length());
                                    escapeFlg = false;
                                    --i2;
                                    break block33;
                                } else {
                                    nonSeparate = false;
                                    escapeFlg = false;
                                    key = key + line.substring(0, i2);
                                    break;
                                }
                            }
                            if (escapeFlg) {
                                tmp = line;
                                line = "";
                                line = tmp.substring(0, i2 - 1);
                                line = line + tmp.substring(i2, tmp.length());
                                --i2;
                            }
                            escapeFlg = false;
                        }
                    }
                    ++i2;
                }
                if (nonSeparate) {
                    if (line.endsWith("\\")) {
                        lineEscape = true;
                        key = key + line;
                        continue;
                    }
                    lineEscape = false;
                    key = key + line;
                } else {
                    lineEscape = false;
                }
                if (map.containsKey(key)) {
                    IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                    marker.setAttribute("severity", 1);
                    marker.setAttribute("transient", true);
                    marker.setAttribute("message", (Object)CheckAndMarkDuplicateKey.replace(warn, key, "$key$"));
                    marker.setAttribute("lineNumber", cntLine);
                    if (!duplicateKeyList.contains(key)) {
                        int tmpCntLine = (Integer)map.get(key);
                        marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                        marker.setAttribute("severity", 1);
                        marker.setAttribute("transient", true);
                        marker.setAttribute("message", (Object)CheckAndMarkDuplicateKey.replace(warn, key, "$key$"));
                        marker.setAttribute("lineNumber", tmpCntLine);
                        duplicateKeyList.add(key);
                    }
                }
                map.put(key, new Integer(cntLine));
                if (line.endsWith("\\")) {
                    multipleValueFlg = true;
                    continue;
                }
                multipleValueFlg = false;
            }
        }
        catch (IOException e) {
            Status s = new Status(4, "org.eclipse.ui", 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
            map.clear();
            map = null;
        }
    }

    public void checkAndMarkDuplicateKeyInString(String text, IFileEditorInput editorInput) throws CoreException {
        IFile resource = editorInput.getFile();
        this.checkAndMarkDuplicateKeyInString(text, (IResource)resource);
    }

    public void clear() {
        this.map = new HashMap();
    }

    public static String replace(String str, String toString, String fromString) {
        StringBuffer buf = new StringBuffer();
        int idx = str.indexOf(fromString, 0);
        if (idx == -1) {
            return str;
        }
        buf.append(str.substring(0, idx));
        buf.append(toString);
        buf.append(str.substring(idx + fromString.length(), str.length()));
        return buf.toString();
    }
}

