/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.checker.CheckAndMarkDuplicateKey;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesPartitionScanner;
import jp.gr.java_conf.ussiy.app.propedit.util.EncodeChanger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class PropertiesDocumentProvider
extends FileDocumentProvider {
    protected IDocument createDocument(Object element) throws CoreException {
        String readEncode = PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("readEncode");
        if (readEncode == null || readEncode.equals("")) {
            readEncode = this.getDefaultEncoding();
        }
        IDocument document = null;
        if (element instanceof IEditorInput && !this.setDocumentContent(document = this.createEmptyDocument(), (IEditorInput)element, readEncode)) {
            document = null;
        }
        document.set(EncodeChanger.unicodeEsc2Unicode(document.get()));
        if (document != null) {
            DefaultPartitioner partitioner = new DefaultPartitioner((IPartitionTokenScanner)new PropertiesPartitionScanner(), new String[]{"__properties_comment", "__properties_separator", "__properties_key"});
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IFileEditorInput) {
            CheckAndMarkDuplicateKey camd = new CheckAndMarkDuplicateKey();
            IFileEditorInput input = (IFileEditorInput)element;
            camd.checkAndMarkDuplicateKeyInString(document.get(), input);
            try {
                String encoding = PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("readEncode");
                if (encoding == null || encoding.equals("")) {
                    encoding = this.getDefaultEncoding();
                }
                String uniEscStr = null;
                uniEscStr = PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvert") ? document.get() : (PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvertComment") ? EncodeChanger.unicode2UnicodeEscWithoutComment(document.get()) : EncodeChanger.unicode2UnicodeEsc(document.get()));
                ByteArrayInputStream stream = new ByteArrayInputStream(uniEscStr.toString().getBytes(encoding));
                IFile file = input.getFile();
                if (file.exists()) {
                    FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(element);
                    if (info != null && !overwrite) {
                        this.checkSynchronizationState(info.fModificationStamp, (IResource)file);
                    }
                    this.fireElementStateChanging(element);
                    try {
                        file.setContents((InputStream)stream, overwrite, true, monitor);
                    }
                    catch (CoreException x) {
                        this.fireElementStateChangeFailed(element);
                        throw x;
                    }
                    catch (RuntimeException x) {
                        this.fireElementStateChangeFailed(element);
                        throw x;
                    }
                    if (info == null) return;
                    ResourceMarkerAnnotationModel model = (ResourceMarkerAnnotationModel)info.fModel;
                    model.updateMarkers(info.fDocument);
                    info.fModificationStamp = this.computeModificationStamp((IResource)file);
                    return;
                }
                super.doSaveDocument(monitor, element, document, overwrite);
                return;
            }
            catch (IOException x) {
                Status s = new Status(4, "org.eclipse.ui", 0, x.getMessage(), (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }
}

