/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import zephyr.util.PDF2MonoBMP;

public class PDF2MonoBMPDual
extends PDF2MonoBMP {
    private static final int DROP_LINE_WIDTH = 1;
    private final int dpi;
    private final int dropLineDot;
    private static final int FIND_SPAN = 50;

    PDF2MonoBMPDual(int dpi) {
        this.dpi = dpi;
        this.dropLineDot = this.mm2dot(1);
    }

    private int mm2dot(int mm) {
        return (int)((double)(mm * this.dpi) / 25.4);
    }

    private int verticalBlackNum(BufferedImage bim, int x) {
        int height = bim.getHeight();
        int nColor = 0;
        int y = 0;
        while (y < height) {
            if (bim.getRGB(x, y) != -1) {
                ++nColor;
            }
            ++y;
        }
        return nColor;
    }

    private int findVerticalLine(BufferedImage bim) {
        int x = bim.getWidth() / 2;
        int maxColor = 0;
        int maxColorX = -1;
        int startx = Integer.max(0, x - 50);
        int endx = Integer.min(x + 50, bim.getWidth());
        x = startx;
        while (x < endx) {
            int nColor = this.verticalBlackNum(bim, x);
            if (nColor > maxColor) {
                maxColor = nColor;
                maxColorX = x;
            }
            ++x;
        }
        if (maxColorX >= 0) {
            return maxColorX;
        }
        return bim.getWidth() / 2;
    }

    private int horizontalBlackNum(BufferedImage bim, int y) {
        int width = bim.getWidth();
        int nColor = 0;
        int x = 0;
        while (x < width) {
            if (bim.getRGB(x, y) != -1) {
                ++nColor;
            }
            ++x;
        }
        return nColor;
    }

    private int findHorizontalLine(BufferedImage bim) {
        int y = bim.getHeight() / 2;
        int maxColor = 0;
        int maxColorY = 0;
        int endy = bim.getWidth() / 5;
        y = 0;
        while (y < endy) {
            int nColor = this.horizontalBlackNum(bim, y);
            if (nColor > maxColor) {
                maxColor = nColor;
                maxColorY = y;
            }
            ++y;
        }
        return maxColorY;
    }

    @Override
    protected void write(BufferedImage bim, String type, File outputfile) throws Exception {
        int topY = this.findHorizontalLine(bim) + this.dropLineDot;
        int height = bim.getHeight() - topY;
        int midX = this.findVerticalLine(bim);
        int midXLeft = midX - this.dropLineDot;
        int midXRight = midX + this.dropLineDot;
        BufferedImage left = bim.getSubimage(0, topY, midXLeft, height);
        File leftFile = new File(outputfile.getAbsolutePath().replace(".bmp", "a.bmp"));
        ImageIO.write((RenderedImage)left, type, leftFile);
        BufferedImage right = bim.getSubimage(midXRight, topY, bim.getWidth() - midXRight, height);
        File rightFile = new File(outputfile.getAbsolutePath().replace(".bmp", "b.bmp"));
        ImageIO.write((RenderedImage)right, type, rightFile);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: java PDF2MonoBMPDual sample.pdf outDir [dpi] [startPage] [endPage] [prefix] [startIdx]");
            return;
        }
        String pdfname = args[0];
        String outDir = args[1];
        int dpi = args.length > 2 ? Integer.parseInt(args[2]) : 200;
        int startPage = args.length > 3 ? Integer.parseInt(args[3]) : 1;
        int endPage = args.length > 4 ? Integer.parseInt(args[4]) : Integer.MAX_VALUE;
        String prefix = args.length > 5 && !args[5].equals("null") ? args[5] : null;
        int startIdx = args.length > 6 ? Integer.parseInt(args[6]) : 1;
        PDF2MonoBMPDual app = new PDF2MonoBMPDual(dpi);
        app.convert(pdfname, outDir, prefix, startIdx, dpi, startPage, endPage);
    }
}

