/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import org.apache.pdfbox.rendering.ImageType;
import zephyr.util.PDF2Jpeg;

public class PDF2MonoBMP
extends PDF2Jpeg {
    private final double WHITE_RATIO = Double.parseDouble(System.getProperty("whiteRatio", "0.01"));

    PDF2MonoBMP() {
        super(ImageType.BINARY, ".bmp", "bmp", false);
        this.TRIM_MARGIN = Integer.parseInt(System.getProperty("margin", "20"));
    }

    @Override
    protected boolean isWhiteHorizon(BufferedImage bim, int y) {
        int width = bim.getWidth();
        int nColor = 0;
        int nThresh = (int)(this.WHITE_RATIO * (double)width);
        int x = 0;
        while (x < width) {
            if (bim.getRGB(x, y) != -1) {
                ++nColor;
            }
            ++x;
        }
        return nColor <= nThresh;
    }

    @Override
    protected boolean isWhiteVertical(BufferedImage bim, int x) {
        int height = bim.getHeight();
        int nColor = 0;
        int nThresh = (int)(this.WHITE_RATIO * (double)height);
        int y = 0;
        while (y < height) {
            if (bim.getRGB(x, y) != -1) {
                ++nColor;
            }
            ++y;
        }
        return nColor <= nThresh;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: java PDF2MonoBMP sample.pdf outDir [dpi] [startPage] [endPage] [prefix] [startIdx]");
            return;
        }
        String pdfname = args[0];
        String outDir = args[1];
        int dpi = args.length > 2 ? Integer.parseInt(args[2]) : 200;
        int startPage = args.length > 3 ? Integer.parseInt(args[3]) : 1;
        int endPage = args.length > 4 ? Integer.parseInt(args[4]) : Integer.MAX_VALUE;
        String prefix = args.length > 5 && !args[5].equals("null") ? args[5] : null;
        int startIdx = args.length > 6 ? Integer.parseInt(args[6]) : 1;
        PDF2MonoBMP app = new PDF2MonoBMP();
        app.convert(pdfname, outDir, prefix, startIdx, dpi, startPage, endPage);
    }
}

