/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.taishukan.kangorin.IndexManager;
import zephyr.taishukan.kangorin.MakeImages;
import zephyr.util.Counter;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final HashMap<Character, Character> zenhanMap = new HashMap();
    private static final TreeSet<Character> unknownHanSet = new TreeSet();
    private static final HashMap<String, String> GAIJI2TXT;
    private static final Pattern MAP_LINE;
    private static final Pattern GAIJI_LINE;
    private final HashMap<String, String> uni2privMap = new HashMap();
    private static final Pattern LINE;
    static final String WARN_CH = "<sup>*</sup>";
    private static final String RET;
    private static final HashMap<String, String> eb2htmlMap;
    private static final Pattern CHCODE;
    private static final String EP_DT_START_BUSHU = "<1F09><0001><1F41><0160>";
    private static final String EP_DT_START_KANJI = "<1F09><0002><1F41><0160>";
    private static final String EP_ANKER = "<1F09><9999>";
    private static final int EPTAG_LEN;
    private final LinkedList<String> closeTags = new LinkedList();
    private final HashSet<String> posSet = new HashSet();
    public static final String SUBKEY = "<subkey/>";
    public static final String JP = "";
    public static final String EXMP_EN = "<exmp/>";
    public static final String EXMP_JP = "<exmpjp/>";
    public static final String IDIOM_EN = "<idiom/>";
    public static final String IDIOM_JP = "<idiomjp/>";
    private final Counter<String> unknownGaijiCounter = new Counter();
    private boolean prevJukugo = false;
    private boolean inJukugoDT = false;
    private String dtKeys = null;
    private final LinkedList<String> kanjiNos = new LinkedList();
    private static final Pattern EP_REF;

    static {
        zenhanMap.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        zenhanMap.put(Character.valueOf('\uff0c'), Character.valueOf(','));
        zenhanMap.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        zenhanMap.put(Character.valueOf('\uff08'), Character.valueOf('('));
        zenhanMap.put(Character.valueOf('\uff09'), Character.valueOf(')'));
        zenhanMap.put(Character.valueOf('\uff3b'), Character.valueOf('['));
        zenhanMap.put(Character.valueOf('\uff3d'), Character.valueOf(']'));
        zenhanMap.put(Character.valueOf('\uff01'), Character.valueOf('!'));
        zenhanMap.put(Character.valueOf('\uff1f'), Character.valueOf('?'));
        zenhanMap.put(Character.valueOf('\uff0b'), Character.valueOf('+'));
        zenhanMap.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        zenhanMap.put(Character.valueOf('\uff0a'), Character.valueOf('*'));
        zenhanMap.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        zenhanMap.put(Character.valueOf('\u2019'), Character.valueOf('\''));
        zenhanMap.put(Character.valueOf('\uff1a'), Character.valueOf(':'));
        zenhanMap.put(Character.valueOf('\uff1b'), Character.valueOf(';'));
        zenhanMap.put(Character.valueOf('\uff06'), Character.valueOf('&'));
        zenhanMap.put(Character.valueOf('\uff3e'), Character.valueOf('^'));
        zenhanMap.put(Character.valueOf('\uff5c'), Character.valueOf('|'));
        zenhanMap.put(Character.valueOf('\uff1d'), Character.valueOf('='));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        String zenzen = "\u30fc\u300a\u300b\u2015\u3008\u3009\u25c6\u00b0\u21d2\u00b4\uff40\u2032\u2033\uffe0\u2026\u4e00\uff1c\uff1e\u00a7\u00a8\u00d7\u2191\u2193\u300c\u300d\uff5e\u2018\uffe3]";
        int i = 0;
        while (i < zenzen.length()) {
            char c = zenzen.charAt(i);
            zenhanMap.put(Character.valueOf(c), Character.valueOf(c));
            ++i;
        }
        GAIJI2TXT = new HashMap();
        GAIJI2TXT.put("B238", JP);
        GAIJI2TXT.put("B239", JP);
        GAIJI2TXT.put("B23B", JP);
        GAIJI2TXT.put("B241", JP);
        GAIJI2TXT.put("B242", JP);
        GAIJI2TXT.put("A12C", "\u00ea\u0300");
        GAIJI2TXT.put("A13A", "\u00fc\u030c");
        GAIJI2TXT.put("A13B", "\u00fc\u0301");
        GAIJI2TXT.put("A132", "d\u0323");
        GAIJI2TXT.put("A133", "n\u0323");
        GAIJI2TXT.put("A139", "\u00fc\u0300");
        GAIJI2TXT.put("A142", "h\u0323");
        GAIJI2TXT.put("A143", "m\u0323");
        GAIJI2TXT.put("A144", "r\u0323");
        GAIJI2TXT.put("A145", "s\u0323");
        GAIJI2TXT.put("A146", "t\u0323");
        GAIJI2TXT.put("A149", " ");
        GAIJI2TXT.put("B12B", JP);
        GAIJI2TXT.put("B12C", "[\u5b57\u7fa9]");
        GAIJI2TXT.put("B12D", "[\u53c2\u8003]");
        GAIJI2TXT.put("B12E", "[\u540d\u524d]");
        GAIJI2TXT.put("B12F", "[\u96e3\u8aad]");
        GAIJI2TXT.put("B13A", "[\u6559]");
        GAIJI2TXT.put("B13B", "[\u5e38]");
        GAIJI2TXT.put("B13C", "[\u4eba]");
        GAIJI2TXT.put("B13D", "[\u6a19]");
        GAIJI2TXT.put("B13E", "[\u56fd\u5b57]");
        GAIJI2TXT.put("B13F", "[\u52a9\u5b57\u30fb\u53e5\u6cd5\u89e3\u8aac]");
        GAIJI2TXT.put("B148", "(1)");
        GAIJI2TXT.put("B149", "(2)");
        GAIJI2TXT.put("B14A", "(3)");
        GAIJI2TXT.put("B14B", "(4)");
        GAIJI2TXT.put("B14C", "(5)");
        GAIJI2TXT.put("B14D", "(6)");
        GAIJI2TXT.put("B14E", "(7)");
        GAIJI2TXT.put("B14F", "(8)");
        GAIJI2TXT.put("B150", "(9)");
        GAIJI2TXT.put("B151", "(10)");
        GAIJI2TXT.put("B152", "(11)");
        GAIJI2TXT.put("B153", "(12)");
        GAIJI2TXT.put("B154", "(13)");
        GAIJI2TXT.put("B155", "(14)");
        GAIJI2TXT.put("B156", "(15)");
        GAIJI2TXT.put("B157", "(16)");
        GAIJI2TXT.put("B158", "(17)");
        GAIJI2TXT.put("B159", "(18)");
        GAIJI2TXT.put("B15A", "(19)");
        GAIJI2TXT.put("B15B", "(\u30a2)");
        GAIJI2TXT.put("B15C", "(\u30a4)");
        GAIJI2TXT.put("B15D", "(\u30a6)");
        GAIJI2TXT.put("B15E", "(\u30a8)");
        GAIJI2TXT.put("B15F", "(\u30aa)");
        GAIJI2TXT.put("B160", "(\u30ab)");
        GAIJI2TXT.put("B161", "(\u30ad)");
        GAIJI2TXT.put("B162", "(\u30af)");
        GAIJI2TXT.put("B163", "(\u30b1)");
        GAIJI2TXT.put("B164", "(\u30b3)");
        GAIJI2TXT.put("B165", "(\u30b5)");
        GAIJI2TXT.put("B166", "(\u30b7)");
        GAIJI2TXT.put("B167", "(\u30b9)");
        GAIJI2TXT.put("B168", "[[\u4e00]]");
        GAIJI2TXT.put("B169", "[[\u4e8c]]");
        GAIJI2TXT.put("B16A", "[[\u4e09]]");
        GAIJI2TXT.put("B16B", "[[\u56db]]");
        GAIJI2TXT.put("B16C", "[[\u4e94]]");
        GAIJI2TXT.put("B16D", "[[\u516d]]");
        GAIJI2TXT.put("B16E", "(1)");
        GAIJI2TXT.put("B16F", "(2)");
        GAIJI2TXT.put("B170", "(3)");
        GAIJI2TXT.put("B171", "(4)");
        GAIJI2TXT.put("B172", "(5)");
        GAIJI2TXT.put("B173", "(6)");
        GAIJI2TXT.put("B174", "(7)");
        GAIJI2TXT.put("B175", "(8)");
        GAIJI2TXT.put("B176", "(9)");
        GAIJI2TXT.put("B177", "(10)");
        GAIJI2TXT.put("B178", "(11)");
        GAIJI2TXT.put("B179", "(12)");
        GAIJI2TXT.put("B17A", "(13)");
        GAIJI2TXT.put("B17B", "(14)");
        GAIJI2TXT.put("B17C", "(15)");
        GAIJI2TXT.put("B17D", "(\u4e00)");
        GAIJI2TXT.put("B17E", "(\u4e8c)");
        GAIJI2TXT.put("B221", "(\u4e09)");
        GAIJI2TXT.put("B222", "(\u56db)");
        GAIJI2TXT.put("B223", "(\u7532)");
        GAIJI2TXT.put("B224", "(\u4e59)");
        GAIJI2TXT.put("B225", "(\u4e19)");
        GAIJI2TXT.put("B226", "(\u4e01)");
        GAIJI2TXT.put("B227", "(\u620a)");
        GAIJI2TXT.put("B228", "(\u5df1)");
        GAIJI2TXT.put("B229", "[\u4e00]");
        GAIJI2TXT.put("B22A", "[\u4e8c]");
        GAIJI2TXT.put("B22B", "[\u4e09]");
        GAIJI2TXT.put("B22C", "[\u56db]");
        GAIJI2TXT.put("B22D", "[\u4e94]");
        GAIJI2TXT.put("B22E", "((1))");
        GAIJI2TXT.put("B22F", "((2))");
        GAIJI2TXT.put("B230", "((3))");
        GAIJI2TXT.put("B231", "((4))");
        GAIJI2TXT.put("B232", "((5))");
        GAIJI2TXT.put("B233", "((6))");
        GAIJI2TXT.put("B234", "((7))");
        GAIJI2TXT.put("B235", " \u2192 ");
        GAIJI2TXT.put("B236", "\u3014");
        GAIJI2TXT.put("B237", "\u3015");
        GAIJI2TXT.put("B23C", "(\u6f22)");
        GAIJI2TXT.put("B23D", "(\u5449)");
        GAIJI2TXT.put("B23E", "(\u5510)");
        GAIJI2TXT.put("B23F", "(\u6163)");
        GAIJI2TXT.put("B240", "(\u97f3)");
        GAIJI2TXT.put("B243", "[\u540c]");
        GAIJI2TXT.put("B244", "(\u52a9)");
        GAIJI2TXT.put("B123", "[\u7528\u4f8b]");
        GAIJI2TXT.put("B124", "[JIS1\uff652]");
        GAIJI2TXT.put("B125", "[JIS3\uff654]");
        GAIJI2TXT.put("B126", "[S-JIS]");
        GAIJI2TXT.put("B127", "[\u88dc\u52a9]");
        GAIJI2TXT.put("B130", "[\u89e3\u5b57]");
        GAIJI2TXT.put("B131", "[[\u9006]]");
        GAIJI2TXT.put("B133", "<b>[[\u56fd]]</b>");
        GAIJI2TXT.put("B134", "[\u4ecf]");
        GAIJI2TXT.put("B135", "[\u4f7f\u3044\u5206\u3051]");
        GAIJI2TXT.put("B136", "[\u5e73\u58f0]");
        GAIJI2TXT.put("B137", "[\u4e0a\u58f0]");
        GAIJI2TXT.put("B138", "[\u53bb\u58f0]");
        GAIJI2TXT.put("B139", "[\u5165\u58f0]");
        GAIJI2TXT.put("B140", "[\u8a33]");
        GAIJI2TXT.put("B141", "[\u985e]");
        GAIJI2TXT.put("B142", "[\u6ce8\u610f]");
        GAIJI2TXT.put("B143", "[\u89e3\u5b571]");
        GAIJI2TXT.put("B144", "[\u89e3\u5b572]");
        GAIJI2TXT.put("B145", "[\u4fd7\u5b57]");
        GAIJI2TXT.put("B146", "[\u770c\u5b57]");
        GAIJI2TXT.put("B147", "[\u5e9c\u5b57]");
        MAP_LINE = Pattern.compile("[hz]([0-9a-fA-F]+)\tu([0-9a-fA-F]+)");
        GAIJI_LINE = Pattern.compile("<gaijiMap unicode=\"#x(....)\" orgcode=\"#x([0-9A-F]+)\" ebcode=\"....\"");
        LINE = Pattern.compile("<tr><td>([0-9A-F]+{4})</td><td>.+<td>&#x([0-9A-F]+);(.*)</td></tr>");
        RET = System.getProperty("line.separator");
        eb2htmlMap = new HashMap();
        eb2htmlMap.put("1F42", "{a}");
        eb2htmlMap.put("1F62", "{/a}");
        eb2htmlMap.put("1F06", "<sub>");
        eb2htmlMap.put("1F07", "</sub>");
        eb2htmlMap.put("1F0E", "<sup>");
        eb2htmlMap.put("1F0F", "</sup>");
        eb2htmlMap.put("1F12", "<b>");
        eb2htmlMap.put("1F13", "</b>");
        CHCODE = Pattern.compile("\uff06\uff03\uff58([\uff10-\uff19\uff21-\uff26]+)\uff1b");
        EPTAG_LEN = "<xxxx>".length();
        EP_REF = Pattern.compile("<1F62>\\[0*([0-9A-F]+):0([0-9A-F]+)\\]");
    }

    private static char zen2han(char c) {
        if ('\uff10' <= c && c <= '\uff19') {
            return (char)(48 + (c - 65296));
        }
        if ('\uff21' <= c && c <= '\uff3a') {
            return (char)(65 + (c - 65313));
        }
        if ('\uff41' <= c && c <= '\uff5a') {
            return (char)(97 + (c - 65345));
        }
        if (c <= '~') {
            return c;
        }
        Character han = zenhanMap.get(Character.valueOf(c));
        if (han != null) {
            return han.charValue();
        }
        unknownHanSet.add(Character.valueOf(c));
        return '#';
    }

    public static String zen2han(String txt) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < txt.length()) {
            sb.append(MakeBodyHtml.zen2han(txt.charAt(i)));
            ++i;
        }
        return sb.toString();
    }

    private void loadLVGaijiMap(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            Matcher m = MAP_LINE.matcher(line);
            if (!m.find()) continue;
            String code = m.group(1).toUpperCase();
            char c = (char)Integer.parseInt(m.group(2), 16);
            GAIJI2TXT.put(code, Character.toString(c));
        }
        br.close();
    }

    private void loadGaijiMap(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            Matcher m = GAIJI_LINE.matcher(line);
            if (!m.find()) continue;
            String code = m.group(2).toUpperCase();
            String uni = m.group(1);
            this.uni2privMap.put(code, uni);
        }
        br.close();
        System.err.println("load " + this.uni2privMap.size() + " extra gaiji entries");
    }

    private void addGaiji2Unicode(String ebcode, String unicode, boolean bWarn) {
        String warn = bWarn ? "<sup>?</sup>" : JP;
        int code = Integer.parseInt(unicode, 16);
        if (code < 131072) {
            GAIJI2TXT.put(ebcode, "/&#x" + unicode + ";" + warn + " <img src=\"i/" + ebcode + ".JPG\"/>/");
        } else {
            String priv = this.uni2privMap.get(unicode);
            if (priv != null) {
                GAIJI2TXT.put(ebcode, "/&#x" + priv + ";" + warn + " <img src=\"i/" + ebcode + ".JPG\"/>/");
            } else {
                System.err.println("\u79c1\u7684\u30b3\u30fc\u30c9\u4e0d\u660e\uff1a" + ebcode);
                GAIJI2TXT.put(ebcode, "/&amp;#x" + unicode + ";" + warn + " <img src=\"i/" + ebcode + ".JPG\"/>/");
            }
        }
    }

    private void loadGaiji2Unicode(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            String[] v = line.split("\t");
            if (v.length < 4 || v[3].length() <= 0) continue;
            this.addGaiji2Unicode(v[0], v[3], false);
        }
        br.close();
    }

    private void loadUnknownGaiji2Unicode(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            boolean hasComment;
            Matcher m = LINE.matcher(line);
            if (!m.find()) continue;
            String ebcode = m.group(1);
            String unicode = m.group(2);
            boolean bl = hasComment = m.group(3) != null && m.group(3).length() > 0;
            if (!hasComment) {
                this.addGaiji2Unicode(ebcode, unicode, false);
                continue;
            }
            this.addGaiji2Unicode(ebcode, unicode, true);
        }
        br.close();
    }

    private String makeUTFChar(String line) {
        StringBuilder sb = null;
        Matcher m = CHCODE.matcher(line);
        int idx = 0;
        while (m.find()) {
            if (idx >= m.start()) continue;
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(line.substring(idx, m.start()));
            int code = Integer.parseInt(MakeBodyHtml.zen2han(m.group(1)), 16);
            sb.append((char)code);
            idx = m.end();
        }
        if (sb == null) {
            return line;
        }
        if (idx < line.length()) {
            sb.append(line.substring(idx));
        }
        return sb.toString();
    }

    private void addKanjiNo(String line) {
        line = line.replaceAll("<[0-9A-F]+>", JP);
        line = MakeBodyHtml.zen2han(line);
        this.kanjiNos.add(line);
    }

    private void handleImage(StringBuilder sb, String line) {
        Matcher m = MakeImages.SINGLE_IMAGE.matcher(line);
        if (!m.find()) {
            System.err.println("\u56f3\u5f62\u7570\u5e38\uff1a" + line);
            return;
        }
        String filename = MakeImages.pos2filename(m.group(1), m.group(2));
        String comment = m.group(3);
        sb.append("<img src=\"g/");
        sb.append(filename);
        sb.append("\"/>");
        if (comment != null && comment.length() > 0) {
            sb.append(comment);
        }
        sb.append("\u3000");
    }

    private String ep2html(String line, HashSet<String> refs, IndexManager idxMgr) {
        String brRetP;
        if ((line = this.makeUTFChar(line)).contains("<1F09><0062>")) {
            line = line.replace('\uff0a', '*');
        }
        StringBuilder sb = new StringBuilder();
        boolean bZenkaku = true;
        int i = line.indexOf(93);
        String[] v = line.substring(1, i).replace(" ", "0").split(":");
        if (v[1].equals("800")) {
            v[0] = String.format("%X", Integer.parseInt(v[0], 16) + 1);
            v[1] = "000";
        }
        String pos = String.valueOf(v[0]) + v[1];
        boolean isRefered = refs.contains(pos);
        String keys = idxMgr.getKey(pos);
        if (keys != null) {
            isRefered = true;
            if (this.dtKeys == null) {
                this.dtKeys = keys;
            }
        }
        String linebody = line.substring(++i);
        if (!isRefered && linebody.startsWith(EP_ANKER)) {
            return JP;
        }
        boolean inDT = false;
        if (isRefered) {
            brRetP = "</p>" + RET + "<p id=\"" + pos + "\">";
            this.posSet.add(pos);
        } else {
            brRetP = "</p>" + RET + "<p>";
        }
        String newJukugoDt = "</p></dd>" + RET + "<dt id=\"" + pos + "\" noindex=\"1\">";
        String jukugoDtEnd = this.dtKeys != null ? "</dt>" + this.dtKeys + "<dd>" + RET + "<p>" : "</dt><dd>" + RET + "<p>";
        boolean hasJukugo = false;
        boolean hasJukugoYomi = false;
        while (i < line.length()) {
            char c;
            block248: {
                String code;
                c = line.charAt(i);
                if (c != '<') break block248;
                switch (code = line.substring(i + 1, i + 5)) {
                    case "1FE0": {
                        String code2;
                        switch (code2 = line.substring(i + 7, i + 11)) {
                            case "0001": {
                                sb.append("<i>");
                                this.closeTags.addFirst("</i>");
                                break;
                            }
                            case "0000": 
                            case "0003": {
                                if (inDT) break;
                                sb.append("<b>");
                                this.closeTags.addFirst("</b>");
                            }
                        }
                        i += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F09": {
                        String code2;
                        String codeX = line.substring(i);
                        if (codeX.startsWith(EP_DT_START_BUSHU) || codeX.startsWith(EP_DT_START_KANJI)) {
                            if (!this.closeTags.isEmpty()) {
                                System.err.println("missing closeTags before " + pos);
                            }
                            if (isRefered) {
                                sb.append("<dt id=\"" + pos + "\" noindex=\"1\">");
                                isRefered = false;
                            } else {
                                sb.append("<dt>");
                            }
                            inDT = true;
                            i += EP_DT_START_BUSHU.length();
                            this.inJukugoDT = false;
                            break;
                        }
                        switch (code2 = line.substring(i + 7, i + 11)) {
                            case "0011": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0010": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0060": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0061": {
                                sb.append(brRetP);
                                sb.append("\u3000");
                                break;
                            }
                            case "0030": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0062": {
                                sb.append(" ");
                                break;
                            }
                            case "0002": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0007": {
                                return JP;
                            }
                            case "0020": {
                                sb.append(String.valueOf(brRetP) + "\u6f22\u5b57\u756a\u53f7\uff1a");
                                this.addKanjiNo(linebody);
                                break;
                            }
                            case "0014": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0021": {
                                sb.append("\u3000");
                                break;
                            }
                            case "0022": {
                                sb.append("\u3000");
                                break;
                            }
                            case "0023": {
                                sb.append("\u3000");
                                break;
                            }
                            case "0024": {
                                sb.append("\u3000");
                                break;
                            }
                            case "0012": {
                                sb.append("\u3000");
                                break;
                            }
                            case "0028": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0027": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0026": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0025": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0008": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0090": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0063": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0031": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0032": {
                                sb.append(String.valueOf(brRetP) + "\u6f22\u5b57\u756a\u53f7\uff1a");
                                this.addKanjiNo(linebody);
                                break;
                            }
                            case "0033": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0034": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0035": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0036": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0037": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0038": 
                            case "0070": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0039": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0043": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0044": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0040": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0041": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0042": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0068": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0051": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0050": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0052": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0053": {
                                if (this.inJukugoDT) {
                                    sb.append(jukugoDtEnd);
                                    this.inJukugoDT = false;
                                    this.dtKeys = null;
                                    break;
                                }
                                sb.append(brRetP);
                                break;
                            }
                            case "0054": {
                                if (this.inJukugoDT) {
                                    sb.append(jukugoDtEnd);
                                    this.inJukugoDT = false;
                                    this.dtKeys = null;
                                    break;
                                }
                                sb.append(brRetP);
                                break;
                            }
                            case "0055": {
                                sb.append(String.valueOf(brRetP) + "\u3000");
                                break;
                            }
                            case "0056": {
                                sb.append(String.valueOf(brRetP) + "\u3000\u3000");
                                break;
                            }
                            case "0081": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0080": {
                                hasJukugo = true;
                                if (this.prevJukugo) {
                                    sb.append("\u3000");
                                    break;
                                }
                                sb.append(String.valueOf(brRetP) + "\u25a0 ");
                                break;
                            }
                            case "0003": {
                                sb.append(newJukugoDt);
                                this.inJukugoDT = true;
                                break;
                            }
                            case "0067": {
                                sb.append("\u3000");
                                hasJukugoYomi = true;
                                break;
                            }
                            case "0066": {
                                if (!this.inJukugoDT) break;
                                sb.append(jukugoDtEnd);
                                this.inJukugoDT = false;
                                this.dtKeys = null;
                                break;
                            }
                            case "0064": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0083": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0065": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0086": {
                                sb.append(brRetP);
                                break;
                            }
                            case "0085": {
                                sb.append(brRetP);
                                break;
                            }
                            default: {
                                System.err.println("Unknown 1F09 " + code2);
                                System.exit(1);
                            }
                            case "0013": 
                            case "0082": 
                            case "0084": 
                        }
                        i += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F61": {
                        if (inDT) {
                            if (keys != null) {
                                sb.append("</dt>" + keys + "<dd><p>");
                            } else {
                                sb.append("</dt><dd><p>");
                            }
                            inDT = false;
                        }
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F04": {
                        bZenkaku = false;
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F05": {
                        bZenkaku = true;
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1FE1": {
                        for (String closeTag : this.closeTags) {
                            sb.append(closeTag);
                        }
                        this.closeTags.clear();
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1FE2": {
                        int end = line.indexOf("<1FE3>", i);
                        if (end < 0) {
                            System.err.println("<1FE3>\u306a\u3057");
                            System.err.println(line);
                            return JP;
                        }
                        i = end + EPTAG_LEN;
                        break;
                    }
                    case "1F4A": {
                        sb.append("\u3000\u97f3\u58f0");
                        i += 3 * EPTAG_LEN;
                        i = line.indexOf(93, i);
                        i = line.indexOf(93, i + 1) + 1;
                        break;
                    }
                    case "1F4D": {
                        int end = line.indexOf("<1F6D>", i);
                        if (end < 0) {
                            System.err.println("<1F6D>\u4e0d\u660e");
                            System.err.println(line);
                            return JP;
                        }
                        this.handleImage(sb, line.substring(i, end += EPTAG_LEN));
                        i = end;
                        break;
                    }
                    default: {
                        if (code.compareTo("A121") >= 0 && code.compareTo("FE7E") <= 0) {
                            String t = GAIJI2TXT.get(code);
                            if (t != null) {
                                sb.append(t);
                            } else {
                                sb.append("<img src=\"i/");
                                sb.append(code);
                                sb.append(".jpg\" /> ");
                                sb.append(code);
                            }
                        } else {
                            String tag = eb2htmlMap.get(code);
                            if (tag != null) {
                                sb.append(tag);
                            }
                        }
                        i += EPTAG_LEN;
                        break;
                    }
                }
                continue;
            }
            if (bZenkaku) {
                sb.append(c);
            } else {
                sb.append(MakeBodyHtml.zen2han(c));
            }
            ++i;
        }
        String l = sb.toString();
        if (inDT) {
            l = String.valueOf(l) + "</dt>" + keys + "<dd><p>";
        }
        this.prevJukugo = hasJukugo;
        if (hasJukugoYomi) {
            l = String.valueOf(l) + "\u3000";
        }
        return l;
    }

    private HashSet<String> findRefs(String filename) throws Exception {
        String line;
        HashSet<String> refs = new HashSet<String>();
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        br.readLine();
        br.readLine();
        while ((line = br.readLine()) != null) {
            Matcher m = EP_REF.matcher(line);
            while (m.find()) {
                refs.add(String.valueOf(m.group(1)) + m.group(2));
            }
        }
        br.close();
        System.err.println("found " + refs.size() + " unique refs");
        return refs;
    }

    private String normalize(String dd) {
        dd = dd.replaceAll("(<p[^>]*>)[\u3000 ]*(\\(<b>[0-9]+</b>\\))", "$1\u3000$2");
        dd = dd.replaceAll("(<p[^>]*>\u3000*<i>[a-z]+</i>(, *<i>[a-z]+</i>)*) *", "$1\u3000");
        dd = dd.replaceAll("\\{a\\}([^\\{\\}]+?)\\{/a\\}\\[0*([0-9A-F]+):0([0-9A-F]+)\\]", "<a href=\"#$2$3\">$1</a>");
        dd = dd.replaceAll("[\u3000 ]+</p>", "</p>");
        dd = dd.replaceAll("<p[^>]*></p>", JP);
        dd = dd.replace("<p><jp/></p><p>", "<p><jp/>");
        dd = dd.replaceAll("=0>=0>\\[[0-9A-F]+:[0-9A-F]+\\]", JP);
        dd = dd.replaceAll("\u3000+</dt>", "</dt>");
        dd = dd.replace("\u25b3", "<sup>\u25b3</sup>");
        if (this.kanjiNos.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String no : this.kanjiNos) {
                sb.append("<key type=\"\u8868\u8a18\">");
                sb.append(no);
                sb.append("</key>");
            }
            String noKey = sb.toString();
            dd = dd.replaceFirst("<dd>", String.valueOf(noKey) + "<dd>");
            this.kanjiNos.clear();
        }
        dd = dd.replaceFirst("<dt id=\"(.+?)\" noindex=\"1\">(\u300a.+?\u300b)</dt>(.+?)<dd>", "<h1 id=\"$1\" noindex=\"1\">$2</h1>$3");
        dd = dd.replaceFirst("(<p>[0-9]+\u753b .+</a></p>)</dd>", "$1");
        return dd;
    }

    private void parse(String filename, IndexManager idxMgr) throws Exception {
        String line;
        HashSet<String> refs = this.findRefs(filename);
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        br.readLine();
        br.readLine();
        StringBuilder sb = null;
        System.out.println("<html><body>");
        int nEntry = 0;
        while ((line = br.readLine()) != null) {
            String html;
            if ((line = line.trim()).isEmpty() || (html = this.ep2html(line, refs, idxMgr)).isEmpty()) continue;
            if (sb == null) {
                sb = new StringBuilder();
            } else if (html.startsWith("<dt") && sb != null) {
                String out = this.normalize(String.valueOf(sb.toString()) + "</p></dd>");
                System.out.println(out);
                this.dtKeys = null;
                sb = new StringBuilder();
                if (++nEntry % 1000 == 0) {
                    if (nEntry % 10000 == 0) {
                        System.err.print(nEntry / 10000);
                    } else {
                        System.err.print(".");
                    }
                }
            }
            sb.append(html);
        }
        br.close();
        if (sb != null) {
            System.out.println(String.valueOf(this.normalize(sb.toString())) + "</p></dd>");
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println(String.valueOf(nEntry) + " entries");
        this.unknownGaijiCounter.dump();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: java MakeBodyHtml kangorin.txt hyoki.txt kana.txt");
            return;
        }
        ZephyrUtil.setUTF8Ouput();
        MakeBodyHtml app = new MakeBodyHtml();
        IndexManager idxMgr = new IndexManager(args[1], args[2]);
        app.loadLVGaijiMap("NKGORIN2.map");
        app.loadGaijiMap("GaijiMap.xml");
        app.loadGaiji2Unicode("gaiji2unicode.txt");
        app.loadUnknownGaiji2Unicode("gaiji2unicode.html");
        app.parse(args[0], idxMgr);
    }
}

