/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class SVG2BMP {
    private Float PIXEL = new Float(50.0f);

    private void svg2png(File svgFile, File pngFile) throws Exception {
        PNGTranscoder t = new PNGTranscoder();
        t.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, (Object)Color.white);
        t.addTranscodingHint(PNGTranscoder.KEY_INDEXED, (Object)new Integer(1));
        t.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)this.PIXEL);
        t.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)this.PIXEL);
        TranscoderInput input = new TranscoderInput(svgFile.toURI().toString());
        FileOutputStream ostream = new FileOutputStream(pngFile);
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        t.transcode(input, output);
        ostream.flush();
        ((OutputStream)ostream).close();
    }

    private void svg2bmp(File svgFile, File outDir, File pngFile) throws Exception {
        System.out.println(svgFile.getName());
        this.svg2png(svgFile, pngFile);
        BufferedImage inImage = ImageIO.read(pngFile);
        BufferedImage outImage = new BufferedImage(inImage.getWidth(), inImage.getHeight(), 12);
        Graphics2D off = outImage.createGraphics();
        off.drawImage(inImage, 0, 0, Color.WHITE, null);
        File outFile = new File(outDir, svgFile.getName().replace(".svg", ".bmp"));
        ImageIO.write((RenderedImage)outImage, "bmp", outFile);
    }

    private void svgDir2bmpDir(File svgDir, File bmpDir) throws Exception {
        bmpDir.mkdirs();
        File pngFile = new File(bmpDir, "tmp.png");
        Object[] files = svgDir.list();
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            this.svg2bmp(new File(svgDir, (String)file), bmpDir, pngFile);
            ++n2;
        }
        pngFile.delete();
    }

    public static void main(String[] args) throws Exception {
        String bmp;
        SVG2BMP app = new SVG2BMP();
        String svg = args.length > 0 ? args[0] : "svg";
        String string = bmp = args.length > 1 ? args[1] : "s";
        if (args.length > 2) {
            app.PIXEL = new Float(Integer.parseInt(args[2]));
        }
        app.svgDir2bmpDir(new File(svg), new File(bmp));
    }
}

