/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;

public class GetSVG {
    private LinkedList<String> load(File txtFile) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(txtFile);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        LinkedList<String> idList = new LinkedList<String>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] v = line.split(" ");
            idList.add(v[0]);
        }
        br.close();
        System.err.println(String.valueOf(idList.size()) + " chars");
        return idList;
    }

    static String id2gwid(String id) {
        if (id.startsWith("DH")) {
            return "dkw-h" + id.substring(2, 6);
        }
        if (id.endsWith(".0")) {
            return "dkw-" + id.substring(1, 6);
        }
        if (id.endsWith(".1")) {
            return "dkw-" + id.substring(1, 6) + "d";
        }
        System.err.println("*** " + id);
        return null;
    }

    private void getSVG(String id, File outDir) throws Exception {
        Thread.sleep(3000L);
        String code = GetSVG.id2gwid(id);
        if (id == null) {
            return;
        }
        URL url = new URL("http://glyphwiki.org/glyph/" + code + ".svg");
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        InputStream inStream = connection.getInputStream();
        BufferedReader input = new BufferedReader(new InputStreamReader(inStream));
        System.out.println(id);
        File outFile = new File(outDir, String.valueOf(id) + ".svg");
        PrintWriter pw = new PrintWriter(outFile);
        String line = "";
        while ((line = input.readLine()) != null) {
            pw.println(line);
        }
        pw.close();
        input.close();
    }

    private void getSVG(LinkedList<String> idList, File outDir) throws Exception {
        outDir.mkdirs();
        for (String id : idList) {
            try {
                this.getSVG(id, outDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String filename = args.length > 0 ? args[0] : "dkw2ucs.txt";
        String outdirName = args.length > 1 ? args[1] : "svg";
        GetSVG app = new GetSVG();
        LinkedList<String> idList = app.load(new File(filename));
        app.getSVG(idList, new File(outdirName));
    }
}

