/*
 * Decompiled with CFR 0.152.
 */
package zephyr.oxford.oed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import zephyr.util.MultiTreeMap;
import zephyr.util.ZephyrUtil;

public class SortLemma {
    private static final HashSet<Character> ignoreChars = new HashSet();
    private final MultiTreeMap<String, LinkedList<String>> lemmaMap = new MultiTreeMap();
    private char lastHead = (char)32;
    private LinkedList<String> lemmaList = null;
    private static final String[][] LIST;

    static {
        String ignore = " !\"#$%&'()'-=^~\\|@`[{]};+:*<>,./?_\u2020\u02cc\u02c8\u2016\u2014\u00b6\u2006\u2013\u2018\u2032\u2019";
        int i = 0;
        while (i < ignore.length()) {
            ignoreChars.add(Character.valueOf(ignore.charAt(i)));
            ++i;
        }
        LIST = new String[][]{{"0898 number, n. Brit.", "14"}, {"A", "16585"}, {"B", "15072"}, {"C", "26838"}, {"D", "14897"}, {"E", "10252"}, {"F", "3121"}, {"field, n.", "2"}, {"fieldage rare.", "11499"}, {"G", "7010"}, {"graving, vbl. n.1", "2854"}, {"H", "6237"}, {"hokey-pokey slang or colloq.", "4926"}, {"I", "7861"}, {"integrant, a. (n.)", "676"}, {"inde\u02c8pendentism", "7581"}, {"J", "2383"}, {"K", "3602"}, {"L", "2254"}, {"\u02c8law-a\u02c8biding, a.", "664"}, {"\u2020 \u02c8leafit Obs.", "6877"}, {"M", "13123"}, {"monkey, n.", "4937"}, {"N", "6116"}, {"O", "8139"}, {"P", "20903"}, {"profilograph", "4418"}, {"Q", "1843"}, {"R", "901"}, {"S", "35196"}, {"T", "15977"}, {"U", "737"}, {"umbrella", "12554"}, {"V", "5536"}, {"W", "8964"}, {"X", "164"}, {"Y", "2348"}, {"Z", "780"}};
    }

    private String normalize(String line) {
        int idx = line.indexOf(44);
        if (idx > 0) {
            line = line.substring(0, idx);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (!ignoreChars.contains(Character.valueOf(c))) {
                sb.append(c);
            }
            ++i;
        }
        return ZephyrUtil.dropMarks(sb.toString()).toLowerCase().trim();
    }

    private void addLemma(String line) {
        String lemma = this.normalize(line);
        if (lemma.length() == 0) {
            return;
        }
        char head = lemma.charAt(0);
        if ('0' <= head && head <= '9') {
            head = '0';
        }
        if (this.lastHead != head) {
            this.lemmaList = new LinkedList();
            this.lemmaMap.put(lemma, this.lemmaList);
            this.lastHead = head;
        }
        this.lemmaList.add(line);
    }

    private void loadFile(File file) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        boolean found = false;
        while ((line = br.readLine()) != null) {
            if (line.equals("======")) {
                found = false;
                continue;
            }
            if (found || line.startsWith("Draft entry ") || line.startsWith("Additions ") || line.isEmpty()) continue;
            found = true;
            this.addLemma(line);
        }
        br.close();
    }

    private void output() {
        ListComp comp = new ListComp();
        for (String key : this.lemmaMap.keySet()) {
            LinkedList listList = this.lemmaMap.getList(key);
            Collections.sort(listList, comp);
            for (LinkedList list : listList) {
                System.err.println(String.valueOf(list.size()) + "\t" + (String)list.getFirst() + "\t" + (String)list.getLast());
            }
        }
        String prevLemma = "";
        String[][] stringArray = LIST;
        int n = LIST.length;
        int n2 = 0;
        while (n2 < n) {
            String[] s = stringArray[n2];
            String key = s[0];
            int len = Integer.parseInt(s[1]);
            System.err.println(String.valueOf(key) + "\t" + len);
            LinkedList list = (LinkedList)this.lemmaMap.getList(this.normalize(key)).getFirst();
            if (list.size() == len) {
                int idx = 0;
                if (idx < len && list.get(idx) == prevLemma) {
                    ++idx;
                }
                if (idx == len) {
                    idx = 0;
                }
                while (idx < len) {
                    String lemma = (String)list.get(idx);
                    System.out.println(String.valueOf(this.normalize(lemma)) + "\t" + lemma);
                    prevLemma = lemma;
                    ++idx;
                }
            }
            ++n2;
        }
    }

    private void loadDir(String dirname) throws Exception {
        this.lastHead = (char)32;
        this.lemmaList = null;
        System.err.println("check " + dirname);
        int i = 0;
        while (i < 50) {
            File f = new File(dirname, "oed-" + i + ".txt");
            if (f.exists()) {
                this.loadFile(f);
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        SortLemma app = new SortLemma();
        if (args.length == 0) {
            File dir = new File("data");
            String[] stringArray = dir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                app.loadDir("data/" + name);
                ++n2;
            }
        } else {
            app.loadDir(args[0]);
        }
        app.output();
    }

    private class ListComp
    implements Comparator<LinkedList<String>> {
        private ListComp() {
        }

        @Override
        public int compare(LinkedList<String> o1, LinkedList<String> o2) {
            return o2.size() - o1.size();
        }
    }
}

