/*
 * Decompiled with CFR 0.152.
 */
package zephyr.oxford.oed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.LinkedList;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    static final String ENTRY_DELIM = "======";
    private final HashSet<String> ignorePosts = new HashSet();
    private int nEntry = 0;

    private void fixLines(LinkedList<String> lines) {
        String l0 = lines.get(0);
        if (l0.startsWith("Draft entry ") || l0.startsWith("Additions ")) {
            String l2 = lines.get(2);
            lines.set(0, l2);
            lines.set(2, l0);
        }
    }

    private void loadPostfixTxt() throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File("postfix.txt"));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("\t") || line.startsWith("#")) continue;
            this.ignorePosts.add(line);
        }
        br.close();
    }

    private void divideTitleLine(String line, String[] titles) {
        int idx = line.indexOf(", ");
        if (idx > 0) {
            titles[0] = line.substring(0, idx);
            titles[1] = line.substring(idx);
            return;
        }
        idx = line.lastIndexOf(32);
        if (idx < 0) {
            titles[0] = line;
            titles[1] = null;
            return;
        }
        String post = line.substring(idx + 1);
        if (this.ignorePosts.contains(post)) {
            titles[0] = line.substring(0, idx);
            titles[1] = line.substring(idx);
        } else {
            titles[0] = line;
            titles[1] = null;
        }
    }

    private void outLines(LinkedList<String> lines) {
        if (lines.size() < 3) {
            System.err.println("lines.size()=" + lines.size());
            return;
        }
        this.fixLines(lines);
        String[] titles = new String[2];
        String line0 = lines.get(0);
        this.divideTitleLine(line0, titles);
        if (titles[1] != null) {
            System.out.print("<dt title=\"");
            System.out.print(line0);
            System.out.print("\">");
            System.out.print(titles[0]);
            System.out.print("</dt><dd><i>");
            System.out.print(titles[1]);
            System.out.println("</i>");
        } else {
            System.out.print("<dt>");
            System.out.print(line0);
            System.out.print("</dt><dd>");
            System.out.println("<br>");
        }
        int i = 1;
        while (i < lines.size()) {
            String l = lines.get(i).trim();
            if (l.isEmpty()) {
                if (i > 1) {
                    System.out.println("<br><br>");
                }
            } else {
                System.out.println("<p>" + l + "</p>");
            }
            ++i;
        }
        System.out.println("</dd>");
        ++this.nEntry;
    }

    private void loadTxt(File file) throws Exception {
        String line;
        System.err.println(file.getName());
        FileInputStream in = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        LinkedList<String> lines = new LinkedList<String>();
        while ((line = br.readLine()) != null) {
            if ((line = line.replace("\ufeff", "")).equals(ENTRY_DELIM)) {
                this.outLines(lines);
                lines.clear();
                continue;
            }
            String[] stringArray = line.split("\r\r");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                l = l.replaceAll("(\\xa0+)([ac\\? ]*[\\xa0\\u2006]*[0-9\\-\u2013]+)", "$1<b>$2</b>");
                l = l.replaceFirst("^([\u2020\u00b6]?(([A-Za-z]|[IVX]+|[0-9]{1,3})\\. )+)", "<b>$1</b>");
                lines.add(l);
                ++n2;
            }
        }
        br.close();
        if (!lines.isEmpty()) {
            this.outLines(lines);
        }
    }

    private void loadDir(String[] args) throws Exception {
        String dirname = args.length > 0 ? args[0] : "data";
        File dir = new File(dirname);
        System.out.println("<html><body>");
        int i = 0;
        while (i < 100) {
            File f = new File(dir, "oed-" + i + ".txt");
            if (!f.exists()) break;
            this.loadTxt(f);
            ++i;
        }
        System.out.println("</body></html>");
        System.err.println(String.valueOf(this.nEntry) + " entries");
    }

    public static void main(String[] args) {
        ZephyrUtil.setUTF8Ouput();
        MakeBodyHtml app = new MakeBodyHtml();
        try {
            app.loadPostfixTxt();
            app.loadDir(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

