/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusya.lajp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    static final String ENTRY_DELIM = "======";
    private final HashMap<String, Integer> bodyIdMap = new HashMap();
    private static final String NUM_REGEXP = "^([0-9]+|I+)[ \\.]";
    private static final Pattern NUM = Pattern.compile("^([0-9]+|I+)[ \\.]");
    private static final String REF_PREV = "\u2191";
    private static final String REF_NEXT = "\u2193";
    private static final String REF_REGEXP = "[\u21d2\uff1d] *(.+?)[\uff0e ()\u300b,]";
    private static final Pattern REF = Pattern.compile("[\u21d2\uff1d] *(.+?)[\uff0e ()\u300b,]");
    private static final String REFWORD_REGEXP = "[^/ ]+";
    private static final Pattern REFWORD = Pattern.compile("[^/ ]+");
    private static boolean CHECK_REF = false;
    private static final String PARA_REGEXP = "<p>(<b>)?.+?</p>";
    private static final Pattern PARA = Pattern.compile("<p>(<b>)?.+?</p>");

    private String makeHeadkey(String dt) {
        int idx = dt.indexOf(44);
        if (idx > 0) {
            dt = dt.substring(0, idx);
        }
        if ((idx = dt.indexOf(32)) > 0) {
            dt = dt.substring(0, idx);
        }
        return dt;
    }

    private void addBodyIdKey(String key, int id, boolean bCheck) {
        if (!this.bodyIdMap.containsKey(key)) {
            this.bodyIdMap.put(key, id);
        }
    }

    private void loadHeadwords(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        int id = 0;
        boolean bNextDt = true;
        while ((line = br.readLine()) != null) {
            boolean hasDialects;
            String trline = line.trim();
            if (trline.isEmpty()) continue;
            if (line.equals(ENTRY_DELIM)) {
                bNextDt = true;
                continue;
            }
            if (!bNextDt) continue;
            String key = this.makeHeadkey(trline);
            this.addBodyIdKey(key, id, true);
            String key2 = ZephyrUtil.makeKey(key, false);
            boolean bl = hasDialects = !key.equals(key2);
            if (hasDialects) {
                this.addBodyIdKey(key2, id, false);
            }
            if (Character.isDigit(key.charAt(key.length() - 1))) {
                this.addBodyIdKey(key.substring(0, key.length() - 1), id, false);
                if (hasDialects) {
                    this.addBodyIdKey(key2.substring(0, key2.length() - 1), id, false);
                }
            }
            ++id;
            bNextDt = false;
        }
        System.err.println("loaded " + id + " entries from " + filename);
        br.close();
        ((InputStream)in).close();
    }

    private Integer getBodyId(String word) {
        Integer bodyId = this.bodyIdMap.get(word);
        if (bodyId != null) {
            return bodyId;
        }
        if (Character.isDigit(word.charAt(word.length() - 1)) && (bodyId = this.bodyIdMap.get(word.substring(0, word.length() - 1))) != null) {
            return bodyId;
        }
        return null;
    }

    private void addKeyHyoki(StringBuffer sb, String dt) {
        String[] words = dt.split(", *");
        if (words.length > 1) {
            TreeSet<String> keys = new TreeSet<String>();
            String[] stringArray = words;
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String w = stringArray[n2];
                String key = ZephyrUtil.makeKey(w, true);
                if (!keys.contains(key)) {
                    sb.append("<key type=\"\u8868\u8a18\">");
                    sb.append(key);
                    sb.append("</key>");
                    keys.add(key);
                }
                ++n2;
            }
        }
    }

    private String fixNumbering(String line) {
        Matcher m = NUM.matcher(line);
        if (m.find()) {
            String num = m.group(1);
            String txt = "";
            txt = String.valueOf(txt) + "<b>" + num + "</b>";
            if (!m.group().endsWith(" ")) {
                txt = String.valueOf(txt) + " ";
            }
            txt = String.valueOf(txt) + line.substring(m.end(1));
            return txt;
        }
        return line;
    }

    private String makeRefById(int id, String word) {
        return "<a href=\"#" + id + "\">" + word + "</a>";
    }

    private String fixRef(String line) {
        Matcher m = REF.matcher(line);
        int k = 0;
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String word;
            Integer bodyId;
            if (k < m.start(1)) {
                sb.append(line.substring(k, m.start(1)));
            }
            if ((bodyId = this.getBodyId(word = m.group(1))) != null) {
                sb.append(this.makeRefById(bodyId, word));
            } else {
                sb.append(word);
            }
            k = m.end(1);
        }
        if (k < line.length()) {
            sb.append(line.substring(k));
        }
        return sb.toString();
    }

    private String fixRefInBracket(String line, String dt, int id) {
        int idx2;
        int idx = line.indexOf(65339);
        if (idx < 0) {
            return line;
        }
        if ((idx2 = line.indexOf(65341, ++idx)) < 0) {
            System.err.println("ERROR: " + line);
        }
        String ref = line.substring(idx, idx2);
        StringBuffer sb = new StringBuffer();
        Matcher m = REFWORD.matcher(ref);
        int k = 0;
        while (m.find()) {
            String word;
            if (k < m.start()) {
                sb.append(ref.substring(k, m.start()));
            }
            if ((word = m.group()).equals(REF_PREV)) {
                sb.append(this.makeRefById(id - 1, REF_PREV));
            } else if (word.equals(REF_NEXT)) {
                sb.append(this.makeRefById(id + 1, REF_NEXT));
            } else {
                Integer bodyId = this.getBodyId(word);
                if (bodyId != null) {
                    sb.append(this.makeRefById(bodyId, word));
                } else {
                    sb.append(word);
                    if (CHECK_REF && !word.startsWith("Gk") && !word.startsWith("-") && !word.startsWith("cf.") && word.charAt(0) < '\u1000') {
                        System.err.println("WARN: cannot find refkey: " + word + " at " + dt);
                    }
                }
            }
            k = m.end();
        }
        if (k < ref.length()) {
            sb.append(ref.substring(k));
        }
        return String.valueOf(line.substring(0, idx)) + sb.toString() + line.substring(idx2);
    }

    private String fixIndent(String line) {
        StringBuffer sb = new StringBuffer();
        Matcher m = PARA.matcher(line);
        int idx = 0;
        int indent = 1;
        boolean hasNum = false;
        while (m.find()) {
            int newIndent;
            if (idx < m.start(0)) {
                sb.append(line.substring(idx, m.start(0)));
            }
            if (!hasNum && m.group(1) != null) {
                hasNum = true;
            }
            if (indent != (newIndent = hasNum && m.group(1) == null ? 2 : 1)) {
                sb.append("<indent val=\"");
                sb.append(newIndent);
                sb.append("\">");
                indent = newIndent;
            }
            sb.append(m.group(0));
            idx = m.end(0);
        }
        if (idx < line.length()) {
            sb.append(line.substring(idx));
        }
        return sb.toString();
    }

    private String fixEntry(String line) {
        line = line.replaceFirst("</p><p>(\uff3b.+?\uff3d</p>)", " $1");
        line = this.fixIndent(line);
        return line;
    }

    private void loadTxt(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        System.out.println("<html><body>");
        int id = 0;
        int ddidx = 0;
        String dt = "";
        StringBuffer sb = null;
        while ((line = br.readLine()) != null) {
            String trline = line.trim();
            if (trline.isEmpty()) continue;
            if (line.equals(ENTRY_DELIM)) {
                sb.append("</dd>");
                System.out.println(this.fixEntry(sb.toString()));
                sb = null;
                if (++id % 1000 != 0) continue;
                System.err.print(".");
                continue;
            }
            if (line.charAt(0) != ' ') {
                sb = new StringBuffer();
                sb.append("<dt id=\"");
                sb.append(id);
                sb.append("\">");
                dt = trline;
                sb.append(dt);
                sb.append("</dt>");
                this.addKeyHyoki(sb, trline);
                sb.append("<dd>");
                ddidx = 0;
                continue;
            }
            String txt = this.fixNumbering(trline);
            if (ddidx < 2) {
                txt = this.fixRefInBracket(txt, dt, id);
            }
            txt = this.fixRef(txt);
            sb.append("<p>");
            sb.append(txt);
            sb.append("</p>");
            ++ddidx;
        }
        System.out.println("</body></html>");
        br.close();
        ((InputStream)in).close();
        System.err.println();
        System.err.println("done. " + id + " entries");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            MakeBodyHtml app = new MakeBodyHtml();
            try {
                app.loadHeadwords(args[0]);
                app.loadTxt(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeBodyHtml SOME_DIR/kenkyusya-lajp.txt");
        }
    }
}

