/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.jpcollo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.UTF8toSJIS;

public class MakeBodyHtml {
    private static final Pattern GAIJI = Pattern.compile("<span style=\"display:none;\">\u2606\u2606\u2606\u5916\u5b57\uff1a(.+?)</span>");

    private String normalize(String line) {
        line = line.replace("<p class=\"moji-down\">", "");
        line = line.replace("</p>", "");
        line = line.replace("<br>", "");
        line = line.replaceAll("<a.+?>(.*?)</a>", "$1");
        line = line.replaceAll("<img src=\"1.png\".*?>", "\u3010\u4f8b\u6587\u3011");
        line = line.replaceAll("<img src=\"2.png\".*?>", "\u3010\u5408\u6210\u8a9e\u3011");
        line = line.replaceAll("<img src=\"3.png\".*?>", "\u3010\u6163\u7528\u53e5\u3011");
        line = line.replaceAll("<img src=\"4.png\".*?>", "\u3010\u8a9e\u7fa9\u3011");
        line = line.replaceAll("<img src=\"5.png\".*?>", "\u3010\u540d\u8a5e\u3011");
        line = line.replaceAll("<img .*?>", "");
        line = line.replaceAll("<div class=\"midashi\">(.+?)</div>", "<dt>$1</dt>");
        line = line.replaceAll("<div.+?style=\"margin-left:2.000000em;\">", "\u3000");
        line = line.replaceAll("<div.+?>", "");
        line = line.replace("</div>", "");
        line = line.replaceAll("<span class=\"hankaku\">(.*?)</span>", "$1");
        line = line.replace("<ruby class=\"ruby7\">", "<ruby>");
        line = line.replace("<rb class=\"rb7\">", "<rb>");
        line = line.replace("<rt class=\"rt7\">", "<rt>");
        line = line.replaceAll("<rp .+?>.+?</rp>", "");
        line = UTF8toSJIS.hex2uni(line);
        line = this.gaijiFix(line);
        return line;
    }

    private String gaijiFix(String line) {
        StringBuffer sb = new StringBuffer(line.length());
        Matcher m = GAIJI.matcher(line);
        int idx = 0;
        while (m.find()) {
            if (idx < m.start()) {
                sb.append(line.substring(idx, m.start()));
            }
            switch (m.group(1)) {
                case "b135": {
                    sb.append("<b>(21)</b>");
                    break;
                }
                case "b136": {
                    sb.append("<b>(22)</b>");
                    break;
                }
                case "b137": {
                    sb.append("<b>(23)</b>");
                    break;
                }
                case "b138": {
                    sb.append("<b>(24)</b>");
                    break;
                }
                default: {
                    System.err.println(m.group());
                    System.exit(1);
                }
            }
            idx = m.end();
        }
        if (idx < line.length()) {
            sb.append(line.substring(idx));
        }
        return sb.toString();
    }

    private void parse(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        boolean bSkip = false;
        System.out.println("<html><body>");
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.equals("<br>")) continue;
            if (line.startsWith("<html>") || line.startsWith("</body>")) {
                bSkip = true;
                continue;
            }
            if (bSkip) {
                if (!line.startsWith("<div class=\"midashi\">")) continue;
                bSkip = false;
            }
            if ((line = this.normalize(line)).isEmpty()) continue;
            if (line.startsWith("<dt>")) {
                System.out.println(line);
                continue;
            }
            System.out.println("<p>" + line + "</p>");
        }
        System.out.println("</body></html>");
        br.close();
    }

    public static void main(String[] args) throws Exception {
        String filename = args.length > 0 ? args[0] : "body.txt";
        MakeBodyHtml app = new MakeBodyHtml();
        app.parse(filename);
    }
}

