/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import zephyr.kagakudoujin.kagakueigo.EntryData;
import zephyr.kagakudoujin.kagakueigo.FileLoader;
import zephyr.kagakudoujin.kagakueigo.KatuyouWriter;
import zephyr.kagakudoujin.kagakueigo.Util;
import zephyr.util.ZephyrUtil;

public class MakeKatuyouHtml {
    private final KatuyouWriter kWriter;
    private final HashMap<String, String> valuesMap = new HashMap();

    MakeKatuyouHtml(String[] args) {
        this.kWriter = new KatuyouWriter(args, 1);
    }

    private String entry2txt(EntryData e) {
        return e != null ? e.txt : null;
    }

    private void parse(byte[] entry) {
        String id = Util.getString(entry, 0, 4);
        String value = this.valuesMap.remove(id);
        EntryData kana = Util.getData(entry, Util.DELIM_02, 0);
        EntryData jp = Util.getData(entry, Util.DELIM_03, kana.nextIndex);
        int start = kana != null ? kana.nextIndex : 0;
        EntryData en = Util.getData(entry, Util.DELIM_ENG_TRANS, start);
        start = en != null ? en.nextIndex : start;
        String[] enWords = Util.getDataList(entry, Util.DELIM_EN_WORDS, start);
        String[] jpWords = Util.getDataList(entry, Util.DELIM_JP_WORDS, start);
        EntryData rel = Util.getData(entry, Util.DELIM_REL_WORDS, start);
        this.kWriter.addEntry(this.entry2txt(jp), this.entry2txt(kana), this.entry2txt(en), value, enWords, jpWords, this.entry2txt(rel));
    }

    private void loadValues(File file) throws Exception {
        byte[] buffer = FileLoader.loadBinary(file);
        if (buffer == null) {
            System.err.println(String.valueOf(file.getAbsolutePath()) + " \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            System.exit(1);
        }
        byte[] DELIM_ID = new byte[]{1, 8};
        int start = 4608;
        while ((start = Util.findData(buffer, start, buffer.length, DELIM_ID)) >= 0) {
            int txtlen;
            String id;
            int index = start + DELIM_ID.length;
            byte idlen = buffer[index];
            if (idlen <= 0 || idlen > 4) {
                start = index;
                continue;
            }
            if (!(id = Util.getString(buffer, ++index, index + idlen)).matches("[0-9]+")) {
                start += DELIM_ID.length;
                continue;
            }
            index += idlen;
            if ((txtlen = (buffer[index += 6] << 8 & 0xFF00) + (buffer[index + 1] & 0xFF)) <= 0) {
                start += DELIM_ID.length;
                continue;
            }
            String txt = Util.getString(buffer, index += 2, index + txtlen);
            String id4 = String.format("%04d", Integer.parseInt(id));
            this.valuesMap.put(id4, txt);
            start = index + txtlen;
        }
    }

    private void load(File file) throws Exception {
        LinkedList<byte[]> entries = FileLoader.load(file, Util.DELIM_K_ENTRY);
        for (byte[] entry : entries) {
            this.parse(entry);
        }
    }

    public static void main(String[] args) throws Exception {
        String filename1 = args.length > 0 ? args[0] : "Dict\\katuyou\\DBSite\\DATA\\@f02003.dat";
        String filename2 = args.length > 1 ? args[1] : "Dict\\katuyou\\DBSite\\DATA\\@Value.dat";
        File file = new File(filename1);
        System.err.println(String.valueOf(file.getAbsolutePath()) + " \u304b\u3089\u53d6\u308a\u8fbc\u307f\u307e\u3059");
        ZephyrUtil.setShiftJisOuput();
        MakeKatuyouHtml app = new MakeKatuyouHtml(args);
        app.loadValues(new File(filename2));
        app.load(file);
        app.kWriter.out();
    }
}

