/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import zephyr.kagakudoujin.kagakueigo.EntryData;
import zephyr.kagakudoujin.kagakueigo.FileLoader;
import zephyr.kagakudoujin.kagakueigo.Gaiji;
import zephyr.kagakudoujin.kagakueigo.Util;
import zephyr.kagakudoujin.kagakueigo2.Util2;
import zephyr.util.ZephyrUtil;

public class MakeJEHtml {
    private boolean makeENkey = false;

    MakeJEHtml(String[] args) {
        int i = 1;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("enjpkey")) {
                this.makeENkey = true;
            }
            ++i;
        }
    }

    private void parse(byte[] entry) throws UnsupportedEncodingException {
        String txt;
        EntryData jp = Util.getData(entry, Util.DELIM_03, 0);
        EntryData en = Util.getData(entry, Util.DELIM_04, jp.nextIndex);
        if (en == null) {
            int start = Util.findData(entry, jp.nextIndex, entry.length, Util.DELIM_04);
            if (start < 0) {
                System.err.println("\u548c\u82f1\u90e8\u7570\u5e38:04\u306a\u3057");
                System.err.println(jp.txt);
                return;
            }
            int end = Util.findData(entry, start += Util.DELIM_04.length + 4, entry.length, Util.DELIM_05);
            if (end < 0) {
                System.err.println("\u548c\u82f1\u90e8\u7570\u5e38:05\u306a\u3057");
                System.err.println(jp.txt);
                return;
            }
            txt = new String(Arrays.copyOfRange(entry, start, end), "Windows-31J");
            en = new EntryData(txt, end);
        }
        EntryData kana = Util.getData(entry, Util.DELIM_05, en.nextIndex);
        StringBuilder sb = new StringBuilder();
        sb.append("<dt>");
        sb.append(jp.txt);
        if (kana != null) {
            sb.append("\u3010");
            sb.append(kana.txt);
            sb.append("\u3011</dt>");
        } else {
            sb.append("</dt>");
        }
        if (this.makeENkey) {
            sb.append(Util2.makeKeys(en.txt, jp.txt));
        }
        sb.append("<dd>");
        sb.append("<p>");
        sb.append(en.txt);
        sb.append("</p></dd>");
        txt = sb.toString();
        txt = Util.normalize(txt);
        txt = Gaiji.convert(txt);
        System.out.println(txt);
    }

    private void load(File file) throws Exception {
        LinkedList<byte[]> entries = FileLoader.load(file, Util.DELIM_ENTRY);
        System.out.println("<html><body>");
        for (byte[] entry : entries) {
            this.parse(entry);
        }
        System.out.println("</body></html>");
    }

    public static void main(String[] args) throws Exception {
        String filename = args.length > 0 ? args[0] : "Dict\\yougosyu\\DBSite\\DATA\\@f02002.dat";
        File file = new File(filename);
        System.err.println(String.valueOf(file.getAbsolutePath()) + " \u304b\u3089\u53d6\u308a\u8fbc\u307f\u307e\u3059");
        ZephyrUtil.setShiftJisOuput();
        MakeJEHtml app = new MakeJEHtml(args);
        app.load(file);
    }
}

