/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo;

import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class Gaiji {
    private static final boolean DUMP = false;
    private static final TreeSet<Character> chSet = new TreeSet();
    private static final HashMap<String, String> gaijiMap = new HashMap();
    private static final Pattern GAIJI;

    static {
        Gaiji.register("ac0", "e", "\u00e9");
        Gaiji.register("ac1", "e", "\u00e9");
        Gaiji.register("ang", "a", "\u00e5");
        Gaiji.register("c", "c", "\u010d");
        Gaiji.register("mho", "mho", "\u010d");
        Gaiji.register("n", "n", "n\u0304");
        Gaiji.register("o", "o", "\u00f8");
        Gaiji.register("uma", "a", "\u00e4");
        Gaiji.register("ume", "e", "\u00eb");
        Gaiji.register("umo0", "o", "\u00f6");
        Gaiji.register("umo1", "o", "\u00f6");
        Gaiji.register("umu", "u", "\u00fc");
        Gaiji.register("x", "x", "x\u0304");
        GAIJI = Pattern.compile("<IMG-[^>]+>[^<>]+</IMG-[^>]+>");
    }

    private static void register(String tag, String dropChar, String realChar) {
        String html = "<IMG-" + tag + ">" + dropChar + "</IMG-" + tag + ">";
        gaijiMap.put(html, ZephyrUtil.uni2hex(realChar));
    }

    public static String convert(String txt) {
        StringBuilder sb = null;
        Matcher m = GAIJI.matcher(txt);
        int idx = 0;
        while (m.find()) {
            String realChar;
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (idx < m.start()) {
                sb.append(txt.substring(idx, m.start()));
            }
            if ((realChar = gaijiMap.get(m.group())) != null) {
                sb.append(realChar);
            } else {
                System.err.println("\u5916\u5b57\uff1a" + m.group());
                sb.append(m.group());
            }
            idx = m.end();
        }
        if (sb == null) {
            return txt;
        }
        if (idx < txt.length()) {
            sb.append(txt.substring(idx));
        }
        return sb.toString();
    }
}

