/*
 * Decompiled with CFR 0.152.
 */
package zephyr.iwanami.koujien;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final HashMap<Character, Character> zenhanMap = new HashMap();
    private static final TreeSet<Character> unknownHanSet = new TreeSet();
    private static final String BR = "<br>";
    private static final HashMap<String, String> eb2htmlMap;
    private static final String EP_DT_START = "<1F09><0001>";
    private static final String EP_ANKER = "<1F09><9999>";
    private static final String EP_BODY_END = "<1F03>";
    private static final String EP_FIGURE = "<x=0,y=0><w=0,h=0>";
    private static final int EPTAG_LEN;
    private final LinkedList<String> closeTags = new LinkedList();
    private static final Pattern EP_REF;
    private static final Pattern EP_AREF;

    static {
        zenhanMap.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        zenhanMap.put(Character.valueOf('\uff0c'), Character.valueOf(','));
        zenhanMap.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        zenhanMap.put(Character.valueOf('\uff08'), Character.valueOf('('));
        zenhanMap.put(Character.valueOf('\uff09'), Character.valueOf(')'));
        zenhanMap.put(Character.valueOf('\uff3b'), Character.valueOf('['));
        zenhanMap.put(Character.valueOf('\uff3d'), Character.valueOf(']'));
        zenhanMap.put(Character.valueOf('\uff01'), Character.valueOf('!'));
        zenhanMap.put(Character.valueOf('\uff1f'), Character.valueOf('?'));
        zenhanMap.put(Character.valueOf('\uff0b'), Character.valueOf('+'));
        zenhanMap.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        zenhanMap.put(Character.valueOf('\uff0a'), Character.valueOf('*'));
        zenhanMap.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        zenhanMap.put(Character.valueOf('\u2019'), Character.valueOf('\''));
        zenhanMap.put(Character.valueOf('\uff1a'), Character.valueOf(':'));
        zenhanMap.put(Character.valueOf('\uff1b'), Character.valueOf(';'));
        zenhanMap.put(Character.valueOf('\uff06'), Character.valueOf('&'));
        zenhanMap.put(Character.valueOf('\uff3e'), Character.valueOf('^'));
        zenhanMap.put(Character.valueOf('\uff5c'), Character.valueOf('|'));
        zenhanMap.put(Character.valueOf('\uff1d'), Character.valueOf('='));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        zenhanMap.put(Character.valueOf('\uff05'), Character.valueOf('%'));
        zenhanMap.put(Character.valueOf('\uff5b'), Character.valueOf('{'));
        zenhanMap.put(Character.valueOf('\uff5d'), Character.valueOf('}'));
        String zenzen = "\u30fc\u300a\u300b\u2015\u3008\u3009\u25c6\u00b0\u21d2\u00b4\uff40\u2032\u2033\uffe0\u2026\u4e00\uff1c\uff1e\u00a7\u00a8\u00d7\u2191\u2193\u300c\u300d\uff5e\u2018\uffe3]";
        int i = 0;
        while (i < zenzen.length()) {
            char c = zenzen.charAt(i);
            zenhanMap.put(Character.valueOf(c), Character.valueOf(c));
            ++i;
        }
        eb2htmlMap = new HashMap();
        eb2htmlMap.put("1F0A", BR);
        eb2htmlMap.put("1F42", "{a}");
        eb2htmlMap.put("1F62", "{/a}");
        eb2htmlMap.put("1F06", "<sub>");
        eb2htmlMap.put("1F07", "</sub>");
        eb2htmlMap.put("1F0E", "<sup>");
        eb2htmlMap.put("1F0F", "</sup>");
        EPTAG_LEN = "<xxxx>".length();
        EP_REF = Pattern.compile("<1F62>\\[0*([0-9A-F]+):0([0-9A-F]+)\\]");
        EP_AREF = Pattern.compile("\\{a\\}([^\\{\\}]+?)\\{/a\\}\\[0*([0-9A-F]+):0([0-9A-F]+)\\]");
    }

    MakeBodyHtml() throws Exception {
    }

    private static char zen2han(char c) {
        if ('\uff10' <= c && c <= '\uff19') {
            return (char)(48 + (c - 65296));
        }
        if ('\uff21' <= c && c <= '\uff3a') {
            return (char)(65 + (c - 65313));
        }
        if ('\uff41' <= c && c <= '\uff5a') {
            return (char)(97 + (c - 65345));
        }
        if (c <= '~') {
            return c;
        }
        Character han = zenhanMap.get(Character.valueOf(c));
        if (han != null) {
            return han.charValue();
        }
        unknownHanSet.add(Character.valueOf(c));
        return c;
    }

    private String ep2html(String line, HashSet<String> refs) {
        StringBuilder sb = new StringBuilder();
        boolean bZenkaku = true;
        int i = line.indexOf(93);
        String[] v = line.substring(1, i).replace(" ", "0").split(":");
        if (v[1].equals("800")) {
            v[0] = String.format("%X", Integer.parseInt(v[0], 16) + 1);
            v[1] = "000";
        }
        String pos = String.valueOf(v[0]) + v[1];
        boolean isRefered = refs.contains(pos);
        String main = line.substring(++i);
        if (!isRefered && main.startsWith(EP_ANKER)) {
            return "";
        }
        if (main.contains(EP_FIGURE)) {
            return "";
        }
        boolean inDT = false;
        block28: while (i < line.length()) {
            char c;
            block54: {
                String code;
                c = line.charAt(i);
                if (c != '<') break block54;
                switch (code = line.substring(i + 1, i + 5)) {
                    case "1FE0": {
                        String code2;
                        switch (code2 = line.substring(i + 7, i + 11)) {
                            case "0001": {
                                sb.append("<i>");
                                this.closeTags.addFirst("</i>");
                                break;
                            }
                            case "0000": 
                            case "0003": 
                            case "0041": {
                                if (inDT) break;
                                sb.append("<b>");
                                this.closeTags.addFirst("</b>");
                            }
                        }
                        i += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1FE1": {
                        for (String closeTag : this.closeTags) {
                            sb.append(closeTag);
                        }
                        this.closeTags.clear();
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F09": {
                        String code2 = line.substring(i);
                        if (code2.startsWith(EP_DT_START)) {
                            if (!this.closeTags.isEmpty()) {
                                System.err.println("missing closeTags before " + pos);
                            }
                            if (isRefered) {
                                sb.append("<dt id=\"" + pos + "\">");
                                isRefered = false;
                            } else {
                                sb.append("<dt>");
                            }
                            inDT = true;
                            i += EP_DT_START.length();
                            break;
                        }
                        i += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F61": {
                        String code2 = line.substring(i += EPTAG_LEN);
                        if (!code2.equals("<1F0A>") || !inDT) continue block28;
                        sb.append("</dt><dd><p>");
                        inDT = false;
                        break;
                    }
                    case "1F04": {
                        bZenkaku = false;
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F05": {
                        bZenkaku = true;
                        i += EPTAG_LEN;
                        break;
                    }
                    case "1F4A": {
                        sb.append("\u3000\u97f3\u58f0");
                        i += 3 * EPTAG_LEN;
                        i = line.indexOf(93, i);
                        i = line.indexOf(93, i + 1) + 1;
                        break;
                    }
                    default: {
                        if (code.compareTo("A121") >= 0 && code.compareTo("FE7E") <= 0) {
                            sb.append("&#x");
                            sb.append(code);
                            sb.append(";");
                        } else {
                            String tag = eb2htmlMap.get(code);
                            if (tag != null) {
                                sb.append(tag);
                            }
                        }
                        i += EPTAG_LEN;
                        break;
                    }
                }
                continue;
            }
            if (bZenkaku) {
                sb.append(c);
            } else {
                sb.append(MakeBodyHtml.zen2han(c));
            }
            ++i;
        }
        String l = sb.toString();
        if (inDT) {
            l = String.valueOf(l) + "</dt><dd><p>";
        }
        return l;
    }

    private HashSet<String> findRefs(String filename) throws Exception {
        String line;
        HashSet<String> refs = new HashSet<String>();
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        br.readLine();
        br.readLine();
        while ((line = br.readLine()) != null) {
            if (line.endsWith(EP_BODY_END)) break;
            Matcher m = EP_REF.matcher(line);
            while (m.find()) {
                refs.add(String.valueOf(m.group(1)) + m.group(2));
            }
        }
        br.close();
        System.err.println("found " + refs.size() + " unique refs");
        return refs;
    }

    private String checkHref(String dd, HashSet<String> refs) {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        Matcher m = EP_AREF.matcher(dd);
        while (m.find()) {
            String refid;
            if (idx < m.start()) {
                sb.append(dd.substring(idx, m.start()));
            }
            if (refs.contains(refid = String.valueOf(m.group(2)) + m.group(3))) {
                sb.append("<a href=\"#");
                sb.append(refid);
                sb.append("\">");
                sb.append(m.group(1));
                sb.append("</a>");
            } else {
                sb.append(m.group(1));
            }
            idx = m.end();
        }
        if (idx < dd.length()) {
            sb.append(dd.substring(idx));
        }
        return sb.toString();
    }

    private String normalize(String dd, HashSet<String> refs) {
        dd = this.checkHref(dd, refs);
        dd = dd.replace("<p><br>", "<p>");
        dd = dd.replace("<br></dt>", "</dt>");
        dd = dd.replace("<br></p>", "</p>");
        dd = dd.replace('\u3010', '\u3010');
        dd = dd.replace('\u3011', '\u3011');
        return dd;
    }

    private void parse(String filename) throws Exception {
        String line;
        HashSet<String> refs = this.findRefs(filename);
        FileInputStream in = new FileInputStream(new File(filename));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "Windows-31J"));
        br.readLine();
        br.readLine();
        StringBuilder sb = null;
        System.out.println("<html><body>");
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            if (line.endsWith(EP_BODY_END)) break;
            String html = this.ep2html(line, refs);
            if (html.isEmpty()) continue;
            if (sb == null) {
                sb = new StringBuilder();
            } else if (html.startsWith("<dt") && sb != null) {
                System.out.println(this.normalize(String.valueOf(sb.toString()) + "</p></dd>", refs));
                sb = new StringBuilder();
            }
            sb.append(html);
        }
        br.close();
        if (sb != null) {
            System.out.println(this.normalize(String.valueOf(sb.toString()) + "</p></dd>", refs));
        }
        System.out.println("</body></html>");
        if (!unknownHanSet.isEmpty()) {
            System.err.println("WARN: Unknown Hankaku characters");
            System.err.println(unknownHanSet.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            MakeBodyHtml app = new MakeBodyHtml();
            try {
                app.parse(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeBodyHtml SOME_DIR/koujienX.txt");
        }
    }
}

