<?php
/**
 *
 * PostWiki - Yet another WikiWikiWeb clone.
 *
 * backup.php
 *
 * Хååפ
 *
 * @package org.postwiki
 * @access  public
 * @author
 * @create
 * @version $Id: backup.php,v 1.2 2006/02/03 17:40:08 raymax Exp $
 * Copyright (C)
 *   2005-2006 PostWiki Developers Team
 *   2002-2005 PukiWiki Developers Team
 *   2001-2002 Originally written by yu-ji
 * License: GPL v2 or (at your option) any later version
 **/

/**
 * make_backup
 * Хååפ
 *
 * @access    public
 * @param     String    $page        ڡ̾
 * @param     Boolean   $delete      TRUE:Хååפ
 *
 * @return    Void
 */

function make_backup($page, $delete = FALSE)
{
	global $cycle, $maxage;
	global $do_backup, $del_backup;

	if (PKWK_READONLY || ! $do_backup) return;

	if ($del_backup && $delete) {
		_backup_delete($page);
		return;
	}

	if (! is_page($page)) return;

	$lastmod = _backup_get_filetime($page);
	if ($lastmod == 0 || UTIME - $lastmod > 60 * 60 * $cycle)
	{
		$backups = get_backup($page);
		$count   = count($backups) + 1;

		// ľ1ɲäΤǡ( - 1)ĶǤΤƤ
		if ($count > $maxage)
			array_splice($backups, 0, $count - $maxage);

		$strout = '';
		foreach($backups as $age=>$data) {
			$strout .= PKWK_SPLITTER . ' ' . $data['time'] . "\n"; // Splitter format
			$strout .= join('', $data['data']);
			unset($backups[$age]);
		}
		$strout = preg_replace("/([^\n])\n*$/", "$1\n", $strout);

		// Escape 'lines equal to PKWK_SPLITTER', by inserting a space
		$body = preg_replace('/^(' . preg_quote(PKWK_SPLITTER) . "\s\d+)$/", '$1 ', get_source($page));
		$body = PKWK_SPLITTER . ' ' . get_filetime($page) . "\n" . join('', $body);
		$body = preg_replace("/\n*$/", "\n", $body);

		$fp = _backup_fopen($page, 'wb')
			or die_message('Cannot open ' . htmlspecialchars(_backup_get_filename($page)) .
			'<br />Maybe permission is not writable or filename is too long');
		_backup_fputs($fp, $strout);
		_backup_fputs($fp, $body);
		_backup_fclose($fp);
	}
}

/**
 * get_backup
 * Хååפ
 * $age = 0ޤϾά : ƤΥХååץǡǼ
 * $age > 0           : ꤷΥХååץǡ
 *
 * @access    public
 * @param     String    $page        ڡ̾
 * @param     Integer   $age         Хååפֹ ά
 *
 * @return    String    Хåå       ($age != 0)
 *            Array     Хååפ ($age == 0)
 */
function get_backup($page, $age = 0)
{
	$lines = _backup_file($page);
	if (! is_array($lines)) return array();

	$_age = 0;
	$retvars = $match = array();
	$regex_splitter = '/^' . preg_quote(PKWK_SPLITTER) . '\s(\d+)$/';
	foreach($lines as $index => $line) {
		if (preg_match($regex_splitter, $line, $match)) {
			// A splitter, tells new data of backup will come
			++$_age;
			if ($age > 0 && $_age > $age)
				return $retvars[$age];

			// Allocate
			$retvars[$_age] = array('time'=>$match[1], 'data'=>array());
		} else {
			// The first ... the last line of the data
			$retvars[$_age]['data'][] = $line;
		}
		unset($lines[$index]);
	}

	return $retvars;
}

/**
 * _backup_get_filename
 * Хååץե̾
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    String    ХååפΥե̾
 */
function _backup_get_filename($page)
{
	return BACKUP_DIR . encode($page) . BACKUP_EXT;
}

/**
 * _backup_file_exists
 * Хååץե뤬¸ߤ뤫
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    Boolean   TRUE: FALSE:ʤ
 */
function _backup_file_exists($page)
{
	return file_exists(_backup_get_filename($page));
}

/**
 * _backup_get_filetime
 * Хååץեι
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    Integer   եι(GMT)
 */

function _backup_get_filetime($page)
{
	return _backup_file_exists($page) ?
		filemtime(_backup_get_filename($page)) - LOCALZONE : 0;
}

/**
 * _backup_delete
 * Хååץե
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    Boolean   FALSE:
 */
function _backup_delete($page)
{
	return unlink(_backup_get_filename($page));
}

/////////////////////////////////////////////////

if (extension_loaded('zlib')) {
	// ե륷ƥؿ
	// zlibؿ
	define('BACKUP_EXT', '.gz');

/**
 * _backup_fopen
 * Хååץե򳫤
 *
 * @access    private
 * @param     String    $page        ڡ̾
 * @param     String    $mode        ⡼
 *
 * @return    Boolean   FALSE:
 */
	function _backup_fopen($page, $mode)
	{
		return gzopen(_backup_get_filename($page), $mode);
	}

/**
 * _backup_fputs
 * Хååץե˽񤭹
 *
 * @access    private
 * @param     Integer   $zp          եݥ
 * @param     String    $str         ʸ
 *
 * @return    Boolean   FALSE: ¾:񤭹Хȿ
 */
	function _backup_fputs($zp, $str)
	{
		return gzputs($zp, $str);
	}

/**
 * _backup_fclose
 * ХååץեĤ
 *
 * @access    private
 * @param     Integer   $zp          եݥ
 *
 * @return    Boolean   FALSE:
 */
	function _backup_fclose($zp)
	{
		return gzclose($zp);
	}

/**
 * _backup_file
 * ХååץեƤ
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    Array     ե
 */
	function _backup_file($page)
	{
		return _backup_file_exists($page) ?
			gzfile(_backup_get_filename($page)) :
			array();
	}
}
/////////////////////////////////////////////////
else
{
	// ե륷ƥؿ
	define('BACKUP_EXT', '.txt');

/**
 * _backup_fopen
 * Хååץե򳫤
 *
 * @access    private
 * @param     String    $page        ڡ̾
 * @param     String    $mode        ⡼
 *
 * @return    Boolean   FALSE:
 */
	function _backup_fopen($page, $mode)
	{
		return fopen(_backup_get_filename($page), $mode);
	}

/**
 * _backup_fputs
 * Хååץե˽񤭹
 *
 * @access    private
 * @param     Integer   $zp          եݥ
 * @param     String    $str         ʸ
 *
 * @return    Boolean   FALSE: ¾:񤭹Хȿ
 */
	function _backup_fputs($zp, $str)
	{
		return fputs($zp, $str);
	}

/**
 * _backup_fclose
 * ХååץեĤ
 *
 * @access    private
 * @param     Integer   $zp          եݥ
 *
 * @return    Boolean   FALSE:
 */
	function _backup_fclose($zp)
	{
		return fclose($zp);
	}

/**
 * _backup_file
 * ХååץեƤ
 *
 * @access    private
 * @param     String    $page        ڡ̾
 *
 * @return    Array     ե
 */
	function _backup_file($page)
	{
		return _backup_file_exists($page) ?
			file(_backup_get_filename($page)) :
			array();
	}
}
?>
