//
// Mac.java
// This file is part of PosterDivider.
//
package jp.sourceforge.posterdivider;

// build on macosx

import java.io.File;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;

public class Mac {
    public static void setOpenFileHandler() {
	Application app = Application.getApplication();
	app.setOpenFileHandler(new OpenFilesHandler() {
		public void openFiles(AppEvent.OpenFilesEvent e) {
		    for (File file : e.getFiles()) {
			MainFrame frame = Program.getSameFileFrame(file);
			if(frame != null) {
			    frame.setVisible(true);
			} else {
			    Program.createFrame(file, true);
			}
		    }
	        }
	    });
    }
    public static void setUseScreenMenuBar() {
	System.setProperty("apple.laf.useScreenMenuBar", "true");
    }
}
