/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.posterdivider;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import jp.sourceforge.posterdivider.CanvasPreview;
import jp.sourceforge.posterdivider.FileContainer;
import jp.sourceforge.posterdivider.ImageContainer;
import jp.sourceforge.posterdivider.Lib;
import jp.sourceforge.posterdivider.NumberField;
import jp.sourceforge.posterdivider.PaperSize;
import jp.sourceforge.posterdivider.PdfGenerator;
import jp.sourceforge.posterdivider.Program;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JFileChooser fileChooserSrcFile;
    private JFileChooser fileChooserOutputFile;
    private JLabel labelSrcFile;
    private JTextField textFieldSrcFileName;
    private JLabel labelSrcFileType;
    private JButton buttonSrcFileChange;
    private JLabel labelSrcPageNum;
    private JComboBox comboBoxSrcPageNum;
    private JLabel labelSrcImageSize;
    private NumberField numberFieldSrcImageWidth;
    private NumberField numberFieldSrcImageHeight;
    private JComboBox comboBoxSrcImageSizeUnit;
    private JLabel labelSrcRect;
    private JCheckBox checkBoxSrcRectWholeOfPage;
    private NumberField numberFieldSrcLeft;
    private NumberField numberFieldSrcBottom;
    private NumberField numberFieldSrcRight;
    private NumberField numberFieldSrcTop;
    private JComboBox comboBoxSrcRectUnit;
    private JLabel labelPosterSize;
    private JComboBox comboBoxPosterSize;
    private NumberField numberFieldPosterWidth;
    private NumberField numberFieldPosterHeight;
    private JComboBox comboBoxPosterSizeUnit;
    private JCheckBox checkBoxPosterSizeKeepAspectRatio;
    private JLabel labelPaperSize;
    private JComboBox comboBoxPaperSize;
    private NumberField numberFieldPaperWidth;
    private NumberField numberFieldPaperHeight;
    private JComboBox comboBoxPaperSizeUnit;
    private JLabel labelPaperMargin;
    private NumberField numberFieldPaperMargin;
    private JComboBox comboBoxPaperMarginUnit;
    private JCheckBox checkBoxPaperRotate;
    private JButton buttonPaperOptimize;
    private JLabel labelPreview;
    private JLabel labelOutputPaperCount;
    private NumberField numberFieldOutputPaperCount;
    private CanvasPreview canvasPreview;
    private JLabel labelOutputFileName;
    private JTextField textFieldOutputFileName;
    private JButton buttonOutput;
    private File srcFile;
    private FileContainer fc;
    private ImageContainer ic;
    private float srcImageWidth;
    private float srcImageHeight;
    private ArrayList<Double> listSrcImageSizeUnit = new ArrayList();
    private float srcLeft;
    private float srcBottom;
    private float srcRight;
    private float srcTop;
    private ArrayList<Double> listSrcRectUnit = new ArrayList();
    private ArrayList<PaperSize> listPosterSize = new ArrayList();
    private float preferredPosterWidth;
    private float preferredPosterHeight;
    private float posterWidth;
    private float posterHeight;
    private ArrayList<Double> listPosterSizeUnit = new ArrayList();
    private ArrayList<PaperSize> listPaperSize = new ArrayList();
    private float paperWidth;
    private float paperHeight;
    private boolean paperRotated;
    private ArrayList<Double> listPaperSizeUnit = new ArrayList();
    private float paperMargin;
    private ArrayList<Double> listPaperMarginUnit = new ArrayList();
    private boolean updatingComboBoxSrcPageNum = false;
    private boolean updatingComboBoxImageSizeUnit = false;
    private boolean updatingComboBoxSrcRectUnit = false;

    private String generateFileName(String string) {
        string = string.replace("{pwd}", System.getProperty("user.dir"));
        if (this.srcFile != null) {
            string = string.replace("{input}", this.srcFile.getName());
        }
        string = string.replace("{date}", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        return string;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public boolean checkFileLoaded() {
        return this.ic != null;
    }

    private void simulateOutput() {
        PdfGenerator.CreatePosterArgs createPosterArgs = new PdfGenerator.CreatePosterArgs();
        createPosterArgs.setSrcRect(this.srcLeft, this.srcBottom, this.srcRight, this.srcTop);
        createPosterArgs.setPosterSize(this.posterWidth, this.posterHeight);
        createPosterArgs.setPaperSize(this.paperWidth, this.paperHeight);
        createPosterArgs.setMargin(this.paperMargin, this.paperMargin, this.paperMargin, this.paperMargin);
        int n = PdfGenerator.simulateOutputPaperCount(createPosterArgs);
        this.numberFieldOutputPaperCount.setValue(n);
        this.canvasPreview.setArgs(createPosterArgs);
        this.canvasPreview.repaint();
    }

    private void optimizePaperRotated() {
        PdfGenerator.CreatePosterArgs createPosterArgs = new PdfGenerator.CreatePosterArgs();
        createPosterArgs.setSrcRect(this.srcLeft, this.srcBottom, this.srcRight, this.srcTop);
        createPosterArgs.setPosterSize(this.posterWidth, this.posterHeight);
        createPosterArgs.setPaperSize(this.paperWidth, this.paperHeight);
        createPosterArgs.setMargin(this.paperMargin, this.paperMargin, this.paperMargin, this.paperMargin);
        int n = PdfGenerator.simulateOutputPaperCount(createPosterArgs);
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        PdfGenerator.CreatePosterArgs createPosterArgs2 = new PdfGenerator.CreatePosterArgs();
        createPosterArgs2.setSrcRect(this.srcLeft, this.srcBottom, this.srcRight, this.srcTop);
        createPosterArgs2.setPosterSize(this.posterWidth, this.posterHeight);
        createPosterArgs2.setPaperSize(this.paperHeight, this.paperWidth);
        createPosterArgs2.setMargin(this.paperMargin, this.paperMargin, this.paperMargin, this.paperMargin);
        int n2 = PdfGenerator.simulateOutputPaperCount(createPosterArgs2);
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (n > n2 || n == n2 && this.paperRotated) {
            this.checkBoxPaperRotate.setSelected(!this.paperRotated);
            this.checkBoxPaperRotate_itemStateChanged();
        }
    }

    public void outputPdf(File file) {
        if (!this.checkFileLoaded()) {
            return;
        }
        PdfGenerator.CreatePosterArgs createPosterArgs = new PdfGenerator.CreatePosterArgs();
        createPosterArgs.setSrcRect(this.srcLeft, this.srcBottom, this.srcRight, this.srcTop);
        createPosterArgs.setPosterSize(this.posterWidth, this.posterHeight);
        createPosterArgs.setPaperSize(this.paperWidth, this.paperHeight);
        createPosterArgs.setMargin(this.paperMargin, this.paperMargin, this.paperMargin, this.paperMargin);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PdfGenerator.createPoster(this.ic, createPosterArgs, byteArrayOutputStream);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byteArrayOutputStream.writeTo(fileOutputStream);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.showErrorMessage(String.format(Lib.getMessage("Text.FailedWrite"), Lib.fileGetCanonicalPath(file)));
            }
        }
        catch (Exception exception) {
            this.showErrorMessage(Lib.getMessage("Text.FailedGenerate"));
        }
    }

    private void changePageSuccess(ImageContainer imageContainer) {
        this.ic = imageContainer;
        this.comboBoxSrcPageNum.setSelectedIndex(imageContainer.getPageNum() - 1);
        this.srcImageWidth = imageContainer.getImageWidth();
        this.srcImageHeight = imageContainer.getImageHeight();
        this.numberFieldSrcImageSize_setValue();
        this.comboBoxSrcImageSizeUnit.setEnabled(true);
        this.checkBoxSrcRectWholeOfPage.setEnabled(true);
        this.comboBoxSrcRectUnit.setEnabled(true);
        this.buttonPaperOptimize.setEnabled(true);
        this.buttonOutput.setEnabled(true);
        this.canvasPreview.setImageContainer(imageContainer);
        this.simulateOutput();
    }

    public void changePage(int n) {
        if (this.fc == null) {
            return;
        }
        try {
            ImageContainer imageContainer = new ImageContainer(this.fc, n);
            this.changePageSuccess(imageContainer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void changeFileSuccess(File file, FileContainer fileContainer) {
        this.srcFile = file;
        this.fc = fileContainer;
        this.textFieldSrcFileName.setText(Lib.fileGetCanonicalPath(file));
        this.labelSrcFileType.setText(Lib.getFileTypeName(fileContainer.getFileType()));
        this.comboBoxSrcPageNum_initialize(fileContainer.getPageCount());
        this.comboBoxSrcPageNum.setSelectedIndex(0);
        this.comboBoxSrcPageNum.setEnabled(fileContainer.getFileType() == 1);
        this.comboBoxSrcImageSizeUnit_initialize(fileContainer.getFileType());
        this.comboBoxSrcImageSizeUnit.setSelectedIndex(0);
        this.comboBoxSrcRectUnit_initialize(fileContainer.getFileType());
        this.comboBoxSrcRectUnit.setSelectedIndex(0);
        this.changePage(this.comboBoxSrcPageNum.getSelectedIndex() + 1);
        this.checkBoxSrcRectWholeOfPage.setSelected(true);
        this.checkBoxSrcRectWholeOfPage_itemStateChanged();
    }

    public void changeFile(File file) {
        try {
            FileContainer fileContainer = new FileContainer(file);
            this.changeFileSuccess(file, fileContainer);
        }
        catch (Exception exception) {
            this.showErrorMessage(String.format(Lib.getMessage("Text.FailedOpen"), Lib.fileGetCanonicalPath(file)));
        }
    }

    private void updatePosterSize() {
        this.posterWidth = this.preferredPosterWidth;
        this.posterHeight = this.preferredPosterHeight;
        if (this.checkBoxPosterSizeKeepAspectRatio.isSelected()) {
            if ((this.srcRight - this.srcLeft) * this.preferredPosterHeight > (this.srcTop - this.srcBottom) * this.preferredPosterWidth) {
                if (this.srcRight != this.srcLeft) {
                    this.posterHeight = this.posterWidth * (this.srcTop - this.srcBottom) / (this.srcRight - this.srcLeft);
                }
            } else if (this.srcTop != this.srcBottom) {
                this.posterWidth = this.posterHeight * (this.srcRight - this.srcLeft) / (this.srcTop - this.srcBottom);
            }
        }
    }

    private void showErrorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, Lib.getMessage("App.LowerTitle"), 0);
    }

    private File fileChooserSrcFile_show() {
        if (this.fileChooserSrcFile.showOpenDialog(this) == 0) {
            return this.fileChooserSrcFile.getSelectedFile();
        }
        return null;
    }

    private void menuItemNewWindow_actionPerformed() {
        Program.createFrame();
    }

    private void menuItemOpenFile_actionPerformed() {
        File file = this.fileChooserSrcFile_show();
        if (file != null) {
            switch (Lib.getOS()) {
                case 1: {
                    MainFrame mainFrame = Program.getSameFileFrame(file);
                    if (mainFrame != null) {
                        mainFrame.setVisible(true);
                        break;
                    }
                    if (!this.checkFileLoaded()) {
                        this.changeFile(file);
                        break;
                    }
                    Program.createFrame(file, false);
                    break;
                }
                default: {
                    this.changeFile(file);
                }
            }
        }
    }

    private void menuItemCloseWindow_actionPerformed() {
        this.dispose();
    }

    private void menuItemOutput_actionPerformed() {
        if (!this.checkFileLoaded()) {
            return;
        }
        String string = this.generateFileName(this.textFieldOutputFileName.getText());
        this.fileChooserOutputFile.setSelectedFile(new File(string));
        if (this.fileChooserOutputFile.showSaveDialog(this) != 0) {
            return;
        }
        this.outputPdf(this.fileChooserOutputFile.getSelectedFile());
    }

    private void menuItemExit_actionPerformed() {
        System.exit(0);
    }

    private void buttonSrcFileChange_actionPerformed() {
        File file = this.fileChooserSrcFile_show();
        if (file != null) {
            switch (Lib.getOS()) {
                case 1: {
                    MainFrame mainFrame = Program.getSameFileFrame(file);
                    if (mainFrame != null) {
                        mainFrame.setVisible(true);
                        break;
                    }
                    this.changeFile(file);
                    break;
                }
                default: {
                    this.changeFile(file);
                }
            }
        }
    }

    private void comboBoxSrcPageNum_initialize(int n) {
        this.updatingComboBoxSrcPageNum = true;
        this.comboBoxSrcPageNum.removeAllItems();
        for (int i = 1; i <= n; ++i) {
            this.comboBoxSrcPageNum.addItem(Integer.toString(i));
        }
        this.updatingComboBoxSrcPageNum = false;
    }

    private void comboBoxSrcPageNum_itemStateChanged() {
        if (this.updatingComboBoxSrcPageNum) {
            return;
        }
        int n = this.comboBoxSrcPageNum.getSelectedIndex() + 1;
        if (this.ic.getPageNum() != n) {
            this.changePage(n);
        }
    }

    private void numberFieldSrcImageSize_setValue() {
        double d = this.listSrcImageSizeUnit.get(this.comboBoxSrcImageSizeUnit.getSelectedIndex());
        this.numberFieldSrcImageWidth.setValue((double)this.srcImageWidth * d);
        this.numberFieldSrcImageHeight.setValue((double)this.srcImageHeight * d);
    }

    private void comboBoxSrcImageSizeUnit_addItem(String string, double d) {
        this.comboBoxSrcImageSizeUnit.addItem(string);
        this.listSrcImageSizeUnit.add(d);
    }

    private void comboBoxSrcImageSizeUnit_initialize(int n) {
        this.updatingComboBoxImageSizeUnit = true;
        this.comboBoxSrcImageSizeUnit.removeAllItems();
        this.listSrcImageSizeUnit.clear();
        switch (n) {
            case 1: {
                this.comboBoxSrcImageSizeUnit_addItem(Lib.getMessage("Str.MM"), Lib.UNIT_POINT_MM);
                this.comboBoxSrcImageSizeUnit_addItem(Lib.getMessage("Str.CM"), Lib.UNIT_POINT_CM);
                this.comboBoxSrcImageSizeUnit_addItem(Lib.getMessage("Str.M"), Lib.UNIT_POINT_M);
                this.comboBoxSrcImageSizeUnit_addItem(Lib.getMessage("Str.Inch"), Lib.UNIT_POINT_INCH);
                this.comboBoxSrcImageSizeUnit_addItem(Lib.getMessage("Str.Point"), 1.0);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.comboBoxSrcImageSizeUnit_addItem(Lib.getMessage("Str.Pixel"), 1.0);
                break;
            }
        }
        this.updatingComboBoxImageSizeUnit = false;
    }

    private void comboBoxSrcImageSizeUnit_itemStateChanged() {
        if (this.updatingComboBoxImageSizeUnit) {
            return;
        }
        this.numberFieldSrcImageSize_setValue();
    }

    private void checkBoxSrcRectWholeOfPage_itemStateChanged() {
        boolean bl = this.checkBoxSrcRectWholeOfPage.isSelected();
        this.numberFieldSrcLeft.setEnabled(!bl);
        this.numberFieldSrcTop.setEnabled(!bl);
        this.numberFieldSrcRight.setEnabled(!bl);
        this.numberFieldSrcBottom.setEnabled(!bl);
        if (bl) {
            this.srcLeft = 0.0f;
            this.srcBottom = 0.0f;
            this.srcRight = this.srcImageWidth;
            this.srcTop = this.srcImageHeight;
            this.numberFieldSrcRect_setValue();
            this.updatePosterSize();
            this.numberFieldPosterSize_setValue();
            this.simulateOutput();
        }
    }

    private void numberFieldSrcRect_actionPerformed(Object object) {
        double d = this.listSrcRectUnit.get(this.comboBoxSrcRectUnit.getSelectedIndex());
        this.srcLeft = (float)(this.numberFieldSrcLeft.getValue() / d);
        this.srcTop = (float)(this.numberFieldSrcTop.getValue() / d);
        this.srcRight = (float)(this.numberFieldSrcRight.getValue() / d);
        this.srcBottom = (float)(this.numberFieldSrcBottom.getValue() / d);
        this.numberFieldSrcRect_setValue();
        this.updatePosterSize();
        this.numberFieldPosterSize_setValue();
        this.simulateOutput();
    }

    private void numberFieldSrcRect_setValue() {
        if (this.listSrcRectUnit.isEmpty()) {
            return;
        }
        double d = this.listSrcRectUnit.get(this.comboBoxSrcRectUnit.getSelectedIndex());
        this.numberFieldSrcLeft.setValue((double)this.srcLeft * d);
        this.numberFieldSrcTop.setValue((double)this.srcTop * d);
        this.numberFieldSrcRight.setValue((double)this.srcRight * d);
        this.numberFieldSrcBottom.setValue((double)this.srcBottom * d);
    }

    private void comboBoxSrcRectUnit_addItem(String string, double d) {
        this.comboBoxSrcRectUnit.addItem(string);
        this.listSrcRectUnit.add(d);
    }

    private void comboBoxSrcRectUnit_initialize(int n) {
        this.updatingComboBoxSrcRectUnit = true;
        this.comboBoxSrcRectUnit.removeAllItems();
        this.listSrcRectUnit.clear();
        switch (n) {
            case 1: {
                this.comboBoxSrcRectUnit_addItem(Lib.getMessage("Str.MM"), Lib.UNIT_POINT_MM);
                this.comboBoxSrcRectUnit_addItem(Lib.getMessage("Str.CM"), Lib.UNIT_POINT_CM);
                this.comboBoxSrcRectUnit_addItem(Lib.getMessage("Str.M"), Lib.UNIT_POINT_M);
                this.comboBoxSrcRectUnit_addItem(Lib.getMessage("Str.Inch"), Lib.UNIT_POINT_INCH);
                this.comboBoxSrcRectUnit_addItem(Lib.getMessage("Str.Point"), 1.0);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.comboBoxSrcRectUnit_addItem(Lib.getMessage("Str.Pixel"), 1.0);
                break;
            }
        }
        this.updatingComboBoxSrcRectUnit = false;
    }

    private void comboBoxSrcRectUnit_itemStateChanged() {
        if (this.updatingComboBoxSrcRectUnit) {
            return;
        }
        this.numberFieldSrcRect_setValue();
    }

    private void comboBoxPosterSize_addItem(String string, PaperSize paperSize) {
        this.comboBoxPosterSize.addItem(string);
        this.listPosterSize.add(paperSize);
    }

    private void comboBoxPosterSize_initialize() {
        this.comboBoxPosterSize.removeAllItems();
        this.listPosterSize.clear();
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.A0"), PaperSize.A0);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.A1"), PaperSize.A1);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.A2"), PaperSize.A2);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.A3"), PaperSize.A3);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.A4"), PaperSize.A4);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.A5"), PaperSize.A5);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.A6"), PaperSize.A6);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.B0"), PaperSize.B0);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.B1"), PaperSize.B1);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.B2"), PaperSize.B2);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.B3"), PaperSize.B3);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.B4"), PaperSize.B4);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.B5"), PaperSize.B5);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.B6"), PaperSize.B6);
        this.comboBoxPosterSize_addItem(Lib.getMessage("Str.Custom"), PaperSize.CUSTOM);
    }

    private void comboBoxPosterSize_itemStateChanged() {
        PaperSize paperSize = this.listPosterSize.get(this.comboBoxPosterSize.getSelectedIndex());
        boolean bl = paperSize.isCustom();
        this.numberFieldPosterWidth.setEnabled(bl);
        this.numberFieldPosterHeight.setEnabled(bl);
        if (!bl) {
            this.preferredPosterWidth = paperSize.getWidth();
            this.preferredPosterHeight = paperSize.getHeight();
            this.updatePosterSize();
            this.numberFieldPosterSize_setValue();
            this.simulateOutput();
        }
    }

    private void numberFieldPosterSize_actionPerformed(Object object) {
        double d = this.listPosterSizeUnit.get(this.comboBoxPosterSizeUnit.getSelectedIndex());
        this.preferredPosterWidth = (float)(this.numberFieldPosterWidth.getValue() / d);
        this.preferredPosterHeight = (float)(this.numberFieldPosterHeight.getValue() / d);
        if (this.checkBoxPosterSizeKeepAspectRatio.isSelected()) {
            if (object == this.numberFieldPosterWidth && this.srcRight != this.srcLeft) {
                this.preferredPosterHeight = this.preferredPosterWidth * (this.srcTop - this.srcBottom) / (this.srcRight - this.srcLeft);
            }
            if (object == this.numberFieldPosterHeight && this.srcTop != this.srcBottom) {
                this.preferredPosterWidth = this.preferredPosterHeight * (this.srcRight - this.srcLeft) / (this.srcTop - this.srcBottom);
            }
        }
        this.updatePosterSize();
        this.numberFieldPosterSize_setValue();
        this.simulateOutput();
    }

    private void numberFieldPosterSize_setValue() {
        double d = this.listPosterSizeUnit.get(this.comboBoxPosterSizeUnit.getSelectedIndex());
        this.numberFieldPosterWidth.setValue((double)this.posterWidth * d);
        this.numberFieldPosterHeight.setValue((double)this.posterHeight * d);
    }

    private void comboBoxPosterSizeUnit_addItem(String string, double d) {
        this.comboBoxPosterSizeUnit.addItem(string);
        this.listPosterSizeUnit.add(d);
    }

    private void comboBoxPosterSizeUnit_initialize() {
        this.comboBoxPosterSizeUnit.removeAllItems();
        this.listPosterSizeUnit.clear();
        this.comboBoxPosterSizeUnit_addItem(Lib.getMessage("Str.MM"), Lib.UNIT_POINT_MM);
        this.comboBoxPosterSizeUnit_addItem(Lib.getMessage("Str.CM"), Lib.UNIT_POINT_CM);
        this.comboBoxPosterSizeUnit_addItem(Lib.getMessage("Str.M"), Lib.UNIT_POINT_M);
        this.comboBoxPosterSizeUnit_addItem(Lib.getMessage("Str.Inch"), Lib.UNIT_POINT_INCH);
        this.comboBoxPosterSizeUnit_addItem(Lib.getMessage("Str.Point"), 1.0);
    }

    private void comboBoxPosterSizeUnit_itemStateChanged() {
        this.numberFieldPosterSize_setValue();
    }

    private void checkBoxPosterSizeKeepAspectRatio_itemStateChanged() {
        this.updatePosterSize();
        this.numberFieldPosterSize_setValue();
        this.simulateOutput();
    }

    private void comboBoxPaperSize_addItem(String string, PaperSize paperSize) {
        this.comboBoxPaperSize.addItem(string);
        this.listPaperSize.add(paperSize);
    }

    private void comboBoxPaperSize_initialize() {
        this.comboBoxPaperSize.removeAllItems();
        this.listPaperSize.clear();
        this.comboBoxPaperSize_addItem(Lib.getMessage("Str.A4"), PaperSize.A4);
        this.comboBoxPaperSize_addItem(Lib.getMessage("Str.A3"), PaperSize.A3);
        this.comboBoxPaperSize_addItem(Lib.getMessage("Str.B5"), PaperSize.B5);
        this.comboBoxPaperSize_addItem(Lib.getMessage("Str.B4"), PaperSize.B4);
        this.comboBoxPaperSize_addItem(Lib.getMessage("Str.Custom"), PaperSize.CUSTOM);
    }

    private void comboBoxPaperSize_itemStateChanged() {
        PaperSize paperSize = this.listPaperSize.get(this.comboBoxPaperSize.getSelectedIndex());
        boolean bl = paperSize.isCustom();
        this.numberFieldPaperWidth.setEnabled(bl);
        this.numberFieldPaperHeight.setEnabled(bl);
        if (!bl) {
            if (this.paperRotated) {
                this.paperWidth = paperSize.getHeight();
                this.paperHeight = paperSize.getWidth();
            } else {
                this.paperWidth = paperSize.getWidth();
                this.paperHeight = paperSize.getHeight();
            }
            this.numberFieldPaperSize_setValue();
            this.simulateOutput();
        }
    }

    private void numberFieldPaperSize_actionPerformed(Object object) {
        double d = this.listPaperSizeUnit.get(this.comboBoxPaperSizeUnit.getSelectedIndex());
        this.paperWidth = (float)(this.numberFieldPaperWidth.getValue() / d);
        this.paperHeight = (float)(this.numberFieldPaperHeight.getValue() / d);
        this.numberFieldPaperSize_setValue();
        this.simulateOutput();
    }

    private void numberFieldPaperSize_setValue() {
        double d = this.listPaperSizeUnit.get(this.comboBoxPaperSizeUnit.getSelectedIndex());
        this.numberFieldPaperWidth.setValue((double)this.paperWidth * d);
        this.numberFieldPaperHeight.setValue((double)this.paperHeight * d);
    }

    private void comboBoxPaperSizeUnit_addItem(String string, double d) {
        this.comboBoxPaperSizeUnit.addItem(string);
        this.listPaperSizeUnit.add(d);
    }

    private void comboBoxPaperSizeUnit_initialize() {
        this.comboBoxPaperSizeUnit.removeAllItems();
        this.listPaperSizeUnit.clear();
        this.comboBoxPaperSizeUnit_addItem(Lib.getMessage("Str.MM"), Lib.UNIT_POINT_MM);
        this.comboBoxPaperSizeUnit_addItem(Lib.getMessage("Str.CM"), Lib.UNIT_POINT_CM);
        this.comboBoxPaperSizeUnit_addItem(Lib.getMessage("Str.M"), Lib.UNIT_POINT_M);
        this.comboBoxPaperSizeUnit_addItem(Lib.getMessage("Str.Inch"), Lib.UNIT_POINT_INCH);
        this.comboBoxPaperSizeUnit_addItem(Lib.getMessage("Str.Point"), 1.0);
    }

    private void comboBoxPaperSizeUnit_itemStateChanged() {
        this.numberFieldPaperSize_setValue();
    }

    private void numberFieldPaperMargin_actionPerformed(Object object) {
        double d = this.listPaperMarginUnit.get(this.comboBoxPaperMarginUnit.getSelectedIndex());
        this.paperMargin = (float)(this.numberFieldPaperMargin.getValue() / d);
        this.numberFieldPaperMargin_setValue();
        this.simulateOutput();
    }

    private void numberFieldPaperMargin_setValue() {
        double d = this.listPaperMarginUnit.get(this.comboBoxPaperMarginUnit.getSelectedIndex());
        this.numberFieldPaperMargin.setValue((double)this.paperMargin * d);
    }

    private void comboBoxPaperMarginUnit_addItem(String string, double d) {
        this.comboBoxPaperMarginUnit.addItem(string);
        this.listPaperMarginUnit.add(d);
    }

    private void comboBoxPaperMarginUnit_initialize() {
        this.comboBoxPaperMarginUnit.removeAllItems();
        this.listPaperMarginUnit.clear();
        this.comboBoxPaperMarginUnit_addItem(Lib.getMessage("Str.MM"), Lib.UNIT_POINT_MM);
        this.comboBoxPaperMarginUnit_addItem(Lib.getMessage("Str.CM"), Lib.UNIT_POINT_CM);
        this.comboBoxPaperMarginUnit_addItem(Lib.getMessage("Str.M"), Lib.UNIT_POINT_M);
        this.comboBoxPaperMarginUnit_addItem(Lib.getMessage("Str.Inch"), Lib.UNIT_POINT_INCH);
        this.comboBoxPaperMarginUnit_addItem(Lib.getMessage("Str.Point"), 1.0);
    }

    private void comboBoxPaperMarginUnit_itemStateChanged() {
        this.numberFieldPaperMargin_setValue();
    }

    private void checkBoxPaperRotate_itemStateChanged() {
        boolean bl = this.checkBoxPaperRotate.isSelected();
        if (this.paperRotated != bl) {
            float f = this.paperWidth;
            this.paperWidth = this.paperHeight;
            this.paperHeight = f;
            this.paperRotated = bl;
            this.numberFieldPaperSize_setValue();
            this.simulateOutput();
        }
    }

    private void buttonPaperOptimize_actionPerformed() {
        this.optimizePaperRotated();
    }

    private void buttonOutput_actionPerformed() {
        if (!this.checkFileLoaded()) {
            return;
        }
        String string = this.generateFileName(this.textFieldOutputFileName.getText());
        this.fileChooserOutputFile.setSelectedFile(new File(string));
        if (this.fileChooserOutputFile.showSaveDialog(this) != 0) {
            return;
        }
        this.outputPdf(this.fileChooserOutputFile.getSelectedFile());
    }

    private void numberField_initialize(NumberField numberField) {
        numberField.setColumns(7);
        numberField.setDisplayDigit(2);
        numberField.setUnitIncrement(0.1);
    }

    private void mainFrame_initializeComponents() {
        int n;
        String string;
        this.setTitle(Lib.getMessage("App.LowerTitle"));
        this.setSize(800, 600);
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.dispose();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return Lib.judgeFileTypeFromExtention(file) != 0;
            }

            @Override
            public String getDescription() {
                return Lib.getMessage("fileFilterPdfAndImage.Description");
            }
        };
        this.fileChooserSrcFile = new JFileChooser();
        this.fileChooserSrcFile.addChoosableFileFilter(fileFilter);
        this.fileChooserSrcFile.setFileFilter(fileFilter);
        this.fileChooserOutputFile = new JFileChooser();
        switch (Lib.getOS()) {
            case 0: {
                string = ".Win";
                n = 128;
                break;
            }
            case 1: {
                string = ".Mac";
                n = 256;
                break;
            }
            default: {
                string = "";
                n = 128;
            }
        }
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        jMenu.setText(Lib.getMessage("menuFile.Text" + string));
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText(Lib.getMessage("menuItemNewWindow.Text" + string));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, n));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.menuItemNewWindow_actionPerformed();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText(Lib.getMessage("menuItemOpenFile.Text" + string) + "...");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, n));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.menuItemOpenFile_actionPerformed();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setText(Lib.getMessage("menuItemCloseWindow.Text" + string));
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(87, n));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.menuItemCloseWindow_actionPerformed();
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem();
        jMenuItem4.setText(Lib.getMessage("menuItemOutput.Text" + string) + "...");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.menuItemOutput_actionPerformed();
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem();
        jMenuItem5.setText(Lib.getMessage("menuItemExit.Text" + string));
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.menuItemExit_actionPerformed();
            }
        });
        this.labelSrcFile = new JLabel();
        this.labelSrcFile.setText(Lib.getMessage("labelSrcFile.Text"));
        this.textFieldSrcFileName = new JTextField();
        this.textFieldSrcFileName.setEditable(false);
        this.textFieldSrcFileName.setColumns(50);
        this.labelSrcFileType = new JLabel();
        this.buttonSrcFileChange = new JButton();
        this.buttonSrcFileChange.setText(Lib.getMessage("buttonSrcFileChange.Text") + "...");
        this.buttonSrcFileChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.buttonSrcFileChange_actionPerformed();
            }
        });
        this.labelSrcPageNum = new JLabel();
        this.labelSrcPageNum.setText(Lib.getMessage("labelSrcPageNum.Text"));
        this.comboBoxSrcPageNum = new JComboBox();
        this.comboBoxSrcPageNum.setEnabled(false);
        this.comboBoxSrcPageNum.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!MainFrame.this.updatingComboBoxSrcPageNum) {
                    MainFrame.this.comboBoxSrcPageNum_itemStateChanged();
                }
            }
        });
        this.labelSrcImageSize = new JLabel();
        this.labelSrcImageSize.setText(Lib.getMessage("labelSrcImageSize.Text"));
        this.numberFieldSrcImageWidth = new NumberField();
        this.numberField_initialize(this.numberFieldSrcImageWidth);
        this.numberFieldSrcImageWidth.setEnabled(false);
        this.numberFieldSrcImageHeight = new NumberField();
        this.numberField_initialize(this.numberFieldSrcImageHeight);
        this.numberFieldSrcImageHeight.setEnabled(false);
        this.comboBoxSrcImageSizeUnit = new JComboBox();
        this.comboBoxSrcImageSizeUnit.setEnabled(false);
        this.comboBoxSrcImageSizeUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.comboBoxSrcImageSizeUnit_itemStateChanged();
            }
        });
        this.labelSrcRect = new JLabel();
        this.labelSrcRect.setText(Lib.getMessage("labelSrcRect.Text"));
        this.checkBoxSrcRectWholeOfPage = new JCheckBox();
        this.checkBoxSrcRectWholeOfPage.setText(Lib.getMessage("checkBoxSrcRectWholeOfPage.Text"));
        this.checkBoxSrcRectWholeOfPage.setEnabled(false);
        this.checkBoxSrcRectWholeOfPage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.checkBoxSrcRectWholeOfPage_itemStateChanged();
            }
        });
        this.numberFieldSrcLeft = new NumberField();
        this.numberField_initialize(this.numberFieldSrcLeft);
        this.numberFieldSrcLeft.setEnabled(false);
        this.numberFieldSrcLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldSrcRect_actionPerformed(actionEvent.getSource());
            }
        });
        this.numberFieldSrcBottom = new NumberField();
        this.numberField_initialize(this.numberFieldSrcBottom);
        this.numberFieldSrcBottom.setEnabled(false);
        this.numberFieldSrcBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldSrcRect_actionPerformed(actionEvent.getSource());
            }
        });
        this.numberFieldSrcRight = new NumberField();
        this.numberField_initialize(this.numberFieldSrcRight);
        this.numberFieldSrcRight.setEnabled(false);
        this.numberFieldSrcRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldSrcRect_actionPerformed(actionEvent.getSource());
            }
        });
        this.numberFieldSrcTop = new NumberField();
        this.numberField_initialize(this.numberFieldSrcTop);
        this.numberFieldSrcTop.setEnabled(false);
        this.numberFieldSrcTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldSrcRect_actionPerformed(actionEvent.getSource());
            }
        });
        this.comboBoxSrcRectUnit = new JComboBox();
        this.comboBoxSrcRectUnit.setEnabled(false);
        this.comboBoxSrcRectUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.comboBoxSrcRectUnit_itemStateChanged();
            }
        });
        this.labelPosterSize = new JLabel();
        this.labelPosterSize.setText(Lib.getMessage("labelPosterSize.Text"));
        this.comboBoxPosterSize = new JComboBox();
        this.comboBoxPosterSize_initialize();
        this.comboBoxPosterSize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.comboBoxPosterSize_itemStateChanged();
            }
        });
        this.numberFieldPosterWidth = new NumberField();
        this.numberField_initialize(this.numberFieldPosterWidth);
        this.numberFieldPosterWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldPosterSize_actionPerformed(actionEvent.getSource());
            }
        });
        this.numberFieldPosterHeight = new NumberField();
        this.numberField_initialize(this.numberFieldPosterHeight);
        this.numberFieldPosterHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldPosterSize_actionPerformed(actionEvent.getSource());
            }
        });
        this.comboBoxPosterSizeUnit = new JComboBox();
        this.comboBoxPosterSizeUnit_initialize();
        this.comboBoxPosterSizeUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.comboBoxPosterSizeUnit_itemStateChanged();
            }
        });
        this.checkBoxPosterSizeKeepAspectRatio = new JCheckBox();
        this.checkBoxPosterSizeKeepAspectRatio.setText(Lib.getMessage("checkBoxPosterSizeKeepAspectRatio.Text"));
        this.checkBoxPosterSizeKeepAspectRatio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.checkBoxPosterSizeKeepAspectRatio_itemStateChanged();
            }
        });
        this.labelPaperSize = new JLabel();
        this.labelPaperSize.setText(Lib.getMessage("labelPaperSize.Text"));
        this.comboBoxPaperSize = new JComboBox();
        this.comboBoxPaperSize_initialize();
        this.comboBoxPaperSize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.comboBoxPaperSize_itemStateChanged();
            }
        });
        this.numberFieldPaperWidth = new NumberField();
        this.numberField_initialize(this.numberFieldPaperWidth);
        this.numberFieldPaperWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldPaperSize_actionPerformed(actionEvent.getSource());
            }
        });
        this.numberFieldPaperHeight = new NumberField();
        this.numberField_initialize(this.numberFieldPaperHeight);
        this.numberFieldPaperHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldPaperSize_actionPerformed(actionEvent.getSource());
            }
        });
        this.comboBoxPaperSizeUnit = new JComboBox();
        this.comboBoxPaperSizeUnit_initialize();
        this.comboBoxPaperSizeUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.comboBoxPaperSizeUnit_itemStateChanged();
            }
        });
        this.labelPaperMargin = new JLabel();
        this.labelPaperMargin.setText(Lib.getMessage("labelPaperMargin.Text"));
        this.numberFieldPaperMargin = new NumberField();
        this.numberField_initialize(this.numberFieldPaperMargin);
        this.numberFieldPaperMargin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldPaperMargin_actionPerformed(actionEvent.getSource());
            }
        });
        this.comboBoxPaperMarginUnit = new JComboBox();
        this.comboBoxPaperMarginUnit_initialize();
        this.comboBoxPaperMarginUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.comboBoxPaperMarginUnit_itemStateChanged();
            }
        });
        this.checkBoxPaperRotate = new JCheckBox();
        this.checkBoxPaperRotate.setText(Lib.getMessage("checkBoxPaperRotate.Text"));
        this.checkBoxPaperRotate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.checkBoxPaperRotate_itemStateChanged();
            }
        });
        this.buttonPaperOptimize = new JButton();
        this.buttonPaperOptimize.setText(Lib.getMessage("buttonPaperOptimize.Text"));
        this.buttonPaperOptimize.setEnabled(false);
        this.buttonPaperOptimize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.buttonPaperOptimize_actionPerformed();
            }
        });
        this.labelPreview = new JLabel();
        this.labelPreview.setText(Lib.getMessage("labelPreview.Text"));
        this.labelOutputPaperCount = new JLabel();
        this.labelOutputPaperCount.setText(Lib.getMessage("labelOutputPaperCount.Text"));
        this.numberFieldOutputPaperCount = new NumberField();
        this.numberFieldOutputPaperCount.setColumns(7);
        this.numberFieldOutputPaperCount.setDisplayDigit(0);
        this.numberFieldOutputPaperCount.setEditable(false);
        this.canvasPreview = new CanvasPreview();
        this.labelOutputFileName = new JLabel();
        this.labelOutputFileName.setText(Lib.getMessage("labelOutputFileName.Text"));
        this.textFieldOutputFileName = new JTextField();
        this.textFieldOutputFileName.setColumns(40);
        this.buttonOutput = new JButton();
        this.buttonOutput.setText(Lib.getMessage("buttonOutput.Text") + "...");
        this.buttonOutput.setEnabled(false);
        this.buttonOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.buttonOutput_actionPerformed();
            }
        });
        if (Lib.getOS() == 1) {
            jMenu.add(jMenuItem);
            jMenu.add(jMenuItem2);
            jMenu.addSeparator();
            jMenu.add(jMenuItem3);
            jMenu.add(jMenuItem4);
        } else {
            jMenu.add(jMenuItem);
            jMenu.add(jMenuItem2);
            jMenu.add(jMenuItem3);
            jMenu.addSeparator();
            jMenu.add(jMenuItem4);
            jMenu.addSeparator();
            jMenu.add(jMenuItem5);
        }
        jMenuBar.add(jMenu);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.labelSrcFile);
        jPanel.add(this.textFieldSrcFileName);
        jPanel.add(this.labelSrcFileType);
        jPanel.add(this.buttonSrcFileChange);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.labelSrcPageNum);
        jPanel2.add(this.comboBoxSrcPageNum);
        jPanel2.add(this.labelSrcImageSize);
        jPanel2.add(this.numberFieldSrcImageWidth);
        jPanel2.add(this.numberFieldSrcImageHeight);
        jPanel2.add(this.comboBoxSrcImageSizeUnit);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.labelSrcRect);
        jPanel3.add(this.checkBoxSrcRectWholeOfPage);
        jPanel3.add(this.numberFieldSrcLeft);
        jPanel3.add(this.numberFieldSrcBottom);
        jPanel3.add(this.numberFieldSrcRight);
        jPanel3.add(this.numberFieldSrcTop);
        jPanel3.add(this.comboBoxSrcRectUnit);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(this.labelPosterSize);
        jPanel4.add(this.comboBoxPosterSize);
        jPanel4.add(this.numberFieldPosterWidth);
        jPanel4.add(this.numberFieldPosterHeight);
        jPanel4.add(this.comboBoxPosterSizeUnit);
        jPanel4.add(this.checkBoxPosterSizeKeepAspectRatio);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(this.labelPaperSize);
        jPanel5.add(this.comboBoxPaperSize);
        jPanel5.add(this.numberFieldPaperWidth);
        jPanel5.add(this.numberFieldPaperHeight);
        jPanel5.add(this.comboBoxPaperSizeUnit);
        jPanel5.add(this.labelPaperMargin);
        jPanel5.add(this.numberFieldPaperMargin);
        jPanel5.add(this.comboBoxPaperMarginUnit);
        jPanel5.add(this.checkBoxPaperRotate);
        jPanel5.add(this.buttonPaperOptimize);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        jPanel6.add(this.labelPreview);
        jPanel6.add(this.labelOutputPaperCount);
        jPanel6.add(this.numberFieldOutputPaperCount);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0));
        jPanel7.add(this.labelOutputFileName);
        jPanel7.add(this.textFieldOutputFileName);
        JPanel jPanel8 = new JPanel();
        switch (Lib.getOS()) {
            case 1: {
                jPanel8.setLayout(new FlowLayout(2, 15, 15));
                jPanel8.add(this.buttonOutput);
                break;
            }
            default: {
                jPanel8.setLayout(new FlowLayout(0, 15, 15));
                jPanel8.add(this.buttonOutput);
            }
        }
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 1));
        jPanel9.add(jPanel);
        jPanel9.add(jPanel2);
        jPanel9.add(jPanel3);
        jPanel9.add(jPanel4);
        jPanel9.add(jPanel5);
        jPanel9.add(jPanel6);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 1));
        jPanel10.add(jPanel8);
        this.setJMenuBar(jMenuBar);
        this.getRootPane().setDefaultButton(this.buttonOutput);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel9, "North");
        this.add((Component)jPanel10, "South");
        this.add((Component)this.canvasPreview, "Center");
    }

    private void mainFrame_initialize() {
        this.preferredPosterWidth = PaperSize.A1.getWidth();
        this.preferredPosterHeight = PaperSize.A1.getHeight();
        this.updatePosterSize();
        this.numberFieldPosterSize_setValue();
        this.comboBoxPosterSize.setSelectedIndex(this.comboBoxPosterSize.getItemCount() - 1);
        this.comboBoxPosterSize_itemStateChanged();
        this.checkBoxPosterSizeKeepAspectRatio.setSelected(true);
        this.checkBoxPosterSizeKeepAspectRatio_itemStateChanged();
        this.comboBoxPaperSize.setSelectedIndex(0);
        this.comboBoxPaperSize_itemStateChanged();
        this.comboBoxPaperSizeUnit.setSelectedIndex(0);
        this.comboBoxPaperSizeUnit_itemStateChanged();
        this.paperMargin = 72.0f;
        this.numberFieldPaperMargin_setValue();
        this.comboBoxPaperMarginUnit.setSelectedIndex(0);
        this.comboBoxPaperMarginUnit_itemStateChanged();
        this.textFieldOutputFileName.setText(String.format("{pwd}%s%s_{input}_{date}.pdf", File.separator, Lib.getMessage("App.LowerTitle")));
        this.simulateOutput();
    }

    public MainFrame() {
        this.mainFrame_initializeComponents();
        this.mainFrame_initialize();
    }
}

