/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.posterdivider;

import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfReader;
import java.awt.image.BufferedImage;
import jp.sourceforge.posterdivider.FileContainer;

public class ImageContainer {
    private int fileType;
    private PdfReader pdf;
    private Image image;
    private int pageNum;
    private BufferedImage awtImage;

    public ImageContainer(FileContainer fileContainer, int n) throws Exception {
        this.fileType = fileContainer.getFileType();
        this.pdf = fileContainer.getPdf();
        this.image = fileContainer.getImage();
        if (n <= 0 || n > fileContainer.getPageCount()) {
            throw new IllegalArgumentException();
        }
        this.pageNum = n;
        this.awtImage = fileContainer.getAwtImage();
    }

    public int getFileType() {
        return this.fileType;
    }

    public PdfReader getPdf() {
        return this.pdf;
    }

    public Image getImage() {
        return this.image;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public float getImageWidth() {
        switch (this.fileType) {
            case 1: {
                return this.pdf.getPageSize(this.pageNum).getWidth();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.image.getWidth();
            }
        }
        return -1.0f;
    }

    public float getImageHeight() {
        switch (this.fileType) {
            case 1: {
                return this.pdf.getPageSize(this.pageNum).getHeight();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.image.getHeight();
            }
        }
        return -1.0f;
    }

    public BufferedImage getAwtImage() {
        return this.awtImage;
    }
}

