/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.posterdivider;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BoxLayout;
import jp.sourceforge.posterdivider.CanvasPreview;
import jp.sourceforge.posterdivider.FileContainer;
import jp.sourceforge.posterdivider.ImageContainer;
import jp.sourceforge.posterdivider.Lib;
import jp.sourceforge.posterdivider.NumberField;
import jp.sourceforge.posterdivider.PaperSize;
import jp.sourceforge.posterdivider.PdfGenerator;
import jp.sourceforge.posterdivider.Program;

public class MainFrame
extends Frame {
    private static final long serialVersionUID = 1L;
    private Label labelSrcFile;
    private TextField textFieldSrcFileName;
    private Label labelSrcFileType;
    private Button buttonSrcFileChange;
    private Label labelSrcPageNum;
    private Choice choiceSrcPageNum;
    private Label labelSrcImageSize;
    private NumberField numberFieldSrcImageWidth;
    private NumberField numberFieldSrcImageHeight;
    private Choice choiceSrcImageSizeUnit;
    private Label labelSrcRect;
    private Checkbox checkboxSrcRectWholeOfPage;
    private NumberField numberFieldSrcLeft;
    private NumberField numberFieldSrcBottom;
    private NumberField numberFieldSrcRight;
    private NumberField numberFieldSrcTop;
    private Choice choiceSrcRectUnit;
    private Label labelPosterSize;
    private Choice choicePosterSize;
    private NumberField numberFieldPosterWidth;
    private NumberField numberFieldPosterHeight;
    private Choice choicePosterSizeUnit;
    private Checkbox checkboxPosterSizeKeepAspectRatio;
    private Label labelPaperSize;
    private Choice choicePaperSize;
    private NumberField numberFieldPaperWidth;
    private NumberField numberFieldPaperHeight;
    private Choice choicePaperSizeUnit;
    private Label labelPaperMargin;
    private NumberField numberFieldPaperMargin;
    private Choice choicePaperMarginUnit;
    private Checkbox checkboxPaperRotate;
    private Button buttonPaperOptimize;
    private Label labelPreview;
    private Label labelOutputPaperCount;
    private NumberField numberFieldOutputPaperCount;
    private CanvasPreview canvasPreview;
    private Label labelOutputFileName;
    private TextField textFieldOutputFileName;
    private Label labelMessage;
    private Button buttonOutput;
    private File srcFile;
    private FileContainer fc;
    private ImageContainer ic;
    private float srcImageWidth;
    private float srcImageHeight;
    private ArrayList<Double> listSrcImageSizeUnit = new ArrayList();
    private float srcLeft;
    private float srcBottom;
    private float srcRight;
    private float srcTop;
    private ArrayList<Double> listSrcRectUnit = new ArrayList();
    private ArrayList<PaperSize> listPosterSize = new ArrayList();
    private float preferredPosterWidth;
    private float preferredPosterHeight;
    private float posterWidth;
    private float posterHeight;
    private ArrayList<Double> listPosterSizeUnit = new ArrayList();
    private ArrayList<PaperSize> listPaperSize = new ArrayList();
    private float paperWidth;
    private float paperHeight;
    private boolean paperRotated;
    private ArrayList<Double> listPaperSizeUnit = new ArrayList();
    private float paperMargin;
    private ArrayList<Double> listPaperMarginUnit = new ArrayList();

    private String generateFileName(String string) {
        string = string.replace("{pwd}", System.getProperty("user.dir"));
        if (this.srcFile != null) {
            string = string.replace("{input}", this.srcFile.getName());
        }
        string = string.replace("{date}", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        return string;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public boolean checkFileLoaded() {
        return this.ic != null;
    }

    private void simulateOutput() {
        this.labelMessage.setText("");
        PdfGenerator.CreatePosterArgs createPosterArgs = new PdfGenerator.CreatePosterArgs();
        createPosterArgs.setSrcRect(this.srcLeft, this.srcBottom, this.srcRight, this.srcTop);
        createPosterArgs.setPosterSize(this.posterWidth, this.posterHeight);
        createPosterArgs.setPaperSize(this.paperWidth, this.paperHeight);
        createPosterArgs.setMargin(this.paperMargin, this.paperMargin, this.paperMargin, this.paperMargin);
        int n = PdfGenerator.simulateOutputPaperCount(createPosterArgs);
        this.numberFieldOutputPaperCount.setValue(n);
        this.canvasPreview.setArgs(createPosterArgs);
        this.canvasPreview.repaint();
    }

    private void optimizePaperRotated() {
        PdfGenerator.CreatePosterArgs createPosterArgs = new PdfGenerator.CreatePosterArgs();
        createPosterArgs.setSrcRect(this.srcLeft, this.srcBottom, this.srcRight, this.srcTop);
        createPosterArgs.setPosterSize(this.posterWidth, this.posterHeight);
        createPosterArgs.setPaperSize(this.paperWidth, this.paperHeight);
        createPosterArgs.setMargin(this.paperMargin, this.paperMargin, this.paperMargin, this.paperMargin);
        int n = PdfGenerator.simulateOutputPaperCount(createPosterArgs);
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        PdfGenerator.CreatePosterArgs createPosterArgs2 = new PdfGenerator.CreatePosterArgs();
        createPosterArgs2.setSrcRect(this.srcLeft, this.srcBottom, this.srcRight, this.srcTop);
        createPosterArgs2.setPosterSize(this.posterWidth, this.posterHeight);
        createPosterArgs2.setPaperSize(this.paperHeight, this.paperWidth);
        createPosterArgs2.setMargin(this.paperMargin, this.paperMargin, this.paperMargin, this.paperMargin);
        int n2 = PdfGenerator.simulateOutputPaperCount(createPosterArgs2);
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (n > n2 || n == n2 && this.paperRotated) {
            this.checkboxPaperRotate.setState(!this.paperRotated);
            this.checkboxPaperRotate_itemStateChanged();
        }
    }

    public void outputPdf() {
        if (!this.checkFileLoaded()) {
            this.labelMessage.setText(Lib.getMessage("Text.NoInputFiles"));
            this.validateTree();
            return;
        }
        PdfGenerator.CreatePosterArgs createPosterArgs = new PdfGenerator.CreatePosterArgs();
        createPosterArgs.setSrcRect(this.srcLeft, this.srcBottom, this.srcRight, this.srcTop);
        createPosterArgs.setPosterSize(this.posterWidth, this.posterHeight);
        createPosterArgs.setPaperSize(this.paperWidth, this.paperHeight);
        createPosterArgs.setMargin(this.paperMargin, this.paperMargin, this.paperMargin, this.paperMargin);
        String string = this.generateFileName(this.textFieldOutputFileName.getText());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PdfGenerator.createPoster(this.ic, createPosterArgs, byteArrayOutputStream);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                byteArrayOutputStream.writeTo(fileOutputStream);
                fileOutputStream.close();
                this.labelMessage.setText(String.format(Lib.getMessage("Text.Saved"), string));
            }
            catch (IOException iOException) {
                this.labelMessage.setText(String.format(Lib.getMessage("Text.FailedWrite"), string));
            }
        }
        catch (Exception exception) {
            this.labelMessage.setText(Lib.getMessage("Text.FailedGenerate"));
        }
        this.validateTree();
    }

    private void changePageSuccess(ImageContainer imageContainer) {
        this.ic = imageContainer;
        this.choiceSrcPageNum.select(imageContainer.getPageNum() - 1);
        this.srcImageWidth = imageContainer.getImageWidth();
        this.srcImageHeight = imageContainer.getImageHeight();
        this.numberFieldSrcImageSize_setValue();
        this.choiceSrcImageSizeUnit.setEnabled(true);
        this.checkboxSrcRectWholeOfPage.setEnabled(true);
        this.choiceSrcRectUnit.setEnabled(true);
        this.buttonPaperOptimize.setEnabled(true);
        this.canvasPreview.setImageContainer(imageContainer);
        this.simulateOutput();
    }

    public void changePage(int n) {
        if (this.fc == null) {
            return;
        }
        try {
            ImageContainer imageContainer = new ImageContainer(this.fc, n);
            this.changePageSuccess(imageContainer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validateTree();
    }

    private void changeFileSuccess(File file, FileContainer fileContainer) {
        this.srcFile = file;
        this.fc = fileContainer;
        try {
            this.textFieldSrcFileName.setText(file.getCanonicalPath());
        }
        catch (Exception exception) {
            this.textFieldSrcFileName.setText(file.getAbsolutePath());
        }
        this.labelSrcFileType.setText(Lib.getFileTypeName(fileContainer.getFileType()));
        this.choiceSrcPageNum.removeAll();
        for (int i = 1; i <= fileContainer.getPageCount(); ++i) {
            this.choiceSrcPageNum.add(Integer.toString(i));
        }
        this.choiceSrcPageNum.select(0);
        this.choiceSrcPageNum.setEnabled(fileContainer.getFileType() == 1);
        this.choiceSrcImageSizeUnit_initialize(fileContainer.getFileType());
        this.choiceSrcImageSizeUnit.select(0);
        this.choiceSrcRectUnit_initialize(fileContainer.getFileType());
        this.choiceSrcRectUnit.select(0);
        this.changePage(this.choiceSrcPageNum.getSelectedIndex() + 1);
        this.checkboxSrcRectWholeOfPage.setState(true);
        this.checkboxSrcRectWholeOfPage_itemStateChanged();
    }

    public void changeFile(File file) {
        try {
            FileContainer fileContainer = new FileContainer(file);
            this.changeFileSuccess(file, fileContainer);
        }
        catch (Exception exception) {
            this.labelMessage.setText(String.format(Lib.getMessage("Text.FailedOpen"), file.getAbsolutePath()));
        }
        this.validateTree();
    }

    private void updatePosterSize() {
        this.posterWidth = this.preferredPosterWidth;
        this.posterHeight = this.preferredPosterHeight;
        if (this.checkboxPosterSizeKeepAspectRatio.getState()) {
            if ((this.srcRight - this.srcLeft) * this.preferredPosterHeight > (this.srcTop - this.srcBottom) * this.preferredPosterWidth) {
                if (this.srcRight != this.srcLeft) {
                    this.posterHeight = this.posterWidth * (this.srcTop - this.srcBottom) / (this.srcRight - this.srcLeft);
                }
            } else if (this.srcTop != this.srcBottom) {
                this.posterWidth = this.posterHeight * (this.srcRight - this.srcLeft) / (this.srcTop - this.srcBottom);
            }
        }
    }

    private void menuItemNewWindow_actionPerformed() {
        Program.createFrame();
    }

    private void menuItemOpenFile_actionPerformed() {
        FileDialog fileDialog = new FileDialog((Frame)this, Lib.getMessage("App.LowerTitle"), 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
            MainFrame mainFrame = Program.getSameFileFrame(file);
            if (mainFrame != null) {
                mainFrame.setVisible(true);
            } else if (!this.checkFileLoaded()) {
                this.changeFile(file);
            } else {
                switch (Lib.getOS()) {
                    case 1: {
                        Program.createFrame(file, false);
                        break;
                    }
                    default: {
                        this.changeFile(file);
                    }
                }
            }
        }
    }

    private void menuItemCloseWindow_actionPerformed() {
        this.dispose();
    }

    private void menuItemOutput_actionPerformed() {
        this.outputPdf();
    }

    private void menuItemExit_actionPerformed() {
        System.exit(0);
    }

    private void buttonSrcFileChange_actionPerformed() {
        FileDialog fileDialog = new FileDialog((Frame)this, Lib.getMessage("App.LowerTitle"), 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
            this.changeFile(file);
        }
    }

    private void choiceSrcPageNum_itemStateChanged() {
        int n = this.choiceSrcPageNum.getSelectedIndex() + 1;
        if (this.ic.getPageNum() != n) {
            this.changePage(n);
        }
    }

    private void numberFieldSrcImageSize_setValue() {
        double d = this.listSrcImageSizeUnit.get(this.choiceSrcImageSizeUnit.getSelectedIndex());
        this.numberFieldSrcImageWidth.setValue((double)this.srcImageWidth * d);
        this.numberFieldSrcImageHeight.setValue((double)this.srcImageHeight * d);
    }

    private void choiceSrcImageSizeUnit_add(String string, double d) {
        this.choiceSrcImageSizeUnit.add(string);
        this.listSrcImageSizeUnit.add(d);
    }

    private void choiceSrcImageSizeUnit_initialize(int n) {
        this.choiceSrcImageSizeUnit.removeAll();
        this.listSrcImageSizeUnit.clear();
        switch (n) {
            case 1: {
                this.choiceSrcImageSizeUnit_add(Lib.getMessage("Str.MM"), Lib.UNIT_POINT_MM);
                this.choiceSrcImageSizeUnit_add(Lib.getMessage("Str.CM"), Lib.UNIT_POINT_CM);
                this.choiceSrcImageSizeUnit_add(Lib.getMessage("Str.M"), Lib.UNIT_POINT_M);
                this.choiceSrcImageSizeUnit_add(Lib.getMessage("Str.Inch"), Lib.UNIT_POINT_INCH);
                this.choiceSrcImageSizeUnit_add(Lib.getMessage("Str.Point"), 1.0);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.choiceSrcImageSizeUnit_add(Lib.getMessage("Str.Pixel"), 1.0);
                break;
            }
        }
    }

    private void choiceSrcImageSizeUnit_itemStateChanged() {
        this.numberFieldSrcImageSize_setValue();
    }

    private void checkboxSrcRectWholeOfPage_itemStateChanged() {
        boolean bl = this.checkboxSrcRectWholeOfPage.getState();
        this.numberFieldSrcLeft.setEnabled(!bl);
        this.numberFieldSrcTop.setEnabled(!bl);
        this.numberFieldSrcRight.setEnabled(!bl);
        this.numberFieldSrcBottom.setEnabled(!bl);
        if (bl) {
            this.srcLeft = 0.0f;
            this.srcBottom = 0.0f;
            this.srcRight = this.srcImageWidth;
            this.srcTop = this.srcImageHeight;
            this.numberFieldSrcRect_setValue();
            this.updatePosterSize();
            this.numberFieldPosterSize_setValue();
            this.simulateOutput();
        }
    }

    private void numberFieldSrcRect_actionPerformed(Object object) {
        double d = this.listSrcRectUnit.get(this.choiceSrcRectUnit.getSelectedIndex());
        this.srcLeft = (float)(this.numberFieldSrcLeft.getValue() / d);
        this.srcTop = (float)(this.numberFieldSrcTop.getValue() / d);
        this.srcRight = (float)(this.numberFieldSrcRight.getValue() / d);
        this.srcBottom = (float)(this.numberFieldSrcBottom.getValue() / d);
        this.numberFieldSrcRect_setValue();
        this.updatePosterSize();
        this.numberFieldPosterSize_setValue();
        this.simulateOutput();
    }

    private void numberFieldSrcRect_setValue() {
        if (this.listSrcRectUnit.isEmpty()) {
            return;
        }
        double d = this.listSrcRectUnit.get(this.choiceSrcRectUnit.getSelectedIndex());
        this.numberFieldSrcLeft.setValue((double)this.srcLeft * d);
        this.numberFieldSrcTop.setValue((double)this.srcTop * d);
        this.numberFieldSrcRight.setValue((double)this.srcRight * d);
        this.numberFieldSrcBottom.setValue((double)this.srcBottom * d);
    }

    private void choiceSrcRectUnit_add(String string, double d) {
        this.choiceSrcRectUnit.add(string);
        this.listSrcRectUnit.add(d);
    }

    private void choiceSrcRectUnit_initialize(int n) {
        this.choiceSrcRectUnit.removeAll();
        this.listSrcRectUnit.clear();
        switch (n) {
            case 1: {
                this.choiceSrcRectUnit_add(Lib.getMessage("Str.MM"), Lib.UNIT_POINT_MM);
                this.choiceSrcRectUnit_add(Lib.getMessage("Str.CM"), Lib.UNIT_POINT_CM);
                this.choiceSrcRectUnit_add(Lib.getMessage("Str.M"), Lib.UNIT_POINT_M);
                this.choiceSrcRectUnit_add(Lib.getMessage("Str.Inch"), Lib.UNIT_POINT_INCH);
                this.choiceSrcRectUnit_add(Lib.getMessage("Str.Point"), 1.0);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.choiceSrcRectUnit_add(Lib.getMessage("Str.Pixel"), 1.0);
                break;
            }
        }
    }

    private void choiceSrcRectUnit_itemStateChanged() {
        this.numberFieldSrcRect_setValue();
    }

    private void choicePosterSize_add(String string, PaperSize paperSize) {
        this.choicePosterSize.add(string);
        this.listPosterSize.add(paperSize);
    }

    private void choicePosterSize_initialize() {
        this.choicePosterSize.removeAll();
        this.listPosterSize.clear();
        this.choicePosterSize_add(Lib.getMessage("Str.A0"), PaperSize.A0);
        this.choicePosterSize_add(Lib.getMessage("Str.A1"), PaperSize.A1);
        this.choicePosterSize_add(Lib.getMessage("Str.A2"), PaperSize.A2);
        this.choicePosterSize_add(Lib.getMessage("Str.A3"), PaperSize.A3);
        this.choicePosterSize_add(Lib.getMessage("Str.A4"), PaperSize.A4);
        this.choicePosterSize_add(Lib.getMessage("Str.A5"), PaperSize.A5);
        this.choicePosterSize_add(Lib.getMessage("Str.A6"), PaperSize.A6);
        this.choicePosterSize_add(Lib.getMessage("Str.B0"), PaperSize.B0);
        this.choicePosterSize_add(Lib.getMessage("Str.B1"), PaperSize.B1);
        this.choicePosterSize_add(Lib.getMessage("Str.B2"), PaperSize.B2);
        this.choicePosterSize_add(Lib.getMessage("Str.B3"), PaperSize.B3);
        this.choicePosterSize_add(Lib.getMessage("Str.B4"), PaperSize.B4);
        this.choicePosterSize_add(Lib.getMessage("Str.B5"), PaperSize.B5);
        this.choicePosterSize_add(Lib.getMessage("Str.B6"), PaperSize.B6);
        this.choicePosterSize_add(Lib.getMessage("Str.Custom"), PaperSize.CUSTOM);
    }

    private void choicePosterSize_itemStateChanged() {
        PaperSize paperSize = this.listPosterSize.get(this.choicePosterSize.getSelectedIndex());
        boolean bl = paperSize.isCustom();
        this.numberFieldPosterWidth.setEnabled(bl);
        this.numberFieldPosterHeight.setEnabled(bl);
        if (!bl) {
            this.preferredPosterWidth = paperSize.getWidth();
            this.preferredPosterHeight = paperSize.getHeight();
            this.updatePosterSize();
            this.numberFieldPosterSize_setValue();
            this.simulateOutput();
        }
    }

    private void numberFieldPosterSize_actionPerformed(Object object) {
        double d = this.listPosterSizeUnit.get(this.choicePosterSizeUnit.getSelectedIndex());
        this.preferredPosterWidth = (float)(this.numberFieldPosterWidth.getValue() / d);
        this.preferredPosterHeight = (float)(this.numberFieldPosterHeight.getValue() / d);
        if (this.checkboxPosterSizeKeepAspectRatio.getState()) {
            if (object == this.numberFieldPosterWidth && this.srcRight != this.srcLeft) {
                this.preferredPosterHeight = this.preferredPosterWidth * (this.srcTop - this.srcBottom) / (this.srcRight - this.srcLeft);
            }
            if (object == this.numberFieldPosterHeight && this.srcTop != this.srcBottom) {
                this.preferredPosterWidth = this.preferredPosterHeight * (this.srcRight - this.srcLeft) / (this.srcTop - this.srcBottom);
            }
        }
        this.updatePosterSize();
        this.numberFieldPosterSize_setValue();
        this.simulateOutput();
    }

    private void numberFieldPosterSize_setValue() {
        double d = this.listPosterSizeUnit.get(this.choicePosterSizeUnit.getSelectedIndex());
        this.numberFieldPosterWidth.setValue((double)this.posterWidth * d);
        this.numberFieldPosterHeight.setValue((double)this.posterHeight * d);
    }

    private void choicePosterSizeUnit_add(String string, double d) {
        this.choicePosterSizeUnit.add(string);
        this.listPosterSizeUnit.add(d);
    }

    private void choicePosterSizeUnit_initialize() {
        this.choicePosterSizeUnit.removeAll();
        this.listPosterSizeUnit.clear();
        this.choicePosterSizeUnit_add(Lib.getMessage("Str.MM"), Lib.UNIT_POINT_MM);
        this.choicePosterSizeUnit_add(Lib.getMessage("Str.CM"), Lib.UNIT_POINT_CM);
        this.choicePosterSizeUnit_add(Lib.getMessage("Str.M"), Lib.UNIT_POINT_M);
        this.choicePosterSizeUnit_add(Lib.getMessage("Str.Inch"), Lib.UNIT_POINT_INCH);
        this.choicePosterSizeUnit_add(Lib.getMessage("Str.Point"), 1.0);
    }

    private void choicePosterSizeUnit_itemStateChanged() {
        this.numberFieldPosterSize_setValue();
    }

    private void checkboxPosterSizeKeepAspectRatio_itemStateChanged() {
        this.updatePosterSize();
        this.numberFieldPosterSize_setValue();
        this.simulateOutput();
    }

    private void choicePaperSize_add(String string, PaperSize paperSize) {
        this.choicePaperSize.add(string);
        this.listPaperSize.add(paperSize);
    }

    private void choicePaperSize_initialize() {
        this.choicePaperSize.removeAll();
        this.listPaperSize.clear();
        this.choicePaperSize_add(Lib.getMessage("Str.A4"), PaperSize.A4);
        this.choicePaperSize_add(Lib.getMessage("Str.A3"), PaperSize.A3);
        this.choicePaperSize_add(Lib.getMessage("Str.B5"), PaperSize.B5);
        this.choicePaperSize_add(Lib.getMessage("Str.B4"), PaperSize.B4);
        this.choicePaperSize_add(Lib.getMessage("Str.Custom"), PaperSize.CUSTOM);
    }

    private void choicePaperSize_itemStateChanged() {
        PaperSize paperSize = this.listPaperSize.get(this.choicePaperSize.getSelectedIndex());
        boolean bl = paperSize.isCustom();
        this.numberFieldPaperWidth.setEnabled(bl);
        this.numberFieldPaperHeight.setEnabled(bl);
        if (!bl) {
            if (this.paperRotated) {
                this.paperWidth = paperSize.getHeight();
                this.paperHeight = paperSize.getWidth();
            } else {
                this.paperWidth = paperSize.getWidth();
                this.paperHeight = paperSize.getHeight();
            }
            this.numberFieldPaperSize_setValue();
            this.simulateOutput();
        }
    }

    private void numberFieldPaperSize_actionPerformed(Object object) {
        double d = this.listPaperSizeUnit.get(this.choicePaperSizeUnit.getSelectedIndex());
        this.paperWidth = (float)(this.numberFieldPaperWidth.getValue() / d);
        this.paperHeight = (float)(this.numberFieldPaperHeight.getValue() / d);
        this.numberFieldPaperSize_setValue();
        this.simulateOutput();
    }

    private void numberFieldPaperSize_setValue() {
        double d = this.listPaperSizeUnit.get(this.choicePaperSizeUnit.getSelectedIndex());
        this.numberFieldPaperWidth.setValue((double)this.paperWidth * d);
        this.numberFieldPaperHeight.setValue((double)this.paperHeight * d);
    }

    private void choicePaperSizeUnit_add(String string, double d) {
        this.choicePaperSizeUnit.add(string);
        this.listPaperSizeUnit.add(d);
    }

    private void choicePaperSizeUnit_initialize() {
        this.choicePaperSizeUnit.removeAll();
        this.listPaperSizeUnit.clear();
        this.choicePaperSizeUnit_add(Lib.getMessage("Str.MM"), Lib.UNIT_POINT_MM);
        this.choicePaperSizeUnit_add(Lib.getMessage("Str.CM"), Lib.UNIT_POINT_CM);
        this.choicePaperSizeUnit_add(Lib.getMessage("Str.M"), Lib.UNIT_POINT_M);
        this.choicePaperSizeUnit_add(Lib.getMessage("Str.Inch"), Lib.UNIT_POINT_INCH);
        this.choicePaperSizeUnit_add(Lib.getMessage("Str.Point"), 1.0);
    }

    private void choicePaperSizeUnit_itemStateChanged() {
        this.numberFieldPaperSize_setValue();
    }

    private void numberFieldPaperMargin_actionPerformed(Object object) {
        double d = this.listPaperMarginUnit.get(this.choicePaperMarginUnit.getSelectedIndex());
        this.paperMargin = (float)(this.numberFieldPaperMargin.getValue() / d);
        this.numberFieldPaperMargin_setValue();
        this.simulateOutput();
    }

    private void numberFieldPaperMargin_setValue() {
        double d = this.listPaperMarginUnit.get(this.choicePaperMarginUnit.getSelectedIndex());
        this.numberFieldPaperMargin.setValue((double)this.paperMargin * d);
    }

    private void choicePaperMarginUnit_add(String string, double d) {
        this.choicePaperMarginUnit.add(string);
        this.listPaperMarginUnit.add(d);
    }

    private void choicePaperMarginUnit_initialize() {
        this.choicePaperMarginUnit.removeAll();
        this.listPaperMarginUnit.clear();
        this.choicePaperMarginUnit_add(Lib.getMessage("Str.MM"), Lib.UNIT_POINT_MM);
        this.choicePaperMarginUnit_add(Lib.getMessage("Str.CM"), Lib.UNIT_POINT_CM);
        this.choicePaperMarginUnit_add(Lib.getMessage("Str.M"), Lib.UNIT_POINT_M);
        this.choicePaperMarginUnit_add(Lib.getMessage("Str.Inch"), Lib.UNIT_POINT_INCH);
        this.choicePaperMarginUnit_add(Lib.getMessage("Str.Point"), 1.0);
    }

    private void choicePaperMarginUnit_itemStateChanged() {
        this.numberFieldPaperMargin_setValue();
    }

    private void checkboxPaperRotate_itemStateChanged() {
        boolean bl = this.checkboxPaperRotate.getState();
        if (this.paperRotated != bl) {
            float f = this.paperWidth;
            this.paperWidth = this.paperHeight;
            this.paperHeight = f;
            this.paperRotated = bl;
            this.numberFieldPaperSize_setValue();
            this.simulateOutput();
        }
    }

    private void buttonPaperOptimize_actionPerformed() {
        this.optimizePaperRotated();
    }

    private void buttonOutput_actionPerformed() {
        this.outputPdf();
    }

    private void numberField_initialize(NumberField numberField) {
        numberField.setColumns(7);
        numberField.setDisplayDigit(2);
        numberField.setUnitIncrement(0.1);
    }

    private void mainFrame_initializeComponents() {
        this.setTitle(Lib.getMessage("App.LowerTitle"));
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.dispose();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                MainFrame.this.buttonOutput.requestFocus();
            }
        });
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu(Lib.getMessage(Lib.getOS() == 0 ? "menuFile.Label.Win" : (Lib.getOS() == 1 ? "menuFile.Label.Mac" : "menuFile.Label")));
        MenuItem menuItem = new MenuItem(Lib.getMessage(Lib.getOS() == 0 ? "menuItemNewWindow.Label.Win" : (Lib.getOS() == 1 ? "menuItemNewWindow.Label.Mac" : "menuItemNewWindow.Label")));
        menuItem.setShortcut(new MenuShortcut(78, false));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.menuItemNewWindow_actionPerformed();
            }
        });
        MenuItem menuItem2 = new MenuItem(Lib.getMessage(Lib.getOS() == 0 ? "menuItemOpenFile.Label.Win" : (Lib.getOS() == 1 ? "menuItemOpenFile.Label.Mac" : "menuItemOpenFile.Label")) + "...");
        menuItem2.setShortcut(new MenuShortcut(79, false));
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.menuItemOpenFile_actionPerformed();
            }
        });
        MenuItem menuItem3 = new MenuItem(Lib.getMessage(Lib.getOS() == 0 ? "menuItemCloseWindow.Label.Win" : (Lib.getOS() == 1 ? "menuItemCloseWindow.Label.Mac" : "menuItemCloseWindow.Label")));
        menuItem3.setShortcut(new MenuShortcut(87, false));
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.menuItemCloseWindow_actionPerformed();
            }
        });
        MenuItem menuItem4 = new MenuItem(Lib.getMessage(Lib.getOS() == 0 ? "menuItemOutput.Label.Win" : (Lib.getOS() == 1 ? "menuItemOutput.Label.Mac" : "menuItemOutput.Label")));
        menuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.menuItemOutput_actionPerformed();
            }
        });
        MenuItem menuItem5 = new MenuItem(Lib.getMessage(Lib.getOS() == 0 ? "menuItemExit.Label.Win" : (Lib.getOS() == 1 ? "menuItemExit.Label.Mac" : "menuItemExit.Label")));
        menuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.menuItemExit_actionPerformed();
            }
        });
        this.labelSrcFile = new Label();
        this.labelSrcFile.setText(Lib.getMessage("labelSrcFile.Text"));
        this.textFieldSrcFileName = new TextField();
        this.textFieldSrcFileName.setEditable(false);
        this.textFieldSrcFileName.setColumns(50);
        this.labelSrcFileType = new Label();
        this.buttonSrcFileChange = new Button();
        this.buttonSrcFileChange.setLabel(Lib.getMessage("buttonSrcFileChange.Label") + "...");
        this.buttonSrcFileChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.buttonSrcFileChange_actionPerformed();
            }
        });
        this.labelSrcPageNum = new Label();
        this.labelSrcPageNum.setText(Lib.getMessage("labelSrcPageNum.Text"));
        this.choiceSrcPageNum = new Choice();
        this.choiceSrcPageNum.setEnabled(false);
        this.choiceSrcPageNum.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.choiceSrcPageNum_itemStateChanged();
            }
        });
        this.labelSrcImageSize = new Label();
        this.labelSrcImageSize.setText(Lib.getMessage("labelSrcImageSize.Text"));
        this.numberFieldSrcImageWidth = new NumberField();
        this.numberField_initialize(this.numberFieldSrcImageWidth);
        this.numberFieldSrcImageWidth.setEnabled(false);
        this.numberFieldSrcImageHeight = new NumberField();
        this.numberField_initialize(this.numberFieldSrcImageHeight);
        this.numberFieldSrcImageHeight.setEnabled(false);
        this.choiceSrcImageSizeUnit = new Choice();
        this.choiceSrcImageSizeUnit.setEnabled(false);
        this.choiceSrcImageSizeUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.choiceSrcImageSizeUnit_itemStateChanged();
            }
        });
        this.labelSrcRect = new Label();
        this.labelSrcRect.setText(Lib.getMessage("labelSrcRect.Text"));
        this.checkboxSrcRectWholeOfPage = new Checkbox();
        this.checkboxSrcRectWholeOfPage.setLabel(Lib.getMessage("checkboxSrcRectWholeOfPage.Label"));
        this.checkboxSrcRectWholeOfPage.setEnabled(false);
        this.checkboxSrcRectWholeOfPage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.checkboxSrcRectWholeOfPage_itemStateChanged();
            }
        });
        this.numberFieldSrcLeft = new NumberField();
        this.numberField_initialize(this.numberFieldSrcLeft);
        this.numberFieldSrcLeft.setEnabled(false);
        this.numberFieldSrcLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldSrcRect_actionPerformed(actionEvent.getSource());
            }
        });
        this.numberFieldSrcBottom = new NumberField();
        this.numberField_initialize(this.numberFieldSrcBottom);
        this.numberFieldSrcBottom.setEnabled(false);
        this.numberFieldSrcBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldSrcRect_actionPerformed(actionEvent.getSource());
            }
        });
        this.numberFieldSrcRight = new NumberField();
        this.numberField_initialize(this.numberFieldSrcRight);
        this.numberFieldSrcRight.setEnabled(false);
        this.numberFieldSrcRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldSrcRect_actionPerformed(actionEvent.getSource());
            }
        });
        this.numberFieldSrcTop = new NumberField();
        this.numberField_initialize(this.numberFieldSrcTop);
        this.numberFieldSrcTop.setEnabled(false);
        this.numberFieldSrcTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldSrcRect_actionPerformed(actionEvent.getSource());
            }
        });
        this.choiceSrcRectUnit = new Choice();
        this.choiceSrcRectUnit.setEnabled(false);
        this.choiceSrcRectUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.choiceSrcRectUnit_itemStateChanged();
            }
        });
        this.labelPosterSize = new Label();
        this.labelPosterSize.setText(Lib.getMessage("labelPosterSize.Text"));
        this.choicePosterSize = new Choice();
        this.choicePosterSize_initialize();
        this.choicePosterSize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.choicePosterSize_itemStateChanged();
            }
        });
        this.numberFieldPosterWidth = new NumberField();
        this.numberField_initialize(this.numberFieldPosterWidth);
        this.numberFieldPosterWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldPosterSize_actionPerformed(actionEvent.getSource());
            }
        });
        this.numberFieldPosterHeight = new NumberField();
        this.numberField_initialize(this.numberFieldPosterHeight);
        this.numberFieldPosterHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldPosterSize_actionPerformed(actionEvent.getSource());
            }
        });
        this.choicePosterSizeUnit = new Choice();
        this.choicePosterSizeUnit_initialize();
        this.choicePosterSizeUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.choicePosterSizeUnit_itemStateChanged();
            }
        });
        this.checkboxPosterSizeKeepAspectRatio = new Checkbox();
        this.checkboxPosterSizeKeepAspectRatio.setLabel(Lib.getMessage("checkboxPosterSizeKeepAspectRatio.Label"));
        this.checkboxPosterSizeKeepAspectRatio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.checkboxPosterSizeKeepAspectRatio_itemStateChanged();
            }
        });
        this.labelPaperSize = new Label();
        this.labelPaperSize.setText(Lib.getMessage("labelPaperSize.Text"));
        this.choicePaperSize = new Choice();
        this.choicePaperSize_initialize();
        this.choicePaperSize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.choicePaperSize_itemStateChanged();
            }
        });
        this.numberFieldPaperWidth = new NumberField();
        this.numberField_initialize(this.numberFieldPaperWidth);
        this.numberFieldPaperWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldPaperSize_actionPerformed(actionEvent.getSource());
            }
        });
        this.numberFieldPaperHeight = new NumberField();
        this.numberField_initialize(this.numberFieldPaperHeight);
        this.numberFieldPaperHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldPaperSize_actionPerformed(actionEvent.getSource());
            }
        });
        this.choicePaperSizeUnit = new Choice();
        this.choicePaperSizeUnit_initialize();
        this.choicePaperSizeUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.choicePaperSizeUnit_itemStateChanged();
            }
        });
        this.labelPaperMargin = new Label();
        this.labelPaperMargin.setText(Lib.getMessage("labelPaperMargin.Text"));
        this.numberFieldPaperMargin = new NumberField();
        this.numberField_initialize(this.numberFieldPaperMargin);
        this.numberFieldPaperMargin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.numberFieldPaperMargin_actionPerformed(actionEvent.getSource());
            }
        });
        this.choicePaperMarginUnit = new Choice();
        this.choicePaperMarginUnit_initialize();
        this.choicePaperMarginUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.choicePaperMarginUnit_itemStateChanged();
            }
        });
        this.checkboxPaperRotate = new Checkbox();
        this.checkboxPaperRotate.setLabel(Lib.getMessage("checkboxPaperRotate.Label"));
        this.checkboxPaperRotate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MainFrame.this.checkboxPaperRotate_itemStateChanged();
            }
        });
        this.buttonPaperOptimize = new Button();
        this.buttonPaperOptimize.setLabel(Lib.getMessage("buttonPaperOptimize.Label"));
        this.buttonPaperOptimize.setEnabled(false);
        this.buttonPaperOptimize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.buttonPaperOptimize_actionPerformed();
            }
        });
        this.labelPreview = new Label();
        this.labelPreview.setText(Lib.getMessage("labelPreview.Text"));
        this.labelOutputPaperCount = new Label();
        this.labelOutputPaperCount.setText(Lib.getMessage("labelOutputPaperCount.Text"));
        this.numberFieldOutputPaperCount = new NumberField();
        this.numberFieldOutputPaperCount.setColumns(7);
        this.numberFieldOutputPaperCount.setDisplayDigit(0);
        this.numberFieldOutputPaperCount.setEditable(false);
        this.canvasPreview = new CanvasPreview();
        this.canvasPreview.setMaximumSize(new Dimension(500, 400));
        this.canvasPreview.setMinimumSize(new Dimension(0, 0));
        this.canvasPreview.setPreferredSize(new Dimension(500, 200));
        this.labelOutputFileName = new Label();
        this.labelOutputFileName.setText(Lib.getMessage("labelOutputFileName.Text"));
        this.textFieldOutputFileName = new TextField();
        this.textFieldOutputFileName.setColumns(40);
        this.labelMessage = new Label();
        this.buttonOutput = new Button();
        this.buttonOutput.setLabel(Lib.getMessage("buttonOutput.Label"));
        this.buttonOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.buttonOutput_actionPerformed();
            }
        });
        if (Lib.getOS() == 1) {
            menu.add(menuItem);
            menu.add(menuItem2);
            menu.addSeparator();
            menu.add(menuItem3);
            menu.add(menuItem4);
        } else {
            menu.add(menuItem);
            menu.add(menuItem2);
            menu.add(menuItem3);
            menu.addSeparator();
            menu.add(menuItem4);
            menu.addSeparator();
            menu.add(menuItem5);
        }
        menuBar.add(menu);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.labelSrcFile);
        panel.add(this.textFieldSrcFileName);
        panel.add(this.labelSrcFileType);
        panel.add(this.buttonSrcFileChange);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0));
        panel2.add(this.labelSrcPageNum);
        panel2.add(this.choiceSrcPageNum);
        panel2.add(this.labelSrcImageSize);
        panel2.add(this.numberFieldSrcImageWidth);
        panel2.add(this.numberFieldSrcImageHeight);
        panel2.add(this.choiceSrcImageSizeUnit);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(0));
        panel3.add(this.labelSrcRect);
        panel3.add(this.checkboxSrcRectWholeOfPage);
        panel3.add(this.numberFieldSrcLeft);
        panel3.add(this.numberFieldSrcBottom);
        panel3.add(this.numberFieldSrcRight);
        panel3.add(this.numberFieldSrcTop);
        panel3.add(this.choiceSrcRectUnit);
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(0));
        panel4.add(this.labelPosterSize);
        panel4.add(this.choicePosterSize);
        panel4.add(this.numberFieldPosterWidth);
        panel4.add(this.numberFieldPosterHeight);
        panel4.add(this.choicePosterSizeUnit);
        panel4.add(this.checkboxPosterSizeKeepAspectRatio);
        Panel panel5 = new Panel();
        panel5.setLayout(new FlowLayout(0));
        panel5.add(this.labelPaperSize);
        panel5.add(this.choicePaperSize);
        panel5.add(this.numberFieldPaperWidth);
        panel5.add(this.numberFieldPaperHeight);
        panel5.add(this.choicePaperSizeUnit);
        panel5.add(this.labelPaperMargin);
        panel5.add(this.numberFieldPaperMargin);
        panel5.add(this.choicePaperMarginUnit);
        panel5.add(this.checkboxPaperRotate);
        panel5.add(this.buttonPaperOptimize);
        Panel panel6 = new Panel();
        panel6.setLayout(new FlowLayout(0));
        panel6.add(this.labelPreview);
        panel6.add(this.labelOutputPaperCount);
        panel6.add(this.numberFieldOutputPaperCount);
        Panel panel7 = new Panel();
        panel7.setLayout(new FlowLayout(0));
        panel7.add(this.labelOutputFileName);
        panel7.add(this.textFieldOutputFileName);
        Panel panel8 = new Panel();
        panel8.setLayout(new FlowLayout(2));
        panel8.add(this.labelMessage);
        panel8.add(this.buttonOutput);
        this.setLayout(new BoxLayout(this, 1));
        this.setMenuBar(menuBar);
        this.add(panel);
        this.add(panel2);
        this.add(panel3);
        this.add(panel4);
        this.add(panel5);
        this.add(panel6);
        this.add(this.canvasPreview);
        this.add(panel7);
        this.add(panel8);
    }

    private void mainFrame_initialize() {
        this.preferredPosterWidth = PaperSize.A1.getWidth();
        this.preferredPosterHeight = PaperSize.A1.getHeight();
        this.updatePosterSize();
        this.numberFieldPosterSize_setValue();
        this.choicePosterSize.select(this.choicePosterSize.getItemCount() - 1);
        this.choicePosterSize_itemStateChanged();
        this.checkboxPosterSizeKeepAspectRatio.setState(true);
        this.checkboxPosterSizeKeepAspectRatio_itemStateChanged();
        this.choicePaperSize.select(0);
        this.choicePaperSize_itemStateChanged();
        this.choicePaperSizeUnit.select(0);
        this.choicePaperSizeUnit_itemStateChanged();
        this.paperMargin = 72.0f;
        this.numberFieldPaperMargin_setValue();
        this.choicePaperMarginUnit.select(0);
        this.choicePaperMarginUnit_itemStateChanged();
        this.textFieldOutputFileName.setText(String.format("{pwd}%s%s_{input}_{date}.pdf", File.separator, Lib.getMessage("App.LowerTitle")));
        this.simulateOutput();
    }

    public MainFrame() {
        this.mainFrame_initializeComponents();
        this.mainFrame_initialize();
    }
}

