#!/usr/bin/perl

# --------------------------------------------------------
# ungroupSprites.cgi:
#      cgi for ungrouping sprite 
#  (tested under perl 5.8.4)
#
# This file is part of PositLog.
# --------------------------------------------------------

BEGIN{
		push(@INC, './extlib');
}
use strict;
use CGI qw(-debug :standard);
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogAuth;
use PositLogConfig;
use PositLogParam;
use JSON;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8'); # HTTP header

my $pageid = $CGI->param("pageid");
my $groupid = $CGI->param("groupid");

my $marginHashJSON = $CGI->param("margin");
my $marginHash = jsonToObj($marginHashJSON);

my $adjustedTopHashJSON = $CGI->param("adjustedTop");
my $adjustedTopHash = jsonToObj($adjustedTopHashJSON);

my $public_password = $CGI->param("public_password");
my $public_author = $CGI->param("public_author");

# Read temporal cookie
my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";

my $pages = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "pages.cgi")};
if($@){ warn "Cannot read " . $PositLogConfig::adminpath . "pages.cgi"; exit(0); }
my $authObj = new PositLogAuth($loginid, $loginpass, $pages);

my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")};
if($@){	print "Cannot read sprites.dat.\n"; exit(0); }

my $groupsHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/groups.dat")} or {};
if($groupsHash eq ""){
		print "Cannot open groups.dat\n";
		exit(0);
}

if($authObj->isAdminUser){
		$loginid = "admin";
}

# Check permission of sprite group
if($groupsHash->{$groupid}){
		my $author_id = $groupsHash->{$groupid}{"author_id"};

		if($author_id eq "public"){
				my $cryptpass = $groupsHash->{$groupid}{"public_password"};
				if($cryptpass ne "" && !$authObj->isAdminUser && !$authObj->isAuthor){
						my $salt="zi";
						my $cryptpass2 = crypt($public_password, $salt);
						if($cryptpass ne $cryptpass2){
								print "invalid_public_password\n";
								exit(0);
						}
				}
		}
		elsif($author_id ne $loginid && !$authObj->isAdminUser && !$authObj->isAuthor){
				print "Permission denied\n";
				exit(0);
		}
}
else{
		print "No such group\n";
		exit(0);
}


# Set adjustedTop
foreach my $id (keys %{$adjustedTopHash}){
		my $item;
		if($id =~ /^spr/){
				$item = $spritesHash->{$id};
		}
		elsif($id =~ /^grp/){
				$item = $groupsHash->{$id};
		}
		$item->{"top"} = $adjustedTopHash->{$id};
}

foreach my $id (keys %{$marginHash}){
		my $item;
		if($id =~ /^spr/){
				$item = $spritesHash->{$id};
		}
		elsif($id =~ /^grp/){
				$item = $groupsHash->{$id};
		}

		if($marginHash->{$id} eq ""){
				delete $item->{"margin_s"};
		}
		else{
				$item->{"margin_s"}{"elder"} = $marginHash->{$id}{"elder"};
				$item->{"margin_s"}{"pixel"} = $marginHash->{$id}{"pixel"};
				$item->{"margin_s"}{"position"} = $marginHash->{$id}{"position"};
		}
}


delete $groupsHash->{$groupid};

# Change modified time
my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $time = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
$pages->{$pageid}{"modified_time"} = $time;

# Save groups.dat
if(!eval{Storable::lock_nstore $groupsHash, $PositLogConfig::datapath . $pageid . "/groups.dat"}){
		print "Cannot write groups.dat.\n";	exit(0);
}

if (!eval{Storable::lock_nstore $pages, $PositLogConfig::adminpath . "pages.cgi"}){
		warn "Cannot write " . $PositLogConfig::adminpath . "pages.cgi";
		exit(0);
}

print "succeed\n";

