#!/usr/bin/perl

# --------------------------------------------------------
# convertOldDrawings.cgi:
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006-2007 Hidekazu Kubota All right reserved
#  <hidekaz@positlog.org> 
#  http://positlog.org/
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------

use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;
use PositLogParam;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8');

my $pid  = $CGI->param("pageid");

if($pid ne ""){

		my $spritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/sprites.dat")} or {};
		if ($spritesHash eq "") {
				print "Cannot read sprites.dat in $pid .<br>\n";
				exit(0);
		}

		foreach my $sid (keys %{$spritesHash}){
				my $spriteContents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/static/" . $sid .".spr")} or "";
				if($$spriteContents =~ s/>(draw\(.+?\);)/>\n<!--\nPLG.$1\n\/\/ -->\n/){
						if(!eval{Storable::lock_nstore $spriteContents, $PositLogConfig::datapath . $pid . "/static/" . $sid . ".spr"}){ warn "Cannot write " . $sid . ".spr.\n"; exit(0); }
				}
		}

my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<title>Convert old drawings which were created on PositLog 0.5beta.</title>\n
	</head>\n";
    
    my $BODY = "<body>\n
  <h1>Convert old drawings which were created on PositLog 0.5beta </h1>\n
  <p>
  Succeeded! 
  </p>
  <p>
  <a href='./admintools/admin.html'>Go to admin page.</a>
  </p>
</body>\n";
    my $FOOTER = "</html>";
    print $HEADER . $BODY . $FOOTER;
}
else{
    my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<title>Convert old drawings which were created on PositLog 0.5beta.</title>\n
	</head>\n";
    
    my $BODY = "<body>\n
  <h1>Convert old drawings which were created on PositLog 0.5beta </h1>\n
<p>
PositLog0.5ベータバージョン上で描かれた絵を，PositLog0.6用の形式へ変換します．<br>
対象のページIDを入力して，Convert! ボタンを押してください．
</p>
  <form action='convertOldDrawings.cgi' method='post'>\n
    <input type='text' name='pageid' id='pageid'>\n
    <input type='submit' id='submitbtn' value='Convert!' tabindex='1'>\n
  </form>\n
</body>\n";
    my $FOOTER = "</html>";
    print $HEADER . $BODY . $FOOTER;
}

