package PositLogPlugin::RecentSpritesLite::RecentSpritesLite;

# --------------------------------------------------------
# RecentSpritesLite.pm:
#      module for listing recent sprites
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006-2007 Hidekazu Kubota All right reserved
#  <hidekaz@positlog.org> 
#  http://positlog.org/
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------

use strict;
use Storable qw(lock_retrieve lock_nstore);
use PositLogConfig;

sub getCSS{
	return "";
}

sub clearCache{
    return "No cache.";
}

sub getSprites{
		my ($self, $sourceID, $argsptr, $templateptr) = @_;

		my %result;

		my $args = $$argsptr;
		my $template = $$templateptr;

		my $srcpageid = $self->{srcpageid};
		my $dstpageid = $self->{dstpageid};

    my @argsArray = split(/,/, $args);
    my $maxnumber = 10;
		if (scalar(@argsArray) >= 1) {
				$maxnumber = $argsArray[0];
		}
    my $maxlength = 30;
		if (scalar(@argsArray) >= 2) {
				$maxlength = $argsArray[1];
		}

    my %timeSpriteid = ();

		my $users = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "users.cgi")};
		if($@){
				$result{"error"} = "RecentSpritesLite.pm: Cannot read " . $PositLogConfig::adminpath . "users.cgi"; 
				$result{"modified"} = -1;
				return \%result;
		}

		my $spritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $dstpageid . "/sprites.dat")};
		if($@){
				$result{"error"} = "RecentSpritesLite.pm: Cannot read " . $dstpageid . "/sprites.dat";
				$result{"modified"} = -1;
				return \%result;
		}

		my $newContents = "";
		$newContents .= "<div class='recentspritelite_contents'>\n<ol>\n";
		my $counter = 0;

    for my $sid (sort { ($spritesHash->{$b}->{"created_time"}) <=> ($spritesHash->{$a}->{"created_time"}) } (keys %$spritesHash)){
				if($sid eq $sourceID){
						next;
				}
				my $tmpdate = $spritesHash->{$sid}{"created_time"};
				$tmpdate =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/i;
				my $modifiedTime = "$1/$2/$3&nbsp;&nbsp;$4:$5:$6";

				my $author_id = $spritesHash->{$sid}{"author_id"};
				my $public_author = $spritesHash->{$sid}{"public_author"};
				my $public_password = $spritesHash->{$sid}{"public_password"};

				my $authorName = "";
				if($author_id eq "admin"){
						$authorName .= "admin";
				}
				else{
						if($author_id eq "public"){
								if($public_password eq ""){
										if($public_author eq "" || $public_author eq "public"){
												$authorName .= "[public]";
										}
										else{
												utf8::decode($public_author);
												$authorName .= '[' . $public_author . ']';
										}
								}
								else{
										if($public_author eq "" || $public_author eq "public"){
												$authorName .= "&lt;public&gt;";
										}
										else{
												utf8::decode($public_author);
												$authorName .= '&lt;' . $public_author . '&gt;';
										}
								}

						}
						else{
								$authorName .= $users->{$author_id}{"nickname"};
								utf8::decode($authorName)
						}
				}

				my $singleContents = "no contents";
				my $contents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $dstpageid . "/static/" . $sid . ".spr")} or "";
				if($contents ne ""){
						$singleContents = $$contents;
				}
				utf8::decode($singleContents);

				my $replaceStr = "";
				if($sid =~ /_link$/i){
						$replaceStr = "(Arrow)";
				}
				elsif($singleContents =~ /^<canvas/i){
						$replaceStr = "(Drawing)";
				}
				elsif($singleContents =~ /<img/i){
						if($singleContents =~ /alt\s*?=['"]['"]/i){
								if($singleContents =~ /src\s*?=['"].*\/(.+?)['"]/i){
										$replaceStr = $1 . "&nbsp;(Image)";
								}
								else{
										$replaceStr = "(Image)";
								}
						}
						elsif($singleContents =~ /alt\s*?=['"](.+?)['"]/i){
								$replaceStr = $1 . "&nbsp;(Image)";
						}
						elsif($singleContents =~ /src\s*?=['"].*\/(.+?)['"]/i){
								$replaceStr = $1 . "&nbsp;(Image)";
						}
						else{
								$replaceStr = "(Image)";
						}
				}
				$singleContents =~ s/<\/p>/&nbsp;/gis;
				$singleContents =~ s/<.+?>//gis;
				$singleContents =~ s/[\n\r]//gis;
				$singleContents = substr($singleContents, 0, $maxlength);

				my $tryContents = $singleContents;
				$tryContents =~ s/&nbsp;//gis;
				if($tryContents eq ""){
						$singleContents = $replaceStr;
				}

				$newContents .= "<li class='recentspritelite_line'><div class='header'>" . "<a href='#id_" . $sid . "'>" . $modifiedTime . "&nbsp;&nbsp;&nbsp;&nbsp;" . $authorName . "</a></div><div class='contents'>" . $singleContents . "</div></li>\n";

				$counter ++;
				if($counter >= $maxnumber){
						last;
				}
		}
		$newContents .= "\n</ol></div>";

		$template =~ s/\[\[plugin\]\]/$newContents/;

		if(!eval{Storable::lock_nstore \$template, $PositLogConfig::datapath . $srcpageid . "/static/" . $sourceID.".spr"}) {
				$result{"error"} = "RecentSpritesLite.pm: Cannot write " . $srcpageid . "/static/" . $sourceID .  ".spr";
				$result{"modified"} = -1;
				return \%result;
		}

		$result{"error"} = "";
		$result{"modified"} = -1;
		return \%result;
}

1;
