#!/usr/local/bin/perl

# --------------------------------------------------------
#
# deleteSprite.cgi:
#      cgi for deleting Sprite
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve);			# is default library (upper perl 5.8)
use JSON;
use PositLogConfig;
use PositLogAuth;
use PositLogGroup;
use PositLogParam;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8'); # HTTP header

my $public_password = $CGI->param("public_password");
my $pageid = $CGI->param("pageid");

my $spriteID = $CGI->param("id");

my $groupingCommand = $CGI->param("grouping");
my $marginCommand = $CGI->param("margin");

my $stories = $CGI->param("stories");
my $storiesHash = jsonToObj($stories);


# Read temporal cookie
my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";

PositLogAuth::authenticateUser($loginid, $loginpass);
PositLogAuth::authenticateCreatePage($loginid, $pageid);


my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")} or {};
if($spritesHash eq ""){ print "Cannot read sprites.dat."; exit(0); }

if(!$spritesHash->{$spriteID}){
		print "Permission denied.";
		exit(0);
}

if($spritesHash->{$spriteID}{"type"} eq "dynamic"){
		print "Permission denied.";
		exit(0);
}

if($spritesHash->{$spriteID}{"author_id"} eq "public")
{
	my $cryptpass = $spritesHash->{$spriteID}{"public_password"};
	if($cryptpass ne "" && !PositLogAuth::isAdminUser)
	{
		my $salt="zi";
		my $cryptpass2 = crypt($public_password, $salt);
		if($cryptpass ne $cryptpass2)
		{
			print "invalid_public_password";
			exit(0);
		}
	}
}
elsif($spritesHash->{$spriteID}{"author_id"} ne $loginid 
      && !PositLogAuth::isPageCreator
      && !PositLogAuth::isAdminUser)
{
	print "Permission denied.";
	exit(0);
}

if($groupingCommand ne ""){
#		warn "GroupingCommand:". $groupingCommand;
		my @commandList = split(/;/, $groupingCommand);
		PositLogGroup::group($spritesHash, \@commandList);
}

#set margin
if($marginCommand ne ""){
		my @marginList = split(/;/, $marginCommand);
		foreach my $margin (@marginList){
				$margin =~ /^(\w*?),(\w*?),(.*?),(\w*?),(.*?),(\w*?)$/;
				if(!$spritesHash->{$1}){
						next;
				}
				if($2 ne "" && $3 ne "" && $4 eq "" && $5 eq "" && $6 eq ""){
						$spritesHash->{$1}{"margin_p"}{"position"} = $2;
						$spritesHash->{$1}{"margin_p"}{"pixel"} = $3;
				}
				elsif($2 eq "" && $3 eq ""){
						if($4 ne "" && $5 ne "" && $6 ne ""){
								$spritesHash->{$1}{"margin_s"}{"elder"} = $4;
								$spritesHash->{$1}{"margin_s"}{"pixel"} = $5;
								$spritesHash->{$1}{"margin_s"}{"position"} = $6;
						}
						else{
								delete$spritesHash->{$1}{"margin_s"};
						}
				}
		}
}


# set stories
foreach my $tmpid (keys %$storiesHash){
		$spritesHash->{$tmpid}{"story"}{"prev"} = $storiesHash->{$tmpid}{"prev"};
		$spritesHash->{$tmpid}{"story"}{"next"} = $storiesHash->{$tmpid}{"next"};
		$spritesHash->{$tmpid}{"story"}{"margin"} = $storiesHash->{$tmpid}{"margin"};
}


my $mes = "succeed";
#unlink $PositLogConfig::datapath . $pageid . "/static/" . $spriteID.".spr" or $mes = "cannot delete! $spriteID.spr";
unlink $PositLogConfig::datapath . $pageid . "/static/" . $spriteID.".spr";

delete $spritesHash->{$spriteID};
if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"}){ print "Cannot write the sprite list."; exit(0); }

# change modified time
my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};

$configHash->{"version"} = $PositLogParam::version;

if($configHash eq ""){ print "Cannot read the page configuration.";	exit(0); }
my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $time = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
$configHash->{"modified_time"} = $time;
if(!eval{Storable::lock_nstore $configHash, $PositLogConfig::datapath . $pageid . "/config.dat"}){ print "Cannot write the page configuration."; exit(0); }

print $mes;

