package PositLogAuth;

use strict;
use PositLogConfig;
use Storable qw(lock_retrieve lock_nstore);

my $errormsg = "";
# authentication for user
my $adminUser = 0;
my $validUser = 0;
my $publicUser = 0;

# authentication for page
my $pageCreator = 0;

my $canCreatePageFlag = 0;
my $canReadPageFlag = 0;

sub getErrorMsg
{
    return $errormsg;
}

sub isAdminUser
{
    return scalar($adminUser);
}

sub isValidUser
{
    return scalar($validUser);
}

sub isPublicUser
{
    return scalar($publicUser);
}

sub isPageCreator
{
    return scalar($pageCreator);
}


sub canCreatePage
{
    return scalar($canCreatePageFlag);
}

sub canReadPage
{
		return scalar($canReadPageFlag);
}


sub authenticateCreatePage
{
		# authenticateUser should be executed before authenticateCreatePage

    my ($loginid, $pageid) = @_;

		if(scalar($adminUser) == 1){
				$canCreatePageFlag = 1;
				return;
		}

    my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
    if($configHash eq ""){ 
				$errormsg = "Cannot read config.dat.";
    }

    if($configHash->{"author_id"} eq $loginid){
				$pageCreator = 1;
				$canCreatePageFlag = 1;
				return;
    }

    my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};

		if(scalar($permissionHash->{"create_page"}{$loginid}) == 1){
				$canCreatePageFlag = 1;
				return;
		}
		else{
				foreach my $usergroupname (keys %{$permissionHash->{"create_page_group"}}){
						my $usergroupnameenc = $usergroupname;
						$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
						$usergroupnameenc =~ tr/ /+/;
						my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
						if(scalar($UserList->{$loginid}) == 1){
								$canCreatePageFlag = 1;
								return;
						}
				}
		}

		if($loginid eq ""){
				$loginid = "public";
		}

}


sub authenticateReadPage{
		# authenticateUser should be executed before authenticateReadPage
		
		my ($pageid, $loginid) = @_;

    $canReadPageFlag = 0;
    my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")} or {};

		if(scalar($adminUser) == 1){
				$canReadPageFlag = 1;
    } elsif (scalar($permissionHash->{"read_page"}{"public"}) == 1) {
				$canReadPageFlag = 1;
    } else {
				# check user list
				if (scalar($permissionHash->{"read_page"}{$loginid}) == 1) {
						$canReadPageFlag = 1;
				} else {
						# check user group list
						foreach my $usergroupname (keys %{$permissionHash->{"read_page_group"}}) {
								my $usergroupnameenc = $usergroupname;
								$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
								$usergroupnameenc =~ tr/ /+/;
								
								my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
								if ($UserList eq "") {
										print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0);
								}
								;
								if (scalar($UserList->{$loginid}) == 1) {
										$canReadPageFlag = 1;
								}
						}
				}
    }
}


sub authenticateUser
{
    my ($loginid, $loginpass) = @_;

    my $usernameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
    my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};

    if($loginid eq "public"){
				$adminUser = 0;
				$validUser = 0;
				$publicUser = 1;
    }
    elsif($adminnameAuth ne "" && $adminnameAuth->{$loginid}){
				my $cryptpass = $adminnameAuth->{$loginid}{"password"};
				my $salt="lc";
				my $cryptpass2 = crypt($loginpass, $salt);
				if($cryptpass eq $cryptpass2){
						$validUser = 1;
						$adminUser = 1;
						$publicUser = 0;
        }
				else{
						$errormsg = "Permission denied.";
        }
    }
    elsif($usernameAuth ne "" && $usernameAuth->{$loginid}){
				my $cryptpass = $usernameAuth->{$loginid}{"password"};
				my $salt="ry";
				my $cryptpass2 = crypt($loginpass, $salt);
				if($cryptpass eq $cryptpass2){
						$adminUser = 0;
						$validUser = 1;
						$publicUser = 0;
        }
				else{
						$errormsg = "Permission denied.";
        }
    }

}

1;
