package PositLogPlugin::RecentSpritesLite;

# --------------------------------------------------------
# RecentSpritesLite.pm:
#      module for showing recent sprites on the page
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

use strict;
use Time::Local;
use Storable qw(lock_retrieve lock_nstore);
use Encode qw/encode decode/;
use PositLogConfig;

my $serializedData = "recentspriteslite";

sub getWidth
{
	return 320;
}

sub getCSS
{
	return "";
}

sub getType
{
	return "replace";
}


sub clearCache
{
    return "No cache.";
}


sub getSprites
{
    my ($pageid, $sourceID, $loginid, $loginpass, $args) = @_;
    my @argsArray = split(/,/, $args);
    my $maxnumber = $argsArray[0];
    my $maxlength = $argsArray[1];

    my @spritesArray;
    my %timeSpriteid = ();

		my $spritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")};
		if($@){ warn $@; print "Cannot read the sprite list.\n"; exit(0); }
		my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")};
		if($@){ warn $@; print "Cannot read the authentication file for users.<br>\n"; exit(0);}


		my $newContents = "";
		$newContents .= "<div class='recentspritelite_contents'>\n<ol>\n";
		my $counter = 0;


    my $urlSpriteid = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/dynamic/". $serializedData  . ".dat")} or {};
		my $spriteID = "";
    if (exists($urlSpriteid->{"recentspriteslite"})){ 
				$spriteID = $urlSpriteid->{"recentspriteslite"};
		}


    for my $sid (sort { ($spritesHash->{$b}->{"created_time"}) <=> ($spritesHash->{$a}->{"created_time"}) } (keys %$spritesHash))
		{
				if($sid eq $spriteID)
				{
						next;
				}
				my $tmpdate = $spritesHash->{$sid}{"created_time"};
				$tmpdate =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/i;
				my $modifiedTime = "$1/$2/$3&nbsp;&nbsp;$4:$5:$6";

				my $author_id = $spritesHash->{$sid}{"author_id"};
				my $public_author = $spritesHash->{$sid}{"public_author"};
				my $public_password = $spritesHash->{$sid}{"public_password"};

				my $authorName = "";
				if($author_id eq "admin")
				{
						$authorName .= "admin";
				}
				else
				{
						if($author_id eq "public")
						{
								if($public_password eq "")
								{
										if($public_author eq "" || $public_author eq "public")
										{
												$authorName .= "[public]";
										}
										else
										{
												$authorName .= '[' . $public_author . ']';
										}
								}
								else
								{
										if($public_author eq "" || $public_author eq "public")
										{
												$authorName .= "&lt;public&gt;";
										}
										else
										{
												$authorName .= '&lt;' . $public_author . '&gt;';
										}
								}

						}
						else
						{
								$authorName .= $useridAuth->{$author_id}{"nickname"};
						}
				}



				my $singleContents = "no contents";
				my $contents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/static/" . $sid . ".spr")} or "";
				if($contents ne "")
				{
						$singleContents = $$contents;
				}
				$singleContents =~ s/<.+?>//gis;
				$singleContents = decode("utf-8", $singleContents);
				$singleContents = substr($singleContents, 0, $maxlength);
				$singleContents = encode("utf-8", $singleContents);


				$newContents .= "<li class='recentspritelite_line'><div class='header'>" . "<a href='./positlog.cgi?load=" . $pageid . "&id=" . $sid . "'>" . $modifiedTime . "&nbsp;&nbsp;&nbsp;&nbsp;" . $authorName . "</a></div><div class='contents'>" . $singleContents . "</div></li>\n";

				$counter ++;
				if($counter >= $maxnumber)
				{
						last;
				}
		}
		$newContents .= "\n</ol></div>";


    my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
    my $modifiedtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);

		if($spriteID eq "")
		{
				do
				{
						my $rand = int (rand(1000));
						$rand = sprintf("%03d", $rand);
						# id must start from alphabet in HTML4.01
						$spriteID = "sprite_" . $modifiedtime . "_" . $rand;
				}while(exists($spritesHash->{$spriteID}));
		}
		# save sprite
		if(!eval{Storable::lock_nstore \$newContents, $PositLogConfig::datapath . $pageid . "/static/" . $spriteID.".spr"}) { print "Cannot write .spr."; return \@spritesArray; }

		push(@spritesArray, {"modified_date" =>$modifiedtime, "id" => $spriteID, "body" => $newContents});

		my %newUrlSpriteid;
		$newUrlSpriteid{"recentspriteslite"} = $spriteID;

    return \@spritesArray;
}

