package PositLogPlugin::RSSlayouter;

# --------------------------------------------------------
# RSSlayouter.pm:
#      module for retrieving PositLog dynamic sprites
#      from RSS1.0
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp>
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This perl module generate new srprites from RSS
# --------------------------------------------------------

use strict;
use HTTP::Lite;			# must be locally installed
use Time::Local;
use Storable qw(lock_retrieve lock_nstore);
use Encode qw/encode decode/;
use PositLogConfig;

# prefix of hash file (order, spriteID)

my $serializedData = "rl_order_spriteid_";

sub getWidth{
		return 150;
}

sub getCSS{
		return "rss_layouter_contents.css";
}

sub getType{
		return "create";
}

sub clearCache{
		my ($pageid, $sourceID, $args) = @_;
		my $orderSpriteid = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$sourceID.".dat")} or {};
		if ($orderSpriteid eq "") {
				return "No cache."
		}
		delete $orderSpriteid->{"modified_time"};
		delete $orderSpriteid->{"rss"};

		if (!eval{Storable::lock_nstore $orderSpriteid, $PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$sourceID.".dat";}) {
				return "Save error.";
		}
		return "Succeed.";
}

sub getSprites{
		# get (URL of RSS)
		my ($pageid, $sourceID, $loginid, $loginpass, $args) = @_;
		my @argsArray = split(/,/, $args);
		my @spritesArray;
		my $rssurl = $argsArray[0];
		my $spritecolor = "#ffc0b0";
		my $maxcount = -1;
		my $maxlength = -1;
		my $titleonly = 0;

		if (scalar(@argsArray) >= 2) {
				$spritecolor = $argsArray[1];
		}
		if (scalar(@argsArray) >= 3) {
				$maxcount = $argsArray[2];
		}
		if (scalar(@argsArray) >= 4) {
				$maxlength = $argsArray[3];
		}
		if (scalar(@argsArray) >= 5) {
				$titleonly = $argsArray[4];
		}

		if ($rssurl eq "" || $rssurl !~ /^http/) {
				return \@spritesArray;
		}

		my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")};

		if ($@) {
				warn $@; return \@spritesArray;
		}

		# retrieve rss file
		# success flag for retrieving RSS
		my $httpsuccess = 1;

		# get dynamic sprite table
		my $orderSpriteid = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$sourceID.".dat")} or {};

		if((-e $PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$sourceID.".dat") && !defined($orderSpriteid)){
				warn "RSSlayouter.pm:Can't lock_retrieve\n";
				return \@spritesArray;
		}

		# rss file
		my $rssstr = "";
		my $cache = 0;
		# Check HTTP Status code 304

		if (exists($orderSpriteid->{"modified_time"})) {
				my $modifiedtime = $orderSpriteid->{"modified_time"};
				$modifiedtime =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/;
				my $sec = $6;	my $min = $5; 	my $hour = $4; 	my $mday = $3; 	my $mon = $2; 	my $year = $1;
				my $modifiedtimeStr = $year . "/" . $mon . "/" . $mday . " " . $hour . ":" . $min . ":" . $sec;
				$sec =~ s/0(\d)/$1/;
				$min =~ s/0(\d)/$1/;
				$hour =~ s/0(\d)/$1/;
				$mday =~ s/0(\d)/$1/;
				$mon =~ s/0(\d)/$1/;
				my $time = timelocal(scalar($sec), scalar($min), scalar($hour), scalar($mday), scalar($mon) - 1, scalar($year));
				my @DoW = qw(Sun Mon Tue Wed Thu Fri Sat);
				my @MoY = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
				my %MonHash = ("Jan" => 1, "Feb" => 2, "Mar" => 3, "Apr" => 4, "May" => 5, "Jun" => 6, "Jul" => 7,  "Aug" => 8,  "Sep" => 9, "Oct" => 10,  "Nov" => 11, "Dec" => 12);
				my ($sec, $min, $hour, $mday, $mon, $year, $wday) = gmtime($time);
				my $modifiedHTTPdate = sprintf("%s, %02d %s %04d %02d:%02d:%02d GMT",
																			 $DoW[$wday],
																			 $mday, $MoY[$mon], $year+1900,
																			 $hour, $min, $sec);
				my $http = new HTTP::Lite;
				$http->add_req_header('If-Modified-Since', $modifiedHTTPdate);

				# HEAD request

				$http->method('GET');
				my $req = $http->request($rssurl) or $httpsuccess = 0;
				if ($httpsuccess == 0) {
						warn "RSSlayouter.pm: HTTP request error!\n";
						return \@spritesArray;
				}

				# check Not Modified
				# check Not Modified or Serve error
				if ($req =~ /304/gi || $req =~ /50\d/gi) {
						# load cached rss
						$cache = 1;
						$rssstr = $orderSpriteid->{"rss"};
				} else {
						$rssstr =  $http->body();
				}

				if ($rssstr eq "") {
						$cache = 0;
						$rssstr = $http->body();
				}
		} else {
				my $http = new HTTP::Lite;
				$http->method('GET');
				my $req = $http->request($rssurl) or $httpsuccess = 0;

				if ($httpsuccess == 0) {
						warn "RSSlayouter.pm: HTTP request error!\n";
						return \@spritesArray;
				}
				$rssstr =  $http->body();
		}

		my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
		my $currenttime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);

		my @itemArray;

		my $itemcounter = 1;

		foreach my $item ($rssstr =~ /<item[^s].*?<\/item>/gis) {
				$item =~ /<item rdf:about="(.*?)">/i;

				my $url = $1;

				$item =~ /<title>(.*?)<\/title>/i;
				my $title = $1;
				if (utf8::is_utf8($title)) {
						$title = encode("utf-8", $title);
				}
				if ($title =~ /^<!\[CDATA\[(.*?)\]\]>$/is) {
						$title = $1;
				}
				my $dateStr = $currenttime;

				if ($item =~ /<dc:date>(.*?)<\/dc:date>/i) {
						my $date = $1;

						# Thanks to Walrus-san!
						if ($date =~ /^(\d{4})(?:-(\d{2})(?:-(\d{2})(?:T(\d{2}):(\d{2})(?::(\d{2})(?:\.(\d))?)?(Z|([+-]\d{2}):(\d{2}))?)?)?)?$/) {

								my ($year, $month, $day, $hour, $min, $sec, $wday) = ($1, ($2 ? $2 : 1), ($3 ? $3 : 1), $4, $5, $6);

								my $now = time();
								my $offset = timegm(gmtime($now)) - timegm(localtime($now));

								$offset = $offset + (abs($8) * 60 + $9) * ($8 >= 0 ? 60 : -60) if($7);

								my $time = ($7) ? &Time::Local::timegm($sec, $min, $hour, $day, $month - 1, $year) - $offset
										: &Time::Local::timelocal($sec, $min, $hour, $day, $month - 1, $year) - $offset;
								($sec, $min, $hour, $day, $month, $year, $wday) = localtime($time);
								$wday = (qw(Sun Mon Tue Wed Thu Fri Sat))[$wday];
								$dateStr = sprintf('%04d%02d%02d%02d%02d%02d', $year + 1900, $month + 1, $day, $hour, $min, $sec);
						}
				}

				if ($item =~ /<pubDate>(.*?)<\/pubDate>/i) {
						my $date = $1;

						# Thanks to Walrus-san!
						my $pattern = '(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun), )?(\d{1,2}) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d{4}|\d{2}) (\d{2}):(\d{2})(?::(\d{2}))? (UT|GMT|[ECMP][SD]T|[ZAMNY]|[+-]\d{4})';
						my %monthes = qw(Jan 1 Feb 2 Mar 3 Apr 4 May 5 Jun 6 Jul 7 Aug 8 Sep 9 Oct 10 Nov 11 Dec 12);
						my %timezones = (
								UT=>'+0000', GMT=>'+0000', EST=>'-0500', EDT=>'-0400', CST=>'-0600', CDT=>'-0500', MST=>'-0700', MDT=>'-0600',
								PST=>'-0800', PDT=>'-0700', Z=>'+0000', A=>'-0100', M=>'-1200', N=>'+0100', Y=>'+1200'
								);
						$date =~ /$pattern/;
						my ($wday, $day, $month, $year, $hour, $min, $sec, $timezone) = ($1, $2, $3, $4, $5, $6, $7, $8);

						$year = ($year < 70) ? $year + 2000 : ($year < 1000) ? $year + 1900 : $year;
						$month = $monthes{$month};
						$timezone = ($timezone =~ /[A-Z]/) ? $timezones{$timezone} : $timezone;
						$timezone = ($timezone =~ /([+-])(\d{2})(\d{2})/) ? $1 . $2 * 3600 + $3 * 60 : 0;

						my $now = time();
						my $offset = scalar($timezone) - timegm(localtime($now)) + timegm(gmtime($now));

						my $time   = ($7) ? &Time::Local::timegm($sec, $min, $hour, $day, $month - 1, $year) - $offset
								: &Time::Local::timelocal($sec, $min, $hour, $day, $month - 1, $year) - $offset;
						my ($sec, $min, $hour, $day, $month, $year, $wday) = localtime($time);
						$wday = (qw(Sun Mon Tue Wed Thu Fri Sat))[$wday];
						$dateStr = sprintf('%04d%02d%02d%02d%02d%02d', $year + 1900, $month + 1, $day, $hour, $min, $sec);
				}

				$item =~ /<link>(.*?)<\/link>/i;
				my $link = $1;

				$item =~ /<description>(.*?)<\/description>/is;
				my $description = $1;
				if ($description =~ /^<!\[CDATA\[(.*?)\]\]>$/is) {
						$description = $1;
				}
				if ($description eq "") {
						next;
				}
				if (utf8::is_utf8($description)) {
						$description = encode("utf-8", $description);
				}
				$description = decode("utf-8", $description);

				if ($maxlength != -1) {
						$description =~ s/<.+?>//gis;
						$description = substr($description, 0, $maxlength);
				}
				$description = encode("utf-8", $description);

				my $contents = "<div class='rss_layouter_contents'><div class='title'><span class='counter'>$itemcounter" . ". </span><a href='$link'>$title</a></div>";
				if($titleonly == 0){
						$contents .= "\n<div class='description'>$description</div>";
				}
				$contents .= "</div>";

				push(@itemArray,{"date" => $dateStr, "contents" => $contents});

				$itemcounter ++;

				if ($maxcount != -1 && $itemcounter > $maxcount) {
						last;
				}
		}

		# generate new spriteID if antenna configuration is modified
		my %newOrderSpriteid;
		if (!$cache) {
				# change modified time
				my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
				my $modifiedtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
				$newOrderSpriteid{"modified_time"} = $modifiedtime;
				$newOrderSpriteid{"rss"} = $rssstr;
		}

		my $counter = 0;
		foreach my $item (@itemArray) {
				my $valueItem = $item->{"contents"};

				if ($orderSpriteid ne "" && exists($orderSpriteid->{$counter})) {
						# spriteID for the rss item already exists
						my $sid = $orderSpriteid->{$counter};

						push(@spritesArray, {"modified_date" => $item->{"date"}, "id" => $sid, "body" => $valueItem});

						# save sprite
						if (!$cache) {
								$spritesHash->{$sid}{"type"} = "dynamic";
								$spritesHash->{$sid}{"plugin_source"} = $sourceID;
#								if (!eval{Storable::lock_nstore \$valueItem, $PositLogConfig::datapath . $pageid . "/static/" . $sid.".spr"}) {
#										print "Cannot write .spr."; return \@spritesArray;
#								}
								$spritesHash->{$sid}{"modified_time"} = $item->{"date"};
								$newOrderSpriteid{$counter} = $sid;
						}
				} else {
						# generate new spriteID
						my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
						($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);

						my $createtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
						my $newSpriteID = "";

						do{
								my $rand = int (rand(1000));
								$rand = sprintf("%03d", $rand);
								# id must start from alphabet in HTML4.01
								$newSpriteID = "sprite_" . $createtime . "_" . $rand;
						}while (exists($spritesHash->{$newSpriteID}));

						push(@spritesArray, {"modified_date" => $item->{"date"}, "id" => $newSpriteID, "body" => $valueItem});

						if (!$cache) {
								$spritesHash->{$newSpriteID}{"type"} = "dynamic";
								$spritesHash->{$newSpriteID}{"plugin_source"} = $sourceID;
#								if (!eval{Storable::lock_nstore \$valueItem, $PositLogConfig::datapath . $pageid . "/static/" . $newSpriteID.".spr"}) {
#										print "Cannot write .spr."; return \@spritesArray;
#								}

								$spritesHash->{$newSpriteID}{"created_time"} = $createtime;
								$spritesHash->{$newSpriteID}{"modified_time"} = $item=>{"date"};
								$spritesHash->{$newSpriteID}{"style"} = "";
								$newOrderSpriteid{$counter} = $newSpriteID;
						}
				}
				$counter ++;

		}

		if (!$cache) {
				# save spriteHash
				if (!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"}) {
						print "Cannot write sprites.dat."; return \@spritesArray;
				}
				# store new serialized "RSS layouter hash (order, spriteID)"
				if (!eval{Storable::lock_nstore \%newOrderSpriteid, $PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$sourceID.".dat";}) {
						warn "RSSlayouter.pm: Cannot write hash data\n"; return "";
				}
		}

		# current number of sprites
		my $spriteCounter = 0;

		# color
		$spritecolor =~ /\s*\#(\w\w)(\w\w)(\w\w)/i;
		my $red = hex(scalar($1));
		my $green = hex(scalar($2));
		my $blue = hex(scalar($3));
		my $newColor = "#ffffff";

		# sorting ...
		my @sortedArray;
		foreach my $sprite (sort {$b->{"modified_date"} cmp $a->{"modified_date"}} @spritesArray) {
				# overwrite contents
				my $revisedContents = $sprite->{"body"};
				if ($spriteCounter == 0) {
						$newColor = "rgb($red, $green, $blue);";
				} elsif ($spriteCounter < 5) {
						my $newRed = scalar($red) + int((256-scalar($red))/5);
						my $newGreen = scalar($green) + int((256-scalar($green))/5);
						my $newBlue = scalar($blue) + int((256-scalar($blue))/5);
						$newColor = "rgb($newRed, $newGreen, $newBlue);";
				} elsif ($spriteCounter < 10) {
						my $newRed = scalar($red) + int((256-scalar($red))*2/5);
						my $newGreen = scalar($green) + int((256-scalar($green))*2/5);
						my $newBlue = scalar($blue) + int((256-scalar($blue))*2/5);
						$newColor = "rgb($newRed, $newGreen, $newBlue);";
				} elsif ($spriteCounter < 20) {
						my $newRed = scalar($red) + int((256-scalar($red))*3/5);
						my $newGreen = scalar($green) + int((256-scalar($green))*3/5);
						my $newBlue = scalar($blue) + int((256-scalar($blue))*3/5);
						$newColor = "rgb($newRed, $newGreen, $newBlue);";
				} elsif ($spriteCounter < 30) {
						my $newRed = scalar($red) + int((256-scalar($red))*4/5);
						my $newGreen = scalar($green) + int((256-scalar($green))*4/5);
						my $newBlue = scalar($blue) + int((256-scalar($blue))*4/5);
						$newColor = "rgb($newRed, $newGreen, $newBlue);";
				} else {
						$newColor = "#ffffff";
				}

				$revisedContents =~ s/^(<div.*?>)(.*)<\/div>$/$1<div class="frame" style="background-color: $newColor">$2<\/div><\/div>/is;

				$sprite->{"body"} = $revisedContents;

				if (!eval{Storable::lock_nstore \$revisedContents, $PositLogConfig::datapath . $pageid . "/static/" . $sprite->{"id"} . ".spr"}) {
						print "Cannot write .spr."; return \@spritesArray;
				}
				push(@sortedArray, $sprite);

				$spriteCounter++;
		}

		return \@sortedArray;
}

1;

