//-------------------------------------------------
// edit.js
//
// Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
//  taro@summer.nifty.jp  
//  http://positlog.storybook.jp/ 
//
// This file is part of PositLog.
// PositLog is distributed under the MIT License.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//-------------------------------------------------

//---------------------------
// Globals for edit.js
//---------------------------

EDT = new Object();

// Saving error.
// Go back to the original sprite!
EDT.orgInnerHtml = "";
EDT.orgLeft = 0;
EDT.orgTop = 0;
EDT.orgWidth = 0;
EDT.orgZindex = 0;

EDT.orgBorderWidth = "";
EDT.orgBorderStyle = "";
EDT.orgBorderColor = "";
EDT.orgBackgroundColor = "";
EDT.orgForegroundColor = "";
EDT.orgPadding = "";

EDT.originalShowLink = "";
EDT.originalShowDate = "";
EDT.originalShowAuthor = "";

EDT.originalAuthor = "";

EDT.orgSpritesHash = "";

// Frame Color
EDT.pickerTopOffset = 84;
EDT.frameColorDialogOpen = false;

// Bg Color
EDT.bgColorDialogOpen = false;

// Foreground(Text) Color
EDT.foreColorDialogOpen = false;

EDT.showAllRegionFlag = false;
EDT.showRegionFlag = false;
EDT.showGuideFlag = false;

EDT.spriteWidthMin = 42;
EDT.spriteMenuWidthMin = 100;

EDT.parentOfComment = null;

//---------------------
// Draw guide lines
//---------------------

function drawSiblingMargin(id)
{
	while(PLG.sprites[id].margin_s && PLG.sprites[id].margin_s.elder && PLG.sprites[id].margin_s.elder != ""){
		id = PLG.sprites[id].margin_s.elder;
	}
	drawYoungerMargin(id);
}

function drawYoungerMargin(id)
{
	if(PLG.drawcanvas != null && PLG.drawcanvas.getContext){
		if(!PLG.sprites[id].margin_s){
			return;
		}

		if(PLG.sprites[id].margin_s && PLG.sprites[id].margin_s.younger && PLG.sprites[id].margin_s.younger.length > 0){
			for(var i=0; i<PLG.sprites[id].margin_s.younger.length; i++){
				drawYoungerMargin(PLG.sprites[id].margin_s.younger[i]);

				PLG.drawctx.strokeStyle = "rgba(100,200,255,0.4)";
				PLG.drawctx.lineWidth = 3;
				var xoffset = 0;
				var yoffset = 0;

				var startx = xoffset + PLG.viewPositionX + PLG.sprites[PLG.sprites[id].margin_s.younger[i]].position.absx + Math.floor(PLG.sprites[PLG.sprites[id].margin_s.younger[i]].width/2);
				var endx = xoffset + PLG.viewPositionX + PLG.sprites[id].position.absx +  Math.floor(PLG.sprites[id].width/2);

				var starty = 0;
				var endy = 0;

				if(!PLG.sprites[PLG.sprites[id].margin_s.younger[i]].margin_p || !PLG.sprites[PLG.sprites[id].margin_s.younger[i]].margin_p.position){
					calcParentMargin(PLG.sprites[id].margin_s.younger[i]);
				}

				if(isUpperSiblings(PLG.sprites[id].margin_s.younger[i], PLG.sprites)){
					if(PLG.sprites[PLG.sprites[id].margin_s.younger[i]].margin_s.position == "TB"){
						starty = yoffset + PLG.viewPositionY + PLG.sprites[PLG.sprites[id].margin_s.younger[i]].position.absy + PLG.sprites[PLG.sprites[id].margin_s.younger[i]].region.bottom;
						endy = yoffset + PLG.viewPositionY + PLG.sprites[id].position.absy + PLG.sprites[id].region.top;
					}
					else{
						starty = yoffset + PLG.viewPositionY + PLG.sprites[PLG.sprites[id].margin_s.younger[i]].position.absy + PLG.sprites[PLG.sprites[id].margin_s.younger[i]].region.bottom;
						endy = yoffset + PLG.viewPositionY + PLG.sprites[id].position.absy + PLG.sprites[id].region.bottom;
					}
				}
				else{
					if(PLG.sprites[PLG.sprites[id].margin_s.younger[i]].margin_s.position == "BT"){
						starty = yoffset + PLG.viewPositionY + PLG.sprites[PLG.sprites[id].margin_s.younger[i]].position.absy + PLG.sprites[PLG.sprites[id].margin_s.younger[i]].region.top;
						endy = yoffset + PLG.viewPositionY + PLG.sprites[id].position.absy + PLG.sprites[id].region.bottom;
					}
					else{
						starty = yoffset + PLG.viewPositionY + PLG.sprites[PLG.sprites[id].margin_s.younger[i]].position.absy + PLG.sprites[PLG.sprites[id].margin_s.younger[i]].region.top;
						endy = yoffset + PLG.viewPositionY + PLG.sprites[id].position.absy + PLG.sprites[id].region.top;
					}
				}

				var srcControlX = startx;
				var dstControlX = endx;

				var srcControlY = 0;
				if(isUpperSiblings(PLG.sprites[id].margin_s.younger[i], PLG.sprites)){
					srcControlY = starty + Math.abs(Math.floor((endy-starty)/3));
					dstControlY = endy - Math.abs(Math.floor((endy-starty)/3));
				}
				else{
					srcControlY = starty - Math.abs(Math.floor((endy-starty)/3));
					dstControlY = endy + Math.abs(Math.floor((endy-starty)/3));
				}

				PLG.drawctx.beginPath();
				PLG.drawctx.lineCap = "round";
				PLG.drawctx.lineJoin = "round";
				PLG.drawctx.moveTo(startx,starty);
				PLG.drawctx.bezierCurveTo(srcControlX,srcControlY, dstControlX,dstControlY, endx,endy);
				PLG.drawctx.stroke();
				
				PLG.drawctx.beginPath();
				PLG.drawctx.fillStyle = PLG.drawctx.strokeStyle;
				PLG.drawctx.arc(endx,endy,4, 0,Math.PI*2,true);
				PLG.drawctx.fill();
			}
		}
	}
}

function drawParentMargin(id)
{
	if(PLG.drawcanvas != null && PLG.drawcanvas.getContext){
		if(PLG.sprites[id].margin_p){
			PLG.drawctx.strokeStyle = "rgba(255,150,100,1.0)";

			PLG.drawctx.lineWidth = 2;			
			if(PLG.sprites[id].parent && PLG.sprites[id].parent != ""){
				// nop
			}
			else{
				PLG.drawctx.strokeStyle = "rgba(255,150,100,0.3)";
			}


			var xoffset = 0;
			var yoffset = 0;
			var srcControlX = 0;
			var srcControlY = 0;
			var dstControlX = 0;
			var dstControlY = 0;

			var parentX = 0;
			var parentY = 0;
			var parentWidth = 1;
			var parentHeight = 1;
			if(PLG.sprites[id].parent && PLG.sprites[id].parent != ""){
				parentX = PLG.sprites[PLG.sprites[id].parent].position.absx;
				parentY = PLG.sprites[PLG.sprites[id].parent].position.absy;
				parentWidth = PLG.sprites[PLG.sprites[id].parent].width;
				parentHeight = PLG.sprites[PLG.sprites[id].parent].height;
			}
			else if(PARAM.page_type == "document"){
				return;
			}

			var startx = xoffset + PLG.viewPositionX + PLG.sprites[id].position.absx + Math.floor(PLG.sprites[id].width/2);
			var starty = yoffset + PLG.viewPositionY + PLG.sprites[id].position.absy + PLG.sprites[id].region.top;
			var endx = xoffset + PLG.viewPositionX + parentX + Math.floor(parentWidth/2);				
			var endy = yoffset + PLG.viewPositionY + parentY;

			var arrowx = 5;
			var arrowy = 15;
			var arrowx2 = -arrowx;
			var arrowy2 = arrowy;
			var alen = Math.sqrt(arrowx*arrowx + arrowy*arrowy);

			PLG.drawctx.beginPath();
			if(PLG.sprites[id].margin_p.position == "BT"){
				endy += parentHeight;

				var width = endx - startx;
				var height = starty - endy;
				srcControlX = startx;
				srcControlY = starty;
				dstControlX = endx;
				dstControlY = endy + Math.abs(Math.floor(height/3));

				var length = Math.sqrt(width*width + height*height);
				var cos = height / length;
				var sin = - width / length;	
				var ax = Math.floor(arrowx*cos-arrowy*sin);
				var ay = Math.floor(arrowx*sin+arrowy*cos);
				var ax2 = Math.floor(arrowx2*cos-arrowy2*sin);
				var ay2 = Math.floor(arrowx2*sin+arrowy2*cos);
			}
			else if(PLG.sprites[id].margin_p.position == "TT"){
				var width = endx - startx;
				var height = starty - endy;
				srcControlX = startx;
				srcControlY = starty;
				dstControlX = endx;
				dstControlY = endy - Math.abs(Math.floor(height/3));

				var length = Math.sqrt(width*width + height*height);
				var cos = height / length;
				var sin = - width / length;	
				var ax = Math.floor(arrowx*cos-arrowy*sin);
				var ay = Math.floor(arrowx*sin+arrowy*cos);
				var ax2 = Math.floor(arrowx2*cos-arrowy2*sin);
				var ay2 = Math.floor(arrowx2*sin+arrowy2*cos);

			}
			else if(PLG.sprites[id].margin_p.position == "TB"){
				starty += PLG.sprites[id].region.bottom - PLG.sprites[id].region.top;

				var width = endx - startx;
				var height = endy - starty;
				srcControlX = startx;
				srcControlY = starty;
				dstControlX = endx;
				dstControlY = endy - Math.abs(Math.floor(height/3));

				var length = Math.sqrt(width*width + height*height);
				var cos = height / length;
				var sin = - width / length;	
				var ax = Math.floor(arrowx*cos-arrowy*sin);
				var ay = -Math.floor(arrowx*sin+arrowy*cos);
				var ax2 = Math.floor(arrowx2*cos-arrowy2*sin);
				var ay2 = -Math.floor(arrowx2*sin+arrowy2*cos);
			}
			else if(PLG.sprites[id].margin_p.position == "NO"){
				return;
			}
			PLG.drawctx.moveTo(startx,starty);
			PLG.drawctx.lineTo(startx+ax,starty-ay);
			PLG.drawctx.lineTo(startx+ax2,starty-ay2);
			PLG.drawctx.lineTo(startx,starty);

			PLG.drawctx.lineCap = "round";
			PLG.drawctx.lineJoin = "round";
			PLG.drawctx.moveTo(startx,starty);
			PLG.drawctx.bezierCurveTo(srcControlX,srcControlY, dstControlX,dstControlY, endx,endy);
			PLG.drawctx.stroke();

			PLG.drawctx.beginPath();
			PLG.drawctx.fillStyle = PLG.drawctx.strokeStyle;
			PLG.drawctx.arc(endx,endy,4, 0,Math.PI*2,true);
			PLG.drawctx.fill();
		}
	}
}


function clearCanvas()
{
	if(PLG.drawcanvas != null && PLG.drawcanvas.getContext){
		PLG.drawctx.clearRect(0, 0, PLG.drawcanvas.offsetWidth, PLG.drawcanvas.offsetHeight);
	}
}

function drawChildRegion(spr, depth, maxdepth)
{	
	if(!spr){
		return;
	}

	if(maxdepth != undefined && depth > maxdepth){
		return;
	}

	if(PLG.drawcanvas != null && PLG.drawcanvas.getContext){
		if(PLG.sprites[spr.id].children && PLG.sprites[spr.id].children.length > 0){

			var children = PLG.sprites[spr.id].children;
			for (var i=0; i<children.length; i++){
				drawChildRegion(document.getElementById(children[i]), depth+1, maxdepth);
			}
		}

		var red = 255;
		var green = 150;
		var blue = 100;

		var xoffset = 0;
		var yoffset = 0;
		var extrawidth = 4;
		var extraheight = 1;

		if(EDT.showAllRegionFlag
			 || (PLG.fixedSprite != null && PLG.fixedSprite.id == spr.id && PLG.sprites[spr.id].children) 
			 || (PLG.fixedSprite != null && PLG.fixedSprite.id != spr.id)
			 || (PLG.selectedSprite != null && PLG.selectedSprite.id == spr.id && PLG.sprites[spr.id].children)
			 || (PLG.selectedSprite != null && PLG.selectedSprite.id != spr.id)
){
						 PLG.drawctx.strokeStyle = "rgba(" + red + "," + green + "," +  blue + ",1.0)";
						 PLG.drawctx.lineWidth = 2;

						 PLG.drawctx.strokeRect(xoffset+PLG.viewPositionX + PLG.sprites[spr.id].position.absx+PLG.sprites[spr.id].region.left, yoffset+PLG.viewPositionY+ PLG.sprites[spr.id].position.absy+PLG.sprites[spr.id].region.top, PLG.sprites[spr.id].region.right-PLG.sprites[spr.id].region.left + extrawidth, PLG.sprites[spr.id].region.bottom-PLG.sprites[spr.id].region.top + extraheight);
		}

		if(PLG.sprites[spr.id].children 
			 && ((PLG.fixedSprite != null && spr.id != PLG.fixedSprite.id)
					 || (PLG.selectedSprite != null && spr.id != PLG.selectedSprite.id))){
			PLG.drawctx.lineWidth = 2;
			PLG.drawctx.strokeStyle = "rgba(255,150,100,1.0)";
			PLG.drawctx.strokeRect(xoffset+PLG.viewPositionX + PLG.sprites[spr.id].position.absx, yoffset+PLG.viewPositionY+ PLG.sprites[spr.id].position.absy, PLG.sprites[spr.id].width + extrawidth, PLG.sprites[spr.id].height + extraheight);
		}

		if(EDT.showGuideFlag){
			drawSiblingMargin(spr.id);
		}
		drawParentMargin(spr.id);
	}
}


function undoDraw()
{
	PLG.drawCanvasLeft = Number.MAX_VALUE;
	PLG.drawCanvasRight = Number.MIN_VALUE;
	PLG.drawCanvasTop = Number.MAX_VALUE;
	PLG.drawCanvasBottom = Number.MIN_VALUE;

	if(PLG.drawRecord.length > 0){
		for(var i=PLG.drawRecord.length-1; i>=0; i--){
			if(PLG.drawRecord[i] == "l"){
				PLG.drawRecord.pop();
				break;
			}
			else{
				PLG.drawRecord.pop();
			}
		}
	}

	PLG.drawctx.clearRect(0, 0, PLG.drawcanvas.offsetWidth, PLG.drawcanvas.offsetHeight);

	if(PLG.drawcanvas != null){
		if(PLG.drawcanvas.getContext){
			for(var i=0; i<PLG.drawRecord.length; i++){
				if(PLG.drawRecord[i] == "l"){
					if(i != 0){
						PLG.drawctx.stroke();
					}
					i++;
					var drawRecordStr = PLG.drawRecord[i];
					drawRecordStr.match(/^s(.+)$/);
					PLG.drawctx.lineWidth = parseFloat(RegExp.$1);
					i++;
					drawRecordStr = PLG.drawRecord[i];
					drawRecordStr.match(/^c(.+)$/);
					PLG.drawctx.strokeStyle = RegExp.$1;
					i++;
					PLG.drawctx.beginPath();
					PLG.drawctx.moveTo(parseInt(PLG.drawRecord[i]),parseInt(PLG.drawRecord[i+1]));
					if(PLG.drawCanvasLeft > parseInt(PLG.drawRecord[i])){
						PLG.drawCanvasLeft = parseInt(PLG.drawRecord[i]);
					}
					if(PLG.drawCanvasRight < parseInt(PLG.drawRecord[i])){
						PLG.drawCanvasRight = parseInt(PLG.drawRecord[i]);
					}
					if(PLG.drawCanvasTop > parseInt(PLG.drawRecord[i+1])){
						PLG.drawCanvasTop = parseInt(PLG.drawRecord[i+1]);
					}
					if(PLG.drawCanvasBottom < parseInt(PLG.drawRecord[i+1])){
						PLG.drawCanvasBottom = parseInt(PLG.drawRecord[i+1]);
					}
				}
				else{
					PLG.drawctx.lineTo(parseInt(PLG.drawRecord[i]),parseInt(PLG.drawRecord[i+1]));
					if(PLG.drawCanvasLeft > parseInt(PLG.drawRecord[i])){
						PLG.drawCanvasLeft = parseInt(PLG.drawRecord[i]);
					}
					if(PLG.drawCanvasRight < parseInt(PLG.drawRecord[i])){
						PLG.drawCanvasRight = parseInt(PLG.drawRecord[i]);
					}
					if(PLG.drawCanvasTop > parseInt(PLG.drawRecord[i+1])){
						PLG.drawCanvasTop = parseInt(PLG.drawRecord[i+1]);
					}
					if(PLG.drawCanvasBottom < parseInt(PLG.drawRecord[i+1])){
						PLG.drawCanvasBottom = parseInt(PLG.drawRecord[i+1]);
					}
				}
				i++;
			}
			PLG.drawctx.stroke();
		}
	}

}


function redrawCanvas(spr)
{
	clearCanvas();
	if(PLG.state == STATES.FIXED || PLG.state == STATES.FIXEDSELECTED || PLG.state == STATES.MOVINGSELECTED || PLG.state == STATES.MOVING || PLG.state == STATES.SCALING || PLG.state == STATES.EDITING || PLG.state == STATES.EDITINGSELECTED){
		if(EDT.showAllRegionFlag){
			for (var id in PLG.sprites){
				if(!id.match(/^sprite_.+$/)){
					continue;
				}
				if(!PLG.sprites[id].parent && document.getElementById(id)){
					drawChildRegion(document.getElementById(id),0);
				}	
			}
		}
		else{
			drawChildRegion(document.getElementById(spr.id),0, 0);
		}
	}
}


function allRegionCheckOnClick()
{
	EDT.showAllRegionFlag = document.getElementById("allRegionCheck").checked;
	if(PLG.drawingFlag){
		document.getElementById("allRegionCheck").checked = false;
		PLG.showAllRegionFlag = false;
		return;
	}
	redrawCanvas(PLG.fixedSprite);
}

function showRegionCheckOnClick()
{
	EDT.showRegionFlag = document.getElementById("showRegionCheck").checked;
	EDT.showAllRegionFlag = document.getElementById("showRegionCheck").checked;
	if(PLG.drawingFlag){
		document.getElementById("showRegionCheck").checked = false;
		PLG.showRegionFlag = false;
		PLG.showAllRegionFlag = false;
		return;
	}
	redrawCanvas(PLG.fixedSprite);
}

function showGuideCheckOnClick()
{
	EDT.showGuideFlag = document.getElementById("showGuideCheck").checked;
	if(PLG.drawingFlag){
		document.getElementById("showGuideCheck").checked = false;
		PLG.showGuideFlag = false;
		return;
	}
	redrawCanvas(PLG.fixedSprite);
}

//---------------------
// Drawing
//---------------------

function drawingCheckOnClick()
{
	PLG.drawingFlag = document.getElementById("drawingCheck").checked;

	if(PLG.state == STATES.EDITING || PLG.state == STATES.EDITINGSELECTED){
		document.getElementById("drawingCheck").checked = false;
		PLG.drawingFlag = false;
	}

	var loginid = getCookie("loginid");
	if(PLG.drawingFlag){
    if(loginid == "public"){
			document.getElementById("drawingPassword").style.display = "block";
			var public_password = getCookie("public_password");
			if(public_password == undefined){
				public_password = "";
			}
			document.getElementById("drawingPassword").value = public_password;

			document.getElementById("drawingPasswordLabel1").style.display = "block";
			document.getElementById("drawingPasswordLabel2").style.display = "block";
		}

		if(PLG.state == STATES.SELECTED){
			removeSelectedFrame();
			clearSelectedSprite();
		}
		if(PLG.state == STATES.FIXEDSELECTED){
			removeSelectedFrame();
			removeUngroupIcon();
			removeSpriteIcons();
			removeFamilyFrame(PLG.selectedSprite);
			clearSelectedSprite();
		}
		if(PLG.state == STATES.FIXED){
			removeSpriteIcons();
			removeFixedFrame();
			clearFixedSprite();
		}
		PLG.state = STATES.WORKING;

		PLG.drawcanvas.style.zIndex = ZIND.DRAWCANVASFRONT;
		PLG.drawcanvas.style.display="block";
		PLG.drawCanvasLeft = Number.MAX_VALUE;
		PLG.drawCanvasRight = Number.MIN_VALUE;
		PLG.drawCanvasTop = Number.MAX_VALUE;
		PLG.drawCanvasBottom = Number.MIN_VALUE;
	
		// You must not set alpha of drawcanvas on IEs
//		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
//			PLG.drawcanvas.style.filter = "alpha(opacity=100)";
//		}
//		else{
//			PLG.drawcanvas.style.opacity = 1.0;
//		}

		if(PLG.cb.bw.mozes){
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "drawingpen.cur), default";
			PLG.drawcanvas.style.cursor  = "url(" + PARAM.IMAGEFILEPATH + "drawingpen.cur), default";
		}
		else if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			// These cursors are displayed only when a mouse cursor is on drawing lines.
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "drawingpen.cur), default";
			PLG.drawcanvas.style.cursor  = "url(" + PARAM.IMAGEFILEPATH + "drawingpen.cur), default";
		}
		else if(PLG.cb.bw.opera || PLG.cb.bw.safari){
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.style.cursor = "crosshair";
			PLG.drawcanvas.style.cursor  = "crosshair";
		}

		disableSelection();

		openPenColorDialog();

	}
	else{
    if(loginid == "public"){
			document.getElementById("drawingPassword").style.display = "none";
			document.getElementById("drawingPasswordLabel1").style.display = "none";
			document.getElementById("drawingPasswordLabel2").style.display = "none";
		}
		
		if(PLG.cb.bw.mozes){
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand.cur), default";
			PLG.drawcanvas.style.cursor  = "";
		}
		else if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand.cur), default";
			PLG.drawcanvas.style.cursor  = "";
		}
		else if(PLG.cb.bw.opera || PLG.cb.bw.safari){
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.style.cursor = "auto";
			PLG.drawcanvas.style.cursor  = "";
		}

		PLG.drawcanvas.style.zIndex = ZIND.DRAWCANVASBACK;
		PLG.drawctx.clearRect(0, 0, PLG.drawcanvas.offsetWidth, PLG.drawcanvas.offsetHeight);
		PLG.drawcanvas.style.display="none";
		createSprite(true);
		closePenColorDialog();
	}
}

function pensizeOnMouseDown()
{
	PLG.ignoreMouseDown = true;
}

function pensizeOnChange()
{
	var pensizeSelectorElm = document.getElementById("pensizeSelector");
	PLG.pensize = parseFloat(pensizeSelectorElm.options[pensizeSelectorElm.selectedIndex].value);
}


//---------------------------------
// Sprite mover
//---------------------------------
function moverOnMouseDown()
{
	removeUngroupIcon();

	PLG.state = STATES.MOVING;

	// drawcanvas interferes with spriteOnMouseOver event on a sprite 
	// that has canvas element on IE
	if(PLG.canvasSpriteExists && (PLG.cb.bw.msie || PLG.cb.bw.msie7)){
		PLG.drawcanvas.style.display = "none";
	}

	if(!EDT.showAllRegionFlag && !EDT.showGuideFlag){
		PLG.drawcanvas.style.display = "none";
	}

	EDT.orgSpritesHash = PLG.sprites.toJSONString();

  // set cursor
	if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
		var menu = document.getElementById("spritemenu");
		var spritesWorldNode = document.getElementById("spritesworld");     
	}

	removeFixedFrame();
	removeSpriteIcons();
	clearSelectedSprite();


  if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
		var regionElm = getSpriteRegion(PLG.fixedSprite);
		regionElm.style.filter = "alpha(opacity=50)";
		var childList = PLG.fixedSprite.getElementsByTagName("li");
		for(var i=0; i<childList.length; i++){
			var child = childList[i];
			if(child.className == "sprite"){
				var regionElm2 = getSpriteRegion(child);
				regionElm2.style.filter = "alpha(opacity=50)";
			}
		}
  }
  else{
    PLG.fixedSprite.style.opacity = 0.5;
  }

  EDT.orgLeft = sprLeft(PLG.fixedSprite);
  EDT.orgTop = sprTop(PLG.fixedSprite);

	disableSelection();

}


//---------------------------------
// Sprite scaler
//---------------------------------
function scalerOnMouseDown()
{
  PLG.state = STATES.SCALING;
  EDT.orgWidth = sprWidth(PLG.selectedSprite);
}

//------------------------------------
// Layer (Top/Bottom)
//------------------------------------
function editorControlTopOnMouseDown()
{
  // get list of all sprites
  var spritesList = document.getElementsByTagName("li");
  var topZ = 0;
  var topSprite = PLG.fixedSprite;
	var topcount = 0;
  for(var i=0; i<spritesList.length; i++){
		var tmpSprite = spritesList[i];
		if(tmpSprite.className == "sprite"){
      var tmpZ = parseFloat(tmpSprite.style.zIndex);
      if(tmpZ > topZ  && tmpZ <= ZIND.SPRITE_MAX){
        topZ = tmpZ;
        topSprite = tmpSprite;
				topcount = 1;
      }
			else if(tmpZ == topZ){
				topcount++;
			}
    }
  }
  if(topSprite != PLG.fixedSprite || topcount > 1){
    if(topZ < ZIND.SPRITE_MAX){
      PLG.orgZindexOfFixedSprite  = topZ+1;
    }
    else{
      PLG.orgZindexOfFixedSprite  = ZIND.SPRITE_MAX;
    }
  }
  document.getElementById("controlresult").innerHTML="Top!";
}

function editorControlBottomOnMouseDown()
{
  if(PLG.orgZindexOfSelectedSprite > 1){
    // get list of all sprites
		var spritesList = document.getElementsByTagName("li");
    var bottomZ = ZIND.SPRITE_MAX + 1;
    var bottomSprite = PLG.fixedSprite;
		var bottomCount = 0;
    for (var i=0; i<spritesList.length; i++){
      var tmpSprite = spritesList[i];
			if(tmpSprite.className == "sprite"){
        var tmpZ = parseFloat(tmpSprite.style.zIndex);
        if(tmpZ < bottomZ){
          bottomZ = tmpZ;
          bottomSprite = tmpSprite;
					bottomCount = 1;
        }
				else if(tmpZ == bottomZ){
					bottomCount++;
				}
      }
    }
    if(bottomSprite != PLG.fixedSprite || bottomCount > 1){
      if(bottomZ > ZIND.SPRITE_MIN){
        PLG.orgZindexOfFixedSprite  = bottomZ-1;
      }
      else{
        PLG.orgZindexOfFixedSprite  = ZIND.SPRITE_MIN;
      }
    }
  }

  document.getElementById("controlresult").innerHTML="Bottom!";
}


//----------------------------------
// File uploader
//----------------------------------

// called from filepload.cgi
function closeFileUploader()
{
  if(document.getElementById("fileuploadframe")){
    document.getElementById("spritesworld").removeChild(document.getElementById("fileuploadframe"));
  }
}

// called from filepload.cgi
function insertUploadedFileToEditor(html)
{
  if(document.getElementById("editor")){
    if(html.match(/^filename;(.+)$/)){
      var filename = RegExp.$1;
      document.getElementById("editor-filename").innerHTML = filename;
    }
    else{
      var editorTextAreaElm = document.getElementById("editor-textarea");
      editorTextAreaElm.value += html;
    }
  }
}


function openFileUploader()
{
  if(!document.getElementById("fileuploadframe")){
    setCookie("pageid", PARAM.pageid, PARAM.CGIFILEPATH, 0);

    var fileUploadFrame = document.createElement("iframe");
    fileUploadFrame.setAttribute("id", "fileuploadframe");
    fileUploadFrame.style.left = document.getElementById("editor").style.left;
    fileUploadFrame.style.top = document.getElementById("editor").style.top;

    fileUploadFrame.setAttribute("src", "./fileupload.cgi?" + (new Date()).getTime());

    document.getElementById("spritesworld").appendChild(fileUploadFrame);

  }
}

//--------------------------------------
// Plugin Dialog
//--------------------------------------

function openPluginDialog()
{
  if(!document.getElementById("plugin-dialog")){
    var pluginName = "";
    var pluginOption = "";
    var pluginTemplate = "";
    if(getSpriteInfo(PLG.fixedSprite, "spriteplugin")){
      var pluginStr = getSpriteInfo(PLG.fixedSprite, "spriteplugin").innerHTML;
      pluginStr = pluginStr.replace(/&amp;/gi,"&");
      var pluginArray = pluginStr.split(";");
      if(pluginArray.length >= 1){
        var pluginCommand = pluginArray[0];
        if(pluginArray.length >= 2){
          for(var i=1; i<pluginArray.length-1; i++){
            pluginTemplate += pluginArray[i]+";";
          }
          pluginTemplate += pluginArray[pluginArray.length-1];

          if(pluginTemplate == undefined){
            pluginTemplate = "[[plugin]]";
          }
        }

        var pluginCommandArray = pluginCommand.split(",");

        if(pluginCommandArray.length >= 1){
          pluginName = pluginCommandArray[0];
        }
        if(pluginCommandArray.length >= 2){
          for(var i=1; i<pluginCommandArray.length-1; i++){
            pluginOption += pluginCommandArray[i]+",";
          }
          pluginOption += pluginCommandArray[pluginCommandArray.length-1];
        }
      }
    }

    if(PLG.cb.bw.msie){
      // select menu is overwrapped on the plugin-dialog on msie6
      document.getElementById("editor-control4").style.display = "none";
    }

    // form 
    var dialogForm = document.createElement("form");
    dialogForm.setAttribute("id", "plugin-dialog");
    dialogForm.style.left = document.getElementById("editor").style.left;
    dialogForm.style.top = document.getElementById("editor").style.top;
    dialogForm.style.width = "380px";
    dialogForm.style.height = "300px";
    dialogForm.onsubmit = function(){ return false;	}

    // Plugin name
    var pluginNameTitleElement = document.createElement("div");
    pluginNameTitleElement.setAttribute("id", "plugin-nametitle");
    pluginNameTitleElement.appendChild(document.createTextNode(""));
    pluginNameTitleElement.innerHTML = "plugin name";
    dialogForm.appendChild(pluginNameTitleElement);

    // clear cache
    var clearElement = document.createElement("input");
    clearElement.setAttribute("type", "button");
    clearElement.setAttribute("id", "dialog-clearcache");
    clearElement.value = "Clear Cache";
    clearElement.onclick = function(){
			var postdata = "&pageid=" + PARAM.pageid + "&sourceID=" + PLG.fixedSprite.id + "&plugin="+document.getElementById("plugin-name").value + "," + document.getElementById("plugin-option").value;
			var clearCacheOnLoaded = function(obj){
				document.getElementById("dialog-clearcacheresult").innerHTML=obj.responseText;
			}
			sendRequest(clearCacheOnLoaded, postdata, "POST", PARAM.CGIFILEPATH + "clearCache.cgi", true, true);
		}

    dialogForm.appendChild(clearElement);

    var clearResultElement = document.createElement("div");
    clearResultElement.setAttribute("id", "dialog-clearcacheresult");
    dialogForm.appendChild(clearResultElement);

    dialogForm.appendChild(document.createElement("br"));

    var pluginNameElement = document.createElement("input");
    pluginNameElement.setAttribute("type", "text");
    pluginNameElement.setAttribute("id", "plugin-name");
    pluginNameElement.setAttribute("size", "40");
    pluginNameElement.value = pluginName;
    dialogForm.appendChild(pluginNameElement);

    // Plugin options
    var pluginOptionTitleElement = document.createElement("div");
    pluginOptionTitleElement.setAttribute("id", "plugin-optiontitle");
    pluginOptionTitleElement.appendChild(document.createTextNode(""));
    pluginOptionTitleElement.innerHTML = "plugin options";
    dialogForm.appendChild(pluginOptionTitleElement);

    var pluginOptionElement = document.createElement("textarea");
    pluginOptionElement.setAttribute("id", "plugin-option");
    pluginOptionElement.setAttribute("rows", "2");
    pluginOptionElement.setAttribute("cols", "40");
    pluginOptionElement.value = pluginOption;
    dialogForm.appendChild(pluginOptionElement);

    // Plugin template
    var pluginTemplateTitleElement = document.createElement("div");
    pluginTemplateTitleElement.setAttribute("id", "plugin-templatetitle");
    pluginTemplateTitleElement.appendChild(document.createTextNode(""));
    pluginTemplateTitleElement.innerHTML = "plugin template";
    dialogForm.appendChild(pluginTemplateTitleElement);

    var pluginTemplateElement = document.createElement("textarea");
    pluginTemplateElement.setAttribute("id", "plugin-template");
    pluginTemplateElement.setAttribute("rows", "6");
    pluginTemplateElement.setAttribute("cols", "40");
    pluginTemplateElement.value = pluginTemplate;
    dialogForm.appendChild(pluginTemplateElement);

    var brElement = document.createElement("br");
    dialogForm.appendChild(brElement);


    // cancel
    var cancelElement = document.createElement("input");
    cancelElement.setAttribute("type", "button");
    cancelElement.setAttribute("id", "dialog-cancel");
    cancelElement.value = "Cancel";
    cancelElement.onclick = function(){
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.removeChild(document.getElementById("plugin-dialog"));
			if(PLG.cb.bw.msie){
        // select menu is overwrapped on the plugin-dialog on msie6
				document.getElementById("editor-control4").style.display = "block";
			}
		}

    dialogForm.appendChild(cancelElement);

    // ok
    var okElement = document.createElement("input");
    okElement.setAttribute("type", "button");
    okElement.setAttribute("id", "dialog-ok");
    okElement.value = "Ok";
    okElement.onclick = function(){
			var templateElm = document.getElementById("plugin-template");
			var template = templateElm.value;
			if(!template.match(/\[\[plugin\]\]/)){
				templateElm.value = "[[plugin]]" + template;
			}
			var pluginElm = getSpriteInfo(PLG.fixedSprite, "spriteplugin");
			pluginElm.innerHTML = document.getElementById("plugin-name").value + "," + document.getElementById("plugin-option").value + ";" + templateElm.value;
			
			editorPluginNameElm = document.getElementById("editor-pluginname");
			editorPluginNameElm.innerHTML = document.getElementById("plugin-name").value;
			textareaElm = document.getElementById("editor-textarea");
			if(textareaElm.innerHTML == ""){
				textareaElm.innerHTML = "[[plugin]]";
			}

			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.removeChild(document.getElementById("plugin-dialog"));

			if(PLG.cb.bw.msie){
        // select menu is overwrapped on the plugin-dialog on msie6
				document.getElementById("editor-control4").style.display = "block";
			}
		}
    dialogForm.appendChild(okElement);

    document.getElementById("spritesworld").appendChild(dialogForm);

  }
}



//-----------------------------------------------
// Password Dialog for moving / scaling public sprite
//-----------------------------------------------

function openPasswordDialog(targetSprite, prevState)
{
	if(prevState == STATES.SCALING){
		removeSpriteIcons();
		removeFixedFrame();
	}

  // form 
  var dialogForm = document.createElement("form");
  dialogForm.setAttribute("id", "password-dialog");

	// callback function 
	dialogForm.onsubmit = function(){
		if(prevState == STATES.FIXEDSELECTED || prevState == STATES.FIXED){
			deleteSprite(false);
		}
		else{
			saveStyles(targetSprite);
		}
		return false;
	}

  var spriteLeft = sprLeftAbs(targetSprite);
  var spriteTop = sprTopAbs(targetSprite);

  var dialogWidth = 200;
  var dialogHeight = 100;
  var dialogLeft = spriteLeft + PLG.viewPositionX;
  var dialogTop = spriteTop + PLG.viewPositionY - dialogHeight;

  var spritesWorldNode = document.getElementById("spritesworld");
  if(dialogLeft + dialogWidth > spritesWorldNode.offsetWidth){
    dialogLeft -= dialogLeft + dialogWidth  - spritesWorldNode.offsetWidth + 5;
  }
  if(dialogTop + dialogHeight > spritesWorldNode.offsetHeight){
    dialogTop -= dialogTop + dialogHeight - spritesWorldNode.offsetHeight + 5;
  }

	if(dialogTop < 0){
		dialogTop = 0;
	}

  if(dialogLeft < 0){
    dialogLeft = 0;
  }

  dialogForm.style.width = dialogWidth.toString() + "px";
  dialogForm.style.height = dialogHeight.toString() + "px";
  dialogForm.style.left = dialogLeft.toString() + "px";
  dialogForm.style.top = dialogTop.toString() + "px";

  var dialogControlElement = document.createElement("div");
  dialogControlElement.setAttribute("id", "dialog-control");
	if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
		dialogControlElement.style.cursor = "auto";
	}

  var dialogControlCloseElement = document.createElement("img");
  dialogControlCloseElement.setAttribute("src", PARAM.IMAGEFILEPATH + "close.gif");
  dialogControlCloseElement.setAttribute("id", "dialog-closebtn");
  dialogControlCloseElement.style.verticalAlign = "middle";
  if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
    dialogControlCloseElement.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
  }
  dialogControlElement.appendChild(dialogControlCloseElement);

  dialogForm.appendChild(dialogControlElement);

  var dialogControlElement2 = document.createElement("div");
  dialogControlElement2.setAttribute("id", "dialog-control2");

  var passElement = document.createElement("div");
  passElement.setAttribute("id", "dialog-passtitle");
  passElement.appendChild(document.createTextNode(""));
  passElement.innerHTML = "Please enter password";
  dialogControlElement2.appendChild(passElement);

  var passFieldElement = document.createElement("input");
  passFieldElement.setAttribute("type", "password");
  passFieldElement.setAttribute("id", "dialog-pass");
  passFieldElement.setAttribute("size", "10");
  passFieldElement.style.verticalAlign = "middle";
  passFieldElement.value = "";
  dialogControlElement2.appendChild(passFieldElement);

  var brElement = document.createElement("br");
  dialogControlElement2.appendChild(brElement);

  var submitElement = document.createElement("input");
  submitElement.setAttribute("type", "submit");
  submitElement.setAttribute("id", "dialog-submit");
  submitElement.value = "Enter";
  dialogControlElement2.appendChild(submitElement);


	// callback function
	var passwordDialogCloseOnMouseDown = function(){
		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.removeChild(document.getElementById("password-dialog"));
		
		if(prevState == STATES.SCALING){
			targetSprite.style.width = EDT.orgWidth  + "px";
			var menu = document.getElementById("spritemenu");
				var menu = document.getElementById("spritemenu");
				var width = Math.round(EDT.orgWidth)/3;
				if(width < EDT.spriteMenuWidthMin){
					width = EDT.spriteMenuWidthMin;
				}
				menu.style.width = width + "px";

//			menu.style.width = (EDT.orgWidth + 6) + "px";
		}
		else if(prevState == STATES.MOVING || prevState == STATES.MOVINGSELECTED){
			targetSprite.style.top = EDT.orgTop + "px";
			targetSprite.style.left = EDT.orgLeft + "px";
		}

		PLG.sprites = eval('(' + EDT.orgSpritesHash + ')');

		if(prevState == STATES.MOVINGSELECTED){
			removeGroupIcon(PLG.selectedSprite);
		}
		removeSpriteIcons();
		removeFixedFrame();

		clearSelectedSprite();
		clearFixedSprite();

		PLG.state = STATES.WORKING;

		clearCanvas();
		PLG.waitSavingFlag = false;
	}


  var cancelElement = document.createElement("input");
  cancelElement.setAttribute("type", "button");
  cancelElement.setAttribute("id", "dialog-cancel");
  cancelElement.value = "Cancel";
  cancelElement.onclick = passwordDialogCloseOnMouseDown;
  dialogControlElement2.appendChild(cancelElement);

  var brElement2 = document.createElement("br");
  dialogControlElement2.appendChild(brElement2);

  var resultElement = document.createElement("span");
  resultElement.setAttribute("id", "dialog-result");
  resultElement.appendChild(document.createTextNode(""));
  dialogControlElement2.appendChild(resultElement);

  dialogForm.appendChild(dialogControlElement2);

  dialogControlCloseElement.onmousedown = passwordDialogCloseOnMouseDown;


  var spritesWorldNode = document.getElementById("spritesworld");
  spritesWorldNode.appendChild(dialogForm);
  
  passFieldElement.focus();

}


//------------------------------------
// Color Dialogs
//------------------------------------

function setColor2Selector(col, defaultColor)
{
  if(EDT.tcs == null){
    return;
  }

  if(col == undefined || col == null || col == ""){
    col = defaultColor;
  }

  var r = 0;
  var g = 0;
  var b = 0;

  if(col.match(/rgb\((\d+?),\s*(\d+?),\s*(\d+?)\)/i)){
    r = parseInt(RegExp.$1);
    g = parseInt(RegExp.$2);
    b = parseInt(RegExp.$3);
  }
  else{
    var rgb = EDT.tcs.hex2rgb(col);
    r = rgb.r;
    g = rgb.g;
    b = rgb.b;
  }

  if(r != 0){
    r /= 255.0;
  }
  if(g != 0){
    g /= 255.0;
  }
  if(b != 0){
    b /= 255.0;
  }

  var hsv = EDT.tcs.rgb2hsv(r, g, b);
  EDT.tcs.setColor(hsv.h, hsv.s, hsv.v);
}

function openFrameColorDialog()
{
  if(EDT.tcs == null){
    EDT.frameColorDialogOpen = true;
    tcs_initialize();
    var tcsElm = document.getElementById("trianglecolorselector");
    tcsElm.style.top = EDT.pickerTopOffset + "px";

    var hexClearElm = document.getElementById("tcs-hexclear");
    hexClearElm.style.display = "none";

    var contents = getSpriteContents(PLG.fixedSprite);
    setColor2Selector(contents.style.borderTopColor, "#000000");

    document.getElementById("tcs-title").innerHTML = "[Frame]";
  }
  else if(EDT.frameColorDialogOpen){
    EDT.frameColorDialogOpen = false;
    var editorElm = document.getElementById("editor");
    var tcsElm = document.getElementById("trianglecolorselector");
    if(tcsElm != null && tcsElm != undefined){
      editorElm.removeChild(tcsElm);
    }
    EDT.tcs = null;
  }
  else if(EDT.bgColorDialogOpen || EDT.foreColorDialogOpen){
    EDT.frameColorDialogOpen = true;
    EDT.bgColorDialogOpen = false;
    EDT.foreColorDialogOpen = false;

    var hexClearElm = document.getElementById("tcs-hexclear");
    hexClearElm.style.display = "none";

    var contents = getSpriteContents(PLG.fixedSprite);
    setColor2Selector(contents.style.borderTopColor, "#000000");

    document.getElementById("tcs-title").innerHTML = "[Frame]";
  }
}



function openBgColorDialog()
{
  if(EDT.tcs == null){
    EDT.bgColorDialogOpen = true;
    tcs_initialize();
    var tcsElm = document.getElementById("trianglecolorselector");
    tcsElm.style.top = EDT.pickerTopOffset + "px";

    var hexClearElm = document.getElementById("tcs-hexclear");
    hexClearElm.style.display = "block";

    var contents = getSpriteContents(PLG.fixedSprite);
    setColor2Selector(contents.style.backgroundColor, "#ffffff");

    document.getElementById("tcs-title").innerHTML = "[Background]";
  }
  else if(EDT.bgColorDialogOpen){
    EDT.bgColorDialogOpen = false;
    var editorElm = document.getElementById("editor");
    var tcsElm = document.getElementById("trianglecolorselector");
    if(tcsElm != null && tcsElm != undefined){
      editorElm.removeChild(tcsElm);
    }
    EDT.tcs = null;
  }
  else if(EDT.frameColorDialogOpen || EDT.foreColorDialogOpen){
    EDT.bgColorDialogOpen = true;
    EDT.frameColorDialogOpen = false;
    EDT.foreColorDialogOpen = false;

    var hexClearElm = document.getElementById("tcs-hexclear");
    hexClearElm.style.display = "block";

    var contents = getSpriteContents(PLG.fixedSprite);
    setColor2Selector(contents.style.backgroundColor, "#ffffff");

    document.getElementById("tcs-title").innerHTML = "[Background]";
  }
}


function openForeColorDialog()
{
  if(EDT.tcs == null){
    EDT.foreColorDialogOpen = true;
    tcs_initialize();
    var tcsElm = document.getElementById("trianglecolorselector");
    tcsElm.style.top = EDT.pickerTopOffset + "px";

    var hexClearElm = document.getElementById("tcs-hexclear");
    hexClearElm.style.display = "none";

    var contents = getSpriteContents(PLG.fixedSprite);
    setColor2Selector(contents.style.color, "#000000");

    document.getElementById("tcs-title").innerHTML = "[Text]";
  }
  else if(EDT.foreColorDialogOpen){
    EDT.foreColorDialogOpen = false;
    var editorElm = document.getElementById("editor");
    var tcsElm = document.getElementById("trianglecolorselector");
    if(tcsElm != null && tcsElm != undefined){
      editorElm.removeChild(tcsElm);
    }
    EDT.tcs = null;
  }
  else if(EDT.frameColorDialogOpen || EDT.bgColorDialogOpen){
    EDT.foreColorDialogOpen = true;
    EDT.frameColorDialogOpen = false;
    EDT.bgColorDialogOpen = false;

    var hexClearElm = document.getElementById("tcs-hexclear");
    hexClearElm.style.display = "none";

    var contents = getSpriteContents(PLG.fixedSprite);
    setColor2Selector(contents.style.color, "#000000");

    document.getElementById("tcs-title").innerHTML = "[Text]";
  }
}

function openPenColorDialog()
{
  if(EDT.tcs == null){
    EDT.penColorDialogOpen = true;
    tcs_initialize();
    var tcsElm = document.getElementById("trianglecolorselector");
    tcsElm.style.top = "24px";
    tcsElm.style.left = ((document.getElementById("controlpanel")).offsetWidth - tcsElm.offsetWidth) + "px";
    var hexClearElm = document.getElementById("tcs-hexclear");
    hexClearElm.style.display = "none";
    setColor2Selector("#000000", "#000000");

		var barElm = document.createElement("div");
		barElm.setAttribute("id", "drawingtitlebar");
		barElm.style.top = "6px";
		barElm.style.left = tcsElm.style.left;
		barElm.style.width = tcsElm.style.width;
		barElm.style.height = "18px";
		var worldElm = document.getElementById("spritesworld");;
		worldElm.appendChild(barElm);
  }
}

function closePenColorDialog()
{
  if(EDT.tcs != null){
    EDT.penColorDialogOpen = false;
    var worldElm = document.getElementById("spritesworld");
    var tcsElm = document.getElementById("trianglecolorselector");
    if(tcsElm != null && tcsElm != undefined){
      worldElm.removeChild(tcsElm);
    }
    EDT.tcs = null;

    var barElm = document.getElementById("drawingtitlebar");
		worldElm.removeChild(barElm);
  }
}

function closeTCS()
{
  if(EDT.tcs != null){
    EDT.frameColorDialogOpen = false;
    EDT.bgColorDialogOpen = false;
    EDT.foreColorDialogOpen = false;
    var editorElm = document.getElementById("editor");
    var tcsElm = document.getElementById("trianglecolorselector");
    if(tcsElm != null && tcsElm != undefined){
      editorElm.removeChild(tcsElm);
    }
    EDT.tcs = null;
  }
}


//------------------------------------
// Close Editor
//------------------------------------
function editorControlCloseOnMouseDown()
{
  if(document.getElementById("fileuploadframe")){
    return;
  }
  if(document.getElementById("plugin-dialog")){
    return;
  }

	closeTCS();

  PLG.fixedSprite.style.zIndex = originalZindex;

  var contents = getSpriteContents(PLG.fixedSprite);
  contents.style.borderWidth = EDT.orgBorderWidth;
  contents.style.borderColor = EDT.orgBorderColor;
  contents.style.borderStyle = EDT.orgBorderStyle;
  contents.style.backgroundColor = EDT.orgBackgroundColor;
  contents.style.color = EDT.orgForegroundColor;
  contents.style.padding = EDT.orgPadding;

  var id = PLG.fixedSprite.id;
  clearSelectedSprite();
  setSelectedSprite(document.getElementById(id));

  var spritesWorldNode = document.getElementById("spritesworld");
  spritesWorldNode.removeChild(document.getElementById("editor"));

	PLG.state = STATES.FIXEDSELECTED;
	setSelectedSprite(PLG.fixedSprite);
	setSpriteIcons(PLG.fixedSprite);
	setFixedFrame(PLG.fixedSprite);
}


//------------------------------------
// Open Editor
//------------------------------------

function isNewSprite(sprite)
{
  var contentsElm = getSpriteContents(sprite);
  if(contentsElm.innerHTML.match(/<br>\nNew sprite\n<br>\n<br>/i)
     || contentsElm.innerHTML.match(/<br>New sprite <br><br>/i)
     || contentsElm.innerHTML.match(/<br\/>\nNew Sprite\n<br\/>\n<br\/>\n/i)
		 || contentsElm.innerHTML.match(/<br>\nNew comment\n<br>\n<br>/i)
     || contentsElm.innerHTML.match(/<br>New comment <br><br>/i)
     || contentsElm.innerHTML.match(/<br\/>\nNew comment\n<br\/>\n<br\/>\n/i)){
			 return true;
		 }
  else{
    return false;
  }
  
}

function openEditor()
{
  if(!document.getElementById("editor")){
		enableSelection();

    // Backup original data
    var contentsElm = getSpriteContents(PLG.fixedSprite);
    EDT.orgInnerHtml = contentsElm.innerHTML;
    originalZindex = PLG.orgZindexOfSelectedSprite;

		// Load user profile
    var profUserName = PLG.sprites[PLG.fixedSprite.id].author;
    if(profUserName.match(/^&lt;(.+)&gt;$/)  || profUserName.match(/^\[(.+)\]$/)){
			profUserName = RegExp.$1;
			if(profUserName == "public"){
				profUserName = getCookie("public_author");
				profUserName = decodeURIComponent(profUserName);
			}
      if(profUserName == undefined){
        profUserName = "public";
      }
      else{
        profUserName = profUserName;
      }
		}
		profUserName = encodeURIComponent(profUserName);

		var userProf = getCookie("prof_"+profUserName);
		var frameColorValue = "";
		var bgColorValue = "";
		var fgColorValue = "";
		var showDateFlag = "";
		var showLinkFlag = "";
		var showAuthorFlag = "";
		var frameStyleValue = "";
		var frameWidthValue = "";
		var framePaddingValue = "";

		if(userProf != undefined){
			var profArray = userProf.split(",");
			for(var i=0; i<profArray.length; i++){
				var myProf = profArray[i];
				var myProfArray = myProf.split(":");
				var key = myProfArray[0];
				var value = myProfArray[1];
				if(key == "frameColor"){
					frameColorValue = value;
				}
				else if(key == "bgColor"){
					bgColorValue = value;
				}
				else if(key == "fgColor"){
					fgColorValue = value;
				}
				else if(key == "fgColor"){
					fgColorValue = value;
				}
				else if(key == "showDate"){
					showDateFlag = value;
				}
				else if(key == "showAuthor"){
					showAuthorFlag = value;
				}
				else if(key == "showLink"){
					showLinkFlag = value;
				}
				else if(key == "frameStyle"){
					frameStyleValue = value;
				}
				else if(key == "frameWidth"){
					frameWidthValue = value;
				}
				else if(key == "framePadding"){
					framePaddingValue = value;
				}
			}
		}

    if(isNewSprite(PLG.fixedSprite)){
      contentsElm.style.backgroundColor = "";
      contentsElm.style.textAlign = "left";
      contentsElm.style.padding = "0px";
      contentsElm.style.borderColor = "#000000";
      contentsElm.style.borderStyle = "none";
      contentsElm.style.borderWidth = "0px";

			if(frameColorValue != ""){
				contentsElm.style.borderColor = decodeURIComponent(frameColorValue);
			}
			if(bgColorValue != ""){
				contentsElm.style.backgroundColor = decodeURIComponent(bgColorValue);
			}
			if(fgColorValue != ""){
				contentsElm.style.color = decodeURIComponent(fgColorValue);
			}

    }

    PLG.fixedSprite.style.zIndex = ZIND.GO_TEMP_FOREGROUND;

		removeSpriteIcons();
    clearSelectedSprite();
		PLG.state = STATES.EDITING;

    // form 
    var editorForm = document.createElement("form");
    editorForm.setAttribute("id", "editor");
    editorForm.onsubmit = function(){ return false; }


    var spriteWidth = sprWidth(PLG.fixedSprite);
    var spriteHeight = sprHeight(PLG.fixedSprite);
    if(spriteHeight > 100){
      spriteHeight = 100;
    }
    
    var spriteLeft = sprLeftAbs(PLG.fixedSprite);
    var spriteTop = sprTopAbs(PLG.fixedSprite);

    var formWidth = 480;
    var formHeight = 0;
    var browserHeight = getInnerHeight();

    formHeight = browserHeight / 2;

    var editorWidth = formWidth + 1;
    var editorHeight = formHeight + 88;
    var editorLeft = spriteLeft + PLG.viewPositionX + 30;
    var editorTop = spriteTop + PLG.viewPositionY + spriteHeight;

		var spritesWorldNode = document.getElementById("spritesworld");
    if(editorLeft + editorWidth > spritesWorldNode.offsetWidth){
      editorLeft -= editorLeft + editorWidth  - spritesWorldNode.offsetWidth + 5;
    }
//    if(editorTop + editorHeight > spritesWorldNode.offsetHeight - document.getElementById("footer").offsetHeight){
    if(editorTop > spritesWorldNode.offsetHeight/2){
      editorTop = spriteTop + PLG.viewPositionY - editorHeight - 30 ;
    }
    if(PLG.cb.bw.msie){
			editorTop = 30;
		}
		if(editorTop < 30){
			editorTop = 30;
		}
    if(editorLeft < 0){
      editorLeft = 0;
    }

    editorForm.style.width = editorWidth.toString() + "px";
    editorForm.style.height = editorHeight.toString() + "px";
    editorForm.style.left = editorLeft.toString() + "px";
    editorForm.style.top = editorTop.toString() + "px";

    // controlPanel for editor
    var editorControlElm = document.createElement("div");
    editorControlElm.setAttribute("id", "editor-control");
    editorControlElm.onmousedown = function(){
			if(PLG.movingEditorFlag){
				return;
			}
			PLG.movingEditorFlag = true;
		}


    // save btn
    var editorControlSaveElm = document.createElement("img");
    editorControlSaveElm.setAttribute("src", PARAM.IMAGEFILEPATH + "save.gif");
    editorControlSaveElm.setAttribute("id", "editor-savebtn");
    editorControlSaveElm.style.verticalAlign = "middle";
    if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
      editorControlSaveElm.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
    }
    editorControlElm.appendChild(editorControlSaveElm);

    // top btn
    var editorControlTopElm = document.createElement("img");
    editorControlTopElm.setAttribute("src", PARAM.IMAGEFILEPATH + "top.gif");
    editorControlTopElm.setAttribute("id", "editor-topbtn");
    editorControlTopElm.style.verticalAlign = "middle";
    if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
      editorControlTopElm.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
    }
    editorControlElm.appendChild(editorControlTopElm);

    // bottom btn
    var editorControlBottomElm = document.createElement("img");
    editorControlBottomElm.setAttribute("src", PARAM.IMAGEFILEPATH + "bottom.gif");
    editorControlBottomElm.setAttribute("id", "editor-bottombtn");
    editorControlBottomElm.style.verticalAlign = "middle";
    if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
      editorControlBottomElm.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
    }
    editorControlElm.appendChild(editorControlBottomElm);

    // close btn
    var editorControlCloseElm = document.createElement("img");
    editorControlCloseElm.setAttribute("src", PARAM.IMAGEFILEPATH + "close.gif");
    editorControlCloseElm.setAttribute("id", "editor-closebtn");
    editorControlCloseElm.style.verticalAlign = "middle";
    if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
      editorControlCloseElm.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
    }
    editorControlElm.appendChild(editorControlCloseElm);

    // id
    var editorIdElm = document.createElement("div");
    editorIdElm.setAttribute("id", "editor-id");
    editorIdElm.appendChild(document.createTextNode(""));
    editorIdElm.innerHTML = PLG.fixedSprite.id;
    editorControlElm.appendChild(editorIdElm);

    editorForm.appendChild(editorControlElm);


    // controlPanel for editor 2
    var editorControlElm2 = document.createElement("div");
    editorControlElm2.setAttribute("id", "editor-control2");

    // time
    var editorDateElm = document.createElement("div");
    editorDateElm.setAttribute("id", "editor-date");
		var date = new String(PLG.sprites[PLG.fixedSprite.id].time);
    var dateValue = date.substring(0,4) + "/" + date.substring(4,6) + "/" + date.substring(6,8) + " " + date.substring(8,10) + ":" + date.substring(10,12) + ":" + date.substring(12,14);
    editorDateElm.appendChild(document.createTextNode(dateValue));
    editorControlElm2.appendChild(editorDateElm);

    // show date
    var editorShowDateElm = document.createElement("input");
    editorShowDateElm.setAttribute("id", "editor-showdate");
    editorShowDateElm.setAttribute("type", "checkbox");
    editorShowDateElm.setAttribute("value", "1");
    if(getSpriteInfo(PLG.fixedSprite, "spritedate")){
      editorShowDateElm.defaultChecked = true;
    }
    if(isNewSprite(PLG.fixedSprite)){
			if(showDateFlag != ""){
				if(showDateFlag == "true"){
					editorShowDateElm.defaultChecked = true;
				}
				else{
					editorShowDateElm.defaultChecked = false;
				}
			}
		}
    if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
      editorShowDateElm.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
    }
    editorControlElm2.appendChild(editorShowDateElm);


    // link
    var linkElm = document.createElement("div");
    linkElm.setAttribute("id", "editor-link");
    linkElm.appendChild(document.createTextNode(""));
    PARAM.id = PLG.fixedSprite.id;
    var urlArray = location.href.split("?");
    var newURL = urlArray[0] + "?" + "load=" + PARAM.pageid + "&id=" + PARAM.id;
    linkElm.innerHTML = "<a href='" + newURL + "'>link</a> ";
    editorControlElm2.appendChild(linkElm);

    // show link
    var editorShowLinkElm = document.createElement("input");
    editorShowLinkElm.setAttribute("id", "editor-showlink");
    editorShowLinkElm.setAttribute("type", "checkbox");
    editorShowLinkElm.setAttribute("value", "1");
    if(getSpriteInfo(PLG.fixedSprite, "spriteuri")){
      editorShowLinkElm.defaultChecked = true;
    }
    if(isNewSprite(PLG.fixedSprite)){
			if(showLinkFlag != ""){
				if(showLinkFlag == "true"){
					editorShowLinkElm.defaultChecked = true;
				}
				else{
					editorShowLinkElm.defaultChecked = false;
				}
			}
		}
    if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
      editorShowLinkElm.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
    }
    editorControlElm2.appendChild(editorShowLinkElm);



    // file upload
    if(parseInt(PARAM.attachedSprite) == 1){
      var editorFileUploadElm = document.createElement("input");
      editorFileUploadElm.setAttribute("id", "editor-fileuploadbtn");
      editorFileUploadElm.setAttribute("type", "button");
      editorFileUploadElm.setAttribute("value", "file");
      editorFileUploadElm.onclick = openFileUploader;
      editorControlElm2.appendChild(editorFileUploadElm);

      if(PARAM.sprite_html != 1){
        var attachedfilename = "";
        var attachedTestHtml = getSpriteContents(PLG.fixedSprite).innerHTML;
        if(attachedTestHtml.match(/<img.*?src=\"(.+?)\".*?>/i)){
          attachedfilename = RegExp.$1;
          var pathArray = attachedfilename.split("/");
          attachedfilename = pathArray[pathArray.length-1];
        }
        if(attachedTestHtml.match(/<a.*?class=.?attachedfile.*?>/i)){
          if(attachedTestHtml.match(/<a.*?href=\"(.+?)\".*?>/i))
						{
							attachedfilename = RegExp.$1;
							var pathArray = attachedfilename.split("/");
							attachedfilename = pathArray[pathArray.length-1];
						}
        }

        if(attachedfilename != ""){
          var editorFileClearElm = document.createElement("input");
          editorFileClearElm.setAttribute("id", "editor-fileclearbtn");
          editorFileClearElm.setAttribute("type", "button");
          editorFileClearElm.setAttribute("value", "clear");
          editorFileClearElm.onclick = function(){
						document.getElementById("editor-filename").innerHTML = "";
					}

          editorControlElm2.appendChild(editorFileClearElm);
        }

        var editorFileNameElm = document.createElement("div");
        editorFileNameElm.setAttribute("id", "editor-filename");
        editorFileNameElm.appendChild(document.createTextNode(attachedfilename));
        editorControlElm2.appendChild(editorFileNameElm);
      }
    }

    if(parseInt(PARAM.superSprite) == 1){
      var editorPluginElm = document.createElement("input");
      editorPluginElm.setAttribute("id", "editor-pluginbtn");
      editorPluginElm.setAttribute("type", "button");
      editorPluginElm.setAttribute("value", "plugin")
      editorPluginElm.onclick = openPluginDialog;
      editorControlElm2.appendChild(editorPluginElm);

      var editorPluginNameElm = document.createElement("div");
      editorPluginNameElm.setAttribute("id", "editor-pluginname");

      var pluginName = "";
      var pluginStr = getSpriteInfo(PLG.fixedSprite, "spriteplugin").innerHTML;
      var pluginArray = pluginStr.split(",");
      if(pluginArray.length >= 1){
        pluginName = pluginArray[0];
      }
      editorPluginNameElm.appendChild(document.createTextNode(pluginName));
      editorControlElm2.appendChild(editorPluginNameElm);
    }

    editorForm.appendChild(editorControlElm2);


    // controlPanel for editor 3
    var editorControlElm3 = document.createElement("div");
    editorControlElm3.setAttribute("id", "editor-control3");

    // author
    var authorName = PLG.sprites[PLG.fixedSprite.id].author;
		var pubauthor = "";
    if(authorName.match(/^&lt;(.+)&gt;$/)  || authorName.match(/^\[(.+)\]$/)){
			pubauthor = RegExp.$1;
      var authorTitleElm = document.createElement("div");
      authorTitleElm.setAttribute("id", "editor-authortitle");
      authorTitleElm.appendChild(document.createTextNode("author "));
      editorControlElm3.appendChild(authorTitleElm);

      // author field
      var authorFieldElm = document.createElement("input");
      authorFieldElm.setAttribute("type", "text");
      authorFieldElm.setAttribute("id", "editor-author");
      authorFieldElm.setAttribute("size", "15");
      authorFieldElm.style.verticalAlign = "middle";

			if(pubauthor == "public"){
				pubauthor = getCookie("public_author");
			}

      if(pubauthor == undefined){
        pubauthor = "public";
      }
      else{
        pubauthor = decodeURIComponent(pubauthor);
      }
      authorFieldElm.value = pubauthor;
      editorControlElm3.appendChild(authorFieldElm);
    }
    else{
      var editorAuthorElm = document.createElement("div");
      editorAuthorElm.setAttribute("id", "editor-authortitle");
      editorAuthorElm.appendChild(document.createTextNode("author [ " + authorName + " ]"));
      editorControlElm3.appendChild(editorAuthorElm);
    }

    // show author
    var editorShowAuthorElm = document.createElement("input");
    editorShowAuthorElm.setAttribute("id", "editor-showauthor");
    editorShowAuthorElm.setAttribute("type", "checkbox");
    editorShowAuthorElm.setAttribute("value", "1");
    if(getSpriteInfo(PLG.fixedSprite, "spriteauthor")){
      editorShowAuthorElm.defaultChecked = true;
    }
    if(isNewSprite(PLG.fixedSprite)){
			if(showAuthorFlag != ""){
				if(showAuthorFlag == "true"){
					editorShowAuthorElm.defaultChecked = true;
				}
				else{
					editorShowAuthorElm.defaultChecked = false;
				}
			}
		}
    if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
      editorShowAuthorElm.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand3.cur), default";
    }
    editorControlElm3.appendChild(editorShowAuthorElm);


    if(authorName.match(/^&lt;.+&gt;$/)  || authorName.match(/^\[.+\]$/)){
      var passElm = document.createElement("div");
      passElm.setAttribute("id", "editor-passtitle");
      passElm.appendChild(document.createTextNode(""));
      passElm.innerHTML = "password";
      editorControlElm3.appendChild(passElm);

      // password field
      var editorControlPasswordElm = document.createElement("input");
      editorControlPasswordElm.setAttribute("type", "password");
      editorControlPasswordElm.setAttribute("id", "editor-password");
      editorControlPasswordElm.setAttribute("size", "8");
      editorControlPasswordElm.style.verticalAlign = "middle";
      var pass = getCookie("public_password");

      var contentsElm = getSpriteContents(PLG.fixedSprite);
      
			if(pass == undefined){
				pass = "";
      }
      if(authorName.match(/^\[.+\]$/) && !isNewSprite(PLG.fixedSprite)){
        pass = "";
      }

      editorControlPasswordElm.value = pass;
      editorControlElm3.appendChild(editorControlPasswordElm);

      var clearpassElm = document.createElement("input");
      clearpassElm.setAttribute("id", "editor-clearpass");
      clearpassElm.setAttribute("type", "button");
      clearpassElm.setAttribute("value", "clear");
      clearpassElm.onclick = function(){
        // clear password of public user
				var passwordElm = document.getElementById("editor-password");
				public_password = passwordElm.value;
				var postdata = "&command=clearpassword&id="+ PLG.fixedSprite.id + "&pageid="+PARAM.pageid + "&public_password="+public_password;


				var clearPasswordOnLoaded = function(obj){
					var res = obj.responseText;
					if (res == "invalid_public_password"){
						document.getElementById("controlresult").innerHTML="Please enter the valid password.";
					}
					else if(res == "clearpassword"){
						var passwordElm = document.getElementById("editor-password");
						passwordElm.value = "";
						document.getElementById("controlresult").innerHTML="The password is cleared.";
						setCookie("public_password", "", PARAM.CGIFILEPATH, 30);
					}
					else{
						document.getElementById("controlresult").innerHTML=res;
					}
				}
				sendRequest(clearPasswordOnLoaded, postdata, "POST", PARAM.CGIFILEPATH + "saveSprite.cgi", true, true);
			}

      editorControlElm3.appendChild(clearpassElm);
    }

    editorForm.appendChild(editorControlElm3);


    var contentsElm = getSpriteContents(PLG.fixedSprite);

    // controlPanel for editor 4
    // select frame color, width, type ...
    var editorControlElm4 = document.createElement("div");
    editorControlElm4.setAttribute("id", "editor-control4");

    var foreColorElm = document.createElement("input");
    foreColorElm.setAttribute("id", "editor-forecolorbtn");
    foreColorElm.setAttribute("type", "button");
    foreColorElm.setAttribute("value", "text");
    foreColorElm.onclick = openForeColorDialog;
    editorControlElm4.appendChild(foreColorElm);

    var bgColorElm = document.createElement("input");
    bgColorElm.setAttribute("id", "editor-bgcolorbtn");
    bgColorElm.setAttribute("type", "button");
    bgColorElm.setAttribute("value", "bg");
    bgColorElm.onclick = openBgColorDialog;
    editorControlElm4.appendChild(bgColorElm);


    var frameColorElm = document.createElement("input");
    frameColorElm.setAttribute("id", "editor-framecolorbtn");
    frameColorElm.setAttribute("type", "button");
    frameColorElm.setAttribute("value", "frame");
    frameColorElm.onclick = openFrameColorDialog;
    editorControlElm4.appendChild(frameColorElm);

    var frameSelectorElm = document.createElement("select");
    frameSelectorElm.setAttribute("id", "editor-frameselector");

    var frameSizeSelectorElm = document.createElement("select");
    frameSizeSelectorElm.setAttribute("id", "editor-framesizeselector");


    var frameOption1 = document.createElement("option");
    frameOption1.setAttribute("value", "none");
    frameOption1.appendChild(document.createTextNode("-"));
    var frameOption2 = document.createElement("option");
    frameOption2.setAttribute("value", "solid");
    frameOption2.appendChild(document.createTextNode("実線"));
    var frameOption3 = document.createElement("option");
    frameOption3.setAttribute("value", "double");
    frameOption3.appendChild(document.createTextNode("二重線"));
    var frameOption4 = document.createElement("option");
    frameOption4.setAttribute("value", "dotted");
    frameOption4.appendChild(document.createTextNode("点線"));
    var frameOption5 = document.createElement("option");
    frameOption5.setAttribute("value", "dashed");
    frameOption5.appendChild(document.createTextNode("破線"));
    var frameOption6 = document.createElement("option");
    frameOption6.setAttribute("value", "groove");
    frameOption6.appendChild(document.createTextNode("溝線"));
    var frameOption7 = document.createElement("option");
    frameOption7.setAttribute("value", "ridge");
    frameOption7.appendChild(document.createTextNode("稜線"));
    var frameOption8 = document.createElement("option");
    frameOption8.setAttribute("value", "inset");
    frameOption8.appendChild(document.createTextNode("陥没"));
    var frameOption9 = document.createElement("option");
    frameOption9.setAttribute("value", "outset");
    frameOption9.appendChild(document.createTextNode("浮上"));

    frameSelectorElm.appendChild(frameOption1);
    frameSelectorElm.appendChild(frameOption2);
    frameSelectorElm.appendChild(frameOption3);
    frameSelectorElm.appendChild(frameOption4);
    frameSelectorElm.appendChild(frameOption5);
    frameSelectorElm.appendChild(frameOption6);
    frameSelectorElm.appendChild(frameOption7);
    frameSelectorElm.appendChild(frameOption8);
    frameSelectorElm.appendChild(frameOption9);

    frameSelectorElm.onchange = function(){
			contentsElm.style.borderStyle = frameSelectorElm.options[frameSelectorElm.selectedIndex].value;
			if(contentsElm.style.borderTopWidth == "0px" && frameSelectorElm.selectedIndex != 0){
				contentsElm.style.borderWidth = "1px";
				frameSizeSelectorElm.selectedIndex = 1;
			}

		}

    editorControlElm4.appendChild(frameSelectorElm);

    if(isNewSprite(PLG.fixedSprite)){
			if(frameStyleValue != ""){
				contentsElm.style.borderStyle = frameStyleValue;
			}
		}

    if(contentsElm.style.borderTopStyle == "none"){
      frameSelectorElm.selectedIndex = 0;
    } 
    else if(contentsElm.style.borderTopStyle == "solid"){
      frameSelectorElm.selectedIndex = 1;
    } 
    else if(contentsElm.style.borderTopStyle == "double"){
      frameSelectorElm.selectedIndex = 2;
    } 
    else if(contentsElm.style.borderTopStyle == "dotted"){
      frameSelectorElm.selectedIndex = 3;
    } 
    else if(contentsElm.style.borderTopStyle == "dashed"){
      frameSelectorElm.selectedIndex = 4;
    } 
    else if(contentsElm.style.borderTopStyle == "groove"){
      frameSelectorElm.selectedIndex = 5;
    } 
    else if(contentsElm.style.borderTopStyle == "ridge"){
      frameSelectorElm.selectedIndex = 6;
    } 
    else if(contentsElm.style.borderTopStyle == "inset"){
      frameSelectorElm.selectedIndex = 7;
    } 
    else if(contentsElm.style.borderTopStyle == "outset"){
      frameSelectorElm.selectedIndex = 8;
    } 



    var frameSizeOption1 = document.createElement("option");
    frameSizeOption1.setAttribute("value", "0px");
    frameSizeOption1.appendChild(document.createTextNode("-"));
    var frameSizeOption2 = document.createElement("option");
    frameSizeOption2.setAttribute("value", "1px");
    frameSizeOption2.appendChild(document.createTextNode("1"));
    var frameSizeOption3 = document.createElement("option");
    frameSizeOption3.setAttribute("value", "2px");
    frameSizeOption3.appendChild(document.createTextNode("2"));
    var frameSizeOption4 = document.createElement("option");
    frameSizeOption4.setAttribute("value", "3px");
    frameSizeOption4.appendChild(document.createTextNode("3"));
    var frameSizeOption5 = document.createElement("option");
    frameSizeOption5.setAttribute("value", "4px");
    frameSizeOption5.appendChild(document.createTextNode("4"));
    var frameSizeOption6 = document.createElement("option");
    frameSizeOption6.setAttribute("value", "6px");
    frameSizeOption6.appendChild(document.createTextNode("6"));
    var frameSizeOption7 = document.createElement("option");
    frameSizeOption7.setAttribute("value", "8px");
    frameSizeOption7.appendChild(document.createTextNode("8"));
    var frameSizeOption8 = document.createElement("option");
    frameSizeOption8.setAttribute("value", "10px");
    frameSizeOption8.appendChild(document.createTextNode("10"));
    var frameSizeOption9 = document.createElement("option");
    frameSizeOption9.setAttribute("value", "12px");
    frameSizeOption9.appendChild(document.createTextNode("12"));

    frameSizeSelectorElm.appendChild(frameSizeOption1);
    frameSizeSelectorElm.appendChild(frameSizeOption2);
    frameSizeSelectorElm.appendChild(frameSizeOption3);
    frameSizeSelectorElm.appendChild(frameSizeOption4);
    frameSizeSelectorElm.appendChild(frameSizeOption5);
    frameSizeSelectorElm.appendChild(frameSizeOption6);
    frameSizeSelectorElm.appendChild(frameSizeOption7);
    frameSizeSelectorElm.appendChild(frameSizeOption8);
    frameSizeSelectorElm.appendChild(frameSizeOption9);

    frameSizeSelectorElm.onchange = function(){
			contentsElm.style.borderWidth = frameSizeSelectorElm.options[frameSizeSelectorElm.selectedIndex].value;
		}

    editorControlElm4.appendChild(frameSizeSelectorElm);

    if(isNewSprite(PLG.fixedSprite)){
			if(frameWidthValue != ""){
				contentsElm.style.borderWidth = frameWidthValue;
			}
		}

    if(contentsElm.style.borderTopWidth == "0px"){
      frameSizeSelectorElm.selectedIndex = 0;
    } 
    else if(contentsElm.style.borderTopWidth == "1px"){
      frameSizeSelectorElm.selectedIndex = 1;
    } 
    else if(contentsElm.style.borderTopWidth == "2px"){
      frameSizeSelectorElm.selectedIndex = 2;
    } 
    else if(contentsElm.style.borderTopWidth == "3px"){
      frameSizeSelectorElm.selectedIndex = 3;
    } 
    else if(contentsElm.style.borderTopWidth == "4px"){
      frameSizeSelectorElm.selectedIndex = 4;
    } 
    else if(contentsElm.style.borderTopWidth == "6px"){
      frameSizeSelectorElm.selectedIndex = 5;
    } 
    else if(contentsElm.style.borderTopWidth == "8px"){
      frameSizeSelectorElm.selectedIndex = 6;
    } 
    else if(contentsElm.style.borderTopWidth == "10px"){
      frameSizeSelectorElm.selectedIndex = 7;
    } 
    else if(contentsElm.style.borderTopWidth == "12px"){
      frameSizeSelectorElm.selectedIndex = 8;
    } 

    var framePaddingSelectorTitleElm = document.createElement("div");
    framePaddingSelectorTitleElm.setAttribute("id", "editor-framepaddingselectortitle");
    framePaddingSelectorTitleElm.appendChild(document.createTextNode("margin"));
    editorControlElm4.appendChild(framePaddingSelectorTitleElm);


    var framePaddingSelectorElm = document.createElement("select");
    framePaddingSelectorElm.setAttribute("id", "editor-framepaddingselector");
    var framePaddingOption1 = document.createElement("option");
    framePaddingOption1.setAttribute("value", "0px");
    framePaddingOption1.appendChild(document.createTextNode("0"));
    var framePaddingOption2 = document.createElement("option");
    framePaddingOption2.setAttribute("value", "1px");
    framePaddingOption2.appendChild(document.createTextNode("1"));
    var framePaddingOption3 = document.createElement("option");
    framePaddingOption3.setAttribute("value", "2px");
    framePaddingOption3.appendChild(document.createTextNode("2"));
    var framePaddingOption4 = document.createElement("option");
    framePaddingOption4.setAttribute("value", "3px");
    framePaddingOption4.appendChild(document.createTextNode("3"));
    var framePaddingOption5 = document.createElement("option");
    framePaddingOption5.setAttribute("value", "4px");
    framePaddingOption5.appendChild(document.createTextNode("4"));
    var framePaddingOption6 = document.createElement("option");
    framePaddingOption6.setAttribute("value", "6px");
    framePaddingOption6.appendChild(document.createTextNode("6"));
    var framePaddingOption7 = document.createElement("option");
    framePaddingOption7.setAttribute("value", "8px");
    framePaddingOption7.appendChild(document.createTextNode("8"));
    var framePaddingOption8 = document.createElement("option");
    framePaddingOption8.setAttribute("value", "10px");
    framePaddingOption8.appendChild(document.createTextNode("10"));
    var framePaddingOption9 = document.createElement("option");
    framePaddingOption9.setAttribute("value", "12px");
    framePaddingOption9.appendChild(document.createTextNode("12"));

    framePaddingSelectorElm.appendChild(framePaddingOption1);
    framePaddingSelectorElm.appendChild(framePaddingOption2);
    framePaddingSelectorElm.appendChild(framePaddingOption3);
    framePaddingSelectorElm.appendChild(framePaddingOption4);
    framePaddingSelectorElm.appendChild(framePaddingOption5);
    framePaddingSelectorElm.appendChild(framePaddingOption6);
    framePaddingSelectorElm.appendChild(framePaddingOption7);
    framePaddingSelectorElm.appendChild(framePaddingOption8);
    framePaddingSelectorElm.appendChild(framePaddingOption9);

    framePaddingSelectorElm.onchange = function(){
			contentsElm.style.padding = framePaddingSelectorElm.options[framePaddingSelectorElm.selectedIndex].value;
		}

    editorControlElm4.appendChild(framePaddingSelectorElm);

    if(isNewSprite(PLG.fixedSprite)){
			if(framePaddingValue != ""){
				contentsElm.style.padding = framePaddingValue;
			}
		}

		if(contentsElm.style.paddingTop == "0px"){
			framePaddingSelectorElm.selectedIndex = 0;
		} 
		else if(contentsElm.style.paddingTop == "1px"){
			framePaddingSelectorElm.selectedIndex = 1;
		} 
		else if(contentsElm.style.paddingTop == "2px"){
			framePaddingSelectorElm.selectedIndex = 2;
		} 
		else if(contentsElm.style.paddingTop == "3px"){
			framePaddingSelectorElm.selectedIndex = 3;
		} 
		else if(contentsElm.style.paddingTop == "4px"){
			framePaddingSelectorElm.selectedIndex = 4;
		} 
		else if(contentsElm.style.paddingTop == "6px"){
			framePaddingSelectorElm.selectedIndex = 5;
		} 
		else if(contentsElm.style.paddingTop == "8px"){
			framePaddingSelectorElm.selectedIndex = 6;
		} 
		else if(contentsElm.style.paddingTop == "10px"){
			framePaddingSelectorElm.selectedIndex = 7;
		} 
		else if(contentsElm.style.paddingTop == "12px"){
			framePaddingSelectorElm.selectedIndex = 8;
		} 

		editorForm.appendChild(editorControlElm4);


  // textarea
		var editorTextAreaElm = document.createElement("textarea");
		editorTextAreaElm.setAttribute("id", "editor-textarea");

		var innerHtml = "";
		if(isNewSprite(PLG.fixedSprite)){
			innerHtml = "";
		}
		else{
			innerHtml = contentsElm.innerHTML;
			
			if(PARAM.sprite_html != 1){
				innerHtml = innerHtml.replace(/<img.*?src=\".+?\".*?>/i,"");
				innerHtml = innerHtml.replace(/<a.*?class=.?attachedfile.*?>.*?<\/a>/i,"");
			}
			
			if(PARAM.sprite_autobr == 1){
				if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
					innerHtml = innerHtml.replace(/<br>/gi,"\r");
				}
				else{
					innerHtml = innerHtml.replace(/<br>/gi,"");
					innerHtml = innerHtml.replace(/<br\/>/gi,"");
				}

			}
			if(PARAM.sprite_autolink == 1){
				innerHtml = innerHtml.replace(/<a href=\".+?\">/gi,"");
				innerHtml = innerHtml.replace(/<\/a>/gi,"");
			}
		}
		
		var textareaTextNode = document.createTextNode(innerHtml);
		editorTextAreaElm.appendChild(textareaTextNode);
		editorTextAreaElm.style.width = (parseInt(formWidth) - 2) + "px";
		editorTextAreaElm.style.height = formHeight + "px";

		if(PLG.sprites[PLG.fixedSprite.id].isDrawing && PARAM.superSprite != 1){
			editorTextAreaElm.style.display = "none";
		}
		editorForm.appendChild(editorTextAreaElm);

		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.appendChild(editorForm);

		if(!(PLG.sprites[PLG.fixedSprite.id].isDrawing && PARAM.superSprite != 1)){
			editorTextAreaElm.focus();
		}

		editorControlSaveElm.onmousedown = function(){
		saveAndCloseEditor();
	}

  editorControlCloseElm.onmousedown = editorControlCloseOnMouseDown;
  editorControlTopElm.onmousedown = editorControlTopOnMouseDown;
  editorControlBottomElm.onmousedown = editorControlBottomOnMouseDown;

  // safari cannot get border by short name. (e.g. border, border-width) 
  // Get by full name. (e.g. border-top-width);
  EDT.orgBorderWidth = contentsElm.style.borderTopWidth;
  EDT.orgBorderColor = contentsElm.style.borderTopColor;

  EDT.orgBorderStyle = contentsElm.style.borderTopStyle;
  EDT.orgBackgroundColor = contentsElm.style.backgroundColor;
  EDT.orgForegroundColor = contentsElm.style.color;
  EDT.orgPadding = contentsElm.style.paddingTop;

}

}


//------------------------------------
// Save or Delete Sprite
//------------------------------------
function saveAndCloseEditor()
{
	PLG.waitSavingFlag = true;
  document.getElementById("controlresult").innerHTML="";

  var authorName = PLG.sprites[PLG.fixedSprite.id].author;

  var loginid = getCookie("loginid");
  if(loginid == "public" && !authorName.match(/^&lt;.+&gt;$/) && !authorName.match(/^\[.+\]$/)){
    document.getElementById("controlresult").innerHTML="Permission denied.";
    return;
  }

  var tmpTextareaElm = document.getElementById("editor-textarea");
  var newText = tmpTextareaElm.value;



  var attachedfilename = "";
  if(document.getElementById("editor-filename")){
    attachedfilename = document.getElementById("editor-filename").innerHTML;
  }
  attachedfilename = encodeURIComponent(attachedfilename);


	// Delete?
  if(newText.length == 0 && attachedfilename == ""){ 
		deleteSprite(true);
		return;
	}

	EDT.orgSpritesHash = PLG.sprites.toJSONString();

  if(getSpriteInfo(PLG.fixedSprite, "spriteuri")){
		EDT.originalShowLink = 1;
	}
	else{
		EDT.originalShowLink = 0;
	}
  if(getSpriteInfo(PLG.fixedSprite, "spritedate")){
		EDT.originalShowDate = 1;
	}
	else{
		EDT.originalShowDate = 0;
	}
	if(getSpriteInfo(PLG.fixedSprite, "spriteuri")){
		EDT.originalShowAuthor = 1;
	}
	else{
		EDT.originalShowAuthor = 0;
	}

  EDT.originalAuthor = authorName;

  var newTextPost = newText;
  if(PARAM.sprite_html != 1){
    newText = newText.replace(/</g,"&lt;");
    newText = newText.replace(/>/g,"&gt;");
  }
  if(PARAM.sprite_html == 1 && PARAM.superSprite != 1){
    newText = newText.replace(/onAbort/gi, "o&ntilde;Abort");
    newText = newText.replace(/onBlur/gi, "o&ntilde;Blur");
    newText = newText.replace(/onChange/gi, "o&ntilde;Change");
    newText = newText.replace(/onClick/gi, "o&ntilde;Click");
    newText = newText.replace(/ondblclick/gi, "o&ntilde;dblclick");
    newText = newText.replace(/ondraganddrop/gi, "o&ntilde;draganddrop");
    newText = newText.replace(/onError/gi, "o&ntilde;Error");
    newText = newText.replace(/onFocus/gi, "o&ntilde;Focus");
    newText = newText.replace(/onkeydown/gi, "o&ntilde;keydown");
    newText = newText.replace(/onkeypress/gi, "o&ntilde;keypress");
    newText = newText.replace(/onkeyup/gi, "o&ntilde;keyup");
    newText = newText.replace(/onLoad/gi, "o&ntilde;Load");
    newText = newText.replace(/onUnload/gi, "o&ntilde;Unload");
    newText = newText.replace(/onMouseDown/gi, "o&ntilde;MouseDown");
    newText = newText.replace(/onMouseOut/gi, "o&ntilde;MouseOut");
    newText = newText.replace(/onMouseOver/gi, "o&ntilde;MouseOver");
    newText = newText.replace(/onMouseUp/gi, "o&ntilde;MouseUp");
    newText = newText.replace(/onMouseWheel/gi, "o&ntilde;MouseWheel");
    newText = newText.replace(/onmove/gi, "o&ntilde;move");
    newText = newText.replace(/onReset/gi, "o&ntilde;Reset");
    newText = newText.replace(/onresize/gi, "o&ntilde;resize");
    newText = newText.replace(/onSelect/gi, "o&ntilde;Select");
    newText = newText.replace(/onSubmit/gi, "o&ntilde;Submit");
    newText = newText.replace(/script /gi, "script&nbsp;");
    newText = newText.replace(/ script/gi, "&nbsp;script");
    newText = newText.replace(/<script/gi, "&lt;script");
  }

  if(PARAM.sprite_autobr == 1){
    newText = newText.replace(/\n/g,"<br/>\n");
  }
  if(PARAM.sprite_autolink == 1){
    newText = newText.replace(/(s?https?|ftp):(\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/g,"<a href=\"$1:$2\">$1:$2<\/a>");
  }

  if(attachedfilename != ""){
    if(attachedfilename.match(/^.+?\.(gif|jpeg|jpg|png)$/i)){
      newText = "<img src='" + PARAM.DATAFILEPATH + PARAM.pageid + "/images/" + attachedfilename + "' class='attachedimage'>" + newText;
    }
    else{
      newText = "<a class=\"attachedfile\" href='"+ PARAM.DATAFILEPATH + PARAM.pageid + "/files/" + attachedfilename + "'>" + attachedfilename + "</a>" + newText;
    }
  }

  var contentsElm = getSpriteContents(PLG.fixedSprite);
	if(!(PLG.sprites[PLG.fixedSprite.id].isDrawing && PARAM.superSprite != 1)){
		contentsElm.innerHTML = newText;
	}
	else{
		newTextPost = ""; // nochange
	}

  // check plugin
  var pluginStr = getSpriteInfo(PLG.fixedSprite, "spriteplugin").innerHTML;
  var pluginStrEnc = encodeURIComponent(pluginStr);
  var pluginName = "";
  var pluginArray = pluginStr.split(",");
  if(pluginArray.length >= 1){
    pluginName = pluginArray[0];
  }
  if(pluginName != "" && newTextPost.length == 0){
    // fill plugin name if sprite is empty
    contentsElm.innerHTML = pluginName;
    newTextPost = pluginName;
  }
  
  newTextPost = encodeURIComponent(newTextPost);

  var public_password = "";
  var public_author = "";
  if(authorName.match(/^&lt;.+&gt;$/) || authorName.match(/^\[.+\]$/)){
    var passwordElm = document.getElementById("editor-password");
    public_password = passwordElm.value;

    var editorAuthorElm = document.getElementById("editor-author");
    public_author = editorAuthorElm.value;
    if(public_author == ""){
      public_author = "public";
    }

    if(public_author == "public"){
      if(public_password != ""){
        authorName = "&lt;public&gt;";
      }
      else{
        authorName = "[public]";
      }
    }
    else{
      if(public_password != ""){
        authorName = "&lt;" + public_author + "&gt;";
      }
      else{
        authorName = "[" + public_author + "]";
      }
    }

    var pubauthor = encodeURIComponent(public_author);
    setCookie("public_author", pubauthor, PARAM.CGIFILEPATH, 30);
  }


  // save sprite contents and styles
  
  var zIndex = PLG.orgZindexOfFixedSprite;
  var styles = "left:" + sprLeft(PLG.fixedSprite) + "px; "
    + "top:" + sprTop(PLG.fixedSprite) + "px; "
    + "width:" + sprWidth(PLG.fixedSprite) + "px; "
    + "z-index:" + zIndex + ";";

	var userProf = "";

  var sizeselector = document.getElementById('editor-framesizeselector');
  var borderWidth = sizeselector.options[sizeselector.selectedIndex].value;
	userProf += "frameWidth:" + borderWidth + ",";
  var selector = document.getElementById('editor-frameselector');
  var borderStyle = selector.options[selector.selectedIndex].value;
	userProf += "frameStyle:" + borderStyle + ",";
  var paddingselector = document.getElementById('editor-framepaddingselector');
  var padding = paddingselector.options[paddingselector.selectedIndex].value;
	userProf += "framePadding:" + padding + ",";

  var contentsStyles = "border-width:" + borderWidth + "; "
    + "border-style:" + borderStyle + ";"
    + "padding:" + padding+ ";"

  if(contentsElm.style.borderTopColor){
    contentsStyles += "border-color:" + contentsElm.style.borderTopColor + "; ";
		var encFrameColor = encodeURIComponent(contentsElm.style.borderTopColor);	
		userProf += "frameColor:" + encFrameColor + ",";
  }
  if(contentsElm.style.backgroundColor){
    contentsStyles += "background-color:" + contentsElm.style.backgroundColor + ";";
		var encBgColor = encodeURIComponent(contentsElm.style.backgroundColor);	
		userProf += "bgColor:" + encBgColor + ",";
  }
	else{
		userProf += "bgColor:" + ",";
	}
  if(contentsElm.style.color){
    contentsStyles += "color:" + contentsElm.style.color + ";";
		var encFgColor = encodeURIComponent(contentsElm.style.color);	
		userProf += "fgColor:" + encFgColor + ",";
  }

		// info
	var region = getSpriteRegion(PLG.fixedSprite);
	var children = region.childNodes;
	var infoElm = null;
	for(var i=0; i<children.length; i++){
		if(children[i].className == "spriteinfo"){
			infoElm = children[i];
			break;
		}
	}

  var showAuthorElm = document.getElementById("editor-showauthor");
  var showAuthorFlag = 0;
  if(showAuthorElm.checked){
    showAuthorFlag = 1;
		if(!getSpriteInfo(PLG.fixedSprite, "spriteauthor")){
			var authorElm = document.createElement("span");
			authorElm.setAttribute("class", "spriteauthor");
			var tmpAuthorName = authorName;
			tmpAuthorName = tmpAuthorName.replace(/&lt;/gi, "<");
			tmpAuthorName = tmpAuthorName.replace(/&gt;/gi, ">");
			authorElm.appendChild(document.createTextNode(tmpAuthorName));
			authorElm.style.display ="block";
			if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
				authorElm.style.cssText = "display: block; float: right; margin-left: 5px; margin-right: 5px;";
				authorElm.setAttribute("className", "spriteauthor");
			}
			infoElm.appendChild(authorElm);
		}
		else{
			var authorElm = getSpriteInfo(PLG.fixedSprite, "spriteauthor");
			authorElm.innerHTML = authorName;
		}
		userProf += "showAuthor:" + "true" + ",";
	}
	else{
		if(getSpriteInfo(PLG.fixedSprite, "spriteauthor")){
			infoElm.removeChild(getSpriteInfo(PLG.fixedSprite, "spriteauthor"));
		}
		userProf += "showAuthor:" + "false" + ",";
	}

	PLG.sprites[PLG.fixedSprite.id].author = authorName;

	var showDateElm = document.getElementById("editor-showdate");
	var showDateFlag = 0;
	if(showDateElm.checked){
		showDateFlag = 1;
		if(!getSpriteInfo(PLG.fixedSprite, "spritedate")){
			var dateElm = document.createElement("span");
			dateElm.setAttribute("class", "spritedate");

			var date = new String(PLG.sprites[PLG.fixedSprite.id].time);
			var dateValue = date.substring(0,4) + "/" + date.substring(4,6) + "/" + date.substring(6,8) + " " + date.substring(8,10) + ":" + date.substring(10,12) + ":" + date.substring(12,14);
			dateElm.appendChild(document.createTextNode(dateValue));

			dateElm.style.display ="block";
			if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
				dateElm.style.cssText = "display: block; float: right; margin-left: 5px; margin-right: 5px;";
				dateElm.setAttribute("className", "spritedate");
			}
			infoElm.appendChild(dateElm);
		}
		userProf += "showDate:" + "true" + ",";
	}
	else{
		if(getSpriteInfo(PLG.fixedSprite, "spritedate")){
			infoElm.removeChild(getSpriteInfo(PLG.fixedSprite, "spritedate"));
		}
		userProf += "showDate:" + "false" + ",";
	}

	var showPositElm = document.getElementById("editor-showlink");
	var showPositFlag = 0;
	if(showPositElm.checked){
		showPositFlag = 1;
		if(!getSpriteInfo(PLG.fixedSprite, "spriteuri")){
			var positElm = document.createElement("span");
			positElm.setAttribute("class", "spriteuri");
			positElm.appendChild(document.createTextNode(""));
			positElm.innerHTML = "<a href='./positlog.cgi?load=" + PARAM.pageid + "&id=" + PLG.fixedSprite.id + "'>link</a>";
			positElm.style.display ="block";
			if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
				positElm.style.cssText = "display: block; float: right; margin-left: 5px; margin-right: 5px;";
				positElm.setAttribute("className", "spriteuri");
			}
			infoElm.appendChild(positElm);
		}
		userProf += "showLink:" + "true";
	}
	else{
		if(getSpriteInfo(PLG.fixedSprite, "spriteuri")){
			infoElm.removeChild(getSpriteInfo(PLG.fixedSprite, "spriteuri"));
		}
		userProf += "showLink:" + "false";
	}

	profUserName = authorName;
  if(profUserName.match(/^&lt;(.+)&gt;$/)  || profUserName.match(/^\[(.+)\]$/)){
		profUserName = RegExp.$1;
	}
	profUserName = encodeURIComponent(profUserName);
	setCookie("prof_" + profUserName, userProf, PARAM.CGIFILEPATH, 30);

  // Re-calc region		
	calcRegionsOfTree(PLG.fixedSprite.id);

  // Re-calc margin
	// because sprite size may be changed
	var margin = calcMarginsTowardsAscendants(PLG.fixedSprite.id);
	var margin2  = calcMarginsTowardsDescendants(PLG.fixedSprite.id);
	if(margin == ""){
		margin = margin2;
	}
	else if(margin2 != ""){
		margin += ";" + margin2;
	}

	rebuildYoungerArray();


  var postdata = "&id="+ PLG.fixedSprite.id + "&contents="+newTextPost + "&pageid="+PARAM.pageid + "&public_password="+public_password + "&public_author="+public_author + "&styles=" + styles + "&contentsStyles=" + contentsStyles + "&dispauthor=" + showAuthorFlag + "&disptime=" + showDateFlag + "&dispposit=" + showPositFlag + "&attached=" + attachedfilename + "&plugin=" + pluginStrEnc + "&margin=" + margin;

		// callback function 
	var saveSpriteOnLoaded = function(obj){
		var res = obj.responseText;
		if (res != "succeed"){        
			var contentsElm = getSpriteContents(PLG.fixedSprite);
			contentsElm.innerHTML = EDT.orgInnerHtml;

			PLG.sprites = eval('(' + EDT.orgSpritesHash + ')');

			if(EDT.originalShowLink == 1){
				if(!getSpriteInfo(PLG.fixedSprite, "spriteuri")){
					var positElm = document.createElement("span");
					positElm.setAttribute("class", "spriteuri");
					positElm.appendChild(document.createTextNode(""));
					positElm.innerHTML = "<a href='./positlog.cgi?load=" + PARAM.pageid + "&id=" + PLG.fixedSprite.id + "'>link</a>";
					positElm.style.display ="block";
					if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
						positElm.style.cssText = "display: block; float: right; margin-left: 5px; margin-right: 5px;";
						positElm.setAttribute("className", "spriteuri");
					}
					infoElm.appendChild(positElm);
				}
			}
			else{
				if(getSpriteInfo(PLG.fixedSprite, "spriteuri")){
					infoElm.removeChild(getSpriteInfo(PLG.fixedSprite, "spriteuri"));
				}
			}
			if(EDT.originalShowDate == 1){
				var dateElm = document.createElement("span");
				dateElm.setAttribute("class", "spritedate");

				var date = new String(PLG.sprites[PLG.fixedSprite.id].time);
				var dateValue = date.substring(0,4) + "/" + date.substring(4,6) + "/" + date.substring(6,8) + " " + date.substring(8,10) + ":" + date.substring(10,12) + ":" + date.substring(12,14);
				dateElm.appendChild(document.createTextNode(dateValue));

				dateElm.style.display ="block";
				if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
					dateElm.style.cssText = "display: block; float: right; margin-left: 5px; margin-right: 5px;";
					dateElm.setAttribute("className", "spritedate");
				}
				infoElm.appendChild(dateElm);
			}				
			else{
				if(getSpriteInfo(PLG.fixedSprite, "spritedate")){
					infoElm.removeChild(getSpriteInfo(PLG.fixedSprite, "spritedate"));
				}
			}
			if(EDT.originalShowAuthor == 1){
				authorName = EDT.originalAuthor;
				if(!getSpriteInfo(PLG.fixedSprite, "spriteauthor")){
					var authorElm = document.createElement("span");
					authorElm.setAttribute("class", "spriteauthor");
					authorElm.appendChild(document.createTextNode(authorName));
					authorElm.style.display ="block";
					if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
						authorElm.style.cssText = "display: block; float: right; margin-left: 5px; margin-right: 5px;";
						authorElm.setAttribute("className", "spriteauthor");
					}
					infoElm.appendChild(authorElm);
				}
			}
			else{
				if(getSpriteInfo(PLG.fixedSprite, "spriteauthor")){
					infoElm.removeChild(getSpriteInfo(PLG.fixedSprite, "spriteauthor"));
				}
			}

			if (res == "invalid_public_password"){
				document.getElementById("controlresult").innerHTML="Please enter the valid password.";
			}
			else{
				document.getElementById("controlresult").innerHTML=res;
			}

			redrawCanvas(PLG.fixedSprite);
			PLG.movingEditorFlag = false;
			PLG.waitSavingFlag = false;
		}
		else{
			if(document.getElementById("editor-password")){
				var passwordElm = document.getElementById("editor-password");
				var public_password = passwordElm.value;
				if(public_password != ""){
					setCookie("public_password", public_password, PARAM.CGIFILEPATH, 30);
				}
			}

			if(PLG.cb.bw.msie){
          // Sprite width is automatically expanded to adjust to the width of inner image on IE6.
				var definedWidth = parseInt(PLG.fixedSprite.style.width);
				var realWidth = parseInt(PLG.fixedSprite.offsetWidth) - 6;
				if(definedWidth < realWidth){
					PLG.fixedSprite.style.width = realWidth + "px";
					saveStyles(PLG.fixedSprite);
				}
			}

			closeTCS();
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.removeChild(document.getElementById("editor"));

			PLG.fixedSprite.style.zIndex = PLG.orgZindexOfFixedSprite;

			PLG.state = STATES.FIXEDSELECTED;
			setSelectedSprite(PLG.fixedSprite);
			setFixedFrame(PLG.fixedSprite);
			setSpriteIcons(PLG.fixedSprite);

			redrawCanvas(PLG.fixedSprite);
			refreshMap();

			PLG.fixedSprite.style.zIndex = ZIND.GO_TEMP_FOREGROUND;

			PLG.movingEditorFlag = false;
			PLG.waitSavingFlag = false;
		}
	}

  sendRequest(saveSpriteOnLoaded, postdata, "POST", PARAM.CGIFILEPATH + "saveSprite.cgi", true, true);
}

function refreshMap()
{
	PLG.leftSprID = "";
	PLG.rightSprID = "";
	PLG.topSprID = "";
	PLG.bottomSprID = "";
	for (var id in PLG.sprites){
		if(!id.match(/^sprite_.+$/)){
			continue;
		}
		if(!PLG.sprites[id].parent && document.getElementById(id)){
			rebuildWholeGeometry(id, PLG.sprites);
		}
	}
	initSmallMap();			
	drawSmallMap();
	drawViewArea();
}


//-------------------------------------
// Delete sprite
//-------------------------------------
function deleteSprite(isEditorOpen)
{
	var groupingCommand = "";
	var list = document.getElementById("spriteslist");

	EDT.orgSpritesHash = PLG.sprites.toJSONString();

	//-------------------------------------
	// Re-calc spritesHash and generate groupingCommand
	//-------------------------------------
	// Id of the parent sprite of the sprite
	var newParentID = "";
	if(PLG.fixedSprite.parentNode.className == "parent" && PLG.fixedSprite.parentNode.tagName.match(/ul/i)){
		newParentID = PLG.fixedSprite.parentNode.parentNode.id;
	}
	// The root element of the sprite's children
	var childRoot = null;
	for(var i=0; i<PLG.fixedSprite.childNodes.length; i++){
		if(PLG.fixedSprite.childNodes[i].className == "parent" && PLG.fixedSprite.childNodes[i].tagName.match(/ul/i)){
			childRoot = PLG.fixedSprite.childNodes[i];
			break;
		}
	}
	// Move the children to the new parent
	if(childRoot != null){
		var children = childRoot.childNodes;
		for(var i=0; i<children.length; i++){
			if(children[i].className == "sprite"){
				groupingCommand += newParentID+ "," + children[i].id + ";";
				if(newParentID == ""){
					groupSpritesHash(list, children[i]);
				}
				else{
					groupSpritesHash(document.getElementById(newParentID), children[i]);
				}
			}
		}
	}
	// Remove the sprite from the tree
	if(newParentID != ""){
		groupingCommand += "," + PLG.fixedSprite.id + ";";
		groupSpritesHash(list, PLG.fixedSprite);
	}

	if(groupingCommand != ""){
		groupingCommand = groupingCommand.substr(0, groupingCommand.length-1);
	}

	delete(PLG.sprites[PLG.fixedSprite.id]);

	//------------------------------------------------
	// Re-calc margin and generate marginCommand
	//------------------------------------------------
	var marginCommand = "";
	if(newParentID != ""){
		calcRegionsOfTree(newParentID);

		var margin2 = calcMarginsTowardsAscendants(newParentID);
		if(marginCommand == ""){
			marginCommand = margin2;
		}
		else if(margin2 != ""){
			marginCommand += ";" + margin2;
		}

		var margin3 = calcMarginsTowardsDescendants(newParentID);
		if(marginCommand == ""){
			marginCommand = margin3;
		}
		else if(margin3 != ""){
			marginCommand += ";" + margin3;
		}
	}
	else{
		var siblings = new Array();
		for (var id in PLG.sprites){
			if(!id.match(/^sprite_.+$/)){
				continue;
			}
			if(!PLG.sprites[id].parent || PLG.sprites[id].parent == ""){
				if(id != PLG.fixedSprite.id){
					siblings.push(id);
				}
			}
		}
		var margin_sibling = calcSiblingsMargin(siblings);
		if(marginCommand == ""){
			marginCommand = margin_sibling;
		}
		else if(margin_sibling != ""){
			marginCommand += ";" + margin_sibling;
		}
	}

	rebuildYoungerArray();


	// password
  var public_password = "";
	if(isEditorOpen){
		var passwordElm = document.getElementById("editor-password");
		if(passwordElm){
			public_password = passwordElm.value;
		}
	}
	else{
		public_password = getCookie("public_password");
		if(document.getElementById("password-dialog")){
			var passwordElm = document.getElementById("dialog-pass");
			public_password = passwordElm.value;
		}
		if(public_password == undefined){
			public_password = "";
		}
	}

	var prevState = PLG.state;

  var postdata = "&id="+ PLG.fixedSprite.id + "&pageid="+PARAM.pageid + "&public_password="+public_password+"&grouping=" + groupingCommand + "&margin=" + marginCommand;
  
	// callback function
	var deleteSpriteOnLoaded = function(obj){
		var res = obj.responseText;
		if (res != "succeed"){        

			if (res == "invalid_public_password"){
				if(isEditorOpen){
					document.getElementById("controlresult").innerHTML="Please enter the valid password.";
				}
				else{
					if(document.getElementById("password-dialog")){
						document.getElementById("dialog-result").innerHTML="Permission denied.";
					}
					else{
						openPasswordDialog(PLG.fixedSprite, prevState);
					}
					return;
				}
			}
			else{
				document.getElementById("controlresult").innerHTML=res;
			}

			if(isEditorOpen){
				var contentsElm = getSpriteContents(PLG.fixedSprite);
				contentsElm.innerHTML = EDT.orgInnerHtml;
			}
			
			PLG.sprites = eval('(' + EDT.orgSpritesHash + ')');

			PLG.movingEditorFlag = false;
			PLG.waitSavingFlag = false;

			redrawCanvas(PLG.fixedSprite);
			return;
		}
		else{
			// Ungroup sprites actually
			if(childRoot != null){
				var newParent = document.getElementById("spriteslist");
				if(PLG.fixedSprite.parentNode.className == "parent" && PLG.fixedSprite.parentNode.tagName.match(/ul/i)){
					newParent = PLG.fixedSprite.parentNode.parentNode;
				}
				var children = childRoot.childNodes;
				while(children.length > 0){
					if(children[0].className == "sprite"){
						groupSprites(newParent, children[0]);
					}
					else{
						childRoot.removeChild(children[0]);
					}
				}
			}
			if(PLG.fixedSprite.parentNode.className == "parent" && PLG.fixedSprite.parentNode.tagName.match(/ul/i)){
				var list = document.getElementById("spriteslist");
				groupSprites(list, PLG.fixedSprite);
			}

			if(document.getElementById("password-dialog")){
				var passwordElm = document.getElementById("dialog-pass");
				var public_password = passwordElm.value;
				if(public_password != ""){
					setCookie("public_password", public_password, PARAM.CGIFILEPATH, 30);
				}
				var spritesWorldNode = document.getElementById("spritesworld");
				spritesWorldNode.removeChild(document.getElementById("password-dialog"));
			}

			removeSpriteIcons();
			removeFixedFrame();

			// delete
			var spritesListNode = document.getElementById("spriteslist");
			spritesListNode.removeChild(PLG.fixedSprite);

			PLG.fixedSprite = null;
			PLG.selectedSprite = null;

			if(isEditorOpen){
				closeTCS();
				var spritesWorldNode = document.getElementById("spritesworld");
				spritesWorldNode.removeChild(document.getElementById("editor"));
			}

			clearCanvas();

			PLG.state = STATES.WORKING;

			refreshMap();

			PLG.numberOfSprites--;
			var status = "&nbsp;&nbsp;(" + PLG.numberOfSprites + "sprites, " + Math.abs(PLG.worldRight - PLG.worldLeft) + "x" +Math.abs(PLG.worldBottom - PLG.worldTop) + "pixels)";
			document.getElementById("status").innerHTML = status;

			PLG.waitSavingFlag = false;
		}

	}

  sendRequest(deleteSpriteOnLoaded, postdata, "POST", PARAM.CGIFILEPATH + "deleteSprite.cgi", true, true);
}


//----------------------------------------------------------------
// calcRegionsOfTree(spr, x, y)
//  id: ID of the target sprite
//  x: New sprites[id].position.x of the target sprite (default: sprLeft(document.getElementById(id)))
//  y: New sprites[id].position.y of the target sprite (default: sprTop(document.getElementById(id)))
// This function calculates the region of the target sprite,
// recursively towards its leaves and its root.
//----------------------------------------------------------------
function calcRegionsOfTree(id, x, y)
{
	if(x){
		PLG.sprites[id].position.x = x;
	}
	else{
		PLG.sprites[id].position.x = sprLeft(document.getElementById(id));
	}
	if(y){
		PLG.sprites[id].position.y = y;
	}
	else{
		PLG.sprites[id].position.y = sprTop(document.getElementById(id));
	}
	PLG.sprites[id].width = sprWidth(document.getElementById(id));
	PLG.sprites[id].height = sprHeight(document.getElementById(id));
	if(PLG.sprites[id].parent && PLG.sprites[id].parent != ""){
		PLG.sprites[id].position.absx = PLG.sprites[PLG.sprites[id].parent].position.absx + PLG.sprites[id].position.x;
		PLG.sprites[id].position.absy = PLG.sprites[PLG.sprites[id].parent].position.absy + PLG.sprites[id].position.y;
	}
	else{
		PLG.sprites[id].position.absx = PLG.sprites[id].position.x;
		PLG.sprites[id].position.absy = PLG.sprites[id].position.y;
	}
	PLG.sprites[id].region.left = 0;
	PLG.sprites[id].region.top = 0;
	PLG.sprites[id].region.bottom = PLG.sprites[id].height;
	PLG.sprites[id].region.right = PLG.sprites[id].width;

	// Change absolute position and region of descendants
	calcRegionsTowardsDescendants(id)

	// Change region of ascendants if changed
	var isChange = true;
	while(isChange && PLG.sprites[id].parent && PLG.sprites[id].parent != ""){
		isChange = false;
		var pid = PLG.sprites[id].parent;
		var siblings = PLG.sprites[pid].children;
		var maxLeft = 0;
		var maxRight = PLG.sprites[pid].width;
		var maxTop = 0;
		var maxBottom = PLG.sprites[pid].height;

		for(var i=0; i<siblings.length; i++){
			var sibling = siblings[i];
			if(maxLeft > PLG.sprites[sibling].position.x + PLG.sprites[sibling].region.left){
				maxLeft = PLG.sprites[sibling].position.x + PLG.sprites[sibling].region.left;
			}
			if(maxRight < PLG.sprites[sibling].position.x + PLG.sprites[sibling].region.right){
				maxRight = PLG.sprites[sibling].position.x + PLG.sprites[sibling].region.right;
			}
			if(maxTop > PLG.sprites[sibling].position.y + PLG.sprites[sibling].region.top){
				maxTop = PLG.sprites[sibling].position.y + PLG.sprites[sibling].region.top;
			}
			if(maxBottom < PLG.sprites[sibling].position.y + PLG.sprites[sibling].region.bottom){
				maxBottom = PLG.sprites[sibling].position.y + PLG.sprites[sibling].region.bottom;
			}
		}

		if(PLG.sprites[pid].region.left != maxLeft){
			PLG.sprites[pid].region.left = maxLeft;
			isChange = true;
		}
		if(PLG.sprites[pid].region.right != maxRight){
			PLG.sprites[pid].region.right = maxRight;
			isChange = true;
		}
		if(PLG.sprites[pid].region.top != maxTop){
			PLG.sprites[pid].region.top = maxTop;
			isChange = true;
		}
		if(PLG.sprites[pid].region.bottom != maxBottom){
			PLG.sprites[pid].region.bottom = maxBottom;
			isChange = true;
		}
		id = pid;
	}
}


//----------------------------------------------------------------
// calcRegionsTowardsDescendants(id)
//  id: ID of the target sprite
//
// This function calculates the region of the target sprite,
// recursively towards its leaves.
//----------------------------------------------------------------
function calcRegionsTowardsDescendants(id)
{
	if(PLG.sprites[id].children && PLG.sprites[id].children.length > 0){
		for(var i=0; i<PLG.sprites[id].children.length; i++){
			var child = PLG.sprites[id].children[i];
			PLG.sprites[child].position.absx = PLG.sprites[id].position.absx + PLG.sprites[child].position.x;
			PLG.sprites[child].position.absy = PLG.sprites[id].position.absy + PLG.sprites[child].position.y;
			if(PLG.sprites[child].children && PLG.sprites[child].children.length > 0){
				calcRegionsTowardsDescendants(child);
			}
			if(PLG.sprites[id].region.left > PLG.sprites[child].position.x + PLG.sprites[child].region.left){
				PLG.sprites[id].region.left = PLG.sprites[child].position.x + PLG.sprites[child].region.left;
			}
			if(PLG.sprites[id].region.right < PLG.sprites[child].position.x + PLG.sprites[child].region.right){
				PLG.sprites[id].region.right = PLG.sprites[child].position.x + PLG.sprites[child].region.right;
			}
			if(PLG.sprites[id].region.top > PLG.sprites[child].position.y + PLG.sprites[child].region.top){
				PLG.sprites[id].region.top = PLG.sprites[child].position.y + PLG.sprites[child].region.top;
			}
			if(PLG.sprites[id].region.bottom < PLG.sprites[child].position.y + PLG.sprites[child].region.bottom){
				PLG.sprites[id].region.bottom = PLG.sprites[child].position.y + PLG.sprites[child].region.bottom;
			}
		}
	}
}


//-------------------------------------------------------------------------
// calcSiblingsMargin(siblings)
//  siblings: Array including ID of target siblings
// This function calculates margin between target siblings.
//-------------------------------------------------------------------------
function calcSiblingsMargin(siblings)
{
  // Margin between siblings
	var margin_sibling = "";
	if(siblings && siblings.length > 0){
		var upperSiblings = new Array();
		//		var lowerSiblings = new Array();

		// Process upper siblings
		for(var i=0; i<siblings.length; i++){
			if(!PLG.sprites[siblings[i]].margin_p || !PLG.sprites[siblings[i]].margin_p.position){
				calcParentMargin(siblings[i]);
			}
			if(isUpperSiblings(siblings[i], PLG.sprites)){
				upperSiblings.push(siblings[i]);
			}
		}

		var sortByBottom = function(a,b){
			return (PLG.sprites[a].position.y + PLG.sprites[a].region.bottom) - (PLG.sprites[b].position.y + PLG.sprites[b].region.bottom);
		};
		upperSiblings.sort(sortByBottom);

		for(var i=0; i<upperSiblings.length; i++){
			margin_sibling = calcSiblingsMargin2(margin_sibling, upperSiblings, "upper", i);
		}

		// Process lower siblings
		var sortByTopReverse = function(a,b){
			return (PLG.sprites[b].position.y + PLG.sprites[b].region.top) - (PLG.sprites[a].position.y + PLG.sprites[a].region.top);
		};
		siblings.sort(sortByTopReverse);

		for(var i=0; i<siblings.length; i++){
			if(!isUpperSiblings(siblings[i], PLG.sprites)){
				//				lowerSiblings.push(siblings[i]);
				margin_sibling = calcSiblingsMargin2(margin_sibling, siblings, "lower", i);
			}
		}
	}
	return margin_sibling;
}

//-------------------------------------------------------------------------
// calcSiblingsMargin2(margin_sibling, siblings, position, i)
//-------------------------------------------------------------------------
function calcSiblingsMargin2(margin_sibling, siblings, position, i)
{
	var minmargin = "";
	var minmarginid = "";
	for(var j=i+1; j<siblings.length; j++){
		if((PLG.sprites[siblings[i]].position.x + PLG.sprites[siblings[i]].region.left <= PLG.sprites[siblings[j]].position.x + PLG.sprites[siblings[j]].region.left
				&& PLG.sprites[siblings[i]].position.x + PLG.sprites[siblings[i]].region.right >= PLG.sprites[siblings[j]].position.x + PLG.sprites[siblings[j]].region.left)
			||
			(PLG.sprites[siblings[i]].position.x + PLG.sprites[siblings[i]].region.left <= PLG.sprites[siblings[j]].position.x + PLG.sprites[siblings[j]].region.right
			 && PLG.sprites[siblings[i]].position.x + PLG.sprites[siblings[i]].region.right >= PLG.sprites[siblings[j]].position.x + PLG.sprites[siblings[j]].region.left)
			 ||
			 (PLG.sprites[siblings[i]].position.x + PLG.sprites[siblings[i]].region.left >= PLG.sprites[siblings[j]].position.x + PLG.sprites[siblings[j]].region.left
				&& PLG.sprites[siblings[i]].position.x + PLG.sprites[siblings[i]].region.right <= PLG.sprites[siblings[j]].position.x + PLG.sprites[siblings[j]].region.right)
			){
				if(position == "upper"){
					// upper sibligns
					// Use === instead of ==
					if(minmargin === "" || minmargin > (PLG.sprites[siblings[j]].position.y + PLG.sprites[siblings[j]].region.top) - (PLG.sprites[siblings[i]].position.y + PLG.sprites[siblings[i]].region.bottom)){
						minmargin = (PLG.sprites[siblings[j]].position.y + PLG.sprites[siblings[j]].region.top) - (PLG.sprites[siblings[i]].position.y + PLG.sprites[siblings[i]].region.bottom);
						minmarginid = siblings[j];
					}
				}
				else{
					// lower sibligns
					if(!isUpperSiblings(siblings[j], PLG.sprites) 
						 || PLG.sprites[siblings[j]].margin_p.position == "TT"){
//						 || (isUpperSiblings(siblings[j], PLG.sprites) 
								 //								 && PLG.sprites[siblings[j]].position.y + PLG.sprites[siblings[j]].height > 0
//								 && PLG.sprites[siblings[i]].position.y + PLG.sprites[siblings[i]].region.top < PLG.sprites[siblings[j]].position.y + PLG.sprites[siblings[j]].region.bottom
//								)
//						){
							// Use === instead of ==
							if(minmargin === "" || minmargin > (PLG.sprites[siblings[i]].position.y + PLG.sprites[siblings[i]].region.top) - (PLG.sprites[siblings[j]].position.y + PLG.sprites[siblings[j]].region.bottom)){
								minmargin = (PLG.sprites[siblings[i]].position.y + PLG.sprites[siblings[i]].region.top) - (PLG.sprites[siblings[j]].position.y + PLG.sprites[siblings[j]].region.bottom);

								if(PLG.debug && PARAM.positlogMode == "EditMode" ){
									PLG.sprites[siblings[i]].s_id = siblings[j];
									PLG.sprites[siblings[i]].s_bottom = PLG.sprites[siblings[j]].position.y + PLG.sprites[siblings[j]].region.bottom;
								}

								minmarginid = siblings[j];
							}
						}
				}
			}

	}

	if(minmargin !== ""){
		if(!PLG.sprites[siblings[i]].margin_s){
			PLG.sprites[siblings[i]].margin_s = new Object();
			PLG.sprites[siblings[i]].margin_s.pixel = "";
		}

		var pos = "";
		if(position == "upper"){
			pos = "TB";
			if(minmargin < 0 && Math.abs(minmargin) >  (PLG.sprites[minmarginid].region.bottom - PLG.sprites[minmarginid].region.top)/2){
				minmargin = (PLG.sprites[minmarginid].region.bottom - PLG.sprites[minmarginid].region.top) - Math.abs(minmargin);
				pos = "BB";
			}
		}
		else{
			pos = "BT";
			if(minmargin < 0 && Math.abs(minmargin) >  (PLG.sprites[minmarginid].region.bottom - PLG.sprites[minmarginid].region.top)/2){
				minmargin = (PLG.sprites[minmarginid].region.bottom - PLG.sprites[minmarginid].region.top) - Math.abs(minmargin);
				pos = "TT";
			}
		}

		PLG.sprites[siblings[i]].margin_s.pixel = minmargin;
		PLG.sprites[siblings[i]].margin_s.elder = minmarginid;
		PLG.sprites[siblings[i]].margin_s.position = pos;
		var tmpmargin = siblings[i] + ",,," + minmarginid + "," + minmargin + "," + pos;
		if(margin_sibling == ""){
			margin_sibling = tmpmargin;
		}
		else if(minmargin !== ""){
			// Use === instead of ==
			margin_sibling += ";" + tmpmargin;
		}

		if(PLG.debug && PARAM.positlogMode == "EditMode"){
			if(siblings[i] == PLG.fixedSprite.id){
				
				document.getElementById("currentposition").innerHTML = tmpmargin + ",sbottom:" + PLG.sprites[siblings[i]].s_bottom;
				if(minmargin === ""){
					document.getElementById("currentposition").innerHTML = "none";
				}
			}
		}

	}
	else{
		// no sibling
		if(PLG.sprites[siblings[i]].margin_s){
			delete(PLG.sprites[siblings[i]].margin_s.pixel);
			delete(PLG.sprites[siblings[i]].margin_s.elder);
			delete(PLG.sprites[siblings[i]].margin_s.position);
		}
		if(margin_sibling == ""){
			margin_sibling = siblings[i] + ",,,,,";
		}
		else{
			margin_sibling += ";" + siblings[i] + ",,,,,";
		}
	}


	return margin_sibling;
}

//--------------------------------------------------------
// calcMarginsTowardsAscendants(id, onlyThisSprite)
//  id: ID of the target sprite
//  onlyThisSprite: Do not apply recursively. (default: false)
//
// This function calculates margin between the target sprite and its parent,
// and margin between the target sprite and its siblings,
// recursively toward to the root.
//--------------------------------------------------------
function calcMarginsTowardsAscendants(id, onlyThisSprite)
{
	var margin = "";
	var ascendantsMargin = "";
	if(PLG.sprites[id].parent && PLG.sprites[id].parent != "" && (!onlyThisSprite || onlyThisSprite != true)){
		ascendantsMargin = calcMarginsTowardsAscendants(PLG.sprites[id].parent);
	}

	if(margin == ""){
		margin = ascendantsMargin;
	}
	else if(ascendantsMargin != ""){
		margin += ";" + ascendantsMargin;
	}

  // Calculate margin between the target sprite and its siblings
	var siblings = null;
	if(PLG.sprites[id].parent && PLG.sprites[id].parent != ""){
		siblings = PLG.sprites[PLG.sprites[id].parent].children;
	}
	else{
		siblings = new Array();
		for (var id in PLG.sprites){
			if(!id.match(/^sprite_.+$/)){
				continue;
			}
			if(!PLG.sprites[id].parent || PLG.sprites[id].parent == ""){
				siblings.push(id);
			}
		}
	}

	// Calculate margin between the sibling sprite and its parent
	// calcParentMargin() must be before calcSiblingsMargin 
	// because isUpperSiblings() depends on calcParentMargin()
	for(var i=0; i<siblings.length; i++){
		var parentMargin = calcParentMargin(siblings[i]);
		if(margin == ""){
			margin = parentMargin;
		}
		else if(parentMargin != ""){
			margin += ";" + parentMargin;
		}
	}

	var siblingMargin = calcSiblingsMargin(siblings);
	if(margin == ""){
		margin = siblingMargin;
	}
	else if(siblingMargin != ""){
		margin += ";" + siblingMargin;
	}


	return margin;
}


//--------------------------------------------------------
// calcMarginsTowardsDescendants(id [,calcParent])
//  id: ID of the target sprite
//  calcParent: This param must be only used by recursive calls.
// This function calculates margin between the target sprite and its children,
// margin between the children, recursively toward to its leaves
//--------------------------------------------------------
function calcMarginsTowardsDescendants(id, calcParent)
{
	var margin = "";
	// Calculate margin between the target sprite and its parent
	if(calcParent && calcParent == true){
	  // This procedure is processed in only recursive calls.
		margin = calcParentMargin(id);
	}

	var children = PLG.sprites[id].children;	
	if(!children){
		return margin;
	}

	// Calculate margin between the children
	var siblingMargin = calcSiblingsMargin(children);
	if(margin == ""){
		margin = siblingMargin;
	}
	else if(siblingMargin != ""){
		margin += ";" + siblingMargin;
	}

	for(var i=0; i<children.length; i++){
		var childMargin = calcMarginsTowardsDescendants(children[i], true);
		if(margin == ""){
			margin = childMargin;
		}
		else if(childMargin != ""){
			margin += ";" + childMargin;
		}
	}
	
	return margin;
}


//------------------------------------------------------------
// calcParentMargin(id)
//  id: ID of the target sprite
//
// This function calculates margin between the target sprite and its parent.
//------------------------------------------------------------
function calcParentMargin(id)
{
	var margin = "";
	// Margin between a parent and a child

	var parentTop = 0;
	var parentBottom = 0;
	if(PLG.sprites[id].parent && PLG.sprites[id].parent != ""){
		parentTop = PLG.sprites[PLG.sprites[id].parent].position.absy;
		parentBottom = PLG.sprites[PLG.sprites[id].parent].position.absy + PLG.sprites[PLG.sprites[id].parent].height;
	}
	
	var childTop = PLG.sprites[id].position.absy + PLG.sprites[id].region.top;
	var childBottom = PLG.sprites[id].position.absy + PLG.sprites[id].region.bottom;

	var marginPosition ="";
	var marginPixel = 0;
	
	if((!PLG.sprites[id].parent ||  PLG.sprites[id].parent == "")
		&& childTop < 0 && childBottom > 0 
		 && PLG.sprites[id].position.absx + PLG.sprites[id].region.left < 0
		 && PLG.sprites[id].position.absx + PLG.sprites[id].region.right > 0
		){
			marginPosition = "NO"; // NOP
		}
	else if(parentBottom < childTop){
		marginPosition = "BT"; //Parent: Bottom, Child: Top
		marginPixel = childTop - parentBottom;
	}
	else if(parentTop < childTop && parentBottom >= childTop && parentBottom < childBottom){
		marginPosition = "BT"; //Parent: Bottom, Child: Top
		marginPixel = childTop - parentBottom;
	}
	else if(parentTop >= childTop && parentBottom < childBottom){
		marginPosition = "TT";
		marginPixel = childTop - parentTop;
		if(Math.abs(marginPixel) > (PLG.sprites[id].region.bottom - PLG.sprites[id].region.top)/2){
			marginPosition = "TB";
			marginPixel = childBottom - parentTop;
		}
	}
	else if(parentTop < childTop && parentBottom >= childBottom){
		if(childTop - parentTop < parentBottom - childTop){
			marginPosition = "TT"; //Parent: Top, Child: Top
			marginPixel = childTop - parentTop;
		}
		else{
			marginPosition = "BT"; //Parent: Bottom, Child: Top
			marginPixel = childTop - parentBottom;
		}
	}
	else if(parentTop >= childTop && parentTop < childBottom && parentBottom >= childBottom){
		marginPosition = "TB"; //Parent: Top, Child: Bottom
		marginPixel = childBottom - parentTop;
	}
	else{
		marginPosition = "TB"; //Parent: Top, Child: Bottom
		marginPixel = childBottom - parentTop;
	}
	if(!PLG.sprites[id].margin_p){
		PLG.sprites[id].margin_p = new Object();
	}
	PLG.sprites[id].margin_p.position = marginPosition;
	PLG.sprites[id].margin_p.pixel = marginPixel;

	margin = id + "," + marginPosition + "," + marginPixel + ",,,";

	return margin;
}


//------------------------------
// Save only styles of sprite
//------------------------------
function saveStyles(targetSprite)
{
  if(targetSprite == null){
    return;
	}
	// styles
	if(PLG.groupingFlag){
		var oldParent = targetSprite.parentNode;
		var oldGrandParent = oldParent.parentNode;
		var oldTop = 0;
		var oldLeft = 0;
		if(oldParent.id != "spriteslist"){
			oldLeft = sprLeftAbs(oldGrandParent);
			oldTop = sprTopAbs(oldGrandParent);
		}
		var newParent = PLG.selectedSprite;
		if(!PLG.commentFlag){
			if(PLG.groupingDirection == "left"){
				targetSprite.style.left = (sprLeftAbs(newParent) - oldLeft - sprWidth(targetSprite) - 3) + "px";
			}
			else if(PLG.groupingDirection == "right"){
				targetSprite.style.left = (sprLeftAbs(newParent) - oldLeft + sprWidth(PLG.selectedSprite) + 3) + "px";
			}
			else if(PLG.groupingDirection == "top"){
				targetSprite.style.top = (sprTopAbs(newParent) - oldTop - sprHeight(targetSprite) - 3) + "px";
			}
			else if(PLG.groupingDirection == "bottom"){
				targetSprite.style.top = (sprTopAbs(newParent) - oldTop + sprHeight(PLG.selectedSprite) + 3) + "px";
			}
		}
	}
  var zIndex = 0;
  if(PLG.fixedSprite != null && PLG.fixedSprite == targetSprite){
    zIndex = PLG.orgZindexOfFixedSprite;
	}
  else{
    zIndex = PLG.orgZindexOfSelectedSprite;
	}
  var styles = "left:" + sprLeft(targetSprite) + "px; "
    + "top:" + sprTop(targetSprite) + "px; "
    + "width:" + sprWidth(targetSprite) + "px; "
    + "z-index:" + zIndex + ";";

	// password
  var public_password = getCookie("public_password");
  if(document.getElementById("password-dialog")){
    var passwordElm = document.getElementById("dialog-pass");
    public_password = passwordElm.value;
  }
  if(public_password == undefined){
    public_password = "";
  }
  // grouping operation
	//   groupingCommand : for giving CGI
	//   groupSpritesHash : for modifying PLG.sprites
	if(PLG.groupingFlag){
		groupSpritesHash(PLG.selectedSprite, targetSprite);
	}
	else if(PLG.ungroupingFlag){
		EDT.orgSpritesHash = PLG.sprites.toJSONString();

		var list = document.getElementById("spriteslist");
		if(PLG.selectedSprite.parentNode.parentNode == targetSprite){
			groupSpritesHash(list, PLG.selectedSprite);
		}
		else{
			groupSpritesHash(list, targetSprite);
		}
	}
	else{
		calcRegionsOfTree(targetSprite.id);
	}

	// Re-calc margin
	var margin  = calcMarginsTowardsAscendants(targetSprite.id);
	rebuildYoungerArray();

	var groupingCommand = "";
	var authUngrouping = "false";
	if(PLG.groupingFlag){
		// parent,child;parent,child;...
		groupingCommand = PLG.selectedSprite.id + "," + targetSprite.id;
	}
	else if(PLG.ungroupingFlag){
		authUngrouping = "true";
		// ,child;,child;...
		if(PLG.selectedSprite.parentNode.parentNode == targetSprite){
			groupingCommand = "," + PLG.selectedSprite.id;
		}
		else{
			groupingCommand = "," + targetSprite.id;
		}
	}

  var postdata = "&id="+ targetSprite.id + "&pageid="+PARAM.pageid + "&public_password="+public_password + "&styles=" + styles + "&grouping=" + groupingCommand + "&authUngrouping=" + authUngrouping + "&margin=" + margin;

	var prevState = PLG.state;


	// callback function
	var saveStylesOnLoaded = function(obj){
		var res = obj.responseText;
		var resArray = res.split(",");
		if (resArray[0] == "invalid_public_password"){
			if(document.getElementById("password-dialog")){
				document.getElementById("dialog-result").innerHTML="Permission denied.";
			}
			else{
				openPasswordDialog(targetSprite, prevState);
			}
			return;
		}
		else if(resArray[0] != "succeed"){

			if(prevState == STATES.SCALING){
				targetSprite.style.width = EDT.orgWidth + "px";
				var menu = document.getElementById("spritemenu");
				var width = Math.round(EDT.orgWidth)/3;
				if(width < EDT.spriteMenuWidthMin){
					width = EDT.spriteMenuWidthMin;
				}
				menu.style.width = width + "px";

//				menu.style.width = (EDT.orgWidth + 6) + "px";
				removeSpriteIcons();
				removeFixedFrame();
			}
			else if(prevState == STATES.MOVING || prevState == STATES.MOVINGSELECTED){
				targetSprite.style.top = EDT.orgTop + "px";
				targetSprite.style.left = EDT.orgLeft + "px";
			}

			PLG.sprites = eval('(' + EDT.orgSpritesHash + ')');

			if(prevState == STATES.MOVINGSELECTED){
				removeGroupIcon(PLG.selectedSprite);
			}

			if(prevState == STATES.FIXEDSELECTED){
				removeSpriteIcons();
				removeFixedFrame();
				removeUngroupIcon();
			}
			clearSelectedSprite();
			clearFixedSprite();
			document.getElementById("controlresult").innerHTML=res;
			PLG.state = STATES.WORKING;
			PLG.waitSavingFlag = false;

			if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
				var spritesWorldNode = document.getElementById("spritesworld");     
				spritesWorldNode.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand.cur), default";
			}
			clearCanvas();
			return;
		}

		if(document.getElementById("password-dialog")){
			var passwordElm = document.getElementById("dialog-pass");
			var public_password = passwordElm.value;
			if(public_password != ""){
				setCookie("public_password", public_password, PARAM.CGIFILEPATH, 30);
			}
			var spritesWorldNode = document.getElementById("spritesworld");
			spritesWorldNode.removeChild(document.getElementById("password-dialog"));
		}

		if(PLG.state == STATES.MOVINGSELECTED){
			if(PLG.groupingFlag){
				removeFamilyFrame(targetSprite);
				groupSprites(PLG.selectedSprite, targetSprite);
				PLG.groupingFlag = false;
			}
			removeSelectedFrame(PLG.selectedSprite);
			removeGroupIcon(PLG.selectedSprite);
			clearSelectedSprite();
		}


		if(PLG.state == STATES.FIXEDSELECTED){
			if(PLG.ungroupingFlag){
				removeSelectedFrame();
				removeFamilyFrame(targetSprite);
				removeUngroupIcon();

				var list = document.getElementById("spriteslist");
				if(PLG.selectedSprite.parentNode.parentNode == targetSprite){
					groupSprites(list, PLG.selectedSprite);
				}
				else{
					groupSprites(list, targetSprite);
				}

				setFamilyFrame(targetSprite);
				setSelectedFrame(PLG.selectedSprite);
			}
		}
		else{
			PLG.state = STATES.FIXEDSELECTED;
			setSpriteIcons(targetSprite);
			setFixedFrame(targetSprite);
			setSelectedSprite(targetSprite);
			setFamilyFrame(targetSprite);
		}

		refreshMap();		

		var status = "&nbsp;&nbsp;(" + PLG.numberOfSprites + "sprites, " + Math.abs(PLG.worldRight - PLG.worldLeft) + "x" +Math.abs(PLG.worldBottom - PLG.worldTop) + "pixels)";
		document.getElementById("status").innerHTML = status;
		
    // set cursor
		if(PLG.cb.bw.mozes || PLG.cb.bw.msie || PLG.cb.bw.msie7){
			var spritesWorldNode = document.getElementById("spritesworld");     
			spritesWorldNode.style.cursor = "url(" + PARAM.IMAGEFILEPATH + "hand.cur), default";
		}

		PLG.waitSavingFlag = false;
	}

  sendRequest(saveStylesOnLoaded, postdata, "POST", PARAM.CGIFILEPATH + "saveStyles.cgi", true, true);
}

//--------------------------------
// Create comment
//--------------------------------
function createComment()
{
	removeFixedFrame();
	PLG.ignoreMouseDown = true;
	PLG.ignoreMouseUp = true;
	EDT.parentOfComment = PLG.fixedSprite;
	createSprite(false, true);
}


//--------------------------------
// Create sprite
//--------------------------------
function createSprite(imageFlag, commentFlag, doubleclickFlag)
{
	if(PLG.drawingFlag){
		return;
	}

  document.getElementById("controlresult").innerHTML="";

  var styles = "";
  var topOfNewSprite = 0;
	var leftOfNewSprite = 0;
  var xOffset = 0;
  var yOffset = 0;

  if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
    leftOfNewSprite = 5 - PLG.viewPositionX + parseInt(document.documentElement.scrollLeft) + Math.floor(Math.random()*70);
    topOfNewSprite = 5 - PLG.viewPositionY + parseInt(document.documentElement.scrollTop) + Math.floor(Math.random()*30);
  }
  else{
    if(PLG.cb.bw.safari){
      xOffset = parseInt(document.body.scrollLeft);
      yOffset = parseInt(document.body.scrollTop);
    }
    else{
      xOffset = parseInt(document.documentElement.scrollLeft);
      yOffset = parseInt(document.documentElement.scrollTop);
    }
    
    leftOfNewSprite = 5 - PLG.viewPositionX + xOffset + Math.floor(Math.random()*70);
    topOfNewSprite = 100 - PLG.viewPositionY + yOffset + Math.floor(Math.random()*30);
  }

	if(commentFlag){
		var width = Math.round(sprWidth(EDT.parentOfComment))/3;
		if(width < EDT.spriteMenuWidthMin){
			width = EDT.spriteMenuWidthMin;
		}
		leftOfNewSprite = sprLeftAbs(EDT.parentOfComment) + width - 50;
		topOfNewSprite = sprTopAbs(EDT.parentOfComment)-20;
	}
	if(doubleclickFlag){
		leftOfNewSprite = PLG.prevMouseDownX - PLG.viewPositionX + xOffset;
		topOfNewSprite = PLG.prevMouseDownY - PLG.viewPositionY + yOffset;
	}

	var widthOfNewSprite = 240;
	var contentsStyle = "border-width: 1px; border-style: solid; border-color: #a0a0a0; background-color: #ffffff; text-align: center; padding: 5px; display:block";
	var newContents = "<br>\nNew sprite\n<br>\n<br>\n";
	var newContents2 = "<br>\nNew sprite\n<br>\n<br>\n";
	if(commentFlag){
		newContents = "<br>\nNew comment\n<br>\n<br>\n";
		newContents2 = "<br>\nNew comment\n<br>\n<br>\n";
	}

	var newRecord = new Array();
	var drawCommand = "";
	if(imageFlag){
		if(PLG.drawRecord.length > 0){
			var offset = 8;
			var offset2 = offset + 3;
			leftOfNewSprite = PLG.drawCanvasLeft - offset2;
			topOfNewSprite = PLG.drawCanvasTop - offset2;

			leftOfNewSprite -= PLG.viewPositionX;
			topOfNewSprite -= PLG.viewPositionY;

			for(var i=0; i<PLG.drawRecord.length; i++){
				if(PLG.drawRecord[i] != "l")
				{
					newRecord.push(parseInt(PLG.drawRecord[i])-parseInt(PLG.drawCanvasLeft) + offset);
				}
				else{
					newRecord.push(PLG.drawRecord[i]);// l
					i++;
					newRecord.push(PLG.drawRecord[i]);// s
					i++;
					newRecord.push(PLG.drawRecord[i]);// c
					i++;
					newRecord.push(parseInt(PLG.drawRecord[i])-parseInt(PLG.drawCanvasLeft) + offset);
				}
				i++;
				newRecord.push(parseInt(PLG.drawRecord[i])-parseInt(PLG.drawCanvasTop) + offset);
			}

			var canvasWidth = (PLG.drawCanvasRight - PLG.drawCanvasLeft + offset * 2);
			newContents = "<canvas width='" + canvasWidth +"' height='" + (PLG.drawCanvasBottom - PLG.drawCanvasTop + offset * 2) + "' id='tmpid'></canvas><script type='text/javascript'>\n<!--\ndraw('tmpid," + newRecord.join() + "');\n// -->\n</script>";
			newContents2 = "<canvas width='" + canvasWidth +"' height='" + (PLG.drawCanvasBottom - PLG.drawCanvasTop + offset * 2) + "' id='tmpid'></canvas><script type='text/javascript'>\n<!--\ndraw('tmpid," + newRecord.join() + "');\n// -->\n</script>";
			drawCommand = "tmpid," + newRecord.join();

			contentsStyle = "";
			if(canvasWidth > EDT.spriteWidthMin){
				widthOfNewSprite = (PLG.drawCanvasRight - PLG.drawCanvasLeft) + offset * 2;
			}
			else{
				widthOfNewSprite = EDT.spriteWidthMin;
			}
			PLG.drawRecord = new Array();
		}
		else{
			return;
		}
	}
  var newContentsPost = encodeURIComponent(newContents);	
	var public_password = "";
	if(imageFlag){
		if(document.getElementById("drawingPassword")){
			public_password = document.getElementById("drawingPassword").value;
		}
	}
	if(public_password != ""){
		setCookie("public_password", public_password, PARAM.CGIFILEPATH, 30);
	}

	// posting
  var postdata = "&pageid="+PARAM.pageid+"&top="+topOfNewSprite+"&left="+leftOfNewSprite + "&width=" + widthOfNewSprite + "&style=" + contentsStyle + "&contents=" + newContentsPost + "&public_password=" + public_password;

	// callback function
	var createSpriteOnLoaded = function(obj){
		var res = obj.responseText;
		var resArray = res.split(",");
		if(resArray == null || resArray[0] != "succeed"){
			document.getElementById("controlresult").innerHTML=res;
			return;
		}

		var newSpriteID = resArray[1];

		var newAuthor = resArray[2]; // for showing "admin" instead of showing admin user name
		var newSpriteDate = resArray[3];
		var newSpriteDateStr = newSpriteDate.substring(0,4) + "/" + newSpriteDate.substring(4,6) + "/" + newSpriteDate.substring(6,8) + " " + newSpriteDate.substring(8,10) + ":" + newSpriteDate.substring(10,12) + ":" + newSpriteDate.substring(12,14);

		var liElm = document.createElement("li");
		liElm.setAttribute("class", "sprite");
		liElm.setAttribute("id", newSpriteID);
		liElm.style.width = widthOfNewSprite + "px";
		liElm.style.left = leftOfNewSprite.toString() + "px";
		liElm.style.top = topOfNewSprite.toString() + "px";
		liElm.style.zIndex = ZIND.SPRITE_CREATEMIN;
		liElm.style.borderWidth = "0px";
		liElm.style.borderStyle = "none";
		liElm.style.borderColor = "#ffffff";

		// for IE
		// IE does not apply .css here
		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			liElm.style.position = "absolute";
			liElm.style.listStyleType = "none";
			liElm.style.margin ="0px";
			liElm.style.padding = "0px";
			liElm.style.overflow = "visible";
			liElm.style.cursor= "auto";
			liElm.setAttribute("className", "sprite");
		}

		var regionElm = document.createElement("div");
		regionElm.setAttribute("class", "spriteregion");
		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			regionElm.style.cssText = "margin: 0px; border: 0px; padding: 3px; width: 100%; float: left;";
			regionElm.setAttribute("className", "spriteregion");
		}

		var contentsElm = document.createElement("div");
		contentsElm.setAttribute("class", "spritecontents");
		contentsElm.appendChild(document.createTextNode(""));

		if(imageFlag){
			var newHTML = newContents2.replace(/tmpid/g, newSpriteID+"_canvas");
			contentsElm.innerHTML = newHTML;
			// Alert!! ie cannot insert canvas via innerHTML
			if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
				var canvasElm = document.createElement("canvas");
				canvasElm.width = canvasWidth;
				canvasElm.height = (PLG.drawCanvasBottom - PLG.drawCanvasTop + offset * 2);
				canvasElm.setAttribute("id", newSpriteID+"_canvas");
				contentsElm.appendChild(canvasElm);
				G_vmlCanvasManager.initElement(canvasElm);
			}
			PLG.canvasSpriteExists = true;
		}
		else{
			contentsElm.innerHTML = newContents2;
		}

		if(!imageFlag){
			contentsElm.style.borderWidth = "1px";
			contentsElm.style.borderStyle = "solid";
			contentsElm.style.borderColor = "#a0a0a0";
			contentsElm.style.padding = "5px";
			contentsElm.style.textAlign = "center";
			contentsElm.style.backgroundColor = "#ffffff";
		}

		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			contentsElm.setAttribute("className", "spritecontents");
		}
		
		regionElm.appendChild(contentsElm);

		var infoElm = document.createElement("div");
		infoElm.setAttribute("class", "spriteinfo");
		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			infoElm.style.cssText = "width: 100%; font-size: 80%; left: 0px; right: 0px; margin: 0px; padding: 0px; border: 0px;";
			infoElm.setAttribute("className", "spriteinfo");
		}

		var ieMagic = document.createElement("span");
		ieMagic.setAttribute("class", "iemagic");
		ieMagic.appendChild(document.createTextNode(" "));		
		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			ieMagic.style.cssText = "float: right; font-size: 1px; line-height: 1px;";
			ieMagic.setAttribute("className", "iemagic");
		}
		infoElm.appendChild(ieMagic);


		var pluginElm = document.createElement("span");
		pluginElm.setAttribute("class", "spriteplugin");
		pluginElm.appendChild(document.createTextNode(""));
		pluginElm.style.display ="none";
		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			pluginElm.setAttribute("className", "spriteplugin");
		}

		infoElm.appendChild(pluginElm);

		if(!imageFlag){
			var authorElm = document.createElement("span");
			authorElm.setAttribute("class", "spriteauthor");
			authorElm.appendChild(document.createTextNode(newAuthor));
			authorElm.style.display ="block";
			if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
				authorElm.style.cssText = "display: block; float: right; margin-left: 5px; margin-right: 5px;";
				authorElm.setAttribute("className", "spriteauthor");
			}
			infoElm.appendChild(authorElm);

			var dateElm = document.createElement("span");
			dateElm.setAttribute("class", "spritedate");
			dateElm.appendChild(document.createTextNode(newSpriteDateStr));
			dateElm.style.display ="block";
			if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
				dateElm.style.cssText = "display: block; float: right; margin-left: 5px; margin-right: 5px;";
				dateElm.setAttribute("className", "spritedate");
			}
			infoElm.appendChild(dateElm);

			var positElm = document.createElement("span");
			positElm.setAttribute("class", "spriteuri");
			positElm.appendChild(document.createTextNode(""));
			positElm.innerHTML = "<a href='./positlog.cgi?load=" + PARAM.pageid + "&id=" + newSpriteID + "'>link</a>";
			positElm.style.display ="block";
			if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
				positElm.style.cssText = "display: block; float: right; margin-left: 5px; margin-right: 5px;";
				positElm.setAttribute("className", "spriteuri");
			}

			infoElm.appendChild(positElm);
		}

		regionElm.appendChild(infoElm);
		liElm.appendChild(regionElm);

		var ulElm = document.getElementById("spriteslist");
		ulElm.appendChild(liElm);

		regionElm.onmouseover = spriteOnMouseOver;

		var newSprite = document.getElementById(newSpriteID);

		PLG.sprites[newSpriteID] = new Object();
		PLG.sprites[newSpriteID].time = newSpriteDate;
		PLG.sprites[newSpriteID].author = newAuthor;
		PLG.sprites[newSpriteID].disp = [1,1,1];
		PLG.sprites[newSpriteID].position = new Object();
		PLG.sprites[newSpriteID].position.x = PLG.sprites[newSpriteID].position.absx = sprLeft(newSprite);
		PLG.sprites[newSpriteID].position.y = PLG.sprites[newSpriteID].position.absy = sprTop(newSprite);
		PLG.sprites[newSpriteID].region = new Object();
		PLG.sprites[newSpriteID].region.left = 0;
		PLG.sprites[newSpriteID].region.top = 0;
		PLG.sprites[newSpriteID].region.right =	sprWidth(newSprite);		
		PLG.sprites[newSpriteID].region.bottom =	sprHeight(newSprite);
		PLG.sprites[newSpriteID].height =	sprHeight(newSprite);
		PLG.sprites[newSpriteID].width =	sprWidth(newSprite);

		calcParentMargin(newSpriteID);

    // get list of all sprites
		var spritesListNode = document.getElementById("spriteslist");
		var topZ = newSprite.style.zIndex;
		var topSprite = newSprite;
		var spritesList = new Array();
		var spritesListNode = document.getElementsByTagName("li");
		for(var i=0; i<spritesListNode.length; i++){
			var elm = spritesListNode[i];
			if(elm.className == "sprite"){
				var tmpZ = parseFloat(elm.style.zIndex);
				if(elm != newSprite){
					if(tmpZ > topZ && tmpZ <= ZIND.SPRITE_MAX){
						topZ = tmpZ;
						topSprite = elm;
					}
				}
			}
		}

		if(topSprite != newSprite){
			if(topZ < ZIND.SPRITE_MAX){
				newSprite.style.zIndex = topZ+1;
			}
			else{
				newSprite.style.zIndex = ZIND.SPRITE_MAX;
			}
		}
		
		PLG.recentSpriteTimes.push(PLG.sprites[newSpriteID].time);
		var sortFunc = function(a,b){return b - a;};
		PLG.recentSpriteTimes.sort(sortFunc);

		if(imageFlag){
			var tmpCommand = drawCommand.replace(/tmpid/g, newSpriteID+"_canvas");
			draw(tmpCommand);
			execDrawCommand();
		}


		if(!imageFlag){
			PLG.state = STATES.FIXED;
			if(!commentFlag){
				setSpriteIcons(newSprite);
			}
			setFixedSprite(newSprite);
			setFixedFrame(newSprite);
		}



		refreshMap();

		PLG.numberOfSprites++;
		var status = "&nbsp;&nbsp;(" + PLG.numberOfSprites + "sprites, " + Math.abs(PLG.worldRight - PLG.worldLeft) + "x" +Math.abs(PLG.worldBottom - PLG.worldTop) + "pixels)";
		document.getElementById("status").innerHTML = status;

		if(commentFlag){
			moverOnMouseDown();
			PLG.groupingFlag = true;
		}
		if(doubleclickFlag){
			openEditor();
		}
	}

  sendRequest(createSpriteOnLoaded, postdata, "POST", PARAM.CGIFILEPATH + "createSprite.cgi", true, true);
}


//-----------------------------------
// Create New Page
//-----------------------------------
function createPage()
{
	if(PLG.drawingFlag){
		return;
	}

  var tmppagetitle = document.title;
  var leftBraceChar = "(";
  var rightBraceChar = ")";

  var pagetitleArray = tmppagetitle.split(" ");
  if(pagetitleArray == null){
    pageNumber = 2;
  }
  else{
    var pageNumber = pagetitleArray[pagetitleArray.length-1];
    var matchNumber = pageNumber.match(/\d+/);
    if(matchNumber){
      if(pageNumber.match(/\[/)){
        leftBraceChar = "[";
        rightBraceChar = "]";
      }

      if(pageNumber.match(/\{/)){
        leftBraceChar = "{";
        rightBraceChar = "}";
      }

      if(pageNumber.match(/#/)){
        leftBraceChar = "#";
        rightBraceChar = "";
      }


      pageNumber = parseInt(matchNumber) + 1;
      tmppagetitle = pagetitleArray[0] + " ";
      for(var i=1; i<pagetitleArray.length-1; i++){
        tmppagetitle += pagetitleArray[i] + " ";
      }
    }
    else{
      pageNumber = 2;
    }
  }

  var newpagetitle = window.prompt("Please enter the title of the new page.", tmppagetitle + " " + leftBraceChar + pageNumber + rightBraceChar);
  if(newpagetitle == ""){
    document.getElementById("controlresult").innerHTML = "The title is not entered.";
    return;
  }
  else if(newpagetitle == null){
    return;
  }


  var topOfNewSprite = 0;
	var leftOfNewSprite = 0;
  if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
    leftOfNewSprite = 5 - PLG.viewPositionX + parseInt(document.documentElement.scrollLeft) + Math.floor(Math.random()*70);
    topOfNewSprite = 5 - PLG.viewPositionY + parseInt(document.documentElement.scrollTop) + Math.floor(Math.random()*30);
  }
  else{
    var xOffset = 0;
    var yOffset = 0;
    if(PLG.cb.bw.safari){
      xOffset = parseInt(document.body.scrollLeft);
      yOffset = parseInt(document.body.scrollTop);
    }
    else{
      xOffset = parseInt(document.documentElement.scrollLeft);
      yOffset = parseInt(document.documentElement.scrollTop);
    }
    
    leftOfNewSprite = 5 - PLG.viewPositionX + xOffset + Math.floor(Math.random()*70);
    topOfNewSprite = 100 - PLG.viewPositionY + yOffset + Math.floor(Math.random()*30);
  }

	var createPageOnLoaded = function(obj){
		var res = obj.responseText;
		var resArray = res.split(",");
		if(resArray == null || resArray[0] != "succeed"){
			document.getElementById("controlresult").innerHTML=res;
			return;
		}

    // get pageid
		var urlArray = location.href.split("?");
		location.href = urlArray[0] + "?load=" + PARAM.pageid + "&mode=EditMode";
	}

  sendRequest(createPageOnLoaded, "&pageid="+PARAM.pageid+"&top="+topOfNewSprite+"&left="+leftOfNewSprite + "&newpagetitle="+newpagetitle , "POST", PARAM.CGIFILEPATH + "createPage.cgi", true, true);

} 



//-------------------------------------
// Event
//-------------------------------------


function editModeOnMouseMove(moveX, moveY)
{
	// Move sprite
  if(PLG.state == STATES.MOVING || PLG.state == STATES.MOVINGSELECTED){
		PLG.fixedSprite.style.left = (sprLeft(PLG.fixedSprite) + moveX) + "px";
		PLG.fixedSprite.style.top = (sprTop(PLG.fixedSprite) + moveY) + "px";
		PLG.sprites[PLG.fixedSprite.id].position.x += moveX;
		PLG.sprites[PLG.fixedSprite.id].position.y += moveY;
		PLG.sprites[PLG.fixedSprite.id].position.absx += moveX;
		PLG.sprites[PLG.fixedSprite.id].position.absy += moveY;

		if(EDT.showAllRegionFlag || EDT.showGuideFlag){
			calcRegionsOfTree(PLG.fixedSprite.id);
			calcMarginsTowardsAscendants(PLG.fixedSprite.id, true);
			rebuildYoungerArray();
			redrawCanvas(PLG.fixedSprite);
		}

	}
	else if(PLG.movingEditorFlag){
    // Move editor
		var editorElm = document.getElementById("editor");
		if(editorElm != null){
			editorElm.style.left = (editorElm.offsetLeft + moveX) + "px";
			editorElm.style.top = (editorElm.offsetTop + moveY) + "px";
			if(editorElm.offsetTop < 0){
				editorElm.style.top = "0px";
			}
			if(editorElm.offsetTop > getInnerHeight()-(document.getElementById("footer")).offsetHeight - 48){
				editorElm.style.top = getInnerHeight()-(document.getElementById("footer")).offsetHeight - 48 + "px";
			}
		}
  }
	else if(PLG.movingDrawingToolFlag){
    // Move drawing tool
		var tcsElm = document.getElementById("trianglecolorselector");
		if(tcsElm != null){
			var barElm = document.getElementById("drawingtitlebar");
			tcsElm.style.left = (tcsElm.offsetLeft + moveX) + "px";
			tcsElm.style.top = (tcsElm.offsetTop + moveY) + "px";
			if(tcsElm.offsetTop < barElm.offsetHeight){
				tcsElm.style.top = barElm.offsetHeight + "px";
			}
			if(tcsElm.offsetTop > getInnerHeight()-(document.getElementById("footer")).offsetHeight - 48){
				tcsElm.style.top = getInnerHeight()-(document.getElementById("footer")).offsetHeight - 48 + "px";
			}
			barElm.style.left = tcsElm.style.left;
			barElm.style.top = (tcsElm.offsetTop - barElm.offsetHeight) + "px";
		}
  }
  else if(PLG.state == STATES.SCALING){

    // Scale single Sprite
		var scalerElm = document.getElementById("sprite-scaler");

		var newWidth = sprWidth(PLG.fixedSprite) + moveX;

		if(newWidth < EDT.spriteWidthMin){
			newWidth = EDT.spriteWidthMin;
		}

		PLG.fixedSprite.style.width = newWidth + "px";
		var menu = document.getElementById("spritemenu");
		var width = Math.round(newWidth)/3;
		if(width < EDT.spriteMenuWidthMin){
			width = EDT.spriteMenuWidthMin;
		}
		menu.style.width = width + "px";


		scalerElm.style.left = (sprLeftAbs(PLG.fixedSprite) + sprWidth(PLG.fixedSprite) - 18 + PLG.viewPositionX) + "px";
		scalerElm.style.top = (sprTopAbs(PLG.fixedSprite) + sprHeight(PLG.fixedSprite) - 24 + PLG.viewPositionY) + "px";

  }
}


function editModeOnMouseUp()
{
	if(EDT.parentOfComment != null){
		removeSelectedFrame();
		clearSelectedSprite();
		setSelectedSprite(EDT.parentOfComment);
		PLG.state = STATES.MOVINGSELECTED;
		EDT.parentOfComment = null;
	}

  if(PLG.state == STATES.MOVING || PLG.state == STATES.MOVINGSELECTED){
		PLG.waitSavingFlag = true;
		if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
			var regionElm = getSpriteRegion(PLG.fixedSprite);
			regionElm.style.filter = "alpha(opacity=100)";
			var childList = PLG.fixedSprite.getElementsByTagName("li");
			for(var i=0; i<childList.length; i++){
				var child = childList[i];
				if(child.className == "sprite"){
					var regionElm2 = getSpriteRegion(child);
					regionElm2.style.filter = "alpha(opacity=100)";
				}
			}
		}
		else{
			PLG.fixedSprite.style.opacity = 1.0;
		}

		saveStyles(PLG.fixedSprite);
  }
  else if(PLG.movingEditorFlag){
		PLG.movingEditorFlag = false;
  }
  else if(PLG.state == STATES.SCALING){
		PLG.waitSavingFlag = true;
		if(PLG.cb.bw.msie){
       // Sprite width is automatically expanded to adujst to the width of inner image on IE6.
			var definedWidth = parseInt(PLG.fixedSprite.style.width.replace(/px/g, ""));
			var realWidth = parseInt(PLG.fixedSprite.offsetWidth) - 6;
			if(definedWidth < realWidth){
				PLG.fixedSprite.style.width = realWidth + "px";
				var menu = document.getElementById("spritemenu");

				var width = Math.round(realWidth)/3;
				if(width < EDT.spriteMenuWidthMin){
					width = EDT.spriteMenuWidthMin;
				}
//				menu.style.width = (realWidth + 6) + "px";
				menu.style.width = width + "px";

			}
		}
		saveStyles(PLG.fixedSprite);
  }
}




//-----------------------------
// Set selected/fixed sprites
//-----------------------------

function setSpriteIcons(spr)
{
	var width = Math.round(sprWidth(spr))/3;
	if(width < EDT.spriteMenuWidthMin){
		width = EDT.spriteMenuWidthMin;
	}
	var menu = document.getElementById("spritemenu");
	menu.style.left = (sprLeftAbs(spr) + PLG.viewPositionX) + "px";
	menu.style.top = (sprTopAbs(spr) - 20 + PLG.viewPositionY) + "px";

	menu.style.width = width + "px";	
	var mover = document.getElementById("sprite-mover");
	mover.style.width = (width - 46) + "px";
	menu.style.display = "block";
	var scalerElm = document.getElementById("sprite-scaler");
	scalerElm.style.left = (sprLeftAbs(spr) + sprWidth(spr) - 18 + PLG.viewPositionX) + "px";
	scalerElm.style.top = (sprTopAbs(spr) + sprHeight(spr) - 24 + PLG.viewPositionY) + "px";
	scalerElm.style.display = "block";
}




function setSelectedFrame(spr)
{
	var region = getSpriteRegion(spr);
	region.style.border = "1px dashed #20a020";
	region.style.padding = "2px";
}

function setUngroupIcon(spr)
{
	if(!document.getElementById("sprite-ungroup")){
		var ungroupElm = document.createElement("div");
		ungroupElm.setAttribute("id", "sprite-ungroup");

		ungroupElm.style.left = (Math.floor(sprWidth(spr)/2) -10) + "px";
		ungroupElm.style.top = (Math.floor(sprHeight(spr)/2) -10) + "px";

		ungroupElm.onmouseover = function(){
			if(PLG.state != STATES.MOVINGSELECTED && PLG.state != STATES.MOVING){
				ungroupElm.style.border = "2px solid #f06060";
				PLG.ungroupingFlag = true;
			}
		}

		var region = getSpriteRegion(spr);
		region.appendChild(ungroupElm);
	}
}

function removeUngroupIcon()
{
		if(document.getElementById("sprite-ungroup")){
			var ungroupElm = document.getElementById("sprite-ungroup");
			ungroupElm.parentNode.removeChild(ungroupElm);
			PLG.ungroupingFlag = false;
		}
}

function setFamilyFrame(spr)
{
	// drawcanvas interferes with spriteOnMouseOver event on a sprite 
	// that has canvas element on IE
	if(PLG.canvasSpriteExists && (PLG.cb.bw.msie || PLG.cb.bw.msie7)
		 && (PLG.state == STATES.MOVINGSELECTED || PLG.state == STATES.MOVING)
		 ){
			 return;
		 }
	if(PLG.drawcanvas != null && PLG.drawcanvas.getContext){
		PLG.drawcanvas.style.display="block";
		redrawCanvas(spr);
	}
}

function setFixedFrame(spr)
{
	var region = getSpriteRegion(spr);
	region.style.border = "1px solid #000000";
	region.style.padding = "2px";
}

//-----------------------------
// Clear selected/fixed sprites
//-----------------------------

function removeSpriteIcons()
{
	var menu = document.getElementById("spritemenu");
	menu.style.display = "none";
	var scalerElm = document.getElementById("sprite-scaler");
	scalerElm.style.display = "none";
}


function removeSelectedFrame()
{ 
	if(PLG.selectedSprite != null){
		var spr = PLG.selectedSprite;
		// reset to original border
		var region = getSpriteRegion(spr);
		region.style.border = "0px none black";
		region.style.padding = "3px";
	}

	if(PLG.state != STATES.FIXEDSELECTED){
		removeFamilyFrame(PLG.selectedSprite);
	}
}

function removeFamilyFrame(spr)
{
	if(PLG.drawcanvas != null && PLG.drawcanvas.getContext){
		clearCanvas();
		PLG.drawcanvas.style.display = "none";
	}
}

function removeFixedFrame()
{
		if(PLG.fixedSprite != null){
			// reset to original border
			var region = getSpriteRegion(PLG.fixedSprite);
			region.style.border = "0px none black";
			region.style.padding = "3px";

			removeFamilyFrame(PLG.fixedSprite);
		}

}


//----------------------------
// Group sprites
//----------------------------

function setGroupIcon(spr)
{
	var direction = "";

	if(PLG.sprites[PLG.fixedSprite.id].children){
		for(var i=0; i<PLG.sprites[PLG.fixedSprite.id].children.length; i++){
			if(spr.id == PLG.sprites[PLG.fixedSprite.id].children[i]){
				return;
			}
		}
	}

	if(!document.getElementById("sprite-group")){
		var groupElm = document.createElement("div");
		groupElm.setAttribute("id", "sprite-group");

		var yoffset = 0;
		if(PARAM.positlogMode == "EditMode"){
			var controlPanelNode = document.getElementById("controlpanel");
			yoffset = controlPanelNode.offsetHeight;
		}

		if(PLG.prevMouseX < sprLeftAbs(spr) + PLG.viewPositionX + Math.round(sprWidth(spr)/5)){
		  // left of sprite
			groupElm.style.left = "0px";
			groupElm.style.top = Math.round(sprHeight(spr)/2 -10) + "px";
			direction = "left";
		}
		else if(PLG.prevMouseX > sprLeftAbs(spr) + PLG.viewPositionX + Math.round(sprWidth(spr)*4/5)){
		  // right of sprite
			if(PLG.cb.bw.msie || PLG.cb.bw.msie7){
				groupElm.style.right = "0px";
			}
			else{
				groupElm.style.right = "-6px";
			}
			groupElm.style.top = (Math.round(sprHeight(spr)/2) -10) + "px";
			direction = "right";
		}
		else if(PLG.prevMouseY - yoffset < sprTopAbs(spr) + PLG.viewPositionY + Math.round(sprHeight(spr)/2)){
 		  // top of sprite
			groupElm.style.left = Math.round(sprWidth(spr)/2 -10) + "px";
			groupElm.style.top = "0px";
			direction = "top";
		}
		else if(PLG.prevMouseY - yoffset >= sprTopAbs(spr) + PLG.viewPositionY + Math.round(sprHeight(spr)/2)){
      // bottom of sprite
			groupElm.style.left = Math.round(sprWidth(spr)/2 - 10) + "px";
			groupElm.style.bottom = "0px";
			direction = "bottom";
		}

		groupElm.onmouseover = function(){
			groupElm.style.border = "2px solid #f06060";
			PLG.groupingFlag = true;
			PLG.groupingDirection = direction;
		}

		groupElm.onmouseout =  function(){
			if(!PLG.waitSavingFlag){
				groupElm.style.border = "2px solid #606060";
				groupElm.style.backgroundColor = "";
				PLG.groupingFlag = false;
				PLG.groupingDirection = "";
			}
		}
		var region = getSpriteRegion(spr);
		region.appendChild(groupElm);
	}
}

function removeGroupIcon(spr)
{
  var groupElm = document.getElementById("sprite-group");
  if(groupElm != undefined && groupElm != null ){
		var region = getSpriteRegion(spr);
		region.removeChild(groupElm);
		PLG.groupingFlag = false;
  }
}


function groupSpritesHash(newParent, child)
{
  var oldParent = child.parentNode;
	var oldGrandParent = oldParent.parentNode;

  // Calc the new position of the child
  var oldTop = 0;
  var oldLeft = 0;
	var x = 0;
	var y = 0;
  if(oldParent.id != "spriteslist"){
		oldLeft = sprLeftAbs(oldGrandParent);
		oldTop = sprTopAbs(oldGrandParent);
	}
  if(newParent.id == "spriteslist"){
		x = (sprLeft(child) + oldLeft);
		y = (sprTop(child) + oldTop);
		delete(PLG.sprites[child.id].parent);
  }
	else{
		var newLeft = sprLeftAbs(newParent);
		var newTop = sprTopAbs(newParent);
		x = (sprLeft(child) + oldLeft - newLeft);
		y = (sprTop(child) + oldTop - newTop);

		// Add the child to the new parent
		PLG.sprites[child.id].parent = newParent.id;
		if(!PLG.sprites[newParent.id].children){
			PLG.sprites[newParent.id].children = new Array();
		}
		PLG.sprites[newParent.id].children.push(child.id);
  }

  // Re-calc the region of the tree including the child
	calcRegionsOfTree(child.id, x, y);

  if(oldParent.id != "spriteslist"){
		for(var i=0; PLG.sprites[oldGrandParent.id].children.length; i++){
			if(PLG.sprites[oldGrandParent.id].children[i] == child.id){
				var children = PLG.sprites[oldGrandParent.id].children.slice(0,i);
				var children2 = PLG.sprites[oldGrandParent.id].children.slice(i+1);
				PLG.sprites[oldGrandParent.id].children = children.concat(children2);
				if(PLG.sprites[oldGrandParent.id].children.length == 0){
					delete(PLG.sprites[oldGrandParent.id].children);
				}
				break;
			}
		}

		// Re-calc the region of the tree including the old parent
		calcRegionsOfTree(oldGrandParent.id);
  }
}



// connect parent with child
function groupSprites(newParent, child)
{
  var oldParent = child.parentNode;
	var oldGrandParent = oldParent.parentNode;
  
  var oldTop = 0;
  var oldLeft = 0;
  if(oldParent.id != "spriteslist"){
		oldLeft = sprLeftAbs(oldGrandParent);
		oldTop = sprTopAbs(oldGrandParent);
	}

  if(newParent.id == "spriteslist"){
		child.style.left = (sprLeft(child) + oldLeft) + "px";
		child.style.top = (sprTop(child) + oldTop) + "px";
		newParent.appendChild(child);
  }
	else{
		var newLeft = sprLeftAbs(newParent);
		var newTop = sprTopAbs(newParent);

		child.style.left = (sprLeft(child) + oldLeft - newLeft) + "px";
		child.style.top = (sprTop(child) + oldTop - newTop) + "px";


		var tmpNodes = newParent.childNodes;
		var existingUlElm = null;
		for(var i=0; i<tmpNodes.length; i++){
			var elm = tmpNodes[i];
			if(elm.className == "parent" && elm.tagName.match(/ul/i)){
				existingUlElm = elm;
			}
		}
		if(existingUlElm == null){
			var ulElm = document.createElement("ul");
			ulElm.className = "parent";
			ulElm.appendChild(child);
			newParent.appendChild(ulElm);
		}
		else{
			existingUlElm.appendChild(child);
		}
  }

  if(oldParent.id != "spriteslist"){
		var tmpNodes = oldParent.childNodes;
		var hasChild = false;
		for(var i=0; i<tmpNodes.length; i++){
			var elm = tmpNodes[i];
			if(elm.tagName.match(/li/i)){
				hasChild = true;
				break;
			}
		}
		if(!hasChild){
      // remove ul element
			oldGrandParent.removeChild(oldParent);
		}
  }

}



// JSON
if (!Object.prototype.toJSONString) {
  Array.prototype.toJSONString = function () {
    var a = ['['], b, i, l = this.length, v;

    function p(s) {
      if (b) {
        a.push(',');
      }
      a.push(s);
      b = true;
    }

    for (i = 0; i < l; i += 1) {
      v = this[i];
      switch (typeof v) {
        case 'undefined':
        case 'function':
        case 'unknown':
        break;
        case 'object':
        if (v) {
          if (typeof v.toJSONString === 'function') {
            p(v.toJSONString());
          }
        } else {
          p("null");
        }
        break;
        default:
        p(v.toJSONString());
      }
    }
    a.push(']');
    return a.join('');
  };

  Boolean.prototype.toJSONString = function () {
    return String(this);
  };

  Date.prototype.toJSONString = function () {

    function f(n) {
      return n < 10 ? '0' + n : n;
    }

    return '"' + this.getFullYear() + '-' +
    f(this.getMonth() + 1) + '-' +
    f(this.getDate()) + 'T' +
    f(this.getHours()) + ':' +
    f(this.getMinutes()) + ':' +
    f(this.getSeconds()) + '"';
  };

  Number.prototype.toJSONString = function () {
    return isFinite(this) ? String(this) : "null";
  };

  Object.prototype.toJSONString = function () {
    var a = ['{'], b, i, v;

    function p(s) {
      if (b) {
        a.push(',');
      }
      a.push(i.toJSONString(), ':', s);
      b = true;
    }

    for (i in this) {
      if (this.hasOwnProperty(i)) {
        v = this[i];
        switch (typeof v) {
          case 'undefined':
          case 'function':
          case 'unknown':
          break;
          case 'object':
          if (v) {
            if (typeof v.toJSONString === 'function') {
              p(v.toJSONString());
            }
          } else {
            p("null");
          }
          break;
          default:
          p(v.toJSONString());
        }
      }
    }
    a.push('}');
    return a.join('');
  };


    (function (s) {
      var m = {
          '\b': '\\b',
          '\t': '\\t',
          '\n': '\\n',
          '\f': '\\f',
          '\r': '\\r',
          '"' : '\\"',
          '\\': '\\\\'
      };

       s.toJSONString = function () {
         if (/["\\\x00-\x1f]/.test(this)) {
                return '"' + this.replace(/([\x00-\x1f\\"])/g, function(a, b) {
                    var c = m[b];
                    if (c) {
                        return c;
                    }
                    c = b.charCodeAt();
                    return '\\u00' +
                        Math.floor(c / 16).toString(16) +
                        (c % 16).toString(16);
                }) + '"';
            }
            return '"' + this + '"';
        };
    })(String.prototype);
}
