#!/usr/local/bin/perl

# --------------------------------------------------------
#
# saveStyles.cgi:
#      cgi for saving styles of Sprite 
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
# Additional library
use JSON;
# Additional plugins
use PositLogConfig;
use PositLogAuth;
use PositLogGroup;


my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8'); # HTTP header

my $public_password = $CGI->param("public_password");
my $pageid = $CGI->param("pageid");

my $spriteID = $CGI->param("id");
my $styles = $CGI->param("styles");

my $groupingCommand = $CGI->param("grouping");
my $marginCommand = $CGI->param("margin");

# $authUngrouping can be "true" only when user's ungrouping operation.
# owner of parent and owner of child can ungroup them
my $authUngrouping = $CGI->param("authUngrouping");

my $stories = $CGI->param("stories");
my $storiesHash = jsonToObj($stories);

# Read temporal cookie
my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";

PositLogAuth::authenticateUser($loginid, $loginpass);
PositLogAuth::authenticatePage($loginid, $pageid);

my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")} or {};
if($spritesHash eq ""){	print "Cannot read sprites.dat."; exit(0); }

if(!$spritesHash->{$spriteID}){
		print "Permission denied.";
		exit(0);
}

my $anotherID = "";
if($authUngrouping eq "true"){
		$groupingCommand =~ /(.*),(.*)/;
		my $parent = $1;
		my $child = $2;
		my $oldParent = $spritesHash->{$child}{"parent"};

		if($child eq $spriteID){
				$anotherID = $oldParent;
		}
		else{
				$anotherID = $child;
		}
}

# set author_id if it does not exist
if($spritesHash->{$spriteID}{"author_id"} eq "")
{
    if(PositLogAuth::isAdminUser)
    {
				$spritesHash->{$spriteID}{"author_id"} = "admin";
    }
    else
    {
				$spritesHash->{$spriteID}{"author_id"} = $loginid;
    }
}

# Can fix it?
my $canFix = "true";
if($spritesHash->{$spriteID}{"author_id"} eq "public")
{
    my $cryptpass = $spritesHash->{$spriteID}{"public_password"};
    if($cryptpass ne "" && !PositLogAuth::isAdminUser && !PositLogAuth::isPageCreator)
    {
				my $salt="zi";
				my $cryptpass2 = crypt($public_password, $salt);
				if($cryptpass ne $cryptpass2)
				{
						$canFix = "invalid_public_password";
				}
    }
}
elsif($spritesHash->{$spriteID}{"author_id"} ne $loginid 
      && !PositLogAuth::isAdminUser
      && !PositLogAuth::isPageCreator
    )
{
		$canFix = "Permission denied.";
}

my	$canFix2 = "false";
if($canFix ne "true" && $anotherID ne ""){
		$canFix2 = "true";
		if($spritesHash->{$anotherID}{"author_id"} eq "public")
		{
				my $cryptpass = $spritesHash->{$anotherID}{"public_password"};
				if($cryptpass ne "" && !PositLogAuth::isAdminUser)
				{
						my $salt="zi";
						my $cryptpass2 = crypt($public_password, $salt);
						if($cryptpass ne $cryptpass2)
						{
								$canFix2 = "invalid_public_password";
						}
				}
		}
		elsif($spritesHash->{$anotherID}{"author_id"} ne $loginid 
					&& !PositLogAuth::isAdminUser
					&& !PositLogAuth::isPageCreator
				)
		{
				$canFix2 = "Permission denied.";
		}
}

if($canFix ne "true" && $canFix2 ne "true"){
		if($canFix eq "invalid_public_password" || $canFix2 eq "invalid_public_password"){
				print "invalid_public_password";
		}
		else{
				print "Permission denied.";
		}
		exit(0);
}

# save styles
my $orgStyles = $spritesHash->{$spriteID}{"style"};
$spritesHash->{$spriteID}{"style"} = $styles;

# grouping 
if($groupingCommand ne ""){
		my @commandList = split(/;/, $groupingCommand);
		my $result = PositLogGroup::group($spritesHash, \@commandList);
		if($result == 0){
				$spritesHash->{$spriteID}{"style"} = $orgStyles;
				print "Permission denied.";
				exit(0);
		}
}

#set margin
if($marginCommand ne ""){
		my @marginList = split(/;/, $marginCommand);
		foreach my $margin (@marginList){
				if($margin =~ /^(\w+?),(\w+?),(-?\d+?),,,$/){
						if(!$spritesHash->{$1}){
								next;
						}
						$spritesHash->{$1}{"margin_p"}{"position"} = $2;
						$spritesHash->{$1}{"margin_p"}{"pixel"} = $3;
				}
				elsif($margin =~ /^(\w+?),,,(\w+?),(-?\d+?),(\w+?)$/){
						$spritesHash->{$1}{"margin_s"}{"elder"} = $2;
						$spritesHash->{$1}{"margin_s"}{"pixel"} = $3;
						$spritesHash->{$1}{"margin_s"}{"position"} = $4;
				}
				elsif($margin =~ /^(\w+?),,,,,$/){
						delete $spritesHash->{$1}{"margin_s"};
				}
		}
}


# set stories
foreach my $tmpid (keys %$storiesHash){
		$spritesHash->{$tmpid}{"story"}{"prev"} = $storiesHash->{$tmpid}{"prev"};
		$spritesHash->{$tmpid}{"story"}{"next"} = $storiesHash->{$tmpid}{"next"};
		$spritesHash->{$tmpid}{"story"}{"margin"} = $storiesHash->{$tmpid}{"margin"};
}

my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
if($configHash eq ""){ print "Cannot read the page configuration."; exit(0); }


# change modified time
my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $time = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
#$spritesHash->{$spriteID}{"modified_time"} = $time;
$configHash->{"modified_time"} = $time;

# save sprites.dat
if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"}){ print "Cannot write sprites.dat.";	exit(0); }

# save config.dat
if(!eval{Storable::lock_nstore $configHash, $PositLogConfig::datapath . $pageid . "/config.dat"}) { print "Cannot write the page configuration."; exit(0); }


print "succeed";

