#!/usr/local/bin/perl

# --------------------------------------------------------
# pagemanager.cgi
#      cgi for PositLog page management
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------


use strict;
use CGI qw/-debug :standard/;
use CGI::Cookie;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;

# parameters are already URL decoded.
my $CGI = new CGI;

# administration command
my $command = $CGI->param("command");

my $newpagetitle = $CGI->param("newpagetitle");

my $homepagetitle = $CGI->param("homepagetitle");

my $pageid = $CGI->param("page");

my $listcounter_page = $CGI->param("listcounter_page");

#--------------------------------------
# Authentication
#--------------------------------------

my $loginid = $CGI->param("loginid");
my $loginpass = $CGI->param("loginpass");

if($loginid eq "")
{
# Read temporal cookie
	$loginid = $CGI->cookie("loginid") || "";
	$loginpass = $CGI->cookie("loginpass") || "";
}

if($loginid eq "public")
{
	$loginid = "";
}

my $cookieUser = new CGI::Cookie(
-path => "$PositLogConfig::cgipath",
-name => "loginid",
-value => "$loginid",
#-domain => "$cookieDomain"
);
my $cookiePass = new CGI::Cookie(
-path => "$PositLogConfig::cgipath",
-name => "loginpass",
-value => "$loginpass",
#-domain => "$cookieDomain"
);

# Print HTTP header
# (Set cookies)
print $CGI->header(-charset => 'utf-8', -cookie => [$cookieUser,$cookiePass]); 

my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;

# Check admin -> Check valid user -> show error
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{

	my $cryptpass = $adminnameAuth->{$loginid}{"password"};
    my $salt="lc";
    my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 1;
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
		$validUser = 0;
		$adminUser = 0;
	}
}
elsif($useridAuth ne "" && $useridAuth->{$loginid})
{
	my $cryptpass = $useridAuth->{$loginid}{"password"};
    my $salt="ry";
    my $cryptpass2 = crypt($loginpass, $salt);
	if($cryptpass eq $cryptpass2)
	{
		$validUser = 1;
		$adminUser = 0;
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
		$validUser = 0;
		$adminUser = 0;
	}
}
else
{
	if($loginid eq ""	&& $loginpass eq "")
	{
		$loginerror = "";
	}
	else
	{
		$loginerror = "<span style='color:red; font-size:12px;'>Invalid user id or password!</span>";
	}
	$validUser = 0;
	$adminUser = 0;
}



if(!$adminUser)
{
	my $checked = "";
	my $savedpass = "";
	if($loginid eq ""){
			$loginid = $CGI->cookie("savedloginid");
			$savedpass = $CGI->cookie("savedloginpass");
			if($loginid ne ""){
					$checked = "checked";
			}
	}

	my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "logincheck.css' type='text/css'>\n
		<script type='text/javascript'>
		<!--
		function saveOnClick()
		{
				theDay = new Date();
				theDay.setTime(theDay.getTime() + (30 * 1000 * 60 * 60 * 24));
				var box = document.getElementById('saveaccount');
				var loginid = document.getElementById('loginid').value;
				var loginpass = document.getElementById('loginpass').value;
				if(loginid == '' || loginpass == ''){
						box.checked = false;
						alert('Please enter user name and password')
						return;
				}
				if(!box.checked){
						loginid = '';
						loginpass = '';
				}
				var cs='savedloginid='+loginid+';';
				cs+=' path=" . $PositLogConfig::cgipath . ";';
				if(box.checked)
				{
						cs+=' expires='+theDay.toGMTString()+';';
				}
				document.cookie=cs;

				cs='savedloginpass='+loginpass+';';
				cs+=' path=" . $PositLogConfig::cgipath . ";';
				if(box.checked)
				{
						cs+=' expires='+theDay.toGMTString()+';';
				}
				document.cookie=cs;
		}
		// -->
		</script>
		<title>PositLog Administration : Login</title>\n
	</head>\n";

	my $BODY = "<body onLoad='document.loginform.loginid.focus()'>\n
  <div id='logintop'>\n
  <div id='login'>\n
  <h1>Login to Positlog Administration</h1>\n
  <form id='loginform' action='pagemanager.cgi' method='post'>\n
    <p>\n
      user name<br>\n
      <input type='text' name='loginid' id='loginid' value='" . $loginid . "' size='20' tabindex='1'>\n
    </p>\n
    <p>\n
      password<br>\n
      <input type='password' name='loginpass' id='loginpass' value='" . $savedpass . "' size='20' tabindex='2'>\n
    </p>\n
    <p id='saveaccount-label'>\n
    Save my user name and password&nbsp;&nbsp;<input type='checkbox' name='saveaccount' id='saveaccount' onclick='saveOnClick();' value='1' " . $checked . ">\n
    </p>\n
    <p id='submitarea'>\n" . $loginerror . 
    "<br/><input type='submit' id='submitbtn' value='Login' tabindex='3'>\n
    </p>\n
  </form>\n
  </div>\n
  <div id='copyright'>\n
  Powered by PositLog\n
  </div>\n
  </div>\n
</body>\n";

	my $FOOTER = "</html>";

	print $HEADER . $BODY . $FOOTER;
	exit(0);

}


#---------------------------------------------------------
# Generate Page List 
#---------------------------------------------------------

sub generatePageList
{
    my (@PageList, $statusStr) = @_;

    my $BODY .="<h3 class='pagemanagement'>Page List</h3>\n";

	$BODY .= "<form id='pagelistform' action='./pagemanager.cgi' method='POST' onSubmit='return deletePages()'>\n";

	$BODY .= "<div class='PageNameArea'>&nbsp;</div><div class='PageEditArea'>&nbsp;</div><div class='PagePropertyArea'>&nbsp;</div>";

	$BODY .= "<input type='submit' name='btn_deletepages' value='delete checked pages' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'>\n";

	my %pagetitlePageid;
	my @PageTitleList;
    foreach my $pid  (@PageList)
	{
		if($pid eq "." || $pid eq ".." || $pid eq ".htaccess")
		{
			next;
		}

		my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/config.dat")} or {};
		if($configHash eq "")
		{
			print "Cannot read the page configuration of $pid .<br>\n";
			next;
		}

		if($pagetitlePageid{$configHash->{"page_title"}} ne "")
		{
			my $postfix = "";
			do
			{
				$postfix .= "*";
			}
			while($pagetitlePageid{$configHash->{"page_title"} . $postfix} ne "");
			$pagetitlePageid{$configHash->{"page_title"} . $postfix} = $pid;
			push(@PageTitleList, $configHash->{"page_title"} . $postfix);
		}
		else
		{
			$pagetitlePageid{$configHash->{"page_title"}} = $pid;
			push(@PageTitleList, $configHash->{"page_title"});
		}

	}

    my $pagecounter = 0;
    foreach my $ptitle (sort {$a cmp $b} @PageTitleList)
    {
		$pagecounter++;

		my $pageclass = "pageline1";
		if($pagecounter % 2 == 0)
		{
			$pageclass = "pageline2";
		}
		my $pid = $pagetitlePageid{$ptitle};

		my $pagecounterStr = sprintf("%03d", $pagecounter);
		$BODY .= "<div class='" . $pageclass . "'>\n"
			. "<div class='PageNameArea'>"
			. $pagecounterStr . ".&nbsp;&nbsp;&nbsp;\n"
			. "<a href='./positlog.cgi?load=" . $pid  . "'><span class='pagename' id='pagename_" . $pagecounter . "'>" . $ptitle . "</span></a>\n"
			. "</div>\n"

			. "<div class='PageEditArea'>" . "<a href='./positlog.cgi?load=" . $pid  . "&amp;mode=EditMode'>edit</a></div>\n"
			. "<div class='PagePropertyArea'>" . "<a href='./pageproperty.cgi?page=" . $pid  . "'>property</a></div>\n"

			. "<div class='DeleteCheckArea'><input type='checkbox' name='pagedeletecheck_" . $pagecounter . "' value='" . $pid  . "'>delete</div>\n"

			. "</div>\n\n";
    }

	$BODY .= "<input type='hidden' name='listcounter_page' id='listcounter_page' value='" . $pagecounter . "'>\n";
	$BODY .= "<input type='hidden' name='command' value='deletepages'>\n";


	$BODY .= "</form>";

    return $BODY;
}



#---------------------------------------------------------
# Generate JavaScript
#---------------------------------------------------------

my $ScriptBody = <<__ScriptBody__;
<script type='text/javascript'>
<!--

function addNewPage()
{
	if(document.getElementById('newpagetitle').value == ''){alert('Please enter a page name.');return false;}

	return true;
}


function deletePages()
{
	var deletePageList = "";

    var reg = new RegExp("^pagedeletecheck_", "i");

	var counter = 1;
	for(var i=0; i<document.forms["pagelistform"].elements.length; i++)
	{
		if (document.forms["pagelistform"].elements[i].name.match(reg))
		{
			if(document.forms["pagelistform"].elements[i].checked)
			{
				deletePageList += document.getElementById("pagename_" + counter).innerHTML + ", ";
			}
			counter++;
		}
	}
	
	var mes = "Delete Pages: ";
	if(counter == 2)
	{
		mes = "Delete Page: ";
	}

	if(deletePageList == "")
	{
		alert('Please check one or more page names.');
		return false;
	}
	else{
		if(window.confirm(mes + deletePageList.substr(0, deletePageList.length-2) + ' ?'))
		{
			return true;
		}
	}
}


function btnAreaMouseOver(elm)
{
	elm.style.backgroundColor = "#ffd0d0";
}

function btnAreaMouseOut(elm)
{
	elm.style.backgroundColor = "#ffffff";
}

// -->
</script>
__ScriptBody__

#---------------------------------------------------------
# Generate HTML
#---------------------------------------------------------

	my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<meta http-equiv='Content-Style-Type' content='text/css'>\n
		<link rel='stylesheet' href='" . $PositLogConfig::systempath . "positlog_admin.css' type='text/css'>\n
                <meta http-equiv='Content-Script-Type' content='text/javascript'>
		<title>PositLog Page Management</title>\n"
	. $ScriptBody
	. "</head>\n";

my $BODY ="";


sub generateMainPage
{
	my ($statusStr) = @_;

	my $BODY = "<body class='pagemanage'>\n";

	my @PageList;

	my $usernamestr = "";
	if($adminUser)
	{
		$usernamestr = "<span class='usernamearea'>You are the 'admin' user.</span>";
	}
	else
	{
		$usernamestr = "<span class='usernamearea'>Your id is '$loginid'.</span>";
	}
	$BODY .="<h1><a href='./positlogadmin.cgi'>PositLog Administration</a>&nbsp;&nbsp;&nbsp;&nbsp;$usernamestr [<a href='./positlogadmin.cgi?command=logout'>logout</a>]</h1>\n";

	$BODY .="<h2 class='pagemanagement'>Page Management</h2>\n";

	$BODY .="<p><span class='StatusArea'>" . $statusStr . "</span></p>";



    my $homepageid = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "homepage.cgi")} or {};
    if($homepageid ne "")
    {
	my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $$homepageid . "/config.dat")} or {};
	if($configHash ne "")
	{
	    $BODY .="<h4 class='pagemanagement'>Current Home Page</h4>\n";
	    $BODY .= "<div class='pageline1'>\n"
		. "<div class='PageNameArea'>Home&nbsp;&nbsp;&nbsp;\n"
		. "<a href='./positlog.cgi?load=" . $$homepageid  . "'><span class='pagename' id='pagename_home'>"
		. $configHash->{"page_title"} . "</span></a>\n"
		. "</div>\n"
		. "<div class='PageEditArea'>" . "<a href='./positlog.cgi?load=" . $$homepageid  . "&amp;mode=EditMode'>edit</a></div>\n"
		. "<div class='PagePropertyArea'>" . "<a href='./pageproperty.cgi?page=" . $$homepageid  . "'>property</a></div>\n"
		. "</div>";
	}

    }

	$BODY .="<h4 class='pagemanagement'>Change Home Page</h4>\n";
	$BODY .= "<ul id='howtotext'><li>以下のページのうち，ホームページにしたいページのタイトルを入力してください．</ul>";

	$BODY .= "<form id='form_changehomepage' action='./pagemanager.cgi' method='post'>\n"
		. "<div class='NewPageNameArea'>Title<br><input type='text' name='homepagetitle' id='homepagetitle' size='24' tabindex='1'></div>\n"
		. "<div class='NewPageBtnArea'><br><input type='submit' id='btn_newpage' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Change home page'  tabindex='2'></div>\n";
	
	$BODY .= "<input type='hidden' name='command' value='changehomepage'>\n"
		. "</form>\n\n";


	# Create new page
	$BODY .="<h4 class='pagemanagement'>Create New Page</h4>\n";

	$BODY .= "<ul id='howtotext'><li>新しいページのタイトルを入力してください．UTF-8 文字セットに含まれる文字が利用可能です．（このままふつうに日本語か英語を入力すればOKです．）</ul>";

	$BODY .= "<form id='form_newpage' action='./pagemanager.cgi' onSubmit='return addNewPage()' method='post'>\n"
		. "<div class='NewPageNameArea'>Title<br><input type='text' name='newpagetitle' id='newpagetitle' size='24' tabindex='1'></div>\n"
		. "<div class='NewPageBtnArea'><br><input type='submit' id='btn_newpage' class='applybtn'  onmouseout='btnAreaMouseOut(this)'   onmouseover='btnAreaMouseOver(this)'  value='Create this page'  tabindex='2'></div>\n";
	
	$BODY .= "<input type='hidden' name='command' value='addnewpage'>\n"
		. "</form>\n\n";

    if($pageid ne "")
    {
		push(@PageList, $pageid);
    }
    else{
		# Get page list
		opendir( DATADIR, $PositLogConfig::datapath );
		@PageList = readdir( DATADIR );
		closedir( DATADIR );
    }
    
    $BODY .= generatePageList(@PageList);

	return $BODY;
}


#---------------------------------------------------------------
# command processor
#---------------------------------------------------------------

if($command eq "")
{
	$BODY = generateMainPage();
}
elsif($command eq "changehomepage")
{
    # Get current page list
    opendir( DATADIR, $PositLogConfig::datapath );
    my @PageList = readdir( DATADIR );
    closedir( DATADIR );
    
    my $homepageid = "";
    foreach my $pid (@PageList)
    {
	if($pid eq "." || $pid eq ".." || $pid eq ".htaccess")
	{
	    next;
	}

	my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/config.dat")} or {};
	if($configHash eq ""){ print "Cannot read the page configuration.<br>\n"; print "<a href='./pagemanager.cgi'>back</a></div>\n"; exit(0); }
	
	if($configHash->{"page_title"} eq $homepagetitle)
	{
	    $homepageid = $pid;
	}
    }

    if($homepageid eq "")
    {
	print "The page does not exist.\n";
	print "<a href='./pagemanager.cgi'>back</a></div>\n";
    }

   
    if(!eval{Storable::lock_nstore \$homepageid, $PositLogConfig::adminpath . "homepage.cgi"})
    {
	print "Cannot create the homepage data.\n";
	print "Please check the file permission.<br>\n";
	print "<a href='./pagemanager.cgi'>back</a></div>\n";
	exit(0);
    }

}
elsif($command eq "addnewpage")
{
    #---------------------------------------------------------
    # Create a new page
    #---------------------------------------------------------

	# Get current page list
	opendir( DATADIR, $PositLogConfig::datapath );
	my @PageList = readdir( DATADIR );
	closedir( DATADIR );


    # generate new pageID
	my $newpageid = "";
	my @alpha = ('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
	do
	{
		my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
		($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
		my $createtime = sprintf("%02d%02d%02d", $year+1900-2000, $mon+1, $mday);
		my $rand = int (rand(52));
		my $rand2 = int (rand(52));
		$newpageid = $createtime . $alpha[$rand] . $alpha[$rand2];
	}
	while((grep {$_ eq $newpageid} @PageList) != 0);


	if(!mkdir($PositLogConfig::datapath . $newpageid, 0755))
    {
		print "Cannot create a page directory '" . $newpageid . " '.\n";
		print "Please check file permission.\n";
		print "<a href='./pagemanager.cgi'>back</a></div>\n";
		exit(0);
    }

	if(!mkdir($PositLogConfig::datapath . $newpageid ."/static", 0755))
    {
		print "Cannot create a static sprite directory in '" . $newpageid . " '.\n";
		print "Please check file permission.\n";
		print "<a href='./pagemanager.cgi'>back</a></div>\n";
		exit(0);
    }

	if(!mkdir($PositLogConfig::datapath . $newpageid ."/dynamic", 0755))
    {
		print "Cannot create a dynamic sprite directory in '" . $newpageid . " '.\n";
		print "Please check file permission.\n";
		print "<a href='./pagemanager.cgi'>back</a></div>\n";
		exit(0);
    }

	my %spritesHash;
	if(!eval{Storable::lock_nstore \%spritesHash, $PositLogConfig::datapath . $newpageid . "/sprites.dat"})
	{
		print "Cannot create the sprite list.\n";
		print "Please check the file permission.<br>\n";
		print "<a href='./pagemanager.cgi'>back</a></div>\n";
		exit(0);
	}
	my %configHash;
	if($adminUser){
		$configHash{"author_id"} = "admin";
	}
	else
	{
		$configHash{"author_id"} = $loginid;
	}

	$configHash{"page_title"} = $newpagetitle;

	$configHash{"sprite_autobr"} = 1;
	$configHash{"sprite_autolink"} = 1;
	$configHash{"sprite_html"} = 0;
	$configHash{"page_type"} = "map";
	$configHash{"page_max_width"} = 100000;
	$configHash{"page_max_height"} = 100000;
	$configHash{"page_bgcolor"} = "ffffff";
	$configHash{"footer_bgcolor"} = "ffffff";
	$configHash{"background_image"} = "";
	my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
	my $time = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
	$configHash{"created_time"} = $time;
	$configHash{"modified_time"} = $time;

	if(!eval{Storable::lock_nstore \%configHash, $PositLogConfig::datapath . $newpageid . "/config.dat"})
	{
		print "Cannot create the page configuration.\n";
		print "Please check the file permission.<br>\n";
		print "<a href='./pagemanager.cgi'>back</a></div>\n";
		exit(0);
	}

	my %permissionHash;
	$permissionHash{"read_page"}{"public"} = 1;
	$permissionHash{"write_plainsprite"}{"public"} = 0;
	$permissionHash{"write_attachedsprite"}{"public"} = 0;
	$permissionHash{"write_supersprite"}{"public"} = 0;
	$permissionHash{"create_page"}{"public"} = 0;

	if(!$adminUser)
	{
		$permissionHash{"read_page"}{$loginid} = 1;
		$permissionHash{"write_plainsprite"}{$loginid} = 1;
		$permissionHash{"write_attachedsprite"}{$loginid} = 1;
		$permissionHash{"write_supersprite"}{$loginid} = 1;
		$permissionHash{"create_page"}{$loginid} = 1;
	}



	if(!eval{Storable::lock_nstore \%permissionHash, $PositLogConfig::datapath . $newpageid . "/permission.cgi"})
	{
		print "Cannot create the permission file.\n";
		print "Please check the file permission.<br>\n";
		print "<a href='./pagemanager.cgi'>back</a></div>\n";
		exit(0);
	}

	$BODY .= generateMainPage("Page '" . $newpagetitle . "' is created.");

}
elsif($command eq "deletepages")
{
    #---------------------------------------------------------
    # Delete Pages
    #---------------------------------------------------------
	
	my $deletePageNameList = "";

	for(my $i=1; $i < $listcounter_page+1; $i++)
	{
		my $pid = $CGI->param("pagedeletecheck_" . $i);
		
		if($pid ne ""){
			my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/config.dat")} or {};
			if($configHash eq "")
			{
				print "Cannot read the page configuration.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
			}
			my $pagetitle =  $configHash->{"page_title"};

			if(0 == unlink($PositLogConfig::datapath . $pid  . "/config.dat"))
			{
				print "<div style='text-align: center'>Error! : Cannot delete the page configuration.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
			}
			if(0 == unlink($PositLogConfig::datapath . $pid  . "/permission.cgi"))
			{
				print "<div style='text-align: center'>Error! : Cannot delete the permission file.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
			}
			if(0 == unlink($PositLogConfig::datapath . $pid  . "/sprites.dat"))
			{
				print "<div style='text-align: center'>Error! : Cannot delete the sprite list.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
			}

			opendir( STATICDIR, $PositLogConfig::datapath . $pid . "/static");
			my @SpritesList = readdir( STATICDIR );
			closedir( STATICDIR );
			foreach my $asprite (@SpritesList)
			{
				if($asprite eq "." || $asprite eq "..")
				{
					next;
				}

				if(0 == unlink($PositLogConfig::datapath . $pid  . "/static/" . $asprite))
				{
					print "<div style='text-align: center'>Error! : Cannot delete a static sprite.<br>\n";
					print "<a href='./pagemanager.cgi'>back</a></div>\n";
					exit(0);
				}
			}

			if(-d $PositLogConfig::datapath . $pid . "/static"  && 0 == rmdir($PositLogConfig::datapath . $pid  . "/static"))
			{
				print "<div style='text-align: center'>Error! : Cannot delete the static sprites dir.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
			}

			opendir( IMAGESDIR, $PositLogConfig::datapath . $pid . "/images");
			my @ImagesList = readdir( IMAGESDIR );
			closedir( IMAGESDIR );
			foreach my $image (@ImagesList)
			{
				if($image eq "." || $image eq "..")
				{
					next;
				}

				if(0 == unlink($PositLogConfig::datapath . $pid  . "/images/" . $image))
				{
					print "<div style='text-align: center'>Error! : Cannot delete an image.<br>\n";
					print "<a href='./pagemanager.cgi'>back</a></div>\n";
					exit(0);
				}
			}

			if(-d $PositLogConfig::datapath . $pid . "/images"  && 0 == rmdir($PositLogConfig::datapath . $pid  . "/images"))
			{
				print "<div style='text-align: center'>Error! : Cannot delete the images dir.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
			}


			opendir( FILESDIR, $PositLogConfig::datapath . $pid . "/files");
			my @FilesList = readdir( FILESDIR );
			closedir( FILESDIR );
			foreach my $file (@FilesList)
			{
				if($file eq "." || $file eq "..")
				{
					next;
				}

				if(0 == unlink($PositLogConfig::datapath . $pid  . "/files/" . $file))
				{
					print "<div style='text-align: center'>Error! : Cannot delete a file.<br>\n";
					print "<a href='./pagemanager.cgi'>back</a></div>\n";
					exit(0);
				}
			}

			if(-d $PositLogConfig::datapath . $pid . "/files"  && 0 == rmdir($PositLogConfig::datapath . $pid  . "/files"))
			{
				print "<div style='text-align: center'>Error! : Cannot delete the files dir.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
			}

			opendir( DYNAMICDIR, $PositLogConfig::datapath . $pid . "/dynamic");
			my @DynamicSpritesList = readdir( DYNAMICDIR );
			closedir( DYNAMICDIR );
			foreach my $asprite (@DynamicSpritesList)
			{
				if($asprite eq "." || $asprite eq "..")
				{
					next;
				}

				if(0 == unlink($PositLogConfig::datapath . $pid  . "/dynamic/" . $asprite))
				{
					print "<div style='text-align: center'>Error! : Cannot delete a dynamic sprite.<br>\n";
					print "<a href='./pagemanager.cgi'>back</a></div>\n";
					exit(0);
				}
			}

			if(-d $PositLogConfig::datapath . $pid . "/dynamic"  && 0 == rmdir($PositLogConfig::datapath . $pid  . "/dynamic"))
			{
				print "<div style='text-align: center'>Error! : Cannot delete the dynamic sprites dir.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
			}

			if(0 == rmdir($PositLogConfig::datapath . $pid))
			{
				print "<div style='text-align: center'>Error! : Cannot delete the page directory.<br>\n";
				print "<a href='./pagemanager.cgi'>back</a></div>\n";
				exit(0);
			}


			$deletePageNameList .= "Page '" . $pagetitle . "' is deleted.<br>\n";
		}
	}
	$BODY .= generateMainPage($deletePageNameList);
}


$BODY .= "</body>\n";

my $FOOTER = "</html>";

print $HEADER . $BODY . $FOOTER;


