#!/usr/local/bin/perl

# --------------------------------------------------------
# fileupload.cgi
#      cgi for PositLog file uploader
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp> 
#   http://storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------

use strict;
use CGI qw/-debug :standard/;
use CGI::Cookie;
use Storable qw(lock_retrieve lock_nstore);   # is default module (upper perl 5.8)
use File::Basename; # is default module
use PositLogConfig;

# --------------------------------------------------------

#my $filesecure = 1;
my $filesecure = 0;

# --------------------------------------------------------

# parameters are already URL decoded.
my $CGI = new CGI;

my $BODY = "";

my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'
		  'http://www.w3.org/TR/html4/loose.dtd'>
<html lang='ja-JP'>
<head>

<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>
<meta http-equiv='Content-Script-Type' content='text/javascript'>

<meta http-equiv='Pragma' content='no-cache'>
<meta http-equiv='Cache-Control' content='no-cache, no-store, must-revalidate, max-age=0'>
<meta http-equiv='Cache-Control' content='post-check=0, pre-check=0'>
<meta http-equiv='Expires' content='Thu, 01 Dec 1994 16:00:00 GMT'>

<title>PositLog File Uploader</title>

<script type='text/javascript'>
<!--
function checkSelector()
{
    if(document.getElementById('fileselector').value == '')
    {
	return false;
    }
    else
    {
	return true;
    }
}
// -->
    </script>
    </head>";


# Print HTTP header
print $CGI->header(-charset => 'utf-8'); 

my $filename = $CGI->param('fileselector');

#--------------------------------------
# Authentication
#--------------------------------------

my $usernameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};

my $validUser = 0; # 0: invalid user, 1: valid user or admin user
my $adminUser = 0; # 0: not admin, 1: admin user
my $publicUser = 0;

# Read temporal cookie
my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";
my $pageid = $CGI->cookie("pageid") || "";

if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{
    my $cryptpass = $adminnameAuth->{$loginid}{"password"};
    my $salt="lc";
    my $cryptpass2 = crypt($loginpass, $salt);
    if($cryptpass eq $cryptpass2)
    {
	$validUser = 1;
	$adminUser = 1;
	$publicUser = 0;
    }
    else
    {
	print "Permission denied.";
	exit(0);	
    }
}
elsif($usernameAuth ne "" && $usernameAuth->{$loginid})
{
    my $cryptpass = $usernameAuth->{$loginid}{"password"};
    my $salt="ry";
    my $cryptpass2 = crypt($loginpass, $salt);
    if($cryptpass eq $cryptpass2)
    {
	$adminUser = 0;
	$validUser = 1;
	$publicUser = 0;
    }
    else
    {
	print "nopermission\n";
	exit(0);	
    }
}
else
{
    $adminUser = 0;
    $validUser = 0;
    $publicUser = 1;
}


my  $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")};
if($@)
{
    print "Cannot read the page permission.<br>\n";
    exit(0);
}
my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")};
if($@)
{
    print "Cannot read the page config.<br>\n";
    exit(0);
}

# check permission of file upload
my $canUpload = 0;
if($adminUser)
{
    $canUpload = 1;
}
elsif(scalar($permissionHash->{"write_attachedsprite"}{"public"}) == 1)
{
    $canUpload = 1;
}
else
{
    # check user list
    if(scalar($permissionHash->{"write_attachedsprite"}{$loginid}) == 1)
    {
	$canUpload = 1;
    }
    else
    {
	# check user group list
	foreach my $usergroupname (keys %{$permissionHash->{"write_attachedsprite_group"}})
	{
	    my $usergroupnameenc = $usergroupname;
	    $usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	    $usergroupnameenc =~ tr/ /+/;
	    
	    my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	    if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
	    if(scalar($UserList->{$loginid}) == 1)
	    {
		$canUpload = 1;
	    }
	}
    }
}

if($canUpload != 1)
{
    $BODY = "<body>";
    $BODY .= "<p>Page not found.</p>\n";
    $BODY .= "<form>";
    $BODY .= "<input type='button' name='cancelbtn'  onclick='top.closeFileUploader()' value='Close'>";
    $BODY .=  "</form>";
    $BODY .= "</body>\n";
    my $FOOTER = "</html>";

    print $HEADER . $BODY . $FOOTER;

    exit(0);
}



if($filename eq "")
{
    $BODY .= q{<body>
<form id="fileuploader" action="./fileupload.cgi" method="POST" onSubmit="return checkSelector();" enctype="multipart/form-data">
<p id="fileuploadermessage">
Please select a file to upload.
</p>
<input type="file" id="fileselector" name="fileselector"><br>
<input type="button" name="cancelbtn"  onclick="top.closeFileUploader()" value="Cancel">
<input type="submit" name="uploadbtn" value="Upload">
</form>
</body>};

    my $FOOTER = "</html>";

    print $HEADER . $BODY . $FOOTER;

    exit(0);	
}


if($pageid eq "" || ! -d $PositLogConfig::datapath . $pageid)
{
    $BODY = "<body>";
    $BODY .= "<p>Page not found.</p>\n";
    $BODY .= "<form>";
    $BODY .= "<input type='button' name='cancelbtn'  onclick='top.closeFileUploader()' value='Close'>";
    $BODY .=  "</form>";
    $BODY .= "</body>\n";
    my $FOOTER = "</html>";

    print $HEADER . $BODY . $FOOTER;

    exit(0);	
}

# authentication
my $usernameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")} or {};
my $loginerror = "";
my $validUser = 0;
my $adminUser = 0;
my $publicUser = 0;
if($adminnameAuth ne "" && $adminnameAuth->{$loginid})
{
    my $cryptpass = $adminnameAuth->{$loginid}{"password"};
    my $salt="lc";
    my $cryptpass2 = crypt($loginpass, $salt);
    if($cryptpass eq $cryptpass2)
    {
	$validUser = 1;
	$adminUser = 1;
	$publicUser = 0;
    }
    else
    {
	$BODY = "<body>";
	$BODY .= "<p>Permission denied.</p>\n";
	$BODY .= "<form>";
	$BODY .= "<input type='button' name='cancelbtn'  onclick='top.closeFileUploader()' value='Close'>";
	$BODY .=  "</form>";
	$BODY .= "</body>\n";
	my $FOOTER = "</html>";

	print $HEADER . $BODY . $FOOTER;

	exit(0);	
    }
}
elsif($usernameAuth ne "" && $usernameAuth->{$loginid})
{
    my $cryptpass = $usernameAuth->{$loginid}{"password"};
    my $salt="ry";
    my $cryptpass2 = crypt($loginpass, $salt);
    if($cryptpass eq $cryptpass2)
    {
	$adminUser = 0;
	$validUser = 1;
	$publicUser = 0;
    }
    else
    {
	$BODY = "<body>";
	$BODY .= "<p>Permission denied.</p>\n";
	$BODY .= "<form>";
	$BODY .= "<input type='button' name='cancelbtn'  onclick='top.closeFileUploader()' value='Close'>";
	$BODY .=  "</form>";
	$BODY .= "</body>\n";
	my $FOOTER = "</html>";

	print $HEADER . $BODY . $FOOTER;

	exit(0);	
    }
}
else
{
    $adminUser = 0;
    $validUser = 0;
    $publicUser = 1;
}

my $isImage = 0;
my $saveDir = "/files/";

my $overwritten = 0;

#---------------------------------------------------------
# Upload file
#---------------------------------------------------------

# upload file name

my $basename = "";
my $errormsg = "";
if($filename ne "")
{
# MIME type
    my $type = $CGI->uploadInfo($filename)->{'Content-Type'};
    my $buffer;
    my $file;
    my $BUFSZ = 2048;
    my $bytesread;
    my $file_size = 0;
    while($bytesread = read($filename, $buffer, $BUFSZ)){
	$file .= $buffer;

	$file_size ++;
	if($file_size > 2500){
	    $BODY = "<body>";
	    $BODY .= "<p>The file size is too large!</p>\n";
	    $BODY .= "<form>";
	    $BODY .= "<input type='button' name='cancelbtn'  onclick='top.closeFileUploader()' value='Close'>";
	    $BODY .=  "</form>";
	    $BODY .= "</body>\n";
	    my $FOOTER = "</html>";

	    print $HEADER . $BODY . $FOOTER;

	    exit(0);	
	}
    }

    if(! -d $PositLogConfig::datapath . $pageid . "/images/")
    {
	if(!mkdir($PositLogConfig::datapath . $pageid . "/images/", 0755))
	{
	    $BODY = "<body>";
	    $BODY .= "<p>Cannot create an image directory.<br>\n";
	    $BODY .= "Please check file permission.</p>\n";
	    $BODY .= "<form>";
	    $BODY .= "<input type='button' name='cancelbtn'  onclick='top.closeFileUploader()' value='Close'>";
	    $BODY .=  "</form>";
	    $BODY .= "</body>\n";
	    my $FOOTER = "</html>";

	    print $HEADER . $BODY . $FOOTER;

	    exit(0);
	}
    }
    if(! -d $PositLogConfig::datapath . $pageid . "/files/")
    {
	if(!mkdir($PositLogConfig::datapath . $pageid . "/files/", 0755))
	{
	    $BODY = "<body>";
	    $BODY .= "<p>Cannot create a file directory.<br>\n";
	    $BODY .= "Please check file permission.</p>\n";
	    $BODY .= "<form>";
	    $BODY .= "<input type='button' name='cancelbtn'  onclick='top.closeFileUploader()' value='Close'>";
	    $BODY .=  "</form>";
	    $BODY .= "</body>\n";
	    my $FOOTER = "</html>";

	    print $HEADER . $BODY . $FOOTER;

	    exit(0);
	}
    }

    $filename =~ s/\\/\//gi;
    $basename = basename($filename);

    if($basename =~ /^.+\.(gif|jpg|jpeg|png)$/i)
    {
	$isImage = 1;
	$saveDir = "/images/";
    }

    if(-f $PositLogConfig::datapath . $pageid . $saveDir .  $basename)
    {
	$overwritten = 1;
    }

    my $success = 1;
    open(OUT, "> $PositLogConfig::datapath" . $pageid . $saveDir .  $basename) or $success = 0;
    if($success != 1)
    {
	$BODY = "<body>";
	$BODY .= "<p>Cannot save the uploaded file.<br>\n";
	$BODY .= "Please check file permission.</p>\n";
	$BODY .= "<form>";
	$BODY .= "<input type='button' name='cancelbtn'  onclick='top.closeFileUploader()' value='Close'>";
	$BODY .=  "</form>";
	$BODY .= "</body>\n";
	my $FOOTER = "</html>";

	print $HEADER . $BODY . $FOOTER;

	exit(0);
    }
    binmode(OUT);
    print(OUT $file);
    close(OUT);
    chmod (0666, "$PositLogConfig::datapath" . $pageid . $saveDir . $basename); 
}

#---------------------------------------------------------
# Generate HTML
#---------------------------------------------------------

my $canHtml = 0;
if(scalar($configHash->{"sprite_html"}) == 1)
{
    $canHtml = 1;
}

if($adminUser)
{
    $canHtml = 1;
}
elsif(scalar($permissionHash->{"write_supersprite"}{"public"}) == 1)
{
    $canHtml = 1;
}
else
{
    # check user list
    if(scalar($permissionHash->{"write_supersprite"}{$loginid}) == 1)
    {
	$canHtml = 1;
    }
    else
    {
	# check user group list
	foreach my $usergroupname (keys %{$permissionHash->{"write_supersprite_group"}})
	{
	    my $usergroupnameenc = $usergroupname;
	    $usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	    $usergroupnameenc =~ tr/ /+/;
	    
	    my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")} or {};
	    if($UserList eq ""){print "<div style='text-align: center'>Error! : Cannot open '" . $usergroupname . "' user group.<br>\n</div>\n"; exit(0); };
	    if(scalar($UserList->{$loginid}) == 1)
	    {
		$canHtml = 1;
	    }
	}
    }
}

my $insertHtml = "";

if($canHtml == 1)
{
	my $filepath = "";
	if($filesecure == 1)
	{
		$filepath = "./";
	}
	else
	{
		$filepath = $PositLogConfig::datapath;
	}
    if(scalar($isImage) == 1)
    {
		$insertHtml = "<img src=\\'" . $filepath . $pageid . "/images/" . $basename . "\\'>";
    }
    else
    {
		$insertHtml = "<a href=\\'" . $filepath . $pageid . "/files/" . $basename . "\\'>" . $basename . "</a>";
    }
}
else
{
    $insertHtml = "filename;" . $basename;
}


if($overwritten == 1){
    $BODY = q{<body onLoad="top.insertUploadedFileToEditor('} . $insertHtml . q{');">};
    $BODY .= "<p>$basename is overwritten.</p>\n";
    $BODY .= "<form>";
    $BODY .= "<input type='button' name='cancelbtn'  onclick='top.closeFileUploader()' value='Close'>";
    $BODY .=  "</form>";
}
else
{
    $BODY = q{<body onLoad="top.insertUploadedFileToEditor('} . $insertHtml . q{'); top.closeFileUploader()">};
}

$BODY .= "</body>\n";

my $FOOTER = "</html>";

print $HEADER . $BODY . $FOOTER;


