//-------------------------------------------------
// edit.js
//
// Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
//  <taro@summer.nifty.jp>
//   http://storybook.jp/ 
//
// This file is part of PositLog.
//
// PositLog is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// PositLog is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//-------------------------------------------------

// top and left of the new sprite
topOfNewSprite = 0;
leftOfNewSprite = 0;


// Saving error.
// Go back to the original sprite!
originalInnerHtml = "";
originalLeft = 0;
originalTop = 0;
originalWidth = 0;
originalZindex = 0;
originalBorderWidth = "";
originalBorderStyle = "";
originalBorderColor = "";
originalBackgroundColor = "";
originalForegroundColor = "";
originalPadding = "";

originalShowPositLink = "";
originalShowTime = "";
originalShowAuthor = "";

originalAuthor = "";


// Frame Color
pickerTopOffset = 84;
frameColorDialogOpen = false;

// Bg Color
bgColorDialogOpen = false;

// Foreground(Text) Color
foreColorDialogOpen = false;

//---------------------------------
// Sprite mover
//---------------------------------
function moverOnMouseDown()
{
    if(movingSpriteFlag
       || selectedSprite == null)
    {
		return;
    }

    movingSpriteFlag = true;

    originalLeft = selectedSprite.style.left;
    originalTop = selectedSprite.style.top;
    originalWidth = selectedSprite.style.width;

    originalZindex = originalZindexOfSelectedSprite;
}

//---------------------------------
// Sprite scaler
//---------------------------------
function scalerOnMouseDown()
{
    if(scalingSpriteFlag
       || selectedSprite == null)
    {
		return;
    }

    scalingSpriteFlag = true;

    originalLeft = selectedSprite.style.left;
    originalTop = selectedSprite.style.top;
    originalWidth = selectedSprite.style.width;

    originalZindex = originalZindexOfSelectedSprite;
}


//------------------------------------
// Layer (Top/Bottom)
//------------------------------------
function editorControlTopOnMouseDown()
{
    // get list of all sprites
    var spritesListNode = document.getElementById("spriteslist");
    var spritesList = spritesListNode.childNodes;
    var topZ = editingSprite.style.zIndex;
    var topSprite = editingSprite;
    for (var i=0; i<spritesList.length; i++)
    {
		var tmpSprite = spritesList[i];
		if(tmpSprite.nodeType == 1)
		{
			var tmpZ = parseFloat(tmpSprite.style.zIndex);
			if(tmpSprite != editingSprite){
				if(tmpZ > topZ  && tmpZ != Z_GO_TEMP_FOREGROUND){
					topZ = tmpZ;
					topSprite = tmpSprite;
				}
			}
		}
    }
    if(topSprite != editingSprite)
    {
		if(topZ < Z_SPRITE_MAX)
		{
			originalZindexOfEditingSprite  = topZ+1;
		}
		else
		{
			originalZindexOfEditingSprite  = Z_SPRITE_MAX;
		}
    }

    document.getElementById("controlresult").innerHTML="Top!";
}

function editorControlBottomOnMouseDown()
{
    if(originalZindexOfSelectedSprite > 1){
		// get list of all sprites
		var spritesListNode = document.getElementById("spriteslist");
		var spritesList = spritesListNode.childNodes;
		var bottomZ = 100000;
		var bottomSprite = editingSprite;
		for (var i=0; i<spritesList.length; i++)
		{
			var tmpSprite = spritesList[i];
			if(tmpSprite.nodeType == 1)
			{
				var tmpZ = parseFloat(tmpSprite.style.zIndex);
				if(tmpSprite != editingSprite){
					if(tmpZ < bottomZ){
						bottomZ = tmpZ;
						bottomSprite = tmpSprite;
					}
				}
			}
		}
		if(bottomSprite != editingSprite)
		{
			if(bottomZ > Z_SPRITE_MIN)
			{
				originalZindexOfEditingSprite  = bottomZ-1;
			}
			else
			{
				originalZindexOfEditingSprite  = Z_SPRITE_MIN;
			}
		}
    }

    document.getElementById("controlresult").innerHTML="Bottom!";
}


//----------------------------------
// File uploader
//----------------------------------

// called from filepload.cgi
function closeFileUploader()
{
    if(document.getElementById("fileuploadframe"))
    {
		document.getElementById("spritesworld").removeChild(document.getElementById("fileuploadframe"));
    }
}

// called from filepload.cgi
function insertUploadedFileToEditor(html)
{
    if(document.getElementById("editor"))
    {
		if(html.match(/^filename;(.+)$/))
		{
			var filename = RegExp.$1;
			document.getElementById("editor-filename").innerHTML = filename;
		}
		else{
			var editorTextAreaElm = document.getElementById("editor-textarea");
			editorTextAreaElm.value += html;
		}
    }
}

function clearUploadedFile()
{
    document.getElementById("editor-filename").innerHTML = "";
}

function openFileUploader()
{
    if(!document.getElementById("fileuploadframe"))
    {
		setCookie("pageid", pageidValue, CGIFILEPATH, 0);

		var fileUploadFrame = document.createElement("iframe");
		fileUploadFrame.setAttribute("id", "fileuploadframe");
		fileUploadFrame.style.left = document.getElementById("editor").style.left;
		fileUploadFrame.style.top = document.getElementById("editor").style.top;

		fileUploadFrame.setAttribute("src", "./fileupload.cgi?" + (new Date()).getTime());

		document.getElementById("spritesworld").appendChild(fileUploadFrame);

    }
}

//--------------------------------------
// Plugin Dialog
//--------------------------------------

function pluginDialogClearCacheOnMouseDown()
{
    var postdata = "&pageid=" + pageidValue + "&plugin="+document.getElementById("plugin-name").value + "," + document.getElementById("plugin-option").value;
    sendRequest(clearCacheOnLoaded, postdata, "POST", CGIFILEPATH + "clearCache.cgi", true, true);
}

function clearCacheOnLoaded(obj)
{
    document.getElementById("dialog-clearcacheresult").innerHTML=obj.responseText;
}

function pluginDialogCancelOnMouseDown()
{
    var spritesWorldNode = document.getElementById("spritesworld");
    spritesWorldNode.removeChild(document.getElementById("plugin-dialog"));

    if(crossBrowser.bw.msie)
    {
		// select menu is overwrapped on the plugin-dialog on msie6
		document.getElementById("editor-control4").style.display = "block";
    }

}

function pluginDialogOkOnMouseDown()
{
    var templateElm = document.getElementById("plugin-template");
    var template = templateElm.value;
    if(!template.match(/\[\[plugin\]\]/))
    {
		templateElm.value = "[[plugin]]" + template;
    }

    var pluginElm = document.getElementById(editingSprite.id + "_plugin");
    pluginElm.innerHTML = document.getElementById("plugin-name").value + "," + document.getElementById("plugin-option").value + ";" + templateElm.value;


    editorPluginNameElm = document.getElementById("editor-pluginname");
    editorPluginNameElm.innerHTML = document.getElementById("plugin-name").value;


    var spritesWorldNode = document.getElementById("spritesworld");
    spritesWorldNode.removeChild(document.getElementById("plugin-dialog"));

    if(crossBrowser.bw.msie)
    {
		// select menu is overwrapped on the plugin-dialog on msie6
		document.getElementById("editor-control4").style.display = "block";
    }

}

function pluginDialogSubmit()
{
    return false;
}

function openPluginDialog()
{
    if(!document.getElementById("plugin-dialog"))
    {
		var pluginName = "";
		var pluginOption = "";
		var pluginTemplate = "";
		if(document.getElementById(editingSprite.id+ "_plugin"))
		{
			var pluginStr = document.getElementById(editingSprite.id+ "_plugin").innerHTML;
			var pluginArray = pluginStr.split(";");
			if(pluginArray.length >= 1)
			{
				var pluginCommand = pluginArray[0];
				if(pluginArray.length >= 2)
				{
					for(var i=1; i<pluginArray.length-1; i++)
					{
						pluginTemplate += pluginArray[i]+";";
					}
					pluginTemplate += pluginArray[pluginArray.length-1];

					if(pluginTemplate == undefined)
					{
						pluginTemplate = "[[plugin]]";
					}
				}

				var pluginCommandArray = pluginCommand.split(",");

				if(pluginCommandArray.length >= 1)
				{
					pluginName = pluginCommandArray[0];
				}
				if(pluginCommandArray.length >= 2)
				{
					for(var i=1; i<pluginCommandArray.length-1; i++)
					{
						pluginOption += pluginCommandArray[i]+",";
					}
					pluginOption += pluginCommandArray[pluginCommandArray.length-1];
				}
			}
		}

		if(crossBrowser.bw.msie)
		{
			// select menu is overwrapped on the plugin-dialog on msie6
			document.getElementById("editor-control4").style.display = "none";
		}

		// form 
		var dialogForm = document.createElement("form");
		dialogForm.setAttribute("id", "plugin-dialog");
		dialogForm.style.left = document.getElementById("editor").style.left;
		dialogForm.style.top = document.getElementById("editor").style.top;
		dialogForm.style.width = "380px";
		dialogForm.style.height = "300px";
		dialogForm.onsubmit = pluginDialogSubmit;

		// Plugin name
		var pluginNameTitleElement = document.createElement("div");
		pluginNameTitleElement.setAttribute("id", "plugin-nametitle");
		pluginNameTitleElement.appendChild(document.createTextNode(""));
		pluginNameTitleElement.innerHTML = "plugin name";
		dialogForm.appendChild(pluginNameTitleElement);

		// clear cache
		var clearElement = document.createElement("input");
		clearElement.setAttribute("type", "button");
		clearElement.setAttribute("id", "dialog-clearcache");
		clearElement.value = "Clear Cache";
		clearElement.onclick = pluginDialogClearCacheOnMouseDown;
		dialogForm.appendChild(clearElement);

		var clearResultElement = document.createElement("div");
		clearResultElement.setAttribute("id", "dialog-clearcacheresult");
		dialogForm.appendChild(clearResultElement);

		dialogForm.appendChild(document.createElement("br"));

		var pluginNameElement = document.createElement("input");
		pluginNameElement.setAttribute("type", "text");
		pluginNameElement.setAttribute("id", "plugin-name");
		pluginNameElement.setAttribute("size", "40");
		pluginNameElement.value = pluginName;
		dialogForm.appendChild(pluginNameElement);

		// Plugin options
		var pluginOptionTitleElement = document.createElement("div");
		pluginOptionTitleElement.setAttribute("id", "plugin-optiontitle");
		pluginOptionTitleElement.appendChild(document.createTextNode(""));
		pluginOptionTitleElement.innerHTML = "plugin options";
		dialogForm.appendChild(pluginOptionTitleElement);

		var pluginOptionElement = document.createElement("textarea");
		pluginOptionElement.setAttribute("id", "plugin-option");
		pluginOptionElement.setAttribute("rows", "2");
		pluginOptionElement.setAttribute("cols", "40");
		pluginOptionElement.value = pluginOption;
		dialogForm.appendChild(pluginOptionElement);

		// Plugin template
		var pluginTemplateTitleElement = document.createElement("div");
		pluginTemplateTitleElement.setAttribute("id", "plugin-templatetitle");
		pluginTemplateTitleElement.appendChild(document.createTextNode(""));
		pluginTemplateTitleElement.innerHTML = "plugin template";
		dialogForm.appendChild(pluginTemplateTitleElement);

		var pluginTemplateElement = document.createElement("textarea");
		pluginTemplateElement.setAttribute("id", "plugin-template");
		pluginTemplateElement.setAttribute("rows", "6");
		pluginTemplateElement.setAttribute("cols", "40");
		pluginTemplateElement.value = pluginTemplate;
		dialogForm.appendChild(pluginTemplateElement);

		var brElement = document.createElement("br");
		dialogForm.appendChild(brElement);


		// cancel
		var cancelElement = document.createElement("input");
		cancelElement.setAttribute("type", "button");
		cancelElement.setAttribute("id", "dialog-cancel");
		cancelElement.value = "Cancel";
		cancelElement.onclick = pluginDialogCancelOnMouseDown;
		dialogForm.appendChild(cancelElement);

		// ok
		var okElement = document.createElement("input");
		okElement.setAttribute("type", "button");
		okElement.setAttribute("id", "dialog-ok");
		okElement.value = "Ok";
		okElement.onclick = pluginDialogOkOnMouseDown;
		dialogForm.appendChild(okElement);

		document.getElementById("spritesworld").appendChild(dialogForm);

    }
}



//-----------------------------------------------
// Password Dialog for moving public sprite
//-----------------------------------------------

function passwordDialogCloseOnMouseDown()
{
    var spritesWorldNode = document.getElementById("spritesworld");
    spritesWorldNode.removeChild(document.getElementById("password-dialog"));

    savingSprite.style.left = originalLeft;
    savingSprite.style.top = originalTop;
    savingSprite.style.width = originalWidth;
    savingSprite.style.zIndex = originalZindex;
}

function passwordDialogSubmit()
{
    saveStyles(selectedSprite);
    return false;
}

function openPasswordDialog()
{
    if(!document.getElementById("password-dialog"))
    {
		selectedSprite.style.zIndex = Z_GO_TEMP_FOREGROUND;
		removeIconsFromSprite(selectedSprite);

		// form 
		var dialogForm = document.createElement("form");
		dialogForm.setAttribute("id", "password-dialog");
		dialogForm.onsubmit = passwordDialogSubmit;

		var spriteLeft = parseInt(selectedSprite.style.left.replace(/px/g, ""));
		var spriteTop = parseInt(selectedSprite.style.top.replace(/px/g, ""));

		var dialogWidth = 200;
		var dialogHeight = 100;
		var dialogLeft = spriteLeft + viewPositionX;
		var dialogTop = spriteTop + viewPositionY - dialogHeight;

		if(dialogLeft + dialogWidth > worldWidth)
		{
			dialogLeft -= dialogLeft + dialogWidth  - worldWidth + 5;
		}
		if(dialogTop + dialogHeight > worldHeight)
		{
			dialogTop -= dialogTop + dialogHeight - worldHeight + 5;
		}
		if(dialogLeft < 0)	
		{
			dialogLeft = 0;
		}

		dialogForm.style.width = dialogWidth.toString() + "px";
		dialogForm.style.height = dialogHeight.toString() + "px";
		dialogForm.style.left = dialogLeft.toString() + "px";
		dialogForm.style.top = dialogTop.toString() + "px";

		var dialogControlElement = document.createElement("div");
		dialogControlElement.setAttribute("id", "dialog-control");

		// close btn
		var dialogControlCloseElement = document.createElement("img");
		dialogControlCloseElement.setAttribute("src", IMAGEFILEPATH + "close.gif");
		dialogControlCloseElement.setAttribute("id", "dialog-closebtn");
		dialogControlCloseElement.style.verticalAlign = "middle";
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			dialogControlCloseElement.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		dialogControlElement.appendChild(dialogControlCloseElement);

		dialogForm.appendChild(dialogControlElement);

		// controlPanel for editor 4
		var dialogControlElement2 = document.createElement("div");
		dialogControlElement2.setAttribute("id", "dialog-control2");

		var passElement = document.createElement("div");
		passElement.setAttribute("id", "dialog-passtitle");
		passElement.appendChild(document.createTextNode(""));
		passElement.innerHTML = "Please enter password";
		dialogControlElement2.appendChild(passElement);

		// password field
		var passFieldElement = document.createElement("input");
		passFieldElement.setAttribute("type", "password");
		passFieldElement.setAttribute("id", "dialog-pass");
		passFieldElement.setAttribute("size", "10");
		passFieldElement.style.verticalAlign = "middle";
		passFieldElement.value = "";
		dialogControlElement2.appendChild(passFieldElement);

		var brElement = document.createElement("br");
		dialogControlElement2.appendChild(brElement);

		// submit 
		var submitElement = document.createElement("input");
		submitElement.setAttribute("type", "submit");
		submitElement.setAttribute("id", "dialog-submit");
		submitElement.value = "Enter";
		dialogControlElement2.appendChild(submitElement);

		// cancel
		var cancelElement = document.createElement("input");
		cancelElement.setAttribute("type", "button");
		cancelElement.setAttribute("id", "dialog-cancel");
		cancelElement.value = "Cancel";
		cancelElement.onclick = passwordDialogCloseOnMouseDown;
		dialogControlElement2.appendChild(cancelElement);

		var brElement2 = document.createElement("br");
		dialogControlElement2.appendChild(brElement2);

		var resultElement = document.createElement("span");
		resultElement.setAttribute("id", "dialog-result");
		resultElement.appendChild(document.createTextNode(""));
		dialogControlElement2.appendChild(resultElement);

		dialogForm.appendChild(dialogControlElement2);

		dialogControlCloseElement.onmousedown = passwordDialogCloseOnMouseDown;

		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.appendChild(dialogForm);
		
		passFieldElement.focus();
    }
}


//------------------------------------
// Color Dialogs
//------------------------------------


function setColor2Selector(col, defaultColor)
{
    if(tcs == null)
    {
		return;
    }

    if(col == undefined || col == null || col == "")
    {
		col = defaultColor;
    }

    var r = 0;
    var g = 0;
    var b = 0;

    if(col.match(/rgb\((\d+?),\s*(\d+?),\s*(\d+?)\)/i))
    {
		r = parseInt(RegExp.$1);
		g = parseInt(RegExp.$2);
		b = parseInt(RegExp.$3);
    }
    else
    {
		var rgb = tcs.hex2rgb(col);
		r = rgb.r;
		g = rgb.g;
		b = rgb.b;
    }

    if(r != 0)
    {
		r /= 255.0;
    }
    if(g != 0)
    {
		g /= 255.0;
    }
    if(b != 0)
    {
		b /= 255.0;
    }

    var hsv = tcs.rgb2hsv(r, g, b);
    tcs.setColor(hsv.h, hsv.s, hsv.v);
}

function openFrameColorDialog()
{
    if(tcs == null)
    {
		frameColorDialogOpen = true;
		tcs_initialize();
		var tcsElm = document.getElementById("trianglecolorselector");
		tcsElm.style.top = pickerTopOffset + "px";

		var hexClearElm = document.getElementById("tcs-hexclear");
		hexClearElm.style.display = "none";

		var contents = document.getElementById(editingSprite.id + "_contents");
		setColor2Selector(contents.style.borderTopColor, "#000000");

		document.getElementById("tcs-title").innerHTML = "[Frame]";
    }
    else if(frameColorDialogOpen)
    {
		frameColorDialogOpen = false;
		var editorElm = document.getElementById("editor");
		var tcsElm = document.getElementById("trianglecolorselector");
		if(tcsElm != null && tcsElm != undefined)
		{
			editorElm.removeChild(tcsElm);
		}
		tcs = null;
    }
    else if(bgColorDialogOpen || foreColorDialogOpen)
    {
		frameColorDialogOpen = true;
		bgColorDialogOpen = false;
		foreColorDialogOpen = false;

		var hexClearElm = document.getElementById("tcs-hexclear");
		hexClearElm.style.display = "none";

		var contents = document.getElementById(editingSprite.id + "_contents");
		setColor2Selector(contents.style.borderTopColor, "#000000");

		document.getElementById("tcs-title").innerHTML = "[Frame]";
    }
}



function openBgColorDialog()
{
    if(tcs == null)
    {
		bgColorDialogOpen = true;
		tcs_initialize();
		var tcsElm = document.getElementById("trianglecolorselector");
		tcsElm.style.top = pickerTopOffset + "px";

		var hexClearElm = document.getElementById("tcs-hexclear");
		hexClearElm.style.display = "block";

		var contents = document.getElementById(editingSprite.id + "_contents");
		setColor2Selector(contents.style.backgroundColor, "#ffffff");

		document.getElementById("tcs-title").innerHTML = "[Background]";
    }
    else if(bgColorDialogOpen)
    {
		bgColorDialogOpen = false;
		var editorElm = document.getElementById("editor");
		var tcsElm = document.getElementById("trianglecolorselector");
		if(tcsElm != null && tcsElm != undefined)
		{
			editorElm.removeChild(tcsElm);
		}
		tcs = null;
    }
    else if(frameColorDialogOpen || foreColorDialogOpen)
    {
		bgColorDialogOpen = true;
		frameColorDialogOpen = false;
		foreColorDialogOpen = false;

		var hexClearElm = document.getElementById("tcs-hexclear");
		hexClearElm.style.display = "block";

		var contents = document.getElementById(editingSprite.id + "_contents");
		setColor2Selector(contents.style.backgroundColor, "#ffffff");

		document.getElementById("tcs-title").innerHTML = "[Background]";
    }
}


function openForeColorDialog()
{
    if(tcs == null)
    {
		foreColorDialogOpen = true;
		tcs_initialize();
		var tcsElm = document.getElementById("trianglecolorselector");
		tcsElm.style.top = pickerTopOffset + "px";

		var hexClearElm = document.getElementById("tcs-hexclear");
		hexClearElm.style.display = "none";

		var contents = document.getElementById(editingSprite.id + "_contents");
		setColor2Selector(contents.style.color, "#000000");

		document.getElementById("tcs-title").innerHTML = "[Text]";
    }
    else if(foreColorDialogOpen)
    {
		foreColorDialogOpen = false;
		var editorElm = document.getElementById("editor");
		var tcsElm = document.getElementById("trianglecolorselector");
		if(tcsElm != null && tcsElm != undefined)
		{
			editorElm.removeChild(tcsElm);
		}
		tcs = null;
    }
    else if(frameColorDialogOpen || bgColorDialogOpen)
    {
		foreColorDialogOpen = true;
		frameColorDialogOpen = false;
		bgColorDialogOpen = false;

		var hexClearElm = document.getElementById("tcs-hexclear");
		hexClearElm.style.display = "none";

		var contents = document.getElementById(editingSprite.id + "_contents");
		setColor2Selector(contents.style.color, "#000000");

		document.getElementById("tcs-title").innerHTML = "[Text]";
    }
}


//------------------------------------
// Close Editor
//------------------------------------
function editorControlCloseOnMouseDown()
{
    if(editingSprite == null)
    {
		return;
    }

    if(document.getElementById("fileuploadframe"))
    {
		return;
    }

    if(document.getElementById("plugin-dialog"))
    {
		return;
    }

    if(tcs != null)
    {
		frameColorDialogOpen = false;
		bgColorDialogOpen = false;
		foreColorDialogOpen = false;
		var editorElm = document.getElementById("editor");
		var tcsElm = document.getElementById("trianglecolorselector");
		if(tcsElm != null && tcsElm != undefined)
		{
			editorElm.removeChild(tcsElm);
		}
		tcs = null;
    }

    editingSprite.style.zIndex = originalZindex;

    var contents = document.getElementById(editingSprite.id + "_contents");
    contents.style.borderWidth = originalBorderWidth;
    contents.style.borderColor = originalBorderColor;
    contents.style.borderStyle = originalBorderStyle;
    contents.style.backgroundColor = originalBackgroundColor;
    contents.style.color = originalForegroundColor;
    contents.style.padding = originalPadding;

    var id = editingSprite.id;
    clearSelectedSprite();
    setSelectedSprite(document.getElementById(id));

    var spritesWorldNode = document.getElementById("spritesworld");
    spritesWorldNode.removeChild(document.getElementById("editor"));

    editingSprite = null;
}


//----------------------------------------
// Move editor
//----------------------------------------

function editorTitleOnMouseDown()
{
    if(movingEditorFlag)
    {
		return;
    }

    movingEditorFlag = true;
}

//----------------------------------------
// Frame Selector
//----------------------------------------

function editorFrameSelectOnChange()
{
    var selector = document.getElementById('editor-frameselector');
    var contents = document.getElementById(editingSprite.id + "_contents");
    contents.style.borderStyle = selector.options[selector.selectedIndex].value;
}

function editorFrameSizeSelectOnChange()
{
    var sizeselector = document.getElementById('editor-framesizeselector');
    var contents = document.getElementById(editingSprite.id + "_contents");
    contents.style.borderWidth = sizeselector.options[sizeselector.selectedIndex].value;
}

function editorFramePaddingSelectOnChange()
{
    var paddingselector = document.getElementById('editor-framepaddingselector');
    var contents = document.getElementById(editingSprite.id + "_contents");
    contents.style.padding = paddingselector.options[paddingselector.selectedIndex].value;
}

//-------------------------------------------
// Clear Public Password
//-------------------------------------------

function clearPasswordOnLoaded(obj)
{
    var res = obj.responseText;
    if (res == "invalid_public_password")
    {
		document.getElementById("controlresult").innerHTML="Please enter the valid password.";
    }
    else if(res == "clearpassword")
    {
		var passwordElm = document.getElementById("editor-password");
		passwordElm.value = "";
		document.getElementById("controlresult").innerHTML="The password is cleared.";
    }
    else
    {
		document.getElementById("controlresult").innerHTML=res;
    }
}

function clearPassword()
{
    // clear password of public user
    var passwordElm = document.getElementById("editor-password");
    public_password = passwordElm.value;

    var postdata = "&command=clearpassword&id="+ editingSprite.id + "&pageid="+pageidValue + "&public_password="+public_password;
    sendRequest(clearPasswordOnLoaded, postdata, "POST", CGIFILEPATH + "saveSprite.cgi", true, true);
}



//------------------------------------
// Open Editor
//------------------------------------

function editoriconOnMouseDown()
{
    openEditor();
}


function editorSubmit()
{
    return false;
}

function isNewSprite(sprite)
{
    var contentsElm = document.getElementById(sprite.id + "_contents");	
    if(contentsElm.innerHTML.match(/<br>\nNew Sprite!!\n<br>\n<br>/i)
       || contentsElm.innerHTML.match(/<br>New Sprite!! <br><br>/i)
       || contentsElm.innerHTML.match(/<br\/>\nNew Sprite!!\n<br\/>\n<br\/>\n/i))
    {
		return true;
    }
    else
    {
		return false;
    }
    
}


function openEditor()
{
    if(!document.getElementById("editor") && selectedSprite != null)
    {
		editingSprite = selectedSprite;
		// backup original data
		var contentsElm = document.getElementById(editingSprite.id + "_contents");	
		originalInnerHtml = contentsElm.innerHTML;
		originalZindex = originalZindexOfSelectedSprite;
		originalZindexOfEditingSprite = originalZindexOfSelectedSprite;

		if(isNewSprite(editingSprite))
		{
			contentsElm.style.backgroundColor = "";
			contentsElm.style.textAlign = "left";
			contentsElm.style.padding = "0px";
			contentsElm.style.borderColor = "#000000";
			contentsElm.style.borderStyle = "none";
			contentsElm.style.borderWidth = "0px";
		}

		// safari cannot get border by short name. (e.g. border, border-width) 
		// Get by full name. (e.g. border-top-width);
		originalBorderWidth = contentsElm.style.borderTopWidth;
		originalBorderColor = contentsElm.style.borderTopColor;
		originalBorderStyle = contentsElm.style.borderTopStyle;
		originalBackgroundColor = contentsElm.style.backgroundColor;
		originalForegroundColor = contentsElm.style.color;
		originalPadding = contentsElm.style.paddingTop;

		editingSprite.style.zIndex = Z_GO_TEMP_FOREGROUND;

		removeIconsFromSprite(editingSprite);

		// form 
		var editorForm = document.createElement("form");
		editorForm.setAttribute("id", "editor");
		editorForm.onsubmit = editorSubmit;

		var spriteWidth = parseInt(editingSprite.style.width.replace(/px/g, ""));
		var spriteHeight = parseInt(editingSprite.offsetHeight);
		if(spriteHeight > 100)
		{
			spriteHeight = 100;
		}
		
		var spriteLeft = parseInt(editingSprite.style.left.replace(/px/g, ""));
		var spriteTop = parseInt(editingSprite.style.top.replace(/px/g, ""));

		var formWidth = 400;
		var formHeight = 0;
		var browserHeight = getInnerHeight();

		if(browserHeight > 600)
		{
			formHeight = 300;
		}
		else
		{
			formHeight = browserHeight / 2;
		}

		var editorWidth = formWidth + 1;
		var editorHeight = formHeight + 88;
		var editorLeft = spriteLeft + viewPositionX;
		var editorTop = spriteTop + viewPositionY + spriteHeight;

		if(editorLeft + editorWidth > worldWidth)
		{
			editorLeft -= editorLeft + editorWidth  - worldWidth + 5;
		}
		if(editorTop + editorHeight > worldHeight - document.getElementById("footer").offsetHeight)
		{
			editorTop -= editorTop + editorHeight - worldHeight + document.getElementById("footer").offsetHeight + 10;
		}
		if(editorLeft < 0)	
		{
			editorLeft = 0;
		}

		editorForm.style.width = editorWidth.toString() + "px";
		editorForm.style.height = editorHeight.toString() + "px";
		editorForm.style.left = editorLeft.toString() + "px";
		editorForm.style.top = editorTop.toString() + "px";


		// controlPanel for editor
		var editorControlElm = document.createElement("div");
		editorControlElm.setAttribute("id", "editor-control");
		editorControlElm.onmousedown = editorTitleOnMouseDown;
		// save btn
		var editorControlSaveElm = document.createElement("img");
		editorControlSaveElm.setAttribute("src", IMAGEFILEPATH + "save.gif");
		editorControlSaveElm.setAttribute("id", "editor-savebtn");
		editorControlSaveElm.style.verticalAlign = "middle";
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorControlSaveElm.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElm.appendChild(editorControlSaveElm);

		// top btn
		var editorControlTopElm = document.createElement("img");
		editorControlTopElm.setAttribute("src", IMAGEFILEPATH + "top.gif");
		editorControlTopElm.setAttribute("id", "editor-topbtn");
		editorControlTopElm.style.verticalAlign = "middle";
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorControlTopElm.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElm.appendChild(editorControlTopElm);

		// bottom btn
		var editorControlBottomElm = document.createElement("img");
		editorControlBottomElm.setAttribute("src", IMAGEFILEPATH + "bottom.gif");
		editorControlBottomElm.setAttribute("id", "editor-bottombtn");
		editorControlBottomElm.style.verticalAlign = "middle";
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorControlBottomElm.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElm.appendChild(editorControlBottomElm);

		// close btn
		var editorControlCloseElm = document.createElement("img");
		editorControlCloseElm.setAttribute("src", IMAGEFILEPATH + "close.gif");
		editorControlCloseElm.setAttribute("id", "editor-closebtn");
		editorControlCloseElm.style.verticalAlign = "middle";
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorControlCloseElm.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElm.appendChild(editorControlCloseElm);


		// id
		var editorIdElm = document.createElement("div");
		editorIdElm.setAttribute("id", "editor-id");
		editorIdElm.appendChild(document.createTextNode(""));
		editorIdElm.innerHTML = editingSprite.id;
		editorControlElm.appendChild(editorIdElm);


		editorForm.appendChild(editorControlElm);


		// controlPanel for editor 2
		var editorControlElm2 = document.createElement("div");
		editorControlElm2.setAttribute("id", "editor-control2");

		// time
		var editorTimeElm = document.createElement("div");
		editorTimeElm.setAttribute("id", "editor-time");
		var timeElm = document.getElementById(editingSprite.id + "_time");
		var timeValue = timeElm.innerHTML;
		editorTimeElm.appendChild(document.createTextNode(timeValue));
		editorControlElm2.appendChild(editorTimeElm);

		// show time
		var editorShowTimeElm = document.createElement("input");
		editorShowTimeElm.setAttribute("id", "editor-showtime");
		editorShowTimeElm.setAttribute("type", "checkbox");
		editorShowTimeElm.setAttribute("value", "1");
		if(timeElm.style.display == "block")
		{
			editorShowTimeElm.defaultChecked = true;
		}
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorShowTimeElm.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElm2.appendChild(editorShowTimeElm);




		// positlink
		var positlinkElm = document.createElement("div");
		positlinkElm.setAttribute("id", "editor-positlink");
		positlinkElm.appendChild(document.createTextNode(""));
		idValue = editingSprite.id;
		var newURL = urlPure + "?" + "load=" + pageidValue + "&id=" + idValue;
		positlinkElm.innerHTML = "<a href='" + newURL + "'>link</a> ";
		editorControlElm2.appendChild(positlinkElm);

		// show link
		var editorShowPositLinkElm = document.createElement("input");
		editorShowPositLinkElm.setAttribute("id", "editor-showpositlink");
		editorShowPositLinkElm.setAttribute("type", "checkbox");
		editorShowPositLinkElm.setAttribute("value", "1");
		var positElm = document.getElementById(editingSprite.id + "_positlink");
		if(positElm.style.display == "block")
		{
			editorShowPositLinkElm.defaultChecked = true;
		}
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorShowPositLinkElm.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElm2.appendChild(editorShowPositLinkElm);


		// file upload
		if(parseInt(attachedSpriteValue) == 1)
		{
			var editorFileUploadElm = document.createElement("input");
			editorFileUploadElm.setAttribute("id", "editor-fileuploadbtn");
			editorFileUploadElm.setAttribute("type", "button");
			editorFileUploadElm.setAttribute("value", "file");
			editorFileUploadElm.onclick = openFileUploader;
			editorControlElm2.appendChild(editorFileUploadElm);

			if(sprite_htmlValue != 1)
			{
				var attachedfilename = "";
				var attachedTestHtml = document.getElementById(editingSprite.id + "_contents").innerHTML;
				if(attachedTestHtml.match(/<img.*?src=\"(.+?)\".*?>/i))
				{
					attachedfilename = RegExp.$1;
					var pathArray = attachedfilename.split("/");
					attachedfilename = pathArray[pathArray.length-1];
				}
				if(attachedTestHtml.match(/<a.*?class=\"attachedfile\".*?>/i))
				{
					if(attachedTestHtml.match(/<a.*?href=\"(.+?)\".*?>/i))
					{
						attachedfilename = RegExp.$1;
						var pathArray = attachedfilename.split("/");
						attachedfilename = pathArray[pathArray.length-1];
					}
				}

				if(attachedfilename != "")
				{
					var editorFileClearElm = document.createElement("input");
					editorFileClearElm.setAttribute("id", "editor-fileclearbtn");
					editorFileClearElm.setAttribute("type", "button");
					editorFileClearElm.setAttribute("value", "clear");
					editorFileClearElm.onclick = clearUploadedFile;
					editorControlElm2.appendChild(editorFileClearElm);
				}

				var editorFileNameElm = document.createElement("div");
				editorFileNameElm.setAttribute("id", "editor-filename");
				editorFileNameElm.appendChild(document.createTextNode(attachedfilename));
				editorControlElm2.appendChild(editorFileNameElm);
			}
		}

		if(parseInt(superSpriteValue) == 1)
		{
			var editorPluginElm = document.createElement("input");
			editorPluginElm.setAttribute("id", "editor-pluginbtn");
			editorPluginElm.setAttribute("type", "button");
			editorPluginElm.setAttribute("value", "plugin")
			editorPluginElm.onclick = openPluginDialog;;
			editorControlElm2.appendChild(editorPluginElm);

			var editorPluginNameElm = document.createElement("div");
			editorPluginNameElm.setAttribute("id", "editor-pluginname");

			var pluginName = "";
			var pluginStr = document.getElementById(editingSprite.id+ "_plugin").innerHTML;
			var pluginArray = pluginStr.split(",");
			if(pluginArray.length >= 1)
			{
				pluginName = pluginArray[0];
			}
			editorPluginNameElm.appendChild(document.createTextNode(pluginName));
			editorControlElm2.appendChild(editorPluginNameElm);
		}

		editorForm.appendChild(editorControlElm2);


		// controlPanel for editor 3
		var editorControlElm3 = document.createElement("div");
		editorControlElm3.setAttribute("id", "editor-control3");

		// author
		var authorElm = document.getElementById(editingSprite.id + "_author");
		var authorName = authorElm.innerHTML;
		if(authorName.match(/^&lt;.+&gt;$/)  || authorName.match(/^\[.+\]$/))
		{
			var authorTitleElm = document.createElement("div");
			authorTitleElm.setAttribute("id", "editor-authortitle");
			authorTitleElm.appendChild(document.createTextNode("author "));
			editorControlElm3.appendChild(authorTitleElm);

			// author field
			var authorFieldElm = document.createElement("input");
			authorFieldElm.setAttribute("type", "text");
			authorFieldElm.setAttribute("id", "editor-author");
			authorFieldElm.setAttribute("size", "15");
			authorFieldElm.style.verticalAlign = "middle";
			var pubauthor = getCookie("public_author");
			if(pubauthor == undefined)
			{
				pubauthor = "public";
			}
			else
			{
				pubauthor = decodeURIComponent(pubauthor);
			}
			authorFieldElm.value = pubauthor;
			editorControlElm3.appendChild(authorFieldElm);
		}
		else
		{
			var editorAuthorElm = document.createElement("div");
			editorAuthorElm.setAttribute("id", "editor-authortitle");
			editorAuthorElm.appendChild(document.createTextNode("author [ " + authorElm.innerHTML + " ]"));
			editorControlElm3.appendChild(editorAuthorElm);
		}

		// show author
		var editorShowAuthorElm = document.createElement("input");
		editorShowAuthorElm.setAttribute("id", "editor-showauthor");
		editorShowAuthorElm.setAttribute("type", "checkbox");
		editorShowAuthorElm.setAttribute("value", "1");
		if(authorElm.style.display == "block")
		{
			editorShowAuthorElm.defaultChecked = true;
		}
		if(crossBrowser.bw.mozes || crossBrowser.bw.msie || crossBrowser.bw.msie7)
		{
			editorShowAuthorElm.style.cursor = "url(" + IMAGEFILEPATH + "hand3.cur), default";
		}
		editorControlElm3.appendChild(editorShowAuthorElm);


		if(authorName.match(/^&lt;.+&gt;$/)  || authorName.match(/^\[.+\]$/))
		{
			var passElm = document.createElement("div");
			passElm.setAttribute("id", "editor-passtitle");
			passElm.appendChild(document.createTextNode(""));
			passElm.innerHTML = "password";
			editorControlElm3.appendChild(passElm);

			// password field
			var editorControlPasswordElm = document.createElement("input");
			editorControlPasswordElm.setAttribute("type", "password");
			editorControlPasswordElm.setAttribute("id", "editor-password");
			editorControlPasswordElm.setAttribute("size", "8");
			editorControlPasswordElm.style.verticalAlign = "middle";
			var pass = getCookie("public_password");

			var contentsElm = document.getElementById(editingSprite.id + "_contents");
			if(isNewSprite(editingSprite))
			{
				// nop
			}
			else
			{
				if(pass == undefined)
				{
					pass = "";
				}
				if(authorName.match(/^\[.+\]$/))
				{
					pass = "";
				}
			}

			editorControlPasswordElm.value = pass;
			editorControlElm3.appendChild(editorControlPasswordElm);

			var clearpassElm = document.createElement("input");
			clearpassElm.setAttribute("id", "editor-clearpass");
			clearpassElm.setAttribute("type", "button");
			clearpassElm.setAttribute("value", "clear");
			clearpassElm.onclick = clearPassword;

			editorControlElm3.appendChild(clearpassElm);
		}

		editorForm.appendChild(editorControlElm3);


		var contentsElm = document.getElementById(editingSprite.id + "_contents");

		// controlPanel for editor 4
		// select frame color, width, type ...
		var editorControlElm4 = document.createElement("div");
		editorControlElm4.setAttribute("id", "editor-control4");

		var foreColorElm = document.createElement("input");
		foreColorElm.setAttribute("id", "editor-forecolorbtn");
		foreColorElm.setAttribute("type", "button");
		foreColorElm.setAttribute("value", "text");
		foreColorElm.onclick = openForeColorDialog;
		editorControlElm4.appendChild(foreColorElm);

		var bgColorElm = document.createElement("input");
		bgColorElm.setAttribute("id", "editor-bgcolorbtn");
		bgColorElm.setAttribute("type", "button");
		bgColorElm.setAttribute("value", "bg");
		bgColorElm.onclick = openBgColorDialog;
		editorControlElm4.appendChild(bgColorElm);


		var frameColorElm = document.createElement("input");
		frameColorElm.setAttribute("id", "editor-framecolorbtn");
		frameColorElm.setAttribute("type", "button");
		frameColorElm.setAttribute("value", "frame");
		frameColorElm.onclick = openFrameColorDialog;
		editorControlElm4.appendChild(frameColorElm);

		var frameSelectorElm = document.createElement("select");
		frameSelectorElm.setAttribute("id", "editor-frameselector");
		var frameOption1 = document.createElement("option");
		frameOption1.setAttribute("value", "none");
		frameOption1.appendChild(document.createTextNode("-"));
		var frameOption2 = document.createElement("option");
		frameOption2.setAttribute("value", "solid");
		frameOption2.appendChild(document.createTextNode("実線"));
		var frameOption3 = document.createElement("option");
		frameOption3.setAttribute("value", "double");
		frameOption3.appendChild(document.createTextNode("二重線"));
		var frameOption4 = document.createElement("option");
		frameOption4.setAttribute("value", "dotted");
		frameOption4.appendChild(document.createTextNode("点線"));
		var frameOption5 = document.createElement("option");
		frameOption5.setAttribute("value", "dashed");
		frameOption5.appendChild(document.createTextNode("破線"));
		var frameOption6 = document.createElement("option");
		frameOption6.setAttribute("value", "groove");
		frameOption6.appendChild(document.createTextNode("溝線"));
		var frameOption7 = document.createElement("option");
		frameOption7.setAttribute("value", "ridge");
		frameOption7.appendChild(document.createTextNode("稜線"));
		var frameOption8 = document.createElement("option");
		frameOption8.setAttribute("value", "inset");
		frameOption8.appendChild(document.createTextNode("陥没"));
		var frameOption9 = document.createElement("option");
		frameOption9.setAttribute("value", "outset");
		frameOption9.appendChild(document.createTextNode("浮上"));

		frameSelectorElm.appendChild(frameOption1);
		frameSelectorElm.appendChild(frameOption2);
		frameSelectorElm.appendChild(frameOption3);
		frameSelectorElm.appendChild(frameOption4);
		frameSelectorElm.appendChild(frameOption5);
		frameSelectorElm.appendChild(frameOption6);
		frameSelectorElm.appendChild(frameOption7);
		frameSelectorElm.appendChild(frameOption8);
		frameSelectorElm.appendChild(frameOption9);

		frameSelectorElm.onchange = editorFrameSelectOnChange;
		editorControlElm4.appendChild(frameSelectorElm);

		if(contentsElm.style.borderTopStyle == "none")
		{
			frameSelectorElm.selectedIndex = 0;
		} 
		else if(contentsElm.style.borderTopStyle == "solid")
		{
			frameSelectorElm.selectedIndex = 1;
		} 
		else if(contentsElm.style.borderTopStyle == "double")
		{
			frameSelectorElm.selectedIndex = 2;
		} 
		else if(contentsElm.style.borderTopStyle == "dotted")
		{
			frameSelectorElm.selectedIndex = 3;
		} 
		else if(contentsElm.style.borderTopStyle == "dashed")
		{
			frameSelectorElm.selectedIndex = 4;
		} 
		else if(contentsElm.style.borderTopStyle == "groove")
		{
			frameSelectorElm.selectedIndex = 5;
		} 
		else if(contentsElm.style.borderTopStyle == "ridge")
		{
			frameSelectorElm.selectedIndex = 6;
		} 
		else if(contentsElm.style.borderTopStyle == "inset")
		{
			frameSelectorElm.selectedIndex = 7;
		} 
		else if(contentsElm.style.borderTopStyle == "outset")
		{
			frameSelectorElm.selectedIndex = 8;
		} 



		var frameSizeSelectorElm = document.createElement("select");
		frameSizeSelectorElm.setAttribute("id", "editor-framesizeselector");
		var frameSizeOption1 = document.createElement("option");
		frameSizeOption1.setAttribute("value", "0px");
		frameSizeOption1.appendChild(document.createTextNode("-"));
		var frameSizeOption2 = document.createElement("option");
		frameSizeOption2.setAttribute("value", "1px");
		frameSizeOption2.appendChild(document.createTextNode("1"));
		var frameSizeOption3 = document.createElement("option");
		frameSizeOption3.setAttribute("value", "2px");
		frameSizeOption3.appendChild(document.createTextNode("2"));
		var frameSizeOption4 = document.createElement("option");
		frameSizeOption4.setAttribute("value", "3px");
		frameSizeOption4.appendChild(document.createTextNode("3"));
		var frameSizeOption5 = document.createElement("option");
		frameSizeOption5.setAttribute("value", "4px");
		frameSizeOption5.appendChild(document.createTextNode("4"));
		var frameSizeOption6 = document.createElement("option");
		frameSizeOption6.setAttribute("value", "6px");
		frameSizeOption6.appendChild(document.createTextNode("6"));
		var frameSizeOption7 = document.createElement("option");
		frameSizeOption7.setAttribute("value", "8px");
		frameSizeOption7.appendChild(document.createTextNode("8"));
		var frameSizeOption8 = document.createElement("option");
		frameSizeOption8.setAttribute("value", "10px");
		frameSizeOption8.appendChild(document.createTextNode("10"));
		var frameSizeOption9 = document.createElement("option");
		frameSizeOption9.setAttribute("value", "12px");
		frameSizeOption9.appendChild(document.createTextNode("12"));

		frameSizeSelectorElm.appendChild(frameSizeOption1);
		frameSizeSelectorElm.appendChild(frameSizeOption2);
		frameSizeSelectorElm.appendChild(frameSizeOption3);
		frameSizeSelectorElm.appendChild(frameSizeOption4);
		frameSizeSelectorElm.appendChild(frameSizeOption5);
		frameSizeSelectorElm.appendChild(frameSizeOption6);
		frameSizeSelectorElm.appendChild(frameSizeOption7);
		frameSizeSelectorElm.appendChild(frameSizeOption8);
		frameSizeSelectorElm.appendChild(frameSizeOption9);

		frameSizeSelectorElm.onchange = editorFrameSizeSelectOnChange;
		editorControlElm4.appendChild(frameSizeSelectorElm);

		if(contentsElm.style.borderTopWidth == "0px")
		{
			frameSizeSelectorElm.selectedIndex = 0;
		} 
		else if(contentsElm.style.borderTopWidth == "1px")
		{
			frameSizeSelectorElm.selectedIndex = 1;
		} 
		else if(contentsElm.style.borderTopWidth == "2px")
		{
			frameSizeSelectorElm.selectedIndex = 2;
		} 
		else if(contentsElm.style.borderTopWidth == "3px")
		{
			frameSizeSelectorElm.selectedIndex = 3;
		} 
		else if(contentsElm.style.borderTopWidth == "4px")
		{
			frameSizeSelectorElm.selectedIndex = 4;
		} 
		else if(contentsElm.style.borderTopWidth == "6px")
		{
			frameSizeSelectorElm.selectedIndex = 5;
		} 
		else if(contentsElm.style.borderTopWidth == "8px")
		{
			frameSizeSelectorElm.selectedIndex = 6;
		} 
		else if(contentsElm.style.borderTopWidth == "10px")
		{
			frameSizeSelectorElm.selectedIndex = 7;
		} 
		else if(contentsElm.style.borderTopWidth == "12px")
		{
			frameSizeSelectorElm.selectedIndex = 8;
		} 



		var framePaddingSelectorTitleElm = document.createElement("div");
		framePaddingSelectorTitleElm.setAttribute("id", "editor-framepaddingselectortitle");
		framePaddingSelectorTitleElm.appendChild(document.createTextNode("margin"));
		editorControlElm4.appendChild(framePaddingSelectorTitleElm);


		var framePaddingSelectorElm = document.createElement("select");
		framePaddingSelectorElm.setAttribute("id", "editor-framepaddingselector");
		var framePaddingOption1 = document.createElement("option");
		framePaddingOption1.setAttribute("value", "0px");
		framePaddingOption1.appendChild(document.createTextNode("0"));
		var framePaddingOption2 = document.createElement("option");
		framePaddingOption2.setAttribute("value", "1px");
		framePaddingOption2.appendChild(document.createTextNode("1"));
		var framePaddingOption3 = document.createElement("option");
		framePaddingOption3.setAttribute("value", "2px");
		framePaddingOption3.appendChild(document.createTextNode("2"));
		var framePaddingOption4 = document.createElement("option");
		framePaddingOption4.setAttribute("value", "3px");
		framePaddingOption4.appendChild(document.createTextNode("3"));
		var framePaddingOption5 = document.createElement("option");
		framePaddingOption5.setAttribute("value", "4px");
		framePaddingOption5.appendChild(document.createTextNode("4"));
		var framePaddingOption6 = document.createElement("option");
		framePaddingOption6.setAttribute("value", "6px");
		framePaddingOption6.appendChild(document.createTextNode("6"));
		var framePaddingOption7 = document.createElement("option");
		framePaddingOption7.setAttribute("value", "8px");
		framePaddingOption7.appendChild(document.createTextNode("8"));
		var framePaddingOption8 = document.createElement("option");
		framePaddingOption8.setAttribute("value", "10px");
		framePaddingOption8.appendChild(document.createTextNode("10"));
		var framePaddingOption9 = document.createElement("option");
		framePaddingOption9.setAttribute("value", "12px");
		framePaddingOption9.appendChild(document.createTextNode("12"));

		framePaddingSelectorElm.appendChild(framePaddingOption1);
		framePaddingSelectorElm.appendChild(framePaddingOption2);
		framePaddingSelectorElm.appendChild(framePaddingOption3);
		framePaddingSelectorElm.appendChild(framePaddingOption4);
		framePaddingSelectorElm.appendChild(framePaddingOption5);
		framePaddingSelectorElm.appendChild(framePaddingOption6);
		framePaddingSelectorElm.appendChild(framePaddingOption7);
		framePaddingSelectorElm.appendChild(framePaddingOption8);
		framePaddingSelectorElm.appendChild(framePaddingOption9);

		framePaddingSelectorElm.onchange = editorFramePaddingSelectOnChange;
		editorControlElm4.appendChild(framePaddingSelectorElm);

		if(contentsElm.style.paddingTop == "0px")
		{
			framePaddingSelectorElm.selectedIndex = 0;
		} 
		else if(contentsElm.style.paddingTop == "1px")
		{
			framePaddingSelectorElm.selectedIndex = 1;
		} 
		else if(contentsElm.style.paddingTop == "2px")
		{
			framePaddingSelectorElm.selectedIndex = 2;
		} 
		else if(contentsElm.style.paddingTop == "3px")
		{
			framePaddingSelectorElm.selectedIndex = 3;
		} 
		else if(contentsElm.style.paddingTop == "4px")
		{
			framePaddingSelectorElm.selectedIndex = 4;
		} 
		else if(contentsElm.style.paddingTop == "6px")
		{
			framePaddingSelectorElm.selectedIndex = 5;
		} 
		else if(contentsElm.style.paddingTop == "8px")
		{
			framePaddingSelectorElm.selectedIndex = 6;
		} 
		else if(contentsElm.style.paddingTop == "10px")
		{
			framePaddingSelectorElm.selectedIndex = 7;
		} 
		else if(contentsElm.style.paddingTop == "12px")
		{
			framePaddingSelectorElm.selectedIndex = 8;
		} 


		editorForm.appendChild(editorControlElm4);




		// textarea
		var editorTextAreaElm = document.createElement("textarea");
		editorTextAreaElm.setAttribute("id", "editor-textarea");

		var innerHtml = "";
		if(isNewSprite(editingSprite))
		{
			innerHtml = "";
		}
		else
		{
			innerHtml = contentsElm.innerHTML;
			
			if(sprite_htmlValue != 1)
			{
				innerHtml = innerHtml.replace(/<img.*?src=\".+?\".*?>/i,"");
				innerHtml = innerHtml.replace(/<a.*?class=\"attachedfile\".*?>.*?<\/a>/i,"");
			}
			
			if(sprite_autobrValue == 1)
			{
				if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
				{
					innerHtml = innerHtml.replace(/<br>/gi,"\r");
				}
				else
				{
					innerHtml = innerHtml.replace(/<br>/gi,"");
					innerHtml = innerHtml.replace(/<br\/>/gi,"");
				}

			}
			if(sprite_autolinkValue == 1)
			{
				innerHtml = innerHtml.replace(/<a href=\".+?\">/gi,"");
				innerHtml = innerHtml.replace(/<\/a>/gi,"");
			}
		}

		var textareaTextNode = document.createTextNode(innerHtml);
		editorTextAreaElm.appendChild(textareaTextNode);
		editorTextAreaElm.style.width = formWidth.toString() + "px";
		editorTextAreaElm.style.height = formHeight.toString() + "px";
		editorForm.appendChild(editorTextAreaElm);

		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.appendChild(editorForm);

		editorTextAreaElm.focus();


		editorControlSaveElm.onmousedown = editorControlSaveOnMouseDown;
		editorControlCloseElm.onmousedown = editorControlCloseOnMouseDown;
		editorControlTopElm.onmousedown = editorControlTopOnMouseDown;
		editorControlBottomElm.onmousedown = editorControlBottomOnMouseDown;

    }

}


//------------------------------------
// Save or Delete Sprite
//------------------------------------

function editorControlSaveOnMouseDown()
{
    saveAndCloseEditor();
}


function saveAndCloseEditor()
{
    document.getElementById("controlresult").innerHTML="";

    var authorElm = document.getElementById(editingSprite.id + "_author");
    var authorName = authorElm.innerHTML;

    if(loginid == "public" && !authorName.match(/^&lt;.+&gt;$/) && !authorName.match(/^\[.+\]$/))
    {
		document.getElementById("controlresult").innerHTML="Permission denied.";
		return;
    }


    var tmpTextareaElm = document.getElementById("editor-textarea");
    var newText = tmpTextareaElm.value;

    var tmpChildren = editingSprite.childNodes;

    var positElm = document.getElementById(editingSprite.id + "_positlink");
    originalShowPositLink = positElm.style.display;
    var timeElm = document.getElementById(editingSprite.id + "_time");
    originalShowTime = timeElm.style.display;

    originalShowAuthor = authorElm.style.display;
    originalAuthor = authorName;


    var newTextPost = newText;
    if(sprite_htmlValue != 1)
    {
		newText = newText.replace(/</g,"&lt;");
		newText = newText.replace(/>/g,"&gt;");
    }
    if(sprite_htmlValue == 1 && superSpriteValue != 1)
    {
		newText = newText.replace(/onAbort/gi, "o&ntilde;Abort");
		newText = newText.replace(/onBlur/gi, "o&ntilde;Blur");
		newText = newText.replace(/onChange/gi, "o&ntilde;Change");
		newText = newText.replace(/onClick/gi, "o&ntilde;Click");
		newText = newText.replace(/ondblclick/gi, "o&ntilde;dblclick");
		newText = newText.replace(/ondraganddrop/gi, "o&ntilde;draganddrop");
		newText = newText.replace(/onError/gi, "o&ntilde;Error");
		newText = newText.replace(/onFocus/gi, "o&ntilde;Focus");
		newText = newText.replace(/onkeydown/gi, "o&ntilde;keydown");
		newText = newText.replace(/onkeypress/gi, "o&ntilde;keypress");
		newText = newText.replace(/onkeyup/gi, "o&ntilde;keyup");
		newText = newText.replace(/onLoad/gi, "o&ntilde;Load");
		newText = newText.replace(/onUnload/gi, "o&ntilde;Unload");
		newText = newText.replace(/onMouseDown/gi, "o&ntilde;MouseDown");
		newText = newText.replace(/onMouseOut/gi, "o&ntilde;MouseOut");
		newText = newText.replace(/onMouseOver/gi, "o&ntilde;MouseOver");
		newText = newText.replace(/onMouseUp/gi, "o&ntilde;MouseUp");
		newText = newText.replace(/onMouseWheel/gi, "o&ntilde;MouseWheel");
		newText = newText.replace(/onmove/gi, "o&ntilde;move");
		newText = newText.replace(/onReset/gi, "o&ntilde;Reset");
		newText = newText.replace(/onresize/gi, "o&ntilde;resize");
		newText = newText.replace(/onSelect/gi, "o&ntilde;Select");
		newText = newText.replace(/onSubmit/gi, "o&ntilde;Submit");
		newText = newText.replace(/script /gi, "script&nbsp;");
		newText = newText.replace(/ script/gi, "&nbsp;script");
		newText = newText.replace(/<script/gi, "&lt;script");
    }

    if(sprite_autobrValue == 1)
    {
		newText = newText.replace(/\n/g,"<br/>\n");
    }
    if(sprite_autolinkValue == 1)
    {
		newText = newText.replace(/(s?https?|ftp):(\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/g,"<a href=\"$1:$2\">$1:$2<\/a>");
    }

    var attachedfilename = "";
    if(document.getElementById("editor-filename"))
    {
		attachedfilename = document.getElementById("editor-filename").innerHTML;
		if(attachedfilename != ""){
			if(attachedfilename.match(/^.+?\.(gif|jpeg|jpg|png)$/i))
			{
				newText = "<img src='" + DATAFILEPATH + pageidValue + "/images/" + attachedfilename + "' class='attachedimage'>" + newText;
			}
			else
			{
				newText = "<a class=\"attachedfile\" href='"+ DATAFILEPATH + pageidValue + "/files/" + attachedfilename + "'>" + attachedfilename + "</a>" + newText ;
			}
		}
    }


    var contentsElm = document.getElementById(editingSprite.id + "_contents");	
    contentsElm.innerHTML = newText;

    // check plugin
    var pluginStr = document.getElementById(editingSprite.id + "_plugin").innerHTML;
    var pluginStrEnc = encodeURIComponent(pluginStr);
    var pluginName = "";
    var pluginArray = pluginStr.split(",");
    if(pluginArray.length >= 1)
    {
		pluginName = pluginArray[0];
    }
    if(pluginName != "" && newTextPost.length == 0)
    {
		// fill plugin name if sprite is empty
		contentsElm.innerHTML = pluginName;
		newTextPost = pluginName;
    }
    

    newTextPost = encodeURIComponent(newTextPost);

    var public_password = "";
    var public_author = "";
    if(authorName.match(/^&lt;.+&gt;$/) || authorName.match(/^\[.+\]$/))
    {
		var passwordElm = document.getElementById("editor-password");
		public_password = passwordElm.value;

		var editorAuthorElm = document.getElementById("editor-author");
		public_author = editorAuthorElm.value;
		if(public_author == "")
		{
			public_author = "public";
		}

		if(public_author == "public")
		{
			if(public_password != "")
			{
				authorElm.innerHTML = "&lt;public&gt;";
			}
			else
			{
				authorElm.innerHTML = "[public]";
			}
		}
		else
		{
			if(public_password != "")
			{
				authorElm.innerHTML = "&lt;" + public_author + "&gt;";
			}
			else
			{
				authorElm.innerHTML = "[" + public_author + "]";
			}
		}

		var pubauthor = encodeURIComponent(public_author);
		setCookie("public_author", pubauthor, CGIFILEPATH, 30);
    }


    if(newTextPost.length > 0 || attachedfilename != "")
    {	
		// save sprite contents and styles
		var selector = document.getElementById('editor-frameselector');
		var sizeselector = document.getElementById('editor-framesizeselector');
		
		var zIndex = originalZindexOfEditingSprite;
		var styles = "left:" + editingSprite.style.left + "; "
			+ "top:" + editingSprite.style.top + "; "
			+ "width:" + editingSprite.style.width + "; "
			+ "z-index:" + zIndex + ";";

		var borderWidth = sizeselector.options[sizeselector.selectedIndex].value;
		var borderStyle = selector.options[selector.selectedIndex].value;

		var paddingselector = document.getElementById('editor-framepaddingselector');
		var padding = paddingselector.options[paddingselector.selectedIndex].value;

		var contentsStyles = "border-width:" + borderWidth + "; "
			+ "border-style:" + borderStyle + ";"
			+ "padding:" + padding+ ";"
		if(contentsElm.style.borderTopColor)
		{
			contentsStyles += "border-color:" + contentsElm.style.borderTopColor + "; ";
		}
		if(contentsElm.style.backgroundColor)
		{
			contentsStyles += "background-color:" + contentsElm.style.backgroundColor + ";";
		}
		if(contentsElm.style.color)
		{
			contentsStyles += "color:" + contentsElm.style.color + ";";
		}

		var showPositElm = document.getElementById("editor-showpositlink");
		var showPositFlag = 0;
		var positElm = document.getElementById(editingSprite.id + "_positlink");
		positElm.style.display = "none";
		if(showPositElm.checked)
		{
			showPositFlag = 1;
			positElm.style.display = "block";
		}

		var showTimeElm = document.getElementById("editor-showtime");
		var showTimeFlag = 0;
		var timeElm = document.getElementById(editingSprite.id + "_time");
		timeElm.style.display = "none";
		if(showTimeElm.checked)
		{
			showTimeFlag = 1;
			timeElm.style.display = "block";
		}

		var showAuthorElm = document.getElementById("editor-showauthor");
		var showAuthorFlag = 0;
		var authorElm = document.getElementById(editingSprite.id + "_author");
		authorElm.style.display = "none";
		if(showAuthorElm.checked)
		{
			showAuthorFlag = 1;
			authorElm.style.display = "block";
		}


		attachedfilename = encodeURIComponent(attachedfilename);

		var postdata = "&id="+ editingSprite.id + "&contents="+newTextPost + "&pageid="+pageidValue + "&public_password="+public_password + "&public_author="+public_author + "&styles=" + styles + "&contentsStyles=" + contentsStyles + "&dispauthor=" + showAuthorFlag + "&disptime=" + showTimeFlag + "&dispposit=" + showPositFlag + "&attached=" + attachedfilename + "&plugin=" + pluginStrEnc;
		savingSprite = editingSprite;
		sendRequest(saveSpriteOnLoaded, postdata, "POST", CGIFILEPATH + "saveSprite.cgi", true, true);

    }
    else
    {
		// delete sprite
		var postdata = "&id="+ editingSprite.id + "&pageid="+pageidValue + "&public_password="+public_password;
		deletingSprite = editingSprite;
		sendRequest(deleteSpriteOnLoaded, postdata, "POST", CGIFILEPATH + "deleteSprite.cgi", true, true);

    }

}


function saveSpriteOnLoaded(obj)
{
    var res = obj.responseText;
    if (res != "succeed")
    {	
		var contentsElm = document.getElementById(savingSprite.id + "_contents");	
		contentsElm.innerHTML = originalInnerHtml;

		var positElm = document.getElementById(savingSprite.id + "_positlink");
		positElm.style.display = originalShowPositLink;
		var timeElm = document.getElementById(savingSprite.id + "_time");
		timeElm.style.display = originalShowTime;
		var authorElm = document.getElementById(savingSprite.id + "_author");
		authorElm.style.display = originalShowAuthor;

		authorElm.innerHTML = originalAuthor;

		if (res == "invalid_public_password")
		{
			document.getElementById("controlresult").innerHTML="Please enter the valid password.";
		}
		else
		{
			document.getElementById("controlresult").innerHTML=res;
		}
    }
    else
    {
		if(document.getElementById("editor-password"))
		{
			var passwordElm = document.getElementById("editor-password");
			var public_password = passwordElm.value;
			if(public_password != "")
			{
				setCookie("public_password", public_password, CGIFILEPATH, 30);
			}
		}


		if(crossBrowser.bw.msie)
		{

			// Sprite width is automatically expanded to adjust to the width of inner image on IE6.
			var definedWidth = parseInt(savingSprite.style.width.replace(/px/g, ""));
			var realWidth = parseInt(savingSprite.offsetWidth) - 6;
			if(definedWidth < realWidth)
			{
				savingSprite.style.width = realWidth + "px";
				saveStyles(savingSprite);
			}
		}

		if(tcs != null)
		{
			frameColorDialogOpen = false;
			bgColorDialogOpen = false;
			foreColorDialogOpen = false;
			var editorElm = document.getElementById("editor");
			var tcsElm = document.getElementById("trianglecolorselector");
			if(tcsElm != null && tcsElm != undefined)
			{
				editorElm.removeChild(tcsElm);
			}
			tcs = null;
		}

		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.removeChild(document.getElementById("editor"));

		var id = editingSprite.id
		clearSelectedSprite();

		editingSprite.style.zIndex = originalZindexOfEditingSprite;
		setSelectedSprite(document.getElementById(id));

		editingSprite = null;
    }
}


function deleteSpriteOnLoaded(obj)
{
    var res = obj.responseText;
    if (res != "succeed")
    {	
		var contentsElm = document.getElementById(deletingSprite.id + "_contents");	
		contentsElm.innerHTML = originalInnerHtml;

		var positElm = document.getElementById(deletingSprite.id + "_positlink");
		positElm.style.display = originalShowPositLink;
		var timeElm = document.getElementById(deletingSprite.id + "_time");
		timeElm.style.display = originalShowTime;
		var authorElm = document.getElementById(deletingSprite.id + "_author");
		authorElm.style.display = originalShowAuthor;

		authorElm.innerHTML = originalAuthor;

		if (res == "invalid_public_password")
		{
			document.getElementById("controlresult").innerHTML="Please enter the valid password.";
		}
		else
		{
			document.getElementById("controlresult").innerHTML=res;
		}
		return;
    }
    else
    {
		fixedID = 0;

		var spritesListNode = document.getElementById("spriteslist");
		spritesListNode.removeChild(deletingSprite);
		
		if(tcs != null)
		{
			frameColorDialogOpen = false;
			bgColorDialogOpen = false;
			foreColorDialogOpen = false;
			var editorElm = document.getElementById("editor");
			var tcsElm = document.getElementById("trianglecolorselector");
			if(tcsElm != null && tcsElm != undefined)
			{
				editorElm.removeChild(tcsElm);
			}
			tcs = null;
		}

		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.removeChild(document.getElementById("editor"));

		deletingSprite = null;
		editingSprite = null;	    
    }

}


//------------------------------
// Save only styles of sprite
//------------------------------
function saveStyles(targetSprite)
{
    if(targetSprite == null)
    {
		return;
    }

    // for page_autosize
    var maxHeight = worldHeight;
    if(parseInt(targetSprite.style.top.replace(/px/g,"")) + parseInt(targetSprite.offsetHeight) > worldHeight - document.getElementById("footer").offsetHeight)
    {	
		maxHeight = parseInt(targetSprite.style.top.replace(/px/g,"")) + parseInt(targetSprite.offsetHeight) + 100;
    }
    var maxWidth = worldWidth;
    if(parseInt(targetSprite.style.left.replace(/px/g,"")) + parseInt(targetSprite.style.width.replace(/px/g,"")) > worldWidth)
    {
		maxWidth = parseInt(targetSprite.style.left.replace(/px/g,"")) + parseInt(targetSprite.style.width.replace(/px/g,"")) + 100;
    }

    var zIndex = 0;
    
    if(fixedID != 0 && fixedID == targetSprite.id)
    {
		zIndex = originalZindexOfSelectedSprite2;
    }
    else
    {
		zIndex = originalZindexOfSelectedSprite;
    }


    var styles = "left:" + targetSprite.style.left + "; "
		+ "top:" + targetSprite.style.top + "; "
		+ "width:" + targetSprite.style.width + "; "
		+ "z-index:" + zIndex + ";";

    var public_password = getCookie("public_password");
    if(document.getElementById("password-dialog"))
    {
		var passwordElm = document.getElementById("dialog-pass");
		public_password = passwordElm.value;
    }

    if(public_password == undefined)
    {
		public_password = "";
    }
    var postdata = "&id="+ targetSprite.id + "&pageid="+pageidValue + "&public_password="+public_password + "&styles=" + styles + "&height="+ maxHeight + "&width="+maxWidth;
    savingSprite = targetSprite;
    sendRequest(saveStylesOnLoaded, postdata, "POST", CGIFILEPATH + "saveStyles.cgi", true, true);

}

function saveStylesOnLoaded(obj)
{
    var res = obj.responseText;
    var resArray = res.split(",");
    if (resArray[0] == "invalid_public_password")
    {
		selectedSprite = savingSprite;

		if(document.getElementById("password-dialog"))
		{
			document.getElementById("dialog-result").innerHTML="Permission denied.";
		}
		else
		{
			openPasswordDialog();
		}
		return;
    }
    else if(resArray[0] != "succeed" && resArray[0] != "resized")
    {
		savingSprite.style.left = originalLeft;
		savingSprite.style.top = originalTop;
		savingSprite.style.width = originalWidth;
		savingSprite.style.zIndex = originalZindex;

		var contents = document.getElementById(savingSprite.id + "_contents");
		contents.style.borderWidth = originalBorderWidth;
		contents.style.borderColor = originalBorderColor;
		contents.style.borderStyle = originalBorderStyle;
		contents.style.backgroundColor = originalBackgroundColor;
		contents.style.color = originalForegroundColor;
		contents.style.padding = originalPadding;

		document.getElementById("controlresult").innerHTML=res;
		return;
    }
    else if(resArray[0] == "resized")
    {
		worldWidth = parseInt(resArray[1]);
		worldHeight = parseInt(resArray[2]);

		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.style.width = worldWidth.toString() + "px";
		spritesWorldNode.style.height = worldHeight.toString() + "px";
    }

    if(document.getElementById("password-dialog"))
    {
		var passwordElm = document.getElementById("dialog-pass");
		var public_password = passwordElm.value;
		if(public_password != "")
		{
			setCookie("public_password", public_password, CGIFILEPATH, 30);
		}

		var spritesWorldNode = document.getElementById("spritesworld");
		spritesWorldNode.removeChild(document.getElementById("password-dialog"));
		editingSprite = null;
    }
}


//--------------------------------
// Create Sprite
//--------------------------------
function createSprite()
{
    document.getElementById("controlresult").innerHTML="";

    var styles = "";
    
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		leftOfNewSprite = 5 - viewPositionX + parseInt(document.documentElement.scrollLeft) + Math.floor(Math.random()*70);
		topOfNewSprite = 5 - viewPositionY + parseInt(document.documentElement.scrollTop) + Math.floor(Math.random()*30);
    }
    else
    {
		var xOffset = 0;
		var yOffset = 0;
		if(crossBrowser.bw.safari)
		{
			xOffset = parseInt(document.body.scrollLeft);
			yOffset = parseInt(document.body.scrollTop);
		}
		else
		{
			xOffset = parseInt(document.documentElement.scrollLeft);
			yOffset = parseInt(document.documentElement.scrollTop);
		}
		
		leftOfNewSprite = 5 - viewPositionX + xOffset + Math.floor(Math.random()*70);
		topOfNewSprite = 100 - viewPositionY + yOffset + Math.floor(Math.random()*30);
    }

    var postdata = "&pageid="+pageidValue+"&top="+topOfNewSprite+"&left="+leftOfNewSprite;
    sendRequest(createSpriteOnLoaded, postdata, "POST", CGIFILEPATH + "createSprite.cgi", true, true);
}


function createSpriteOnLoaded(obj)
{
    var res = obj.responseText;
    var resArray = res.split(",");
    if(resArray == null || resArray[0] != "succeed")
    {
		document.getElementById("controlresult").innerHTML=res;
		return;
    }

    var newSpriteID = resArray[1];
    var newSprite = resArray[2];
    var newAuthor = resArray[3]; // for showing "admin" instead of showing admin user name
    var newSpriteTime = resArray[4];

    // msie
    if(crossBrowser.bw.msie || crossBrowser.bw.msie7)
    {
		var ulElm = document.getElementById("spriteslist");
		var tmpHTML = ulElm.innerHTML;
		tmpHTML += "<li class='sprite' id='" + newSpriteID + "' style='left:" +  leftOfNewSprite.toString() + "px; top:" + topOfNewSprite.toString() + "px; width:240px;  z-index:" + Z_SPRITE_CREATEMIN + "; border-left:0px none #000000; border-right:0px none #000000; border-top:0px none #000000; border-bottom:0px none #000000;'><div class='spritecontents' id='" + newSpriteID + "_contents' style='background-color: #ffffff; padding:5px; border:1px solid #a0a0a0; text-align:center; display:block;'>" + newSprite + "</div><div class='spriteinfo'><span class='spriteplugin' id='" + newSpriteID + "_plugin' style='display:none;'></span><span class='spriteauthor' id='" + newSpriteID + "_author' style='display:block;'>" + newAuthor + "</span><span class='spritetime' id='" + newSpriteID + "_time' style='display:block;'>" + newSpriteTime + "</span><span class='spritepositlink' id='" + newSpriteID + "_positlink' style='display:block;'><a href='./positlog.cgi?load=" + pageidValue + "&id=" + newSpriteID + "'>link</a></span></div></li>";
		ulElm.innerHTML = tmpHTML;

		// reset id property for mouseover event
		var spritesList = ulElm.childNodes;
		for (var i=0; i<spritesList.length; i++)
		{
			var tmpSprite = spritesList[i];
			if(tmpSprite.nodeType == 1)
			{
				tmpSprite.onmouseover = spriteOnMouseOver;
			}
		}
    }
    else
    {
		// not msie

		var liElm = document.createElement("li");
		liElm.setAttribute("class", "sprite");
		liElm.setAttribute("id", newSpriteID);
		liElm.style.width = "240px";
		liElm.style.left = leftOfNewSprite.toString() + "px";
		liElm.style.top = topOfNewSprite.toString() + "px";
		liElm.style.zIndex = Z_SPRITE_CREATEMIN;

		liElm.style.borderWidth = "0px";
		liElm.style.borderStyle = "none";
		liElm.style.borderColor = "#ffffff";

		var contentsElm = document.createElement("div");
		contentsElm.setAttribute("id", newSpriteID + "_contents");
		contentsElm.setAttribute("class", "spritecontents");
		contentsElm.appendChild(document.createTextNode(""));
		contentsElm.innerHTML = newSprite;

		contentsElm.style.borderWidth = "1px";
		contentsElm.style.borderStyle = "solid";
		contentsElm.style.borderColor = "#a0a0a0";
		contentsElm.style.padding = "5px";
		contentsElm.style.textAlign = "center";
		contentsElm.style.backgroundColor = "#ffffff";

		liElm.appendChild(contentsElm);

		var infoElm = document.createElement("div");
		infoElm.setAttribute("class", "spriteinfo");

		var pluginElm = document.createElement("span");
		pluginElm.setAttribute("id", newSpriteID + "_plugin");
		pluginElm.setAttribute("class", "spriteplugin");
		pluginElm.appendChild(document.createTextNode(""));
		pluginElm.style.display ="none";
		infoElm.appendChild(pluginElm);

		var authorElm = document.createElement("span");
		authorElm.setAttribute("id", newSpriteID + "_author");
		authorElm.setAttribute("class", "spriteauthor");
		authorElm.appendChild(document.createTextNode(newAuthor));
		authorElm.style.display ="block";
		infoElm.appendChild(authorElm);

		var timeElm = document.createElement("span");
		timeElm.setAttribute("id", newSpriteID + "_time");
		timeElm.setAttribute("class", "spritetime");
		timeElm.appendChild(document.createTextNode(newSpriteTime));
		timeElm.style.display ="block";
		infoElm.appendChild(timeElm);

		var positElm = document.createElement("span");
		positElm.setAttribute("id", newSpriteID + "_positlink");
		positElm.setAttribute("class", "spritepositlink");
		positElm.appendChild(document.createTextNode(""));
		positElm.innerHTML = "<a href='./positlog.cgi?load=" + pageidValue + "&id=" + newSpriteID + "'>link</a>";
		positElm.style.display ="block";
		infoElm.appendChild(positElm);

		liElm.appendChild(infoElm);

		liElm.onmouseover = spriteOnMouseOver;

		var ulElm = document.getElementById("spriteslist");
		ulElm.appendChild(liElm);
    }


    var newSprite = document.getElementById(newSpriteID);
    // get list of all sprites
    var spritesListNode = document.getElementById("spriteslist");
    var spritesList = spritesListNode.childNodes;
    var topZ = newSprite.style.zIndex;
    var topSprite = newSprite;

    clearSelectedSprite(); // reset z-index

    for (var i=0; i<spritesList.length; i++)
    {
		var tmpSprite = spritesList[i];
		if(tmpSprite.nodeType == 1)
		{
			var tmpZ = parseFloat(tmpSprite.style.zIndex);
			if(tmpSprite != newSprite)
			{
				if(tmpZ > topZ && tmpZ != Z_GO_TEMP_FOREGROUND)
				{
					topZ = tmpZ;
					topSprite = tmpSprite;
				}
			}
		}
    }
    if(topSprite != newSprite)
    {
		if(topZ < Z_SPRITE_MAX)
		{
			newSprite.style.zIndex = topZ+1;
		}
		else
		{
			newSprite.style.zIndex = Z_SPRITE_MAX;
		}
    }
}


//-----------------------------------
// Create New Page
//-----------------------------------
function createPage()
{
    var tmppagetitle = document.title;
    var leftBraceChar = "(";
    var rightBraceChar = ")";

    var pagetitleArray = tmppagetitle.split(" ");
    if(pagetitleArray == null)
    {
		pageNumber = 2;
    }
    else
    {
		var pageNumber = pagetitleArray[pagetitleArray.length-1];
		var matchNumber = pageNumber.match(/\d+/);
		if(matchNumber)
		{
			if(pageNumber.match(/\[/))
			{
				leftBraceChar = "[";
				rightBraceChar = "]";
			}

			if(pageNumber.match(/\{/))
			{
				leftBraceChar = "{";
				rightBraceChar = "}";
			}

			if(pageNumber.match(/#/))
			{
				leftBraceChar = "#";
				rightBraceChar = "";
			}


			pageNumber = parseInt(matchNumber) + 1;
			tmppagetitle = pagetitleArray[0] + " ";
			for(var i=1; i<pagetitleArray.length-1; i++)
			{
				tmppagetitle += pagetitleArray[i] + " ";
			}
		}
		else
		{
			pageNumber = 2;
		}
    }

    var newpagetitle = window.prompt("Please enter the title of the new page.", tmppagetitle + " " + leftBraceChar + pageNumber + rightBraceChar);
    if(newpagetitle == "")
    {
		document.getElementById("controlresult").innerHTML = "The title is not entered.";
		return;
    }
    else if(newpagetitle == null)
    {
		return;
    }

    sendRequest(createPageOnLoaded, "&pageid="+pageidValue+"&newpagetitle="+newpagetitle , "POST", CGIFILEPATH + "createPage.cgi", true, true);

} 

function createPageOnLoaded(obj)
{
    var res = obj.responseText;
    var resArray = res.split(",");
    
    if(resArray == null || resArray[0] != "succeed"){
		document.getElementById("controlresult").innerHTML=res;
		return;
    }

    // get pageid
    location.href = urlPure + "?load=" + pageidValue + "&mode=EditMode";
}

