#!/usr/local/bin/perl

use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve lock_nstore);
use PositLogConfig;

my $CGI = new CGI;
my $pageid = $CGI->param("page");
my $path = $CGI->param("path");

if($pageid eq "" || $path eq "")
{
    exit(0);
}

my $validUser = 0;
my $adminUser = 0;

sub showLoginScreen()
{
    my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<title>Invalid user</title>\n
	</head>\n";

    my $BODY = "<body onLoad=\"location.href='" . $PositLogConfig::cgipath . "positlog.cgi?load=" . $pageid . "&mode=login'\">\n";
    $BODY .= "<p><a href='" . $PositLogConfig::cgipath . "positlog.cgi?load=" . $pageid . "&mode=login'>Please Login</a>\n</body>\n";

    my $FOOTER = "</html>";
    print "Content-type: text/html\n\n";
    print $HEADER . $BODY . $FOOTER;
    exit(0);
}

my $loginid = $CGI->cookie("loginid") || "";
my $loginpass = $CGI->cookie("loginpass") || "";

if($loginid eq "" || $loginid eq "public")
{
    $loginid = "public";
}
else
{
    my $adminnameAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "key.cgi")};
    if($@){ exit(0);}
    if($adminnameAuth ne "" && exists($adminnameAuth->{$loginid}))
    {
		my $cryptpass = $adminnameAuth->{$loginid}{"password"};
		my $salt="lc";
		my $cryptpass2 = crypt($loginpass, $salt);
		if($cryptpass eq $cryptpass2)
		{
			$validUser = 1;
			$adminUser = 1;
		}
    }
    else{
		my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")};
		if($@){ exit(0);}
		if($useridAuth ne "" && exists($useridAuth->{$loginid}))
		{
			my $cryptpass = $useridAuth->{$loginid}{"password"};
			my $salt="ry";
			my $cryptpass2 = crypt($loginpass, $salt);
			if($cryptpass eq $cryptpass2)
			{
				$validUser = 1;
			}
		}
    }

    if(!$validUser && !$adminUser)
    {
		&showLoginScreen();
		exit(0);
    }
}

#-------------------------------------------------------------
# Can read?
#-------------------------------------------------------------

my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")};
if($@){ exit(0); }

my $canRead = 0;
if($adminUser)
{
    $canRead = 1;
}
elsif(scalar($permissionHash->{"read_page"}{"public"}) == 1)
{
    $canRead = 1;
}
else
{
    # check user list
    if(scalar($permissionHash->{"read_page"}{$loginid}) == 1)
    {
		$canRead = 1;
    }
    else
    {
		# check user group list
		foreach my $usergroupname (keys %{$permissionHash->{"read_page_group"}})
		{
			my $usergroupnameenc = $usergroupname;
			$usergroupnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
			$usergroupnameenc =~ tr/ /+/;

			my $UserList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $usergroupnameenc . ".cgi")};
			if($@){ exit(0); }
			if(scalar($UserList->{$loginid}) == 1)
			{
				$canRead = 1;
			}
		}
    }
}


if(!$canRead)
{
    &showLoginScreen();
    exit(0);
}

my $fname = $PositLogConfig::datapath . $pageid . $path;
my $type = "";
if($path =~ /^.+\.(gif|jpg|jpeg|png)$/i)
{
    if($1 eq "jpg")
    {
		$type = "image/jpeg";
    }
    else
    {
		$type = "image/" . $1;
    }
}
elsif($path =~ /^.+\.pdf$/i)
{
    $type = "application/pdf";
}
elsif($path =~ /^.+\.(html|htm)$/i)
{
    $type = "text/html";
}
elsif($path =~ /^.+\.txt$/i)
{
    $type = "text/plain";
}
elsif($path =~ /^.+\.(mpg|mpeg)$/i)
{
    $type = "video/mpeg";
}
elsif($path =~ /^.+\.(asx|asf)$/i)
{
    $type = "video/x-ms-asf";
}
elsif($path =~ /^.+\.wma$/i)
{
    $type = "video/x-ms-wma";
}
elsif($path =~ /^.+\.wmv$/i)
{
    $type = "video/x-ms-wmv";
}
elsif($path =~ /^.+\.mov$/i)
{
    $type = "video/quicktime";
}
else
{
    $type = "application/octet-stream";
}


open(FILE, $fname) or die;
binmode FILE;
binmode STDOUT;
print "Content-type: " . $type . "\n\n";
print while (<FILE>);
close(FILE);
