package PositLogPlugin::cocolog;

# --------------------------------------------------------
# cocolog.pm:
#      module for retrieving PositLog dynamic sprites
#      from cocolog
#
# Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp>
#   http://storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# --------------------------------------------------------

# --------------------------------------------------------
# This perl module generate a new srprite from cocolog
# and returns a reference of an associative array
# %spriteidItem = ("ModifiedTime,SpriteID", "contents")
#
# "contents" includes html contents for a sprite
# --------------------------------------------------------

use strict;
use HTTP::Lite;			# must be locally installed
use Time::Local;
use Storable qw(lock_retrieve lock_nstore);
use Encode qw/encode decode from_to/;
use PositLogConfig;

# prefix of serialized associtation data (url, spriteID)
my $serializedData = "cclg_url_spriteid_";

sub getWidth
{
	return 320;
}

sub getCSS
{
	return "cocolog_contents.css";
}

sub getType
{
	return "replace";
}

sub clearCache
{
    my ($pageid, $args) = @_;

    my @argsArray = split(/,/, $args);
    my $url = $argsArray[0];
    my $urlenc = $url;
    $urlenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
    $urlenc =~ tr/ /+/;

    my $urlSpriteid = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/dynamic/". $serializedData . $urlenc.".dat")} or {};

    if (exists($urlSpriteid->{$url})) {
	my $sid = $urlSpriteid->{$url};
	unlink $PositLogConfig::datapath . $pageid . "/static/" . $sid.".spr" or return "Delete error.";
	delete $urlSpriteid->{$url};

	if(!eval{Storable::lock_nstore $urlSpriteid, $PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$urlenc .".dat";}){ return "Save error."; }
	return "Succeed.";
    }
    else{
	return "No cache.";
    }
}


sub getSprites
{
    # get (URL of cocolog and rss)
    my ($pageid, $sourceID, $args) = @_;
    my @argsArray = split(/,/, $args);

    my $url = $argsArray[0];

    # if no $rssurl, no use cache
    my $rssurl = "";
    if(scalar(@argsArray) >= 2)
    {
		$rssurl = $argsArray[1];
    }

    my %spriteidItem = ();

    # URL encoding for serialized data file name
    my $urlenc = $url;
    $urlenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
    $urlenc =~ tr/ /+/;


    # get sprite list
    my $spritesHash = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")};
    if($@){ warn $@; return \%spriteidItem; }
    # get page config
    my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")};
    if($@){ warn $@; return \%spriteidItem; }
    # get dynamic sprite table
    my $urlSpriteid = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/dynamic/". $serializedData.$urlenc.".dat")} or {};

    # retrieve web page
    my $http = new HTTP::Lite;

    # success flag for retrieving
    my $httpsuccess = 1;

    # Check HTTP Status code 304
    if (exists($urlSpriteid->{$url}) && $rssurl ne "") {

		my $req = "";

		
		# spriteID for the requestted url already exists
		my $sid = $urlSpriteid->{$url};
		if(exists($spritesHash->{$sid}))
		{
			my $modifiedtime = $spritesHash->{$sid}{"modified_time"};

			if($rssurl ne "usecache"){
				$modifiedtime =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/;
				my $sec = $6;	my $min = $5; 	my $hour = $4; 	my $mday = $3; 	my $mon = $2; 	my $year = $1;
				my $modifiedtimeStr = $year . "/" . $mon . "/" . $mday . " " . $hour . ":" . $min . ":" . $sec;
				$sec =~ s/0(\d)/$1/;
				$min =~ s/0(\d)/$1/;
				$hour =~ s/0(\d)/$1/;
				$mday =~ s/0(\d)/$1/;
				$mon =~ s/0(\d)/$1/;
				my $time = timelocal(scalar($sec), scalar($min), scalar($hour), scalar($mday), scalar($mon) - 1, scalar($year));
				my @DoW = qw(Sun Mon Tue Wed Thu Fri Sat);
				my @MoY = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
				my %MonHash = ("Jan" => 1, "Feb" => 2, "Mar" => 3, "Apr" => 4, "May" => 5, "Jun" => 6, "Jul" => 7,  "Aug" => 8,  "Sep" => 9, "Oct" => 10,  "Nov" => 11, "Dec" => 12);
				my ($sec, $min, $hour, $mday, $mon, $year, $wday) = gmtime($time);
				my $modifiedHTTPdate = sprintf("%s, %02d %s %04d %02d:%02d:%02d GMT",
											   $DoW[$wday],
											   $mday, $MoY[$mon], $year+1900,
											   $hour, $min, $sec);
				$http->add_req_header('If-Modified-Since', $modifiedHTTPdate);

				# HEAD request
				$http->method('HEAD');
				$req = $http->request($rssurl);
			}

			if($req =~ /304/gi || $req =~ /50\d/gi || $rssurl eq "usecache")
			{
				# return cached sprite
				my $spriteContents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/static/" . $sid.".spr")} or "";
				if($spriteContents ne "")
				{
					$spriteidItem{$modifiedtime . "," . $sid} = $$spriteContents;
					return \%spriteidItem;
				}
			}
		}
    }


    # GET Request
    $http->method('GET');
    my $req = $http->request($url)
		or $httpsuccess = 0;

    my $page =  $http->body();

    # -----------------------------------
    # parse entry of cocolog
    # (using XML module is more functional,
    #  but needs installing perl module)
    # -----------------------------------

    my $newContents = "";

    # parse entry
    my @contentsArray = ();
    foreach my $entry ($page =~ /(\n\n<h2>.+?<\/h2>.+?<div class=\"entry-top\"><\/div>.+<div class=\"entry-bottom\"><\/div>)/gis)     
    {
		push(@contentsArray, $entry);
    }

    while(@contentsArray)
    {
		$newContents .= "<div class='cocolog_contents'>";
		$newContents .= shift(@contentsArray);
		$newContents .= "</div>";
    }

    # change modified time
    my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
    my $modifiedtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);

    if (!$httpsuccess) {
		# can't retrieve page
		while ( (my $keyURL, my $valueSpriteid) = each %$urlSpriteid ) {
			$spriteidItem{$modifiedtime . "," . $valueSpriteid} = "<div class='cocolog_contents'>Cannot retrieve contents</div>";
		}
    } 
    else
    {
		my %newUrlSpriteid;

		if (exists($urlSpriteid->{$url})) {
			# spriteID for requested url already exists
			my $sid = $urlSpriteid->{$url};
			$spriteidItem{$modifiedtime . "," . $sid} = $newContents;

			# save sprite
			if(!eval{Storable::lock_nstore \$newContents, $PositLogConfig::datapath . $pageid . "/static/" . $sid.".spr"}) { print "Cannot write .spr."; return \%spriteidItem; }
			$spritesHash->{$sid}{"type"} = "dynamic";
			$spritesHash->{$sid}{"plugin_source"} = $sourceID;
			$spritesHash->{$sid}{"modified_time"} = $modifiedtime;
			$configHash->{"modified_time"} = $modifiedtime;

		} else {
			# generate new spriteID
			# id must start from alphabet in HTML4.01
			my $newSpriteID = "";
			do
			{
				my $rand = int (rand(1000));
				$rand = sprintf("%03d", $rand);
				# id must start from alphabet in HTML4.01
				$newSpriteID = "sprite_" . $modifiedtime . "_" . $rand;
			}while(exists($spritesHash->{$newSpriteID}));

			$spriteidItem{$modifiedtime . "," . $newSpriteID} = $newContents;
			$newUrlSpriteid{$url} = $newSpriteID;

			# store new dynamic sprite table
			if(!eval{Storable::lock_nstore \%newUrlSpriteid, $PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData.$urlenc.".dat"}) { print "Cannot write dynamic sprite table."; return \%spriteidItem; }

			# save sprite
			if(!eval{Storable::lock_nstore \$newContents, $PositLogConfig::datapath . $pageid . "/static/" . $newSpriteID.".spr"}) { print "Cannot write .spr."; return \%spriteidItem; }
			$spritesHash->{$newSpriteID}{"type"} = "dynamic";
			$spritesHash->{$newSpriteID}{"plugin_source"} = $sourceID;
			$spritesHash->{$newSpriteID}{"created_time"} = $modifiedtime;
			$spritesHash->{$newSpriteID}{"modified_time"} = $modifiedtime;
			$configHash->{"modified_time"} = $modifiedtime;
		}

		# save modified time
		if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pageid . "/sprites.dat"}){ print "Cannot write sprites.dat."; return \%spriteidItem; }

	if(!eval{Storable::lock_nstore $configHash, $PositLogConfig::datapath . $pageid . "/config.dat"}) { print "Cannot write the page configuration."; return \%spriteidItem; }

    }

    return \%spriteidItem;
}
