/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.FilteringDirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class EntryUtils {
    public static void copyNodeRecursively(Entry entry, DirectoryEntry target) throws IOException {
        DirectoryEntry newTarget = null;
        if (entry.isDirectoryEntry()) {
            newTarget = target.createDirectory(entry.getName());
            Iterator entries = ((DirectoryEntry)entry).getEntries();
            while (entries.hasNext()) {
                EntryUtils.copyNodeRecursively((Entry)entries.next(), newTarget);
            }
        } else {
            DocumentEntry dentry = (DocumentEntry)entry;
            DocumentInputStream dstream = new DocumentInputStream(dentry);
            target.createDocument(dentry.getName(), dstream);
            dstream.close();
        }
    }

    public static void copyNodes(DirectoryEntry sourceRoot, DirectoryEntry targetRoot) throws IOException {
        Iterator iterator = sourceRoot.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            EntryUtils.copyNodeRecursively(entry, targetRoot);
        }
    }

    public static void copyNodes(FilteringDirectoryNode filteredSource, FilteringDirectoryNode filteredTarget) throws IOException {
        EntryUtils.copyNodes((DirectoryEntry)filteredSource, (DirectoryEntry)filteredTarget);
    }

    public static void copyNodes(DirectoryEntry sourceRoot, DirectoryEntry targetRoot, List excepts) throws IOException {
        Iterator entries = sourceRoot.getEntries();
        while (entries.hasNext()) {
            Entry entry = (Entry)entries.next();
            if (excepts.contains(entry.getName())) continue;
            EntryUtils.copyNodeRecursively(entry, targetRoot);
        }
    }

    public static void copyNodes(POIFSFileSystem source, POIFSFileSystem target) throws IOException {
        EntryUtils.copyNodes(source.getRoot(), target.getRoot());
    }

    public static void copyNodes(POIFSFileSystem source, POIFSFileSystem target, List excepts) throws IOException {
        EntryUtils.copyNodes(new FilteringDirectoryNode(source.getRoot(), excepts), new FilteringDirectoryNode(target.getRoot(), excepts));
    }

    public static boolean areDirectoriesIdentical(DirectoryEntry dirA, DirectoryEntry dirB) {
        Entry a;
        if (!dirA.getName().equals(dirB.getName())) {
            return false;
        }
        if (dirA.getEntryCount() != dirB.getEntryCount()) {
            return false;
        }
        HashMap<String, Integer> aSizes = new HashMap<String, Integer>();
        int isDirectory = -12345;
        Iterator iterator = dirA.iterator();
        while (iterator.hasNext()) {
            a = (Entry)iterator.next();
            String aName = a.getName();
            if (a.isDirectoryEntry()) {
                aSizes.put(aName, new Integer(-12345));
                continue;
            }
            aSizes.put(aName, new Integer(((DocumentNode)a).getSize()));
        }
        iterator = dirB.iterator();
        while (iterator.hasNext()) {
            Entry b = (Entry)iterator.next();
            String bName = b.getName();
            if (!aSizes.containsKey(bName)) {
                return false;
            }
            int size = b.isDirectoryEntry() ? -12345 : ((DocumentNode)b).getSize();
            if (size != (Integer)aSizes.get(bName)) {
                return false;
            }
            aSizes.remove(bName);
        }
        if (!aSizes.isEmpty()) {
            return false;
        }
        iterator = dirA.iterator();
        while (iterator.hasNext()) {
            a = (Entry)iterator.next();
            try {
                Entry b = dirB.getEntry(a.getName());
                boolean match = a.isDirectoryEntry() ? EntryUtils.areDirectoriesIdentical((DirectoryEntry)a, (DirectoryEntry)b) : EntryUtils.areDocumentsIdentical((DocumentEntry)a, (DocumentEntry)b);
                if (match) continue;
                return false;
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean areDocumentsIdentical(DocumentEntry docA, DocumentEntry docB) throws IOException {
        if (!docA.getName().equals(docB.getName())) {
            return false;
        }
        if (docA.getSize() != docB.getSize()) {
            return false;
        }
        boolean matches = true;
        DocumentInputStream inpA = null;
        DocumentInputStream inpB = null;
        try {
            int readB;
            inpA = new DocumentInputStream(docA);
            inpB = new DocumentInputStream(docB);
            do {
                int readA;
                if ((readA = inpA.read()) != (readB = inpB.read())) {
                    matches = false;
                    return matches;
                }
                if (readA == -1) return matches;
            } while (readB != -1);
            return matches;
        }
        finally {
            if (inpA != null) {
                inpA.close();
            }
            if (inpB != null) {
                inpB.close();
            }
        }
    }
}

