/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherPropertyFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public abstract class AbstractEscherOptRecord
extends EscherRecord {
    protected List properties = new ArrayList();

    public void addEscherProperty(EscherProperty prop) {
        this.properties.add(prop);
    }

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        short propertiesCount = AbstractEscherOptRecord.readInstance(data, offset);
        int pos = offset + 8;
        EscherPropertyFactory f = new EscherPropertyFactory();
        this.properties = f.createProperties(data, pos, propertiesCount);
        return bytesRemaining + 8;
    }

    public List getEscherProperties() {
        return this.properties;
    }

    public EscherProperty getEscherProperty(int index) {
        return (EscherProperty)this.properties.get(index);
    }

    private int getPropertiesSize() {
        int totalSize = 0;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EscherProperty property = (EscherProperty)iterator.next();
            totalSize += property.getPropertySize();
        }
        return totalSize;
    }

    public int getRecordSize() {
        return 8 + this.getPropertiesSize();
    }

    public Object lookup(int propId) {
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = (EscherProperty)iterator.next();
            if (prop.getPropertyNumber() != propId) continue;
            EscherProperty result = prop;
            return result;
        }
        return null;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        EscherProperty property;
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        LittleEndian.putInt(data, offset + 4, this.getPropertiesSize());
        int pos = offset + 8;
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            property = (EscherProperty)iterator.next();
            pos += property.serializeSimplePart(data, pos);
        }
        iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            property = (EscherProperty)iterator.next();
            pos += property.serializeComplexPart(data, pos);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public void sortProperties() {
        Collections.sort(this.properties, new Comparator(){

            public int compare(Object in_p1, Object in_p2) {
                short s2;
                EscherProperty p1 = (EscherProperty)in_p1;
                EscherProperty p2 = (EscherProperty)in_p2;
                short s1 = p1.getPropertyNumber();
                return s1 < (s2 = p2.getPropertyNumber()) ? -1 : (s1 == s2 ? 0 : 1);
            }
        });
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer stringBuilder = new StringBuffer();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(":");
        stringBuilder.append(nl);
        stringBuilder.append("  isContainer: ");
        stringBuilder.append(this.isContainerRecord());
        stringBuilder.append(nl);
        stringBuilder.append("  version: 0x");
        stringBuilder.append(HexDump.toHex(this.getVersion()));
        stringBuilder.append(nl);
        stringBuilder.append("  instance: 0x");
        stringBuilder.append(HexDump.toHex(this.getInstance()));
        stringBuilder.append(nl);
        stringBuilder.append("  recordId: 0x");
        stringBuilder.append(HexDump.toHex(this.getRecordId()));
        stringBuilder.append(nl);
        stringBuilder.append("  numchildren: ");
        stringBuilder.append(this.getChildRecords().size());
        stringBuilder.append(nl);
        stringBuilder.append("  properties:");
        stringBuilder.append(nl);
        Iterator iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            EscherProperty property = (EscherProperty)iterator.next();
            stringBuilder.append("    " + property.toString() + nl);
        }
        return stringBuilder.toString();
    }
}

