/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.p2.metadata.Copyright;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnitFragment;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnitPatch;
import org.eclipse.equinox.internal.p2.metadata.License;
import org.eclipse.equinox.internal.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.RequirementChange;
import org.eclipse.equinox.internal.p2.metadata.ResolvedInstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.TouchpointData;
import org.eclipse.equinox.internal.p2.metadata.TouchpointInstruction;
import org.eclipse.equinox.internal.p2.metadata.TouchpointType;
import org.eclipse.equinox.internal.p2.metadata.UpdateDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.ICopyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.ILicense;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointType;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;

public class MetadataFactory {
    private static final ITouchpointData EMPTY_TOUCHPOINT_DATA = new TouchpointData(Collections.EMPTY_MAP);
    private static ITouchpointType[] typeCache = new ITouchpointType[5];
    private static int typeCacheOffset;

    public static IInstallableUnit createInstallableUnit(InstallableUnitDescription description) {
        Assert.isNotNull((Object)description);
        return description.unitCreate();
    }

    public static IInstallableUnitFragment createInstallableUnitFragment(InstallableUnitFragmentDescription description) {
        Assert.isNotNull((Object)description);
        return (IInstallableUnitFragment)description.unitCreate();
    }

    public static IInstallableUnitPatch createInstallableUnitPatch(InstallableUnitPatchDescription description) {
        Assert.isNotNull((Object)description);
        return (IInstallableUnitPatch)description.unitCreate();
    }

    public static IProvidedCapability createProvidedCapability(String namespace, String name, Version version) {
        return new ProvidedCapability(namespace, name, version);
    }

    public static IRequiredCapability createRequiredCapability(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple) {
        return new RequiredCapability(namespace, name, range, filter, optional, multiple);
    }

    public static IRequiredCapability createRequiredCapability(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple, boolean greedy) {
        return new RequiredCapability(namespace, name, range, filter, optional, multiple, greedy);
    }

    public static IRequirementChange createRequirementChange(IRequiredCapability applyOn, IRequiredCapability newValue) {
        return new RequirementChange(applyOn, newValue);
    }

    public static ICopyright createCopyright(URI location, String body) {
        return new Copyright(location, body);
    }

    public static ILicense createLicense(URI location, String body) {
        return new License(location, body);
    }

    public static IInstallableUnit createResolvedInstallableUnit(IInstallableUnit unit, IInstallableUnitFragment[] fragments) {
        if (unit.isResolved()) {
            return unit;
        }
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)fragments);
        return new ResolvedInstallableUnit(unit, fragments);
    }

    public static ITouchpointData createTouchpointData(Map instructions) {
        Assert.isNotNull((Object)instructions);
        if (instructions.isEmpty()) {
            return EMPTY_TOUCHPOINT_DATA;
        }
        LinkedHashMap result = new LinkedHashMap(instructions.size());
        Iterator iterator = instructions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object value = entry.getValue();
            if (value == null || value instanceof String) {
                value = MetadataFactory.createTouchpointInstruction((String)value, null);
            }
            result.put(entry.getKey(), value);
        }
        return new TouchpointData(result);
    }

    public static ITouchpointInstruction createTouchpointInstruction(String body, String importAttribute) {
        return new TouchpointInstruction(body, importAttribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITouchpointType createTouchpointType(String id, Version version) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)version);
        if (id.equals(ITouchpointType.NONE.getId()) && version.equals((Object)ITouchpointType.NONE.getVersion())) {
            return ITouchpointType.NONE;
        }
        ITouchpointType[] iTouchpointTypeArray = typeCache;
        synchronized (typeCache) {
            ITouchpointType result = MetadataFactory.getCachedTouchpointType(id, version);
            if (result != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            result = new TouchpointType(id, version);
            MetadataFactory.putCachedTouchpointType(result);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public static IUpdateDescriptor createUpdateDescriptor(String id, VersionRange range, int severity, String description) {
        return new UpdateDescriptor(id, range, severity, description);
    }

    private static ITouchpointType getCachedTouchpointType(String id, Version version) {
        int i = 0;
        while (i < typeCache.length) {
            if (typeCache[i] != null && typeCache[i].getId().equals(id) && typeCache[i].getVersion().equals((Object)version)) {
                return typeCache[i];
            }
            ++i;
        }
        return null;
    }

    private static void putCachedTouchpointType(ITouchpointType result) {
        MetadataFactory.typeCache[MetadataFactory.typeCacheOffset] = result;
        typeCacheOffset = (typeCacheOffset + 1) % typeCache.length;
    }

    public static class InstallableUnitDescription {
        protected InstallableUnit unit;

        public void addProvidedCapabilities(Collection additional) {
            if (additional == null || additional.size() == 0) {
                return;
            }
            IProvidedCapability[] current = this.unit().getProvidedCapabilities();
            IProvidedCapability[] result = new IProvidedCapability[additional.size() + current.length];
            System.arraycopy(current, 0, result, 0, current.length);
            int j = current.length;
            Iterator i = additional.iterator();
            while (i.hasNext()) {
                result[j++] = (IProvidedCapability)i.next();
            }
            this.unit().setCapabilities(result);
        }

        public void addRequiredCapabilities(Collection additional) {
            if (additional == null || additional.size() == 0) {
                return;
            }
            IRequiredCapability[] current = this.unit().getRequiredCapabilities();
            IRequiredCapability[] result = new IRequiredCapability[additional.size() + current.length];
            System.arraycopy(current, 0, result, 0, current.length);
            int j = current.length;
            Iterator i = additional.iterator();
            while (i.hasNext()) {
                result[j++] = (IRequiredCapability)i.next();
            }
            this.unit().setRequiredCapabilities(result);
        }

        public void addTouchpointData(ITouchpointData data) {
            Assert.isNotNull((Object)data);
            this.unit().addTouchpointData(data);
        }

        public String getId() {
            return this.unit().getId();
        }

        public IProvidedCapability[] getProvidedCapabilities() {
            return this.unit().getProvidedCapabilities();
        }

        public IRequiredCapability[] getRequiredCapabilities() {
            return this.unit().getRequiredCapabilities();
        }

        public IRequiredCapability[] getMetaRequiredCapabilities() {
            return this.unit().getMetaRequiredCapabilities();
        }

        public ITouchpointData[] getTouchpointData() {
            return this.unit().getTouchpointData();
        }

        public Version getVersion() {
            return this.unit().getVersion();
        }

        public void setArtifacts(IArtifactKey[] value) {
            this.unit().setArtifacts(value);
        }

        public void setCapabilities(IProvidedCapability[] exportedCapabilities) {
            this.unit().setCapabilities(exportedCapabilities);
        }

        public void setCopyright(ICopyright copyright) {
            this.unit().setCopyright(copyright);
        }

        public void setFilter(String filter) {
            this.unit().setFilter(filter);
        }

        public void setId(String id) {
            this.unit().setId(id);
        }

        public void setLicense(ILicense license) {
            this.unit().setLicense(license);
        }

        public void setProperty(String key, String value) {
            this.unit().setProperty(key, value);
        }

        public void setRequiredCapabilities(IRequiredCapability[] requirements) {
            this.unit().setRequiredCapabilities(requirements);
        }

        public void setMetaRequiredCapabilities(IRequiredCapability[] metaRequirements) {
            this.unit().setMetaRequiredCapabilities(metaRequirements);
        }

        public void setSingleton(boolean singleton) {
            this.unit().setSingleton(singleton);
        }

        public void setTouchpointType(ITouchpointType type) {
            this.unit().setTouchpointType(type);
        }

        public void setUpdateDescriptor(IUpdateDescriptor updateInfo) {
            this.unit().setUpdateDescriptor(updateInfo);
        }

        public void setVersion(Version newVersion) {
            this.unit().setVersion(newVersion);
        }

        InstallableUnit unit() {
            if (this.unit == null) {
                this.unit = new InstallableUnit();
                this.unit.setArtifacts(new IArtifactKey[0]);
            }
            return this.unit;
        }

        IInstallableUnit unitCreate() {
            InstallableUnit result = this.unit();
            this.unit = null;
            return result;
        }
    }

    public static class InstallableUnitFragmentDescription
    extends InstallableUnitDescription {
        public InstallableUnitFragmentDescription() {
            this.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        }

        public void setHost(IRequiredCapability[] hostRequirements) {
            ((InstallableUnitFragment)this.unit()).setHost(hostRequirements);
        }

        InstallableUnit unit() {
            if (this.unit == null) {
                this.unit = new InstallableUnitFragment();
            }
            return this.unit;
        }
    }

    public static class InstallableUnitPatchDescription
    extends InstallableUnitDescription {
        public InstallableUnitPatchDescription() {
            this.setProperty("org.eclipse.equinox.p2.type.patch", Boolean.TRUE.toString());
        }

        public void setApplicabilityScope(IRequiredCapability[][] applyTo) {
            if (applyTo == null) {
                throw new IllegalArgumentException("A patch scope can not be null");
            }
            ((InstallableUnitPatch)this.unit()).setApplicabilityScope(applyTo);
        }

        public void setLifeCycle(IRequiredCapability lifeCycle) {
            ((InstallableUnitPatch)this.unit()).setLifeCycle(lifeCycle);
        }

        public void setRequirementChanges(IRequirementChange[] changes) {
            ((InstallableUnitPatch)this.unit()).setRequirementsChange(changes);
        }

        InstallableUnit unit() {
            if (this.unit == null) {
                this.unit = new InstallableUnitPatch();
                ((InstallableUnitPatch)this.unit()).setApplicabilityScope(new IRequiredCapability[0][0]);
            }
            return this.unit;
        }
    }
}

