/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.provisional.p2.core.IServiceUI;
import org.eclipse.equinox.internal.provisional.p2.core.IServiceUICheckUnsigned;
import org.eclipse.equinox.internal.provisional.p2.engine.Messages;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class CertificateChecker {
    private ArrayList artifacts = new ArrayList();
    private ServiceTracker trustEngineTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CertificateChecker() {
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.trustEngineTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.trustEngineTracker.open();
    }

    public IStatus start() {
        return this.checkCertificates();
    }

    private IStatus checkCertificates() {
        int i;
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.signedcontent.SignedContentFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SignedContentFactory verifierFactory = (SignedContentFactory)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        BundleContext bundleContext2 = EngineActivator.getContext();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.IServiceUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IServiceUI serviceUI = (IServiceUI)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName());
        SignedContent content = null;
        SignerInfo[] signerInfo = null;
        ArrayList<Certificate> untrusted = new ArrayList<Certificate>();
        ArrayList<File> unsigned = new ArrayList<File>();
        ArrayList<Certificate[]> untrustedChain = new ArrayList<Certificate[]>();
        IStatus status = Status.OK_STATUS;
        if (this.artifacts.size() == 0 || serviceUI == null) {
            return status;
        }
        TrustEngine trustEngine = (TrustEngine)this.trustEngineTracker.getService();
        Iterator it = this.artifacts.iterator();
        while (it.hasNext()) {
            File artifact = (File)it.next();
            try {
                content = verifierFactory.getSignedContent(artifact);
                if (!content.isSigned()) {
                    unsigned.add(artifact);
                    continue;
                }
                signerInfo = content.getSignerInfos();
            }
            catch (GeneralSecurityException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentError, (Throwable)e);
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentIOError, (Throwable)e);
            }
            i = 0;
            while (i < signerInfo.length) {
                Certificate[] certificateChain = signerInfo[i].getCertificateChain();
                try {
                    Certificate trustAnchor = trustEngine.findTrustAnchor(certificateChain);
                    if (trustAnchor == null && !untrusted.contains(certificateChain[0])) {
                        untrusted.add(certificateChain[0]);
                        untrustedChain.add(certificateChain);
                    }
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                }
                ++i;
            }
        }
        status = this.checkUnsigned(serviceUI, unsigned);
        if (status.getSeverity() == 4 || status.getSeverity() == 8) {
            return status;
        }
        if (!untrusted.isEmpty()) {
            Certificate[][] certificates = new Certificate[untrustedChain.size()][];
            int i2 = 0;
            while (i2 < untrustedChain.size()) {
                certificates[i2] = (Certificate[])untrustedChain.get(i2);
                ++i2;
            }
            Certificate[] trustedCertificates = serviceUI.showCertificates(certificates);
            if (trustedCertificates == null) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
            }
            i = 0;
            while (i < trustedCertificates.length) {
                untrusted.remove(trustedCertificates[i]);
                ++i;
            }
            if (untrusted.size() > 0) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
            }
            i = 0;
            while (i < trustedCertificates.length) {
                try {
                    trustEngine.addTrustAnchor(trustedCertificates[i], trustedCertificates[i].toString());
                }
                catch (IOException e) {
                    return new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                }
                catch (GeneralSecurityException e) {
                    return new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateError, (Throwable)e);
                }
                ++i;
            }
        }
        return status;
    }

    private IStatus checkUnsigned(IServiceUI serviceUI, ArrayList unsigned) {
        if (unsigned.isEmpty()) {
            return Status.OK_STATUS;
        }
        String policy = EngineActivator.getContext().getProperty("eclipse.p2.unsignedPolicy");
        if ("allow".equals(policy)) {
            return Status.OK_STATUS;
        }
        if ("fail".equals(policy)) {
            return new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.CertificateChecker_UnsignedNotAllowed, (Object)unsigned));
        }
        if (serviceUI instanceof IServiceUICheckUnsigned) {
            String[] details = new String[unsigned.size()];
            int i = 0;
            while (i < details.length) {
                details[i] = unsigned.get(i).toString();
                ++i;
            }
            if (!((IServiceUICheckUnsigned)serviceUI).promptForUnsignedContent(details)) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    public void add(File toAdd) {
        this.artifacts.add(toAdd);
    }

    public void add(Object[] toAdd) {
        int i = 0;
        while (i < toAdd.length) {
            if (toAdd[i] instanceof File) {
                this.add((File)toAdd[i]);
            }
            ++i;
        }
    }
}

