package jp.oarts.pirka.core.util.check;

import java.io.Serializable;

import jp.oarts.pirka.core.util.check.message.PirkaMessageUtil;
import jp.oarts.pirka.core.util.check.message.PirkaStandardMessage;

/**
 * `FbNG[EXCEPTION<BR>
 * `FbJ[ŃG[炱EXCEPTIONX[܂B <BR>
 * RXgN^[ŗ^ꂽbZ[WG[bZ[WƂ WEBʂɕ\܂B
 * 
 * @author ito
 * 
 */
public class PirkaCheckException extends Exception implements Serializable {

	// WbZ[W
	protected PirkaStandardMessage standardMessage = null;

	// bZ[WIvVz
	protected String[] messageOptions = new String[0];

	/**
	 * RXgN^
	 * 
	 * @param message
	 *            G[bZ[W
	 */
	public PirkaCheckException(String message) {
		super(message);
	}

	/**
	 * RXgN^
	 * 
	 * @param standardMessage
	 *            WbZ[W
	 * @param messageOptions
	 *            bZ[WIvVz
	 */
	public PirkaCheckException(PirkaStandardMessage standardMessage, String... messageOptions) {
		super(PirkaMessageUtil.createMessage(standardMessage.getMessage(), messageOptions));
		this.standardMessage = standardMessage;
		this.messageOptions = messageOptions;
	}

	/**
	 * RXgN^
	 * 
	 * @param message
	 *            G[bZ[W
	 * @param cause
	 *            ̃G[̗O
	 */
	public PirkaCheckException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * RXgN^
	 * 
	 * @param standardMessage
	 *            WbZ[W
	 * @param cause
	 *            ̃G[̗O
	 * @param messageOptions
	 *            bZ[WIvVz
	 */
	public PirkaCheckException(PirkaStandardMessage standardMessage, Throwable cause, String... messageOptions) {
		super(PirkaMessageUtil.createMessage(standardMessage.getMessage(), messageOptions));
		this.standardMessage = standardMessage;
		this.messageOptions = messageOptions;
	}

	/**
	 * WbZ[W擾
	 * 
	 * @return pirkaWbZ[W
	 */
	public PirkaStandardMessage getStandardMessage() {
		return standardMessage;
	}

	/**
	 * bZ[WIvV̎擾
	 * 
	 * @return bZ[WIvVz
	 */
	public String[] getMessageOptions() {
		return messageOptions;
	}

}
