package jp.oarts.pirka.core.ctrl.proc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import jp.oarts.pirka.core.ctrl.proc.def.AProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.ButtonSubmitProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.DivLoopProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.DivSwitchProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.FormProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.ImageProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.ImgProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputCheckboxProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputFileProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputHiddenProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputImageProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputPasswordProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputRadioProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputSubmitProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.InputTextProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.LabelProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.ScriptProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.SelectProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.SpanProcesser;
import jp.oarts.pirka.core.ctrl.proc.def.TextareaProcesser;

/**
 * Rg[[IuWFNg̊ǗNX
 * 
 * @author ito
 * 
 */
public class CtrlProcesserManager  implements Serializable{

	/** ftHg̃Rg[[NX}bv */
	private static Map<String, CtrlProcesser> defaultCtrlProcesserMap;

	/** m̃vZbT[ */
	private static CtrlProcesser unknownProcesser;

	static {
		synchronized (CtrlProcesserManager.class) { // pŜ߂̓

			// ftHgRg[[̃}bv쐬
			defaultCtrlProcesserMap = new HashMap<String, CtrlProcesser>();

			defaultCtrlProcesserMap.put("a", new AProcesser());
			defaultCtrlProcesserMap.put("button#submit", new ButtonSubmitProcesser());
			defaultCtrlProcesserMap.put("div#loop", new DivLoopProcesser());
			defaultCtrlProcesserMap.put("div#switch", new DivSwitchProcesser());
			defaultCtrlProcesserMap.put("form", new FormProcesser());
			defaultCtrlProcesserMap.put("img", new ImgProcesser());
			defaultCtrlProcesserMap.put("image", new ImageProcesser());
			defaultCtrlProcesserMap.put("input#checkbox", new InputCheckboxProcesser());
			defaultCtrlProcesserMap.put("input#file", new InputFileProcesser());
			defaultCtrlProcesserMap.put("input#hidden", new InputHiddenProcesser());
			defaultCtrlProcesserMap.put("input#image", new InputImageProcesser());
			defaultCtrlProcesserMap.put("input#password", new InputPasswordProcesser());
			defaultCtrlProcesserMap.put("input#radio", new InputRadioProcesser());
			defaultCtrlProcesserMap.put("input#submit", new InputSubmitProcesser());
			defaultCtrlProcesserMap.put("input#text", new InputTextProcesser());
			defaultCtrlProcesserMap.put("label", new LabelProcesser());
			defaultCtrlProcesserMap.put("script", new ScriptProcesser());
			defaultCtrlProcesserMap.put("select", new SelectProcesser());
			defaultCtrlProcesserMap.put("span", new SpanProcesser());
			defaultCtrlProcesserMap.put("textarea", new TextareaProcesser());

			// ḿi`́jvZbT[i[
			unknownProcesser = new UnknownProcesser();

		}
	}

	/**
	 * vZbT[̂ɑΉftHg̃vZbT[擾
	 * 
	 * @param name
	 *            vZbT[
	 * @return ftHg̃vZbT[ AftHgvZbT[ɑ݂ȂƂnullԂ
	 */
	public static CtrlProcesser getDefaultCtrlProcesser(String name) {
		return defaultCtrlProcesserMap.get(name);
	}

	/**
	 * ḿi`́jvZbT[擾
	 * 
	 * @return ḿi`́jvZbT[
	 */
	public static CtrlProcesser getUnknownProcesser() {
		return unknownProcesser;
	}

	/**
	 * vZbT[̂ɑΉvZbT[擾<BR>
	 * Ǝ̃vZbT[}bvAftHg̃vZbT[}bv̏Ɍ<BR>
	 * ǂ̃}bvɂȂΖḿi`́jvZbT[߂
	 * 
	 * @param processerName
	 *            vZbT[
	 * @param ctrlProcesserMap
	 *            Ǝ̃vZbT[}bv
	 * @return vZbT[
	 */
	public static CtrlProcesser getCtrlProseccer(String processerName, Map<String, CtrlProcesser> ctrlProcesserMap) {

		CtrlProcesser ctrlProcesser = null;
		String processerTagName = null;

		if (ctrlProcesserMap != null) {
			ctrlProcesser = ctrlProcesserMap.get(processerName);
			if (ctrlProcesser != null) {
				return ctrlProcesser;
			}

			processerTagName = getProcesserTagName(processerName);

			if (processerTagName != null && processerTagName.length() > 0) {
				ctrlProcesser = ctrlProcesserMap.get(processerTagName);
				if (ctrlProcesser != null) {
					return ctrlProcesser;
				}
			}
		}

		ctrlProcesser = CtrlProcesserManager.getDefaultCtrlProcesser(processerName);
		if (ctrlProcesser != null) {
			return ctrlProcesser;
		}

		if (processerTagName == null) {
			processerTagName = getProcesserTagName(processerName);
		}
		if (processerTagName != null && processerTagName.length() > 0) {
			ctrlProcesser = CtrlProcesserManager.getDefaultCtrlProcesser(processerTagName);
			if (ctrlProcesser != null) {
				return ctrlProcesser;
			}
		}

		return CtrlProcesserManager.getUnknownProcesser();
	}

	/**
	 * vZbT[type^O𒊏oB<BR>
	 * Atype(#)͋󕶎ԂB
	 * 
	 * @param processerName
	 *            vZbT[
	 * @return ^O
	 */
	private static String getProcesserTagName(String processerName) {
		int index = processerName.indexOf('#');
		if (index <= 0) {
			return "";
		}
		return processerName.substring(0, index);
	}

}
