package jp.oarts.pirka.core.analyzer.html;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;

/**
 * HTML͗p̃c[Q
 * 
 * @author ito
 * 
 */
public class HtmlTools  implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8207798152943945086L;

	/** ^O\ */
	private static final String TAG_HAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789$_";

	/** ^OZp[^ */
	private static final String TAG_IN_SEPARATOR = " \t\r\n";

	/**
	 * ^ȎԂ̃Zp[^\Ă镶ł邩̌
	 * 
	 * @param c
	 *            
	 * @return true=^OZp[^
	 */
	static boolean isTagInSeparator(char c) {
		return TAG_IN_SEPARATOR.indexOf(c) >= 0;
	}

	/**
	 * ^O\Ă镶ł邩̌؁i<>͏j
	 * 
	 * @param c
	 *            
	 * @return true=^O\
	 */
	static boolean isTagChar(char c) {
		return TAG_HAR.indexOf(c) >= 0;
	}

	/**
	 * HTMLp[cXgHTML쐬܂B
	 * 
	 * @param partsList
	 *            p[cXg
	 * @return 
	 */
	static String makeHtmlString(List<HtmlParts> partsList) {
		StringBuilder sb = new StringBuilder();

		for (HtmlParts parts : partsList) {
			sb.append(parts.getOrgString());
			if (parts.getChild() != null) {

				sb.append(makeHtmlString(parts.getChild()));
				sb.append(parts.getEndTag());
			}
		}

		return sb.toString();
	}

		/**
	 * ^O񂩂瑮𔲂o}bv쐬
	 * 
	 * @param tagString
	 *            ^O
	 * @return }bv
	 */
	static TreeMap<String, String> getOptionMap(String tagString) {

		String[] strList = HtmlTools.tagSplit(tagString);

		TreeMap<String, String> map = new TreeMap<String, String>();
		for (int i = 1; i < strList.length; i++) {
			char c = strList[i].charAt(0);
			if (c == '\'' || c == '\"' || c == '=') {
				// error
			} else {
				if (i < strList.length - 1) {
					if (strList[i + 1].charAt(0) == '=') {
						if (i < strList.length - 2) {
							map.put(strList[i].toLowerCase(), HtmlTools.cutQuotation(strList[i + 2]));
							i = i + 2;
						} else {
							map.put(strList[i].toLowerCase(), "");
							i = i + 1;
						}
					} else {
						map.put(strList[i].toLowerCase(), null);
					}

				} else {
					map.put(strList[i].toLowerCase(), null);
				}
			}
		}

		return map;
	}

	/**
	 * ^O܂̓Rg𕪉
	 * 
	 * @param tagString
	 *            ^O̓Rg
	 * @return ꂽXg
	 */
	static String[] tagSplit(String tagString) {

		ArrayList<String> list = new ArrayList<String>();

		char q = 0;
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < tagString.length() - 1; i++) {
			char c = tagString.charAt(i);
			if (q != 0) {
				sb.append(c);
				if (q == c) {
					list.add(sb.toString());
					sb.setLength(0);
					q = 0;
				}
			} else if (c == '\'' || c == '\"') {
				if (sb.length() > 0) {
					list.add(sb.toString());
					sb.setLength(0);
				}
				sb.append(c);
				q = c;
			} else if (c == '=') {
				if (sb.length() > 0) {
					list.add(sb.toString());
					sb.setLength(0);
				}
				list.add("=");
			} else {
				if (sb.length() <= 0) {
					if (!HtmlTools.isTagInSeparator(c)) {
						sb.append(c);
					}
				} else {
					if (HtmlTools.isTagInSeparator(c)) {
						list.add(sb.toString());
						sb.setLength(0);
					} else {
						sb.append(c);
					}
				}
			}
		}
		if (sb.length() > 0) {
			list.add(sb.toString());
		}
		return list.toArray(new String[0]);
	}

	/**
	 * 񂪃VOR[e[VA_uR[e[V̉ꂩɈ͂܂Ă炻폜ԂB
	 * 
	 * @param str
	 *            
	 * @return VOR[e[VA_uR[e[VOꂽ
	 */
	static String cutQuotation(String str) {
		if (str == null || str.length() < 1) {
			return str;
		}

		char c = str.charAt(0);
		if (c != '\'' && c != '\"') {
			return str;
		}

		char ec = str.charAt(str.length() - 1);
		if (c == ec) {
			if (str.length() > 2) {
				return str.substring(1, str.length() - 1);
			} else {
				return "";
			}
		}
		return str.substring(1);
	}

	/**
	 * [_[蕶̏I[܂łoXgOr_[IuWFNg֊i[BiI[͊i[Ȃj
	 * 
	 * @param sb
	 *            oi[XgOr_[IuWFNg
	 * @param r
	 *            [_[
	 * @param s
	 *            I[
	 * @throws IOException
	 */
	static void stringStart(StringBuilder sb, Reader r, char s) throws IOException {

		while (true) {
			int cint = r.read();
			if (cint < 0) {
				break;
			}
			char c = (char) cint;

			sb.append(c);
			if (c == s) {
				return;
			}
		}

	}

	/**
	 * HTMLp[cXg̃N[쐬
	 * 
	 * @param list
	 *            HTMLp[cXg
	 * @return ꂽHTMLp[cXg
	 */
	public static List<HtmlParts> cloneHtmlPartsList(List<HtmlParts> list) {

		List<HtmlParts> cloneList = new ArrayList<HtmlParts>();

		for (HtmlParts parts : list) {
			cloneList.add((HtmlParts) parts.clone());
		}

		return cloneList;
	}

	/**
	 * HTMLWJ̖O쐬
	 * 
	 * @param baseName
	 *            x[X
	 * @param loopSufix
	 *            [vTtBbNX
	 * @return HTMLWJ̖O
	 */
	public static String makeName(String baseName, String loopSufix) {
		if (loopSufix == null || loopSufix.length() <= 0) {
			return baseName;
		}
		return baseName + loopSufix;
	}

	/**
	 * HTMLWJ̖O쐬
	 * 
	 * @param loopSufix
	 *            [vTtBbNX
	 * @param groupLoopLevel
	 *            O[v[vxi0ԓj
	 * @return HTMLWJ̖O
	 */
	public static String changeSuffix( String loopSufix, int groupLoopLevel) {
		if (groupLoopLevel <= 0) {
			return loopSufix;
		}
		String[] loopStrs = loopSufix.split("\\$");
		int count = loopStrs.length-1 - groupLoopLevel;
		if (count <= 0) {
			return "";
		}
		StringBuilder sb = new StringBuilder();
		for (int i = 1; i <= count; i++) {
			sb.append('$');
			sb.append(loopStrs[i]);
		}
		return sb.toString();
	}

	/**
	 * HTMLp[cXg蕶ɊȈՕϊ
	 * 
	 * @param list
	 *            HTMLp[cXg
	 * @return HTMLC[W
	 */
	public static String toSimpleString(List<HtmlParts> list) {

		StringBuilder sb = new StringBuilder();
		if (list != null) {
			for (HtmlParts parts : list) {
				if (parts.getType() == HtmlPartsType.TAG) {

					sb.append('<');
					sb.append(parts.getTagName());
					sb.append(changeHtmlOption2String(parts.getOption()));
					sb.append('>');

					if (parts.getChild() != null) { // VO^O
						sb.append(toSimpleString(parts.getChild()));
						sb.append("</");
						sb.append(parts.getTagName());
						// sb.append(changeHtmlOption2String(parts.getEndTagOption()));
						sb.append('>');
					}
				} else {
					sb.append(parts.getOrgString());
				}
			}
		}

		return sb.toString();
	}

	/**
	 * }bv𕶎ɕϊ
	 * 
	 * @param optionMap
	 *            }bv
	 * @return ϊꂽ
	 */
	private static String changeHtmlOption2String(Map<String, String> optionMap) {
		StringBuilder sb = new StringBuilder();

		// ^Cv
		addOption(sb, optionMap, "type");

		// l[
		addOption(sb, optionMap, "name");

		for (String key : optionMap.keySet()) {

			if (!key.equalsIgnoreCase("type") && !key.equalsIgnoreCase("name")) {
				addOption(sb, optionMap, key);
			}
		}

		return sb.toString();
	}

	private static boolean addOption(StringBuilder sb, Map<String, String> optionMap, String optionName) {
		if (optionMap.containsKey(optionName)) {
			sb.append(' ');
			sb.append(optionName);
			String value = optionMap.get(optionName);
			if (value != null) {
				sb.append('=');
				sb.append('\"');
				sb.append(value);
				sb.append('\"');
			}
			return true;
		}
		return false;
	}

	/**
	 * WEBZ[tȕɕϊB
	 * 
	 * @param str
	 *            
	 * @return WEBZ[tȕ
	 */
	static public String webString(String str) {
		if (str == null) {
			return "";
		}

		StringBuffer sb = new StringBuffer();
		char c;

		for (int i = 0; i < str.length(); i++) {
			c = str.charAt(i);
			switch (c) {
			case '<':
				sb.append("&lt;");
				break;
			case '>':
				sb.append("&gt;");
				break;
			case '\"':
				sb.append("&quot;");
				break;
			case '&':
				sb.append("&amp;");
				break;
			// 폜 2006/11/21 By S.Ito eLXg{bNXŕs邽
			// case ' ' : // 2006/11/21 ǉ By S.Ito
			// sb.append("&nbsp;");
			// break;
			default:
				sb.append(c);
				break;
			}
		}
		return sb.toString();
	}

	// 2006/11/21 ǉ By S.Ito /////////////////////////////////////
	/**
	 * WEBZ[tȕɕϊBXy[XϊB
	 * 
	 * @param str
	 *            
	 * @return WEBZ[tȕ
	 */
	static public String webStringWithSpace(String str) {
		if (str == null) {
			return "";
		}

		StringBuffer sb = new StringBuffer();
		char c;

		for (int i = 0; i < str.length(); i++) {
			c = str.charAt(i);
			switch (c) {
			case '<':
				sb.append("&lt;");
				break;
			case '>':
				sb.append("&gt;");
				break;
			case '\"':
				sb.append("&quot;");
				break;
			case '&':
				sb.append("&amp;");
				break;
			case ' ':
				sb.append("&nbsp;");
				break;
			default:
				sb.append(c);
				break;
			}
		}
		return sb.toString();
	}
	// //////////////////////////////////////////////////////////////////////

	/**
	 * JavaScript̕SȌ`ɕϊ
	 * 
	 * @param	str	
	 * @return	ϊꂽ
	 */
	public static String javaScriptString(String str){
		if (str == null) {
			return "";
		}

		StringBuffer sb = new StringBuffer();
		char c;

		for (int i = 0; i < str.length(); i++) {
			c = str.charAt(i);
			switch (c) {
			case '\\':
				sb.append("\\\\");
				break;
			case '\"':
				sb.append("\\\"");
				break;
			case '\'':
				sb.append("\\'");
				break;
			case '\t':
				sb.append("\\t");
				break;
			case '\n':
				sb.append("\\n");
				break;
			case '\f':
				sb.append("\\f");
				break;
			case '\b':
				sb.append("\\b");
				break;
			case '\r':
				sb.append("\\r");
				break;
			default:
				sb.append(c);
				break;
			}
		}
		return sb.toString();
	}

}
